/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.selectvalues;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.selectvalues.SelectValuesData;
import com.kingdee.bos.ctrl.etl.transformation.step.selectvalues.SelectValuesMeta;
import com.kingdee.bos.ctrl.etl.value.Value;

public class SelectValues
extends BaseStep
implements StepInterface {
    private SelectValuesMeta meta;
    private SelectValuesData data;

    public SelectValues(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private synchronized boolean selectValues(Row row) {
        int i;
        this.debug = "Start of selectValues";
        if (this.data.firstselect) {
            this.debug = "Init (first)";
            this.data.firstselect = false;
            this.data.fieldnrs = new int[this.meta.getSelectName().length];
            this.data.values = new Value[this.meta.getSelectName().length];
            for (int i2 = 0; i2 < this.data.fieldnrs.length; ++i2) {
                this.data.fieldnrs[i2] = row.searchValueIndex(this.meta.getSelectName()[i2]);
                if (this.data.fieldnrs[i2] >= 0) continue;
                this.logError("Couldn't find field '" + this.meta.getSelectName()[i2] + "' in row!");
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            int[] cnt = new int[this.meta.getSelectName().length];
            for (int i3 = 0; i3 < this.meta.getSelectName().length; ++i3) {
                cnt[i3] = 0;
                for (int j = 0; j < this.meta.getSelectName().length; ++j) {
                    if (this.meta.getSelectName()[i3].equals(this.meta.getSelectName()[j])) {
                        int n = i3;
                        cnt[n] = cnt[n] + 1;
                    }
                    if (cnt[i3] <= 1) continue;
                    this.logError("Field '" + this.meta.getSelectName()[i3] + "' is specified twice with the same name!");
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
            }
        }
        this.debug = "get fields values";
        for (i = 0; i < this.meta.getSelectName().length; ++i) {
            this.debug = "get start loop (fieldnrs[" + i + "]=" + this.data.fieldnrs[i] + ")";
            if (this.data.fieldnrs[i] < row.size()) {
                this.data.values[i] = row.getValue(this.data.fieldnrs[i]);
                if (this.meta.getSelectRename()[i] != null && this.meta.getSelectRename()[i].length() > 0) {
                    this.data.values[i].setName(this.meta.getSelectRename()[i]);
                } else {
                    this.data.values[i].setName(this.meta.getSelectName()[i]);
                }
                if (this.meta.getSelectLength()[i] != -2) {
                    this.data.values[i].setLength(this.meta.getSelectLength()[i]);
                }
                if (this.meta.getSelectPrecision()[i] == -2) continue;
                this.data.values[i].setPrecision(this.meta.getSelectPrecision()[i]);
                continue;
            }
            this.logDetailed("WARNING: Mixing streams with different nr of fields.");
        }
        this.debug = "add values to row in correct order...";
        for (i = 0; i < this.meta.getSelectName().length; ++i) {
            if (i > row.size()) {
                row.addValue(this.data.values[i]);
                continue;
            }
            row.setValue(i, this.data.values[i]);
        }
        this.debug = "remove unwanted/unselected fields.";
        for (i = row.size() - 1; i >= this.meta.getSelectName().length; --i) {
            row.removeValue(i);
        }
        this.debug = "End of selectValues";
        return true;
    }

    private synchronized boolean removeValues(Row row) {
        this.debug = "Start of removeValues";
        if (this.data.firstdeselect) {
            int j;
            int i;
            this.debug = "Init (first)";
            this.data.firstdeselect = false;
            this.data.removenrs = new int[this.meta.getDeleteName().length];
            for (int i2 = 0; i2 < this.data.removenrs.length; ++i2) {
                this.data.removenrs[i2] = row.searchValueIndex(this.meta.getDeleteName()[i2]);
                if (this.data.removenrs[i2] >= 0) continue;
                this.logError("Couldn't find field '" + this.meta.getDeleteName()[i2] + "' in row!");
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            int[] cnt = new int[this.meta.getDeleteName().length];
            for (i = 0; i < this.meta.getDeleteName().length; ++i) {
                cnt[i] = 0;
                for (j = 0; j < this.meta.getDeleteName().length; ++j) {
                    if (this.meta.getDeleteName()[i].equals(this.meta.getDeleteName()[j])) {
                        int n = i;
                        cnt[n] = cnt[n] + 1;
                    }
                    if (cnt[i] <= 1) continue;
                    this.logError("Field '" + this.meta.getDeleteName()[i] + "' is specified twice with the same name!");
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
            }
            for (i = 0; i < this.data.removenrs.length; ++i) {
                for (j = 0; j < this.data.removenrs.length - 1; ++j) {
                    if (this.data.removenrs[j] >= this.data.removenrs[j + 1]) continue;
                    int dummy = this.data.removenrs[j];
                    this.data.removenrs[j] = this.data.removenrs[j + 1];
                    this.data.removenrs[j + 1] = dummy;
                }
            }
        }
        this.debug = "remove field values";
        for (int i = 0; i < this.data.removenrs.length; ++i) {
            row.removeValue(this.data.removenrs[i]);
        }
        this.debug = "End of removeValues";
        return true;
    }

    private synchronized boolean metadataValues(Row row) {
        this.debug = "Start of metadataValues";
        if (this.data.firstmetadata) {
            this.debug = "Init (first)";
            this.data.firstmetadata = false;
            this.data.metanrs = new int[this.meta.getMetaName().length];
            for (int i = 0; i < this.data.metanrs.length; ++i) {
                this.data.metanrs[i] = row.searchValueIndex(this.meta.getMetaName()[i]);
                if (this.data.metanrs[i] >= 0) continue;
                this.logError("Couldn't find field '" + this.meta.getMetaName()[i] + "' in row!");
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            int[] cnt = new int[this.meta.getMetaName().length];
            for (int i = 0; i < this.meta.getMetaName().length; ++i) {
                cnt[i] = 0;
                for (int j = 0; j < this.meta.getMetaName().length; ++j) {
                    if (this.meta.getMetaName()[i].equals(this.meta.getMetaName()[j])) {
                        int n = i;
                        cnt[n] = cnt[n] + 1;
                    }
                    if (cnt[i] <= 1) continue;
                    this.logError("Field '" + this.meta.getMetaName()[i] + "' is specified twice with the same name!");
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
            }
        }
        this.debug = "change metadata of fields";
        for (int i = 0; i < this.data.metanrs.length; ++i) {
            Value v = row.getValue(this.data.metanrs[i]);
            if (this.meta.getMetaRename()[i] != null && this.meta.getMetaRename()[i].length() > 0) {
                v.setName(this.meta.getMetaRename()[i]);
            }
            if (this.meta.getMetaType()[i] != 0) {
                v.setType(this.meta.getMetaType()[i]);
            }
            if (this.meta.getMetaLength()[i] != -2) {
                v.setLength(this.meta.getMetaLength()[i]);
            }
            if (this.meta.getMetaPrecision()[i] == -2) continue;
            v.setPrecision(this.meta.getMetaPrecision()[i]);
        }
        this.debug = "End of metadataValues";
        return true;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.meta = (SelectValuesMeta)smi;
        this.data = (SelectValuesData)sdi;
        Row r = null;
        boolean err = true;
        r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        this.logRowlevel("Got row from previous step: " + r);
        err = true;
        if (this.data.select) {
            err = this.selectValues(r);
        }
        if (this.data.deselect) {
            err = this.removeValues(r);
        }
        if (this.data.metadata) {
            err = this.metadataValues(r);
        }
        if (!err) {
            this.setOutputDone();
            return false;
        }
        this.putRow(r);
        this.logRowlevel("Wrote row to next step: " + r);
        if (this.linesRead > 0L && this.linesRead % 5000L == 0L) {
            this.logBasic("linenr " + this.linesRead);
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SelectValuesMeta)smi;
        this.data = (SelectValuesData)sdi;
        if (super.init(smi, sdi)) {
            boolean atLeaseOne;
            this.data.firstselect = true;
            this.data.firstdeselect = true;
            this.data.firstmetadata = true;
            this.data.select = false;
            this.data.deselect = false;
            this.data.metadata = false;
            if (this.meta.getSelectName() != null && this.meta.getSelectName().length > 0) {
                this.data.select = true;
            }
            if (this.meta.getDeleteName() != null && this.meta.getDeleteName().length > 0) {
                this.data.deselect = true;
            }
            if (this.meta.getMetaName() != null && this.meta.getMetaName().length > 0) {
                this.data.metadata = true;
            }
            boolean bl = atLeaseOne = this.data.select || this.data.deselect || this.data.metadata;
            if (!atLeaseOne) {
                this.setErrors(1L);
                this.logError("At lease one of select, remove or meta screens should contain data.");
            }
            return atLeaseOne;
        }
        return false;
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }
}

