/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.tableinput;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.tableinput.TableInput;
import com.kingdee.bos.ctrl.etl.transformation.step.tableinput.TableInputData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class TableInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private DatabaseMeta databaseMeta;
    private String sql;
    private int rowLimit;
    private String lookupFromStepname;
    private StepMeta lookupFromStep;
    private boolean executeEachInputRow;

    public TableInputMeta() {
    }

    public TableInputMeta(DatabaseMeta database, String sql) {
        this.setDatabaseMeta(database);
        this.setSQL(sql);
    }

    public boolean isExecuteEachInputRow() {
        return this.executeEachInputRow;
    }

    public void setExecuteEachInputRow(boolean oncePerRow) {
        this.executeEachInputRow = oncePerRow;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getSQL() {
        return this.sql;
    }

    public void setSQL(String sql) {
        this.sql = sql;
    }

    public StepMeta getLookupFromStep() {
        return this.lookupFromStep;
    }

    public void setLookupFromStep(StepMeta lookupFromStep) {
        this.lookupFromStep = lookupFromStep;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        TableInputMeta retval = (TableInputMeta)super.clone();
        return retval;
    }

    private void readData(Node stepnode, List databases) throws ETLXMLException {
        try {
            String con = XMLHandler.getTagValue(stepnode, "connection");
            this.databaseMeta = Const.findDatabase(databases, con);
            this.sql = XMLHandler.getTagValue(stepnode, "sql");
            String limit = XMLHandler.getTagValue(stepnode, "limit");
            this.rowLimit = Const.toInt(limit, 0);
            this.lookupFromStepname = XMLHandler.getTagValue(stepnode, "lookup");
            String perRow = XMLHandler.getTagValue(stepnode, "execute_each_row");
            this.executeEachInputRow = "Y".equals(perRow);
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load step info from XML", e);
        }
    }

    @Override
    public void setDefault() {
        this.databaseMeta = null;
        this.sql = "SELECT <values> FROM <table name> WHERE <conditions>";
        this.rowLimit = 0;
    }

    @Override
    public String[] getInfoSteps() {
        if (this.getLookupStepname() == null) {
            return null;
        }
        return new String[]{this.getLookupStepname()};
    }

    @Override
    public Row getFields(Row r, String name, Row info) throws ETLStepException {
        boolean param = false;
        Row row = r == null ? new Row() : r;
        if (this.databaseMeta == null) {
            return row;
        }
        Database db = new Database(this.databaseMeta);
        this.databases = new Database[]{db};
        Row add = null;
        try {
            add = db.getQueryFields(this.sql, param, info);
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLStepException("Unable to get queryfields for SQL: " + Const.CR + this.sql, dbe);
        }
        if (add != null) {
            for (int i = 0; i < add.size(); ++i) {
                Value v = add.getValue(i);
                v.setOrigin(name);
            }
            row.addRow(add);
        } else {
            try {
                db.connect();
                if (this.getLookupStepname() != null) {
                    param = true;
                }
                if ((add = db.getQueryFields(this.sql, param, info)) == null) {
                    Row i = row;
                    return i;
                }
                for (int i = 0; i < add.size(); ++i) {
                    Value v = add.getValue(i);
                    v.setOrigin(name);
                }
                row.addRow(add);
            }
            catch (ETLException ke) {
                throw new ETLStepException("Unable to get queryfields for SQL: " + Const.CR + this.sql, ke);
            }
            finally {
                db.disconnect();
            }
        }
        return row;
    }

    @Override
    public String getXML() {
        String xml = "";
        xml = xml + "    " + XMLHandler.addTagValue("connection", this.databaseMeta == null ? "" : this.databaseMeta.getName());
        xml = xml + "    " + XMLHandler.addTagValue("sql", this.sql);
        xml = xml + "    " + XMLHandler.addTagValue("limit", this.rowLimit);
        xml = xml + "    " + XMLHandler.addTagValue("lookup", this.getLookupStepname());
        xml = xml + "    " + XMLHandler.addTagValue("execute_each_row", this.executeEachInputRow);
        return xml;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            long id_connection = rep.getStepAttributeInteger(id_step, "id_connection");
            this.databaseMeta = Const.findDatabase(databases, id_connection);
            this.sql = rep.getStepAttributeString(id_step, "sql");
            this.rowLimit = (int)rep.getStepAttributeInteger(id_step, "limit");
            this.lookupFromStepname = rep.getStepAttributeString(id_step, "lookup");
            this.executeEachInputRow = rep.getStepAttributeBoolean(id_step, "execute_each_row");
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta == null ? -1.0 : (double)this.databaseMeta.getID());
            rep.saveStepAttribute(id_transformation, id_step, "sql", this.sql);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            rep.saveStepAttribute(id_transformation, id_step, "lookup", this.getLookupStepname());
            rep.saveStepAttribute(id_transformation, id_step, "execute_each_row", this.executeEachInputRow);
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getID());
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(List remarks, StepMeta stepMeta, Row prev, String[] input, String[] output, Row info) {
        CheckResult cr;
        if (this.databaseMeta != null) {
            cr = new CheckResult(1, "Connection exists", stepMeta);
            remarks.add(cr);
            Database db = new Database(this.databaseMeta);
            this.databases = new Database[]{db};
            try {
                db.connect();
                cr = new CheckResult(1, "Connection to database OK", stepMeta);
                remarks.add(cr);
                if (this.sql != null && this.sql.length() != 0) {
                    cr = new CheckResult(1, "SQL statement is entered", stepMeta);
                    remarks.add(cr);
                }
                cr = new CheckResult(4, "SQL statement is missing.", stepMeta);
                remarks.add(cr);
            }
            catch (ETLException e) {
                cr = new CheckResult(4, "An error occurred: " + e.getMessage(), stepMeta);
                remarks.add(cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            cr = new CheckResult(4, "Please select or create a connection to use", stepMeta);
            remarks.add(cr);
        }
        if (this.getLookupStepname() != null) {
            boolean found = false;
            for (int i = 0; i < input.length; ++i) {
                if (!this.getLookupStepname().equalsIgnoreCase(input[i])) continue;
                found = true;
            }
            if (found) {
                cr = new CheckResult(1, "Previous step to read info from [" + this.getLookupStepname() + "] is found.", stepMeta);
                remarks.add(cr);
            } else {
                cr = new CheckResult(4, "Previous step to read info from [" + this.getLookupStepname() + "] is not found.", stepMeta);
                remarks.add(cr);
            }
            int count = 0;
            for (int i = 0; i < this.sql.length(); ++i) {
                char c = this.sql.charAt(i);
                if (c == '\'') {
                    while ((c = this.sql.charAt(++i)) != '\'') {
                    }
                }
                if (c != '?') continue;
                ++count;
            }
            if (info != null) {
                if (count == info.size()) {
                    cr = new CheckResult(1, "This step is expecting and receiving " + info.size() + " fields of input from the previous step.", stepMeta);
                    remarks.add(cr);
                } else {
                    cr = new CheckResult(4, "This step is receiving " + info.size() + " but not the expected " + count + " fields of input from the previous step.", stepMeta);
                    remarks.add(cr);
                }
            } else {
                cr = new CheckResult(4, "Input step name is not recognized!", stepMeta);
                remarks.add(cr);
            }
        } else if (input.length > 0) {
            cr = new CheckResult(4, "Step is not expecting info from input steps.", stepMeta);
            remarks.add(cr);
        } else {
            cr = new CheckResult(1, "No input expected, no input provided.", stepMeta);
            remarks.add(cr);
        }
    }

    public String getLookupStepname() {
        if (this.lookupFromStep != null && this.lookupFromStep.getName() != null && this.lookupFromStep.getName().length() > 0) {
            return this.lookupFromStep.getName();
        }
        return null;
    }

    @Override
    public void searchInfoAndTargetSteps(List steps) {
        this.lookupFromStep = Const.findStep(steps, this.lookupFromStepname);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new TableInput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new TableInputData();
    }
}

