/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.tableoutput;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseBatchException;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.tableoutput.TableOutputData;
import com.kingdee.bos.ctrl.etl.transformation.step.tableoutput.TableOutputMeta;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.sql.PreparedStatement;
import java.text.SimpleDateFormat;

public class TableOutput
extends BaseStep
implements StepInterface {
    private TableOutputMeta meta;
    private TableOutputData data;

    public TableOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.meta = (TableOutputMeta)smi;
        this.data = (TableOutputData)sdi;
        Row r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        try {
            this.writeToTable(r);
            this.putRow(r);
            if (this.linesOutput > 0L && this.linesOutput % 5000L == 0L && this.linesOutput > 0L) {
                this.logBasic("linenr " + this.linesOutput);
            }
        }
        catch (ETLException e) {
            this.logError("Because of an error, this step can't continue: " + e.getMessage());
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    private boolean writeToTable(Row r) throws ETLException {
        this.debug = "start";
        if (r == null) {
            this.logDetailed("Last line inserted: stop");
            return false;
        }
        PreparedStatement insertStatement = null;
        String tableName = null;
        Value removedValue = null;
        if (this.meta.isTableNameInField()) {
            if (this.data.indexOfTableNameField < 0) {
                this.data.indexOfTableNameField = r.searchValueIndex(this.meta.getTableNameField());
                if (this.data.indexOfTableNameField < 0) {
                    String message = "Unable to find table name field [" + this.meta.getTableNameField() + "] in input row";
                    this.log.logError(this.toString(), message);
                    throw new ETLStepException(message);
                }
            }
            tableName = r.getValue(this.data.indexOfTableNameField).getString();
            if (!this.meta.isTableNameInTable()) {
                removedValue = r.getValue(this.data.indexOfTableNameField);
                r.removeValue(this.data.indexOfTableNameField);
            }
        } else if (this.meta.isPartitioningEnabled() && (this.meta.isPartitioningDaily() || this.meta.isPartitioningMonthly()) && this.meta.getPartitioningField() != null && this.meta.getPartitioningField().length() > 0) {
            Value partitioningValue;
            if (this.data.indexOfPartitioningField < 0) {
                this.data.indexOfPartitioningField = r.searchValueIndex(this.meta.getPartitioningField());
                if (this.data.indexOfPartitioningField < 0) {
                    throw new ETLStepException("Unable to find field [" + this.meta.getPartitioningField() + "] in the input row!");
                }
                this.data.dateFormater = this.meta.isPartitioningDaily() ? new SimpleDateFormat("yyyyMMdd") : new SimpleDateFormat("yyyyMM");
            }
            if (!(partitioningValue = r.getValue(this.data.indexOfPartitioningField)).isDate() || partitioningValue.isNull()) {
                throw new ETLStepException("Sorry, the partitioning field needs to contain a data value and can't be empty!");
            }
            tableName = tableName + "_" + this.data.dateFormater.format(partitioningValue.getDate());
        } else {
            tableName = Const.replEnv(this.meta.getTablename());
        }
        if (tableName == null || tableName.length() == 0) {
            throw new ETLStepException("The tablename is not defined (empty)");
        }
        insertStatement = (PreparedStatement)this.data.preparedStatements.get(tableName);
        if (insertStatement == null) {
            this.debug = "prepareInsert for table [" + tableName + "]";
            String sql = this.data.db.getInsertStatement(tableName, r);
            this.logDetailed("Prepared statement : " + sql);
            insertStatement = this.data.db.prepareSQL(sql);
            this.data.preparedStatements.put(tableName, insertStatement);
        }
        try {
            this.debug = "setValuesInsert";
            this.data.db.setValues(r, insertStatement);
            this.debug = "insertRow";
            this.data.db.insertRow(insertStatement, this.data.batchMode);
            ++this.linesOutput;
        }
        catch (ETLDatabaseBatchException be) {
            this.data.db.clearBatch(insertStatement);
            this.data.db.rollback();
            throw new ETLException("Error batch inserting rows into table [" + tableName + "]", be);
        }
        catch (ETLDatabaseException dbe) {
            this.debug = "Normal exception";
            if (this.meta.ignoreErrors()) {
                if (this.data.warnings < 20) {
                    this.logBasic("WARNING: Coudln't insert row into table: " + r + Const.CR + dbe.getMessage());
                } else if (this.data.warnings == 20) {
                    this.logBasic("FINAL WARNING (no more then 20 displayed): Coudln't insert row into table: " + r + Const.CR + dbe.getMessage());
                }
                ++this.data.warnings;
            }
            this.setErrors(this.getErrors() + 1L);
            this.data.db.rollback();
            throw new ETLException("Error inserting row into table [" + tableName + "] with values: " + r, dbe);
        }
        if (this.meta.isTableNameInField() && !this.meta.isTableNameInTable()) {
            this.debug = "add value of table name field";
            r.addValue(this.data.indexOfTableNameField, removedValue);
        }
        this.debug = "end";
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TableOutputMeta)smi;
        this.data = (TableOutputData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.data.batchMode = this.meta.getCommitSize() > 0 && this.meta.useBatchUpdate();
                this.data.db = new Database(this.meta.getDatabase());
                this.data.db.connect();
                this.logBasic("Connected to database [" + this.meta.getDatabase() + "] (commit=" + this.meta.getCommitSize() + ")");
                this.data.db.setCommit(this.meta.getCommitSize());
                if (!this.meta.isPartitioningEnabled() && !this.meta.isTableNameInField() && this.meta.truncateTable() && this.getCopy() == 0) {
                    this.data.db.truncateTable(Const.replEnv(this.meta.getTablename()));
                }
                return true;
            }
            catch (ETLException e) {
                this.logError("An error occurred intialising this step: " + e.getMessage());
                this.stopAll();
                this.setErrors(1L);
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TableOutputMeta)smi;
        this.data = (TableOutputData)sdi;
        try {
            for (PreparedStatement insertStatement : this.data.preparedStatements.values()) {
                this.data.db.insertFinished(insertStatement, this.data.batchMode);
            }
        }
        catch (ETLDatabaseBatchException be) {
            this.logError("Unexpected batch update error committing the database connection: " + be.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        catch (Exception dbe) {
            dbe.printStackTrace();
            this.logError("Unexpected error committing the database connection: " + dbe.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        this.data.db.disconnect();
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error encountered [" + this.debug + "] : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }
}

