/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.tableoutput;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.base.SQLStatement;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.tableoutput.TableOutput;
import com.kingdee.bos.ctrl.etl.transformation.step.tableoutput.TableOutputData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class TableOutputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private DatabaseMeta database;
    private String tablename;
    private int commitSize = 100;
    private boolean truncateTable;
    private boolean ignoreErrors;
    private boolean useBatchUpdate = true;
    private boolean partitioningEnabled;
    private String partitioningField;
    private boolean partitioningDaily;
    private boolean partitioningMonthly;
    private boolean tableNameInField;
    private String tableNameField;
    private boolean tableNameInTable;

    public boolean isTableNameInTable() {
        return this.tableNameInTable;
    }

    public void setTableNameInTable(boolean tableNameInTable) {
        this.tableNameInTable = tableNameInTable;
    }

    public String getTableNameField() {
        return this.tableNameField;
    }

    public void setTableNameField(String tableNameField) {
        this.tableNameField = tableNameField;
    }

    public boolean isTableNameInField() {
        return this.tableNameInField;
    }

    public void setTableNameInField(boolean tableNameInField) {
        this.tableNameInField = tableNameInField;
    }

    public boolean isPartitioningDaily() {
        return this.partitioningDaily;
    }

    public void setPartitioningDaily(boolean partitioningDaily) {
        this.partitioningDaily = partitioningDaily;
    }

    public boolean isPartitioningMonthly() {
        return this.partitioningMonthly;
    }

    public void setPartitioningMonthly(boolean partitioningMontly) {
        this.partitioningMonthly = partitioningMontly;
    }

    public boolean isPartitioningEnabled() {
        return this.partitioningEnabled;
    }

    public void setPartitioningEnabled(boolean partitioningEnabled) {
        this.partitioningEnabled = partitioningEnabled;
    }

    public String getPartitioningField() {
        return this.partitioningField;
    }

    public void setPartitioningField(String partitioningField) {
        this.partitioningField = partitioningField;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        TableOutputMeta retval = (TableOutputMeta)super.clone();
        return retval;
    }

    public DatabaseMeta getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseMeta database) {
        this.database = database;
    }

    public int getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public boolean truncateTable() {
        return this.truncateTable;
    }

    public void setTruncateTable(boolean truncateTable) {
        this.truncateTable = truncateTable;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public boolean ignoreErrors() {
        return this.ignoreErrors;
    }

    public void setUseBatchUpdate(boolean useBatchUpdate) {
        this.useBatchUpdate = useBatchUpdate;
    }

    public boolean useBatchUpdate() {
        return this.useBatchUpdate;
    }

    private void readData(Node stepnode, List databases) throws ETLXMLException {
        try {
            String con = XMLHandler.getTagValue(stepnode, "connection");
            this.database = Const.findDatabase(databases, con);
            this.tablename = XMLHandler.getTagValue(stepnode, "table");
            String commit = XMLHandler.getTagValue(stepnode, "commit");
            this.commitSize = Const.toInt(commit, 0);
            this.truncateTable = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "truncate"));
            this.ignoreErrors = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "ignore_errors"));
            this.useBatchUpdate = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "use_batch"));
            this.partitioningEnabled = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "partitioning_enabled"));
            this.partitioningField = XMLHandler.getTagValue(stepnode, "partitioning_field");
            this.partitioningDaily = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "partitioning_daily"));
            this.partitioningMonthly = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "partitioning_monthly"));
            this.tableNameInField = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "tablename_in_field"));
            this.tableNameField = XMLHandler.getTagValue(stepnode, "tablename_field");
            this.tableNameInTable = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "tablename_in_table"));
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load step info from XML", e);
        }
    }

    @Override
    public void setDefault() {
        this.database = null;
        this.tablename = "";
        this.commitSize = 0;
        this.partitioningEnabled = false;
        this.partitioningMonthly = true;
        this.partitioningField = "";
        this.tableNameInTable = true;
        this.tableNameField = "";
    }

    @Override
    public String getXML() {
        String retval = new String();
        retval = retval + "    " + XMLHandler.addTagValue("connection", this.database == null ? "" : this.database.getName());
        retval = retval + "    " + XMLHandler.addTagValue("table", this.tablename);
        retval = retval + "    " + XMLHandler.addTagValue("commit", this.commitSize);
        retval = retval + "    " + XMLHandler.addTagValue("truncate", this.truncateTable);
        retval = retval + "    " + XMLHandler.addTagValue("ignore_errors", this.ignoreErrors);
        retval = retval + "    " + XMLHandler.addTagValue("use_batch", this.useBatchUpdate);
        retval = retval + "    " + XMLHandler.addTagValue("partitioning_enabled", this.partitioningEnabled);
        retval = retval + "    " + XMLHandler.addTagValue("partitioning_field", this.partitioningField);
        retval = retval + "    " + XMLHandler.addTagValue("partitioning_daily", this.partitioningDaily);
        retval = retval + "    " + XMLHandler.addTagValue("partitioning_monthly", this.partitioningMonthly);
        retval = retval + "    " + XMLHandler.addTagValue("tablename_in_field", this.tableNameInField);
        retval = retval + "    " + XMLHandler.addTagValue("tablename_field", this.tableNameField);
        retval = retval + "    " + XMLHandler.addTagValue("tablename_in_table", this.tableNameInTable);
        return retval;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            long id_connection = rep.getStepAttributeInteger(id_step, "id_connection");
            this.database = Const.findDatabase(databases, id_connection);
            this.tablename = rep.getStepAttributeString(id_step, "table");
            this.commitSize = (int)rep.getStepAttributeInteger(id_step, "commit");
            this.truncateTable = rep.getStepAttributeBoolean(id_step, "truncate");
            this.ignoreErrors = rep.getStepAttributeBoolean(id_step, "ignore_errors");
            this.useBatchUpdate = rep.getStepAttributeBoolean(id_step, "use_batch");
            this.partitioningEnabled = rep.getStepAttributeBoolean(id_step, "partitioning_enabled");
            this.partitioningField = rep.getStepAttributeString(id_step, "partitioning_field");
            this.partitioningDaily = rep.getStepAttributeBoolean(id_step, "partitioning_daily");
            this.partitioningMonthly = rep.getStepAttributeBoolean(id_step, "partitioning_monthly");
            this.tableNameInField = rep.getStepAttributeBoolean(id_step, "tablename_in_field");
            this.tableNameField = rep.getStepAttributeString(id_step, "tablename_field");
            this.tableNameInTable = rep.getStepAttributeBoolean(id_step, "tablename_in_table");
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "id_connection", this.database == null ? -1.0 : (double)this.database.getID());
            rep.saveStepAttribute(id_transformation, id_step, "table", this.tablename);
            rep.saveStepAttribute(id_transformation, id_step, "commit", this.commitSize);
            rep.saveStepAttribute(id_transformation, id_step, "truncate", this.truncateTable);
            rep.saveStepAttribute(id_transformation, id_step, "ignore_errors", this.ignoreErrors);
            rep.saveStepAttribute(id_transformation, id_step, "use_batch", this.useBatchUpdate);
            rep.saveStepAttribute(id_transformation, id_step, "partitioning_enabled", this.partitioningEnabled);
            rep.saveStepAttribute(id_transformation, id_step, "partitioning_field", this.partitioningField);
            rep.saveStepAttribute(id_transformation, id_step, "partitioning_daily", this.partitioningDaily);
            rep.saveStepAttribute(id_transformation, id_step, "partitioning_monthly", this.partitioningMonthly);
            rep.saveStepAttribute(id_transformation, id_step, "tablename_in_field", this.tableNameInField);
            rep.saveStepAttribute(id_transformation, id_step, "tablename_field", this.tableNameField);
            rep.saveStepAttribute(id_transformation, id_step, "tablename_in_table", this.tableNameInTable);
            if (this.database != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.database.getID());
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(List remarks, StepMeta stepMeta, Row prev, String[] input, String[] output, Row info) {
        CheckResult cr;
        if (this.database != null) {
            cr = new CheckResult(1, "Connection exists", stepMeta);
            remarks.add(cr);
            Database db = new Database(this.database);
            try {
                db.connect();
                cr = new CheckResult(1, "Connection to database OK", stepMeta);
                remarks.add(cr);
                if (this.tablename != null && this.tablename.length() != 0) {
                    if (db.checkTableExists(this.tablename)) {
                        cr = new CheckResult(1, "Table [" + this.tablename + "] exists and is accessible", stepMeta);
                        remarks.add(cr);
                        Row r = db.getTableFields(this.tablename);
                        if (r != null) {
                            cr = new CheckResult(1, "Table [" + this.tablename + "] is readeable and we got the fields from it.", stepMeta);
                            remarks.add(cr);
                            String error_message = "";
                            boolean error_found = false;
                            if (prev != null && prev.size() > 0) {
                                int idx;
                                int i;
                                cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", stepMeta);
                                remarks.add(cr);
                                for (i = 0; i < prev.size(); ++i) {
                                    Value pv = prev.getValue(i);
                                    idx = r.searchValueIndex(pv.getName());
                                    if (idx >= 0) continue;
                                    error_message = error_message + "\t\t" + pv.getName() + " (" + pv.getTypeDesc() + ")" + Const.CR;
                                    error_found = true;
                                }
                                if (error_found) {
                                    error_message = "Fields in input stream, not found in output table:" + Const.CR + Const.CR + error_message;
                                    cr = new CheckResult(4, error_message, stepMeta);
                                    remarks.add(cr);
                                } else {
                                    cr = new CheckResult(1, "All fields, coming from previous steps, are found in the output table", stepMeta);
                                    remarks.add(cr);
                                }
                                for (i = 0; i < r.size(); ++i) {
                                    Value rv = r.getValue(i);
                                    idx = prev.searchValueIndex(rv.getName());
                                    if (idx >= 0) continue;
                                    error_message = error_message + "\t\t" + rv.getName() + " (" + rv.getTypeDesc() + ")" + Const.CR;
                                    error_found = true;
                                }
                                if (error_found) {
                                    error_message = "Fields in table, not found in input stream:" + Const.CR + Const.CR + error_message;
                                    cr = new CheckResult(4, error_message, stepMeta);
                                    remarks.add(cr);
                                }
                                cr = new CheckResult(1, "All fields in the table are found in the input stream, coming from previous steps", stepMeta);
                                remarks.add(cr);
                            }
                            cr = new CheckResult(4, "Couldn't find fields from previous steps, check the hops...!", stepMeta);
                            remarks.add(cr);
                        }
                        cr = new CheckResult(4, "Couldn't read the table info, please check the table-name & permissions.", stepMeta);
                        remarks.add(cr);
                    }
                    cr = new CheckResult(4, "Table [" + this.tablename + "] doesn't exist or can't be read on this database connection.", stepMeta);
                    remarks.add(cr);
                }
                cr = new CheckResult(4, "No table name was entered in this step.", stepMeta);
                remarks.add(cr);
            }
            catch (ETLException e) {
                cr = new CheckResult(4, "An error occurred: " + e.getMessage(), stepMeta);
                remarks.add(cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            cr = new CheckResult(4, "Please select or create a connection to use", stepMeta);
            remarks.add(cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", stepMeta);
            remarks.add(cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", stepMeta);
            remarks.add(cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new TableOutput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new TableOutputData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, Row prev) {
        SQLStatement retval = new SQLStatement(stepMeta.getName(), this.database, null);
        if (this.database != null) {
            if (prev != null && prev.size() > 0) {
                if (this.tablename != null && this.tablename.length() > 0) {
                    Database db = new Database(this.database);
                    try {
                        db.connect();
                        String cr_table = db.getDDL(this.tablename, prev);
                        if (cr_table == null || cr_table.length() == 0) {
                            cr_table = null;
                        }
                        retval.setSQL(cr_table);
                    }
                    catch (ETLDatabaseException dbe) {
                        retval.setError("I was unable to connect to the database to verify the status of the table: " + dbe.getMessage());
                    }
                    finally {
                        db.disconnect();
                    }
                } else {
                    retval.setError("No table is defined on this connection.");
                }
            } else {
                retval.setError("Not receiving any fields from previous steps. Check the previous steps for errors & the connecting hops.");
            }
        } else {
            retval.setError("There is no connection defined in this step.");
        }
        return retval;
    }
}

