/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.textfileinput;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.textfileinput.TextFileFilter;
import com.kingdee.bos.ctrl.etl.transformation.step.textfileinput.TextFileInput;
import com.kingdee.bos.ctrl.etl.transformation.step.textfileinput.TextFileInputData;
import com.kingdee.bos.ctrl.etl.transformation.step.textfileinput.TextFileInputField;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Node;

public class TextFileInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    public static final int TYPE_TRIM_NONE = 0;
    public static final int TYPE_TRIM_LEFT = 1;
    public static final int TYPE_TRIM_RIGHT = 2;
    public static final int TYPE_TRIM_BOTH = 3;
    public static final String[] trimTypeDesc = new String[]{"none", "left", "right", "both"};
    private String[] fileName;
    private String[] fileMask;
    private String fileType;
    private String separator;
    private String enclosure;
    private String escapeCharacter;
    private boolean header;
    private int nrHeaderLines;
    private boolean footer;
    private int nrFooterLines;
    private boolean lineWrapped;
    private int nrWraps;
    private boolean layoutPaged;
    private int nrLinesDocHeader;
    private int nrLinesPerPage;
    private boolean zipped;
    private boolean noEmptyLines;
    private boolean includeFilename;
    private String filenameField;
    private boolean includeRowNumber;
    private String rowNumberField;
    private String fileFormat;
    private long rowLimit;
    private TextFileInputField[] inputFields;
    private TextFileFilter[] filter;
    private String encoding;
    private boolean errorIgnored;
    private String errorCountField;
    private String errorFieldsField;
    private String errorTextField;

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public TextFileInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(TextFileInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public String getEnclosure() {
        return this.enclosure;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public String[] getFileMask() {
        return this.fileMask;
    }

    public void setFileMask(String[] fileMask) {
        this.fileMask = fileMask;
    }

    public String[] getFileName() {
        return this.fileName;
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public TextFileFilter[] getFilter() {
        return this.filter;
    }

    public void setFilter(TextFileFilter[] filter) {
        this.filter = filter;
    }

    public boolean hasFooter() {
        return this.footer;
    }

    public void setFooter(boolean footer) {
        this.footer = footer;
    }

    public boolean hasHeader() {
        return this.header;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public boolean includeFilename() {
        return this.includeFilename;
    }

    public void setIncludeFilename(boolean includeFilename) {
        this.includeFilename = includeFilename;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public boolean noEmptyLines() {
        return this.noEmptyLines;
    }

    public void setNoEmptyLines(boolean noEmptyLines) {
        this.noEmptyLines = noEmptyLines;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public boolean isZipped() {
        return this.zipped;
    }

    public void setZipped(boolean zipped) {
        this.zipped = zipped;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        int i;
        TextFileInputMeta retval = (TextFileInputMeta)super.clone();
        int nrfiles = this.fileName.length;
        int nrfields = this.inputFields.length;
        int nrfilters = this.filter.length;
        retval.allocate(nrfiles, nrfields, nrfilters);
        for (i = 0; i < nrfields; ++i) {
            retval.inputFields[i] = (TextFileInputField)this.inputFields[i].clone();
        }
        for (i = 0; i < nrfilters; ++i) {
            retval.filter[i] = (TextFileFilter)this.filter[i].clone();
        }
        return retval;
    }

    public void allocate(int nrfiles, int nrfields, int nrfilters) {
        this.fileName = new String[nrfiles];
        this.fileMask = new String[nrfiles];
        this.inputFields = new TextFileInputField[nrfields];
        this.filter = new TextFileFilter[nrfilters];
    }

    @Override
    public void setDefault() {
        int i;
        this.separator = ";";
        this.enclosure = "\"";
        this.header = true;
        this.nrHeaderLines = 1;
        this.footer = false;
        this.nrFooterLines = 1;
        this.lineWrapped = false;
        this.nrWraps = 1;
        this.layoutPaged = false;
        this.nrLinesPerPage = 80;
        this.nrLinesDocHeader = 0;
        this.zipped = false;
        this.noEmptyLines = true;
        this.fileFormat = "DOS";
        this.fileType = "CSV";
        this.includeFilename = false;
        this.filenameField = "";
        this.includeRowNumber = false;
        this.rowNumberField = "";
        int nrfiles = 0;
        int nrfields = 0;
        int nrfilters = 0;
        this.allocate(nrfiles, nrfields, nrfilters);
        for (i = 0; i < nrfiles; ++i) {
            this.fileName[i] = "filename" + (i + 1);
            this.fileMask[i] = "";
        }
        for (i = 0; i < nrfields; ++i) {
            this.inputFields[i] = new TextFileInputField("field" + (i + 1), 1, -1);
        }
        this.rowLimit = 0L;
    }

    @Override
    public Row getFields(Row r, String name, Row info) {
        Value v;
        Row row = r == null ? new Row() : r;
        for (int i = 0; i < this.inputFields.length; ++i) {
            TextFileInputField field = this.inputFields[i];
            int type = field.getType();
            if (type == 0) {
                type = 2;
            }
            Value v2 = new Value(field.getName(), type);
            v2.setLength(field.getLength(), field.getPrecision());
            v2.setOrigin(name);
            row.addValue(v2);
        }
        if (this.errorIgnored) {
            if (this.errorCountField != null && this.errorCountField.length() > 0) {
                v = new Value(this.errorCountField, 5);
                v.setOrigin(name);
                row.addValue(v);
            }
            if (this.errorFieldsField != null && this.errorFieldsField.length() > 0) {
                v = new Value(this.errorFieldsField, 2);
                v.setOrigin(name);
                row.addValue(v);
            }
            if (this.errorTextField != null && this.errorTextField.length() > 0) {
                v = new Value(this.errorTextField, 2);
                v.setOrigin(name);
                row.addValue(v);
            }
        }
        if (this.includeFilename) {
            v = new Value(this.filenameField, 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValue(v);
        }
        if (this.includeRowNumber) {
            v = new Value(this.rowNumberField, 1);
            v.setLength(7, 0);
            v.setOrigin(name);
            row.addValue(v);
        }
        return row;
    }

    @Override
    public String getXML() {
        int i;
        String retval = "";
        retval = retval + "    " + XMLHandler.addTagValue("separator", this.separator);
        retval = retval + "    " + XMLHandler.addTagValue("enclosure", this.enclosure);
        retval = retval + "    " + XMLHandler.addTagValue("escapechar", this.escapeCharacter);
        retval = retval + "    " + XMLHandler.addTagValue("header", this.header);
        retval = retval + "    " + XMLHandler.addTagValue("nr_headerlines", this.nrHeaderLines);
        retval = retval + "    " + XMLHandler.addTagValue("footer", this.footer);
        retval = retval + "    " + XMLHandler.addTagValue("nr_footerlines", this.nrFooterLines);
        retval = retval + "    " + XMLHandler.addTagValue("line_wrapped", this.lineWrapped);
        retval = retval + "    " + XMLHandler.addTagValue("nr_wraps", this.nrWraps);
        retval = retval + "    " + XMLHandler.addTagValue("layout_paged", this.layoutPaged);
        retval = retval + "    " + XMLHandler.addTagValue("nr_lines_per_page", this.nrLinesPerPage);
        retval = retval + "    " + XMLHandler.addTagValue("nr_lines_doc_header", this.nrLinesDocHeader);
        retval = retval + "    " + XMLHandler.addTagValue("noempty", this.noEmptyLines);
        retval = retval + "    " + XMLHandler.addTagValue("include", this.includeFilename);
        retval = retval + "    " + XMLHandler.addTagValue("include_field", this.filenameField);
        retval = retval + "    " + XMLHandler.addTagValue("rownum", this.includeRowNumber);
        retval = retval + "    " + XMLHandler.addTagValue("rownum_field", this.rowNumberField);
        retval = retval + "    " + XMLHandler.addTagValue("format", this.fileFormat);
        retval = retval + "    " + XMLHandler.addTagValue("encoding", this.encoding);
        retval = retval + "    <file>" + Const.CR;
        for (i = 0; i < this.fileName.length; ++i) {
            retval = retval + "      " + XMLHandler.addTagValue("name", this.fileName[i]);
            retval = retval + "      " + XMLHandler.addTagValue("filemask", this.fileMask[i]);
        }
        retval = retval + "      " + XMLHandler.addTagValue("type", this.fileType);
        retval = retval + "      " + XMLHandler.addTagValue("zipped", this.zipped);
        retval = retval + "      </file>" + Const.CR;
        retval = retval + "    <filters>" + Const.CR;
        for (i = 0; i < this.filter.length; ++i) {
            retval = retval + "      <filter>" + Const.CR;
            retval = retval + "        " + XMLHandler.addTagValue("filter_string", this.filter[i].getFilterString(), false);
            retval = retval + "        " + XMLHandler.addTagValue("filter_position", this.filter[i].getFilterPosition(), false);
            retval = retval + "        " + XMLHandler.addTagValue("filter_is_last_line", this.filter[i].isFilterLastLine(), false);
            retval = retval + "      <filter>" + Const.CR;
        }
        retval = retval + "      </filters>" + Const.CR;
        retval = retval + "    <fields>" + Const.CR;
        for (i = 0; i < this.inputFields.length; ++i) {
            TextFileInputField field = this.inputFields[i];
            retval = retval + "      <field>" + Const.CR;
            retval = retval + "        " + XMLHandler.addTagValue("name", field.getName());
            retval = retval + "        " + XMLHandler.addTagValue("type", field.getTypeDesc());
            retval = retval + "        " + XMLHandler.addTagValue("format", field.getFormat());
            retval = retval + "        " + XMLHandler.addTagValue("currency", field.getCurrencySymbol());
            retval = retval + "        " + XMLHandler.addTagValue("decimal", field.getDecimalSymbol());
            retval = retval + "        " + XMLHandler.addTagValue("group", field.getGroupSymbol());
            retval = retval + "        " + XMLHandler.addTagValue("nullif", field.getNullString());
            retval = retval + "        " + XMLHandler.addTagValue("position", field.getPosition());
            retval = retval + "        " + XMLHandler.addTagValue("length", field.getLength());
            retval = retval + "        " + XMLHandler.addTagValue("precision", field.getPrecision());
            retval = retval + "        " + XMLHandler.addTagValue("trim_type", field.getTrimTypeDesc());
            retval = retval + "        " + XMLHandler.addTagValue("repeat", field.isRepeated());
            retval = retval + "        </field>" + Const.CR;
        }
        retval = retval + "      </fields>" + Const.CR;
        retval = retval + "    " + XMLHandler.addTagValue("limit", this.rowLimit);
        retval = retval + "    " + XMLHandler.addTagValue("error_ignored", this.errorIgnored);
        retval = retval + "    " + XMLHandler.addTagValue("error_count_field", this.errorCountField);
        retval = retval + "    " + XMLHandler.addTagValue("error_fields_field", this.errorFieldsField);
        retval = retval + "    " + XMLHandler.addTagValue("error_text_field", this.errorTextField);
        return retval;
    }

    private void readData(Node stepnode) throws ETLXMLException {
        try {
            Node fnode;
            int i;
            this.separator = XMLHandler.getTagValue(stepnode, "separator");
            this.enclosure = XMLHandler.getTagValue(stepnode, "enclosure");
            this.escapeCharacter = XMLHandler.getTagValue(stepnode, "escapechar");
            this.header = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "header"));
            this.nrHeaderLines = Const.toInt(XMLHandler.getTagValue(stepnode, "nr_headerlines"), 1);
            this.footer = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "footer"));
            this.nrFooterLines = Const.toInt(XMLHandler.getTagValue(stepnode, "nr_footerlines"), 1);
            this.lineWrapped = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "line_wrapped"));
            this.nrWraps = Const.toInt(XMLHandler.getTagValue(stepnode, "nr_wraps"), 1);
            this.layoutPaged = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "layout_paged"));
            this.nrLinesPerPage = Const.toInt(XMLHandler.getTagValue(stepnode, "nr_lines_per_page"), 1);
            this.nrLinesDocHeader = Const.toInt(XMLHandler.getTagValue(stepnode, "nr_lines_doc_header"), 1);
            String nempty = XMLHandler.getTagValue(stepnode, "noempty");
            this.noEmptyLines = "Y".equalsIgnoreCase(nempty) || nempty == null;
            this.includeFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "include"));
            this.filenameField = XMLHandler.getTagValue(stepnode, "include_field");
            this.includeRowNumber = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "rownum"));
            this.rowNumberField = XMLHandler.getTagValue(stepnode, "rownum_field");
            this.fileFormat = XMLHandler.getTagValue(stepnode, "format");
            this.encoding = XMLHandler.getTagValue(stepnode, "encoding");
            Node filenode = XMLHandler.getSubNode(stepnode, "file");
            Node fields = XMLHandler.getSubNode(stepnode, "fields");
            Node filtersNode = XMLHandler.getSubNode(stepnode, "filters");
            int nrfiles = XMLHandler.countNodes(filenode, "name");
            int nrfields = XMLHandler.countNodes(fields, "field");
            int nrfilters = XMLHandler.countNodes(fields, "filter");
            this.allocate(nrfiles, nrfields, nrfilters);
            for (i = 0; i < nrfiles; ++i) {
                Node filenamenode = XMLHandler.getSubNodeByNr(filenode, "name", i);
                Node filemasknode = XMLHandler.getSubNodeByNr(filenode, "filemask", i);
                this.fileName[i] = XMLHandler.getNodeValue(filenamenode);
                this.fileMask[i] = XMLHandler.getNodeValue(filemasknode);
            }
            this.fileType = XMLHandler.getTagValue(stepnode, "file", "type");
            this.zipped = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "file", "zipped"));
            if (XMLHandler.getTagValue(stepnode, "filter") != null) {
                this.filter = new TextFileFilter[1];
                this.filter[0] = new TextFileFilter();
                this.filter[0].setFilterPosition(Const.toInt(XMLHandler.getTagValue(stepnode, "filter_position"), -1));
                this.filter[0].setFilterString(XMLHandler.getTagValue(stepnode, "filter_string"));
                this.filter[0].setFilterLastLine("Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "filter_is_last_line")));
            } else {
                for (i = 0; i < nrfilters; ++i) {
                    fnode = XMLHandler.getSubNodeByNr(filtersNode, "filter", i);
                    this.filter[i] = new TextFileFilter();
                    this.filter[i].setFilterPosition(Const.toInt(XMLHandler.getTagValue(fnode, "filter_position"), -1));
                    this.filter[i].setFilterString(XMLHandler.getTagValue(fnode, "filter_string"));
                    this.filter[i].setFilterLastLine("Y".equalsIgnoreCase(XMLHandler.getTagValue(fnode, "filter_is_last_line")));
                }
            }
            for (i = 0; i < nrfields; ++i) {
                fnode = XMLHandler.getSubNodeByNr(fields, "field", i);
                TextFileInputField field = new TextFileInputField();
                field.setName(XMLHandler.getTagValue(fnode, "name"));
                field.setType(Value.getType(XMLHandler.getTagValue(fnode, "type")));
                field.setFormat(XMLHandler.getTagValue(fnode, "format"));
                field.setCurrencySymbol(XMLHandler.getTagValue(fnode, "currency"));
                field.setDecimalSymbol(XMLHandler.getTagValue(fnode, "decimal"));
                field.setGroupSymbol(XMLHandler.getTagValue(fnode, "group"));
                field.setNullString(XMLHandler.getTagValue(fnode, "nullif"));
                field.setPosition(Const.toInt(XMLHandler.getTagValue(fnode, "position"), -1));
                field.setLength(Const.toInt(XMLHandler.getTagValue(fnode, "length"), -1));
                field.setPrecision(Const.toInt(XMLHandler.getTagValue(fnode, "precision"), -1));
                field.setTrimType(TextFileInputMeta.getTrimType(XMLHandler.getTagValue(fnode, "trim_type")));
                String srepeat = XMLHandler.getTagValue(fnode, "repeat");
                if (srepeat != null) {
                    field.setRepeated("Y".equalsIgnoreCase(srepeat));
                } else {
                    field.setRepeated(false);
                }
                this.inputFields[i] = field;
            }
            this.rowLimit = Const.toLong(XMLHandler.getTagValue(stepnode, "limit"), 0L);
            this.errorIgnored = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "error_ignored"));
            this.errorCountField = XMLHandler.getTagValue(stepnode, "error_count_field");
            this.errorFieldsField = XMLHandler.getTagValue(stepnode, "error_fields_field");
            this.errorTextField = XMLHandler.getTagValue(stepnode, "error_text_field");
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load step info from XML", e);
        }
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            int i;
            this.separator = rep.getStepAttributeString(id_step, "separator");
            this.enclosure = rep.getStepAttributeString(id_step, "enclosure");
            this.escapeCharacter = rep.getStepAttributeString(id_step, "escapechar");
            this.header = rep.getStepAttributeBoolean(id_step, "header");
            this.nrHeaderLines = (int)rep.getStepAttributeInteger(id_step, "nr_headerlines");
            this.footer = rep.getStepAttributeBoolean(id_step, "footer");
            this.nrFooterLines = (int)rep.getStepAttributeInteger(id_step, "nr_footerlines");
            this.lineWrapped = rep.getStepAttributeBoolean(id_step, "line_wrapped");
            this.nrWraps = (int)rep.getStepAttributeInteger(id_step, "nr_wraps");
            this.layoutPaged = rep.getStepAttributeBoolean(id_step, "layout_paged");
            this.nrLinesPerPage = (int)rep.getStepAttributeInteger(id_step, "nr_lines_per_page");
            this.nrLinesDocHeader = (int)rep.getStepAttributeInteger(id_step, "nr_lines_doc_header");
            this.noEmptyLines = rep.getStepAttributeBoolean(id_step, "noempty");
            this.includeFilename = rep.getStepAttributeBoolean(id_step, "include");
            this.filenameField = rep.getStepAttributeString(id_step, "include_field");
            this.includeRowNumber = rep.getStepAttributeBoolean(id_step, "rownum");
            this.rowNumberField = rep.getStepAttributeString(id_step, "rownum_field");
            this.fileFormat = rep.getStepAttributeString(id_step, "format");
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            this.rowLimit = (int)rep.getStepAttributeInteger(id_step, "limit");
            int nrfiles = rep.countNrStepAttributes(id_step, "file_name");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            int nrfilters = rep.countNrStepAttributes(id_step, "filter_string");
            this.allocate(nrfiles, nrfields, nrfilters);
            for (i = 0; i < nrfiles; ++i) {
                this.fileName[i] = rep.getStepAttributeString(id_step, i, "file_name");
                this.fileMask[i] = rep.getStepAttributeString(id_step, i, "file_mask");
            }
            this.fileType = rep.getStepAttributeString(id_step, "file_type");
            this.zipped = rep.getStepAttributeBoolean(id_step, "file_zipped");
            for (i = 0; i < nrfilters; ++i) {
                this.filter[i] = new TextFileFilter();
                this.filter[i].setFilterPosition((int)rep.getStepAttributeInteger(id_step, i, "filter_position"));
                this.filter[i].setFilterString(rep.getStepAttributeString(id_step, i, "filter_string"));
                this.filter[i].setFilterLastLine(rep.getStepAttributeBoolean(id_step, i, "filter_is_last_line"));
            }
            for (i = 0; i < nrfields; ++i) {
                TextFileInputField field = new TextFileInputField();
                field.setName(rep.getStepAttributeString(id_step, i, "field_name"));
                field.setType(Value.getType(rep.getStepAttributeString(id_step, i, "field_type")));
                field.setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                field.setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                field.setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                field.setGroupSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
                field.setNullString(rep.getStepAttributeString(id_step, i, "field_nullif"));
                field.setPosition((int)rep.getStepAttributeInteger(id_step, i, "field_position"));
                field.setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                field.setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
                field.setTrimType(TextFileInputMeta.getTrimType(rep.getStepAttributeString(id_step, i, "field_trim_type")));
                field.setRepeated(rep.getStepAttributeBoolean(id_step, i, "field_repeat"));
                this.inputFields[i] = field;
            }
            this.errorIgnored = rep.getStepAttributeBoolean(id_step, "error_ignored");
            this.errorCountField = rep.getStepAttributeString(id_step, "error_count_field");
            this.errorFieldsField = rep.getStepAttributeString(id_step, "error_fields_field");
            this.errorTextField = rep.getStepAttributeString(id_step, "error_text_field");
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "separator", this.separator);
            rep.saveStepAttribute(id_transformation, id_step, "enclosure", this.enclosure);
            rep.saveStepAttribute(id_transformation, id_step, "escapechar", this.escapeCharacter);
            rep.saveStepAttribute(id_transformation, id_step, "header", this.header);
            rep.saveStepAttribute(id_transformation, id_step, "nr_headerlines", this.nrHeaderLines);
            rep.saveStepAttribute(id_transformation, id_step, "footer", this.footer);
            rep.saveStepAttribute(id_transformation, id_step, "nr_footerlines", this.nrFooterLines);
            rep.saveStepAttribute(id_transformation, id_step, "line_wrapped", this.lineWrapped);
            rep.saveStepAttribute(id_transformation, id_step, "nr_wraps", this.nrWraps);
            rep.saveStepAttribute(id_transformation, id_step, "layout_paged", this.layoutPaged);
            rep.saveStepAttribute(id_transformation, id_step, "nr_lines_per_page", this.nrLinesPerPage);
            rep.saveStepAttribute(id_transformation, id_step, "nr_lines_doc_header", this.nrLinesDocHeader);
            rep.saveStepAttribute(id_transformation, id_step, "noempty", this.noEmptyLines);
            rep.saveStepAttribute(id_transformation, id_step, "include", this.includeFilename);
            rep.saveStepAttribute(id_transformation, id_step, "include_field", this.filenameField);
            rep.saveStepAttribute(id_transformation, id_step, "rownum", this.includeRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, "rownum_field", this.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "format", this.fileFormat);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            for (i = 0; i < this.fileName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "file_name", this.fileName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "file_mask", this.fileMask[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, "file_type", this.fileType);
            rep.saveStepAttribute(id_transformation, id_step, "file_zipped", this.zipped);
            for (i = 0; i < this.filter.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "filter_position", this.filter[i].getFilterPosition());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "filter_string", this.filter[i].getFilterString());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "filter_is_last_line", this.filter[i].isFilterLastLine());
            }
            for (i = 0; i < this.inputFields.length; ++i) {
                TextFileInputField field = this.inputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_currency", field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_decimal", field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_group", field.getGroupSymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_nullif", field.getNullString());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_position", field.getPosition());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_length", field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_precision", field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_trim_type", field.getTrimTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_repeat", field.isRepeated());
            }
            rep.saveStepAttribute(id_transformation, id_step, "error_ignored", this.errorIgnored);
            rep.saveStepAttribute(id_transformation, id_step, "error_count_field", this.errorCountField);
            rep.saveStepAttribute(id_transformation, id_step, "error_fields_field", this.errorFieldsField);
            rep.saveStepAttribute(id_transformation, id_step, "error_text_field", this.errorTextField);
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    public static final int getTrimType(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeDesc.length; ++i) {
            if (!trimTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final String getTrimTypeDesc(int i) {
        if (i < 0 || i >= trimTypeDesc.length) {
            return trimTypeDesc[0];
        }
        return trimTypeDesc[i];
    }

    public String[] getFiles() {
        Object files = null;
        String[] realfile = Const.replEnv(this.fileName);
        String[] realmask = Const.replEnv(this.fileMask);
        ArrayList<String> filelist = new ArrayList<String>();
        for (int i = 0; i < realfile.length; ++i) {
            File file;
            String onefile = realfile[i];
            final String onemask = realmask[i];
            if (onemask != null && onemask.length() > 0) {
                file = new File(FilenameUtils.normalize((String)onefile));
                try {
                    files = file.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return Pattern.matches(onemask, name);
                        }
                    });
                    for (int j = 0; j < ((String[])files).length; ++j) {
                        files[j] = !onefile.endsWith(Const.FILE_SEPARATOR) ? onefile + Const.FILE_SEPARATOR + files[j] : onefile + files[j];
                    }
                }
                catch (Exception e) {
                    files = null;
                }
            } else {
                file = new File(FilenameUtils.normalize((String)onefile));
                files = file.exists() && file.isFile() && file.canRead() ? new String[]{onefile} : null;
            }
            if (files == null) continue;
            for (int x = 0; x < ((String[])files).length; ++x) {
                filelist.add(files[x]);
            }
        }
        Collections.sort(filelist);
        files = filelist.toArray(new String[filelist.size()]);
        return files;
    }

    @Override
    public void check(List remarks, StepMeta stepinfo, Row prev, String[] input, String[] output, Row info) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(4, "This step is not expecting nor reading any input", stepinfo);
            remarks.add(cr);
        } else {
            cr = new CheckResult(1, "Not receiving any input from other steps.", stepinfo);
            remarks.add(cr);
        }
        String[] files = this.getFiles();
        if (files == null || files.length == 0) {
            cr = new CheckResult(4, "No files can be found to read.", stepinfo);
            remarks.add(cr);
        } else {
            cr = new CheckResult(1, "This step is reading " + files.length + " files.", stepinfo);
            remarks.add(cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new TextFileInput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new TextFileInputData();
    }

    public String getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public void setEscapeCharacter(String escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    public String getErrorCountField() {
        return this.errorCountField;
    }

    public void setErrorCountField(String errorCountField) {
        this.errorCountField = errorCountField;
    }

    public String getErrorFieldsField() {
        return this.errorFieldsField;
    }

    public void setErrorFieldsField(String errorFieldsField) {
        this.errorFieldsField = errorFieldsField;
    }

    public boolean isErrorIgnored() {
        return this.errorIgnored;
    }

    public void setErrorIgnored(boolean errorIgnored) {
        this.errorIgnored = errorIgnored;
    }

    public String getErrorTextField() {
        return this.errorTextField;
    }

    public void setErrorTextField(String errorTextField) {
        this.errorTextField = errorTextField;
    }

    public boolean isLineWrapped() {
        return this.lineWrapped;
    }

    public void setLineWrapped(boolean lineWrapped) {
        this.lineWrapped = lineWrapped;
    }

    public int getNrFooterLines() {
        return this.nrFooterLines;
    }

    public void setNrFooterLines(int nrFooterLines) {
        this.nrFooterLines = nrFooterLines;
    }

    public int getNrHeaderLines() {
        return this.nrHeaderLines;
    }

    public void setNrHeaderLines(int nrHeaderLines) {
        this.nrHeaderLines = nrHeaderLines;
    }

    public int getNrWraps() {
        return this.nrWraps;
    }

    public void setNrWraps(int nrWraps) {
        this.nrWraps = nrWraps;
    }

    public boolean isLayoutPaged() {
        return this.layoutPaged;
    }

    public void setLayoutPaged(boolean layoutPaged) {
        this.layoutPaged = layoutPaged;
    }

    public int getNrLinesPerPage() {
        return this.nrLinesPerPage;
    }

    public void setNrLinesPerPage(int nrLinesPerPage) {
        this.nrLinesPerPage = nrLinesPerPage;
    }

    public int getNrLinesDocHeader() {
        return this.nrLinesDocHeader;
    }

    public void setNrLinesDocHeader(int nrLinesDocHeader) {
        this.nrLinesDocHeader = nrLinesDocHeader;
    }
}

