/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.update;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.update.UpdateData;
import com.kingdee.bos.ctrl.etl.transformation.step.update.UpdateMeta;
import com.kingdee.bos.ctrl.etl.value.Value;

public class Update
extends BaseStep
implements StepInterface {
    private UpdateMeta meta;
    private UpdateData data;

    public Update(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private synchronized void lookupValues(Row row) throws ETLException {
        int i;
        this.debug = "Start of lookupValues";
        if (this.first) {
            this.debug = "first run, initialize";
            this.first = false;
            this.data.dblup.setLookup(this.meta.getTableName(), this.meta.getKeyLookup(), this.meta.getKeyCondition(), this.meta.getUpdateLookup(), null, null);
            this.data.dbupd.prepareUpdate(this.meta.getTableName(), this.meta.getKeyLookup(), this.meta.getKeyCondition(), this.meta.getUpdateLookup());
            this.debug = "first run, lookup values, field positions, etc.";
            this.logDetailed("Checking row: " + row.toString());
            this.data.keynrs = new int[this.meta.getKeyStream().length];
            this.data.keynrs2 = new int[this.meta.getKeyStream().length];
            for (i = 0; i < this.meta.getKeyStream().length; ++i) {
                this.data.keynrs[i] = row.searchValueIndex(this.meta.getKeyStream()[i]);
                if (this.data.keynrs[i] < 0 && !"IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i]) && !"IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                    throw new ETLStepException("Field [" + this.meta.getKeyStream()[i] + "] is required and couldn't be found!");
                }
                this.data.keynrs2[i] = row.searchValueIndex(this.meta.getKeyStream2()[i]);
                if (this.data.keynrs2[i] < 0 && "BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                    throw new ETLStepException("Field [" + this.meta.getKeyStream2()[i] + "] is required and couldn't be found!");
                }
                this.logDebug("Field [" + this.meta.getKeyStream()[i] + "] has nr. " + this.data.keynrs[i]);
            }
            this.debug = "first run, lookup compare fields, positions, etc.";
            this.data.valuenrs = new int[this.meta.getUpdateLookup().length];
            for (i = 0; i < this.meta.getUpdateLookup().length; ++i) {
                this.data.valuenrs[i] = row.searchValueIndex(this.meta.getUpdateStream()[i]);
                if (this.data.valuenrs[i] < 0) {
                    throw new ETLStepException("Field [" + this.meta.getUpdateStream()[i] + "] is required and couldn't be found!");
                }
                this.logDebug("Field [" + this.meta.getUpdateStream()[i] + "] has nr. " + this.data.valuenrs[i]);
            }
        }
        Row lu = new Row();
        for (i = 0; i < this.meta.getKeyStream().length; ++i) {
            if (this.data.keynrs[i] >= 0) {
                lu.addValue(row.getValue(this.data.keynrs[i]));
            }
            if (this.data.keynrs2[i] < 0) continue;
            lu.addValue(row.getValue(this.data.keynrs2[i]));
        }
        this.debug = "setValues()";
        this.data.dblup.setValuesLookup(lu);
        this.logDebug("Values set for lookup: " + lu.toString() + ", input row: " + row);
        this.debug = "getLookup()";
        Row add = this.data.dblup.getLookup();
        ++this.linesInput;
        if (add == null) {
            if (!this.meta.isErrorIgnored()) {
                throw new ETLDatabaseException("Entry to update with following key could not be found: " + lu);
            }
            this.log.logDetailed(this.toString(), "WARNING: key could not be found for update: " + lu);
            if (this.meta.getIgnoreFlagField() != null && this.meta.getIgnoreFlagField().length() > 0) {
                row.addValue(new Value(this.meta.getIgnoreFlagField(), false));
            }
        } else {
            this.logRowlevel("Found row: !" + add.toString());
            this.debug = "compare for update";
            boolean update = false;
            for (int i2 = 0; i2 < this.data.valuenrs.length; ++i2) {
                Value rowvalue = row.getValue(this.data.valuenrs[i2]);
                lu.addValue(i2, rowvalue);
                Value retvalue = add.getValue(i2);
                if (rowvalue.equals(retvalue)) continue;
                update = true;
            }
            if (update) {
                this.logRowlevel("Update row with: !" + lu.toString());
                this.debug = "setValuesUpdate()";
                this.data.dbupd.setValuesUpdate(lu);
                this.debug = "updateRow()";
                this.data.dbupd.updateRow();
                ++this.linesUpdated;
            } else {
                ++this.linesSkipped;
            }
            if (this.meta.getIgnoreFlagField() != null && this.meta.getIgnoreFlagField().length() > 0) {
                row.addValue(new Value(this.meta.getIgnoreFlagField(), false));
            }
        }
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.meta = (UpdateMeta)smi;
        this.data = (UpdateData)sdi;
        Row r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        try {
            this.lookupValues(r);
            this.putRow(r);
            if (this.linesRead > 0L && this.linesRead % 5000L == 0L) {
                this.logBasic("linenr " + this.linesRead);
            }
        }
        catch (ETLException e) {
            this.logError("Error in step, asking everyone to stop because of:" + e.getMessage());
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (UpdateMeta)smi;
        this.data = (UpdateData)sdi;
        if (super.init(smi, sdi)) {
            this.data.dblup = new Database(this.meta.getDatabase());
            this.data.dbupd = new Database(this.meta.getDatabase());
            try {
                this.data.dblup.connect();
                this.data.dbupd.connect();
                this.logBasic("Connected to database...");
                this.data.dbupd.setCommit(this.meta.getCommitSize());
                return true;
            }
            catch (ETLException ke) {
                this.logError("An error occurred, processing will be stopped: " + ke.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (UpdateMeta)smi;
        this.data = (UpdateData)sdi;
        try {
            if (!this.data.dbupd.isAutoCommit()) {
                this.data.dbupd.commit();
            }
            this.data.dbupd.closeUpdate();
        }
        catch (ETLDatabaseException e) {
            this.log.logError(this.toString(), "Unable to commit Update connection [" + this.data.dbupd + "] :" + e.toString());
            this.setErrors(1L);
        }
        this.data.dblup.disconnect();
        this.data.dbupd.disconnect();
        super.dispose(smi, sdi);
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }
}

