/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.cmp;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1Encodable;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1EncodableVector;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1Sequence;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1TaggedObject;
import com.kingdee.bos.ctrl.cipher.asn1.DERObject;
import com.kingdee.bos.ctrl.cipher.asn1.DERSequence;
import com.kingdee.bos.ctrl.cipher.asn1.DERTaggedObject;
import com.kingdee.bos.ctrl.cipher.asn1.cmp.CMPCertificate;
import com.kingdee.bos.ctrl.cipher.asn1.cmp.CertResponse;

public class CertRepMessage
extends ASN1Encodable {
    private ASN1Sequence caPubs;
    private ASN1Sequence response;

    private CertRepMessage(ASN1Sequence seq) {
        int index = 0;
        if (seq.size() > 1) {
            this.caPubs = ASN1Sequence.getInstance((ASN1TaggedObject)seq.getObjectAt(index++), true);
        }
        this.response = ASN1Sequence.getInstance(seq.getObjectAt(index));
    }

    public static CertRepMessage getInstance(Object o) {
        if (o instanceof CertRepMessage) {
            return (CertRepMessage)o;
        }
        if (o instanceof ASN1Sequence) {
            return new CertRepMessage((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public CMPCertificate[] getCaPubs() {
        if (this.caPubs == null) {
            return null;
        }
        CMPCertificate[] results = new CMPCertificate[this.caPubs.size()];
        for (int i = 0; i != results.length; ++i) {
            results[i] = CMPCertificate.getInstance(this.caPubs.getObjectAt(i));
        }
        return results;
    }

    public CertResponse[] getResponse() {
        CertResponse[] results = new CertResponse[this.caPubs.size()];
        for (int i = 0; i != results.length; ++i) {
            results[i] = CertResponse.getInstance(this.caPubs.getObjectAt(i));
        }
        return results;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.caPubs != null) {
            v.add(new DERTaggedObject(true, 1, this.caPubs));
        }
        v.add(this.response);
        return new DERSequence(v);
    }
}

