/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1InputStream;
import com.kingdee.bos.ctrl.cipher.asn1.DERString;
import com.kingdee.bos.ctrl.cipher.asn1.isismtt.x509.AdditionalInformationSyntax;
import com.kingdee.bos.ctrl.cipher.asn1.test.ASN1UnitTest;
import com.kingdee.bos.ctrl.cipher.asn1.x500.DirectoryString;
import java.io.IOException;

public class AdditionalInformationSyntaxUnitTest
extends ASN1UnitTest {
    @Override
    public String getName() {
        return "AdditionalInformationSyntax";
    }

    @Override
    public void performTest() throws Exception {
        AdditionalInformationSyntax syntax = new AdditionalInformationSyntax("hello world");
        this.checkConstruction(syntax, new DirectoryString("hello world"));
        syntax = AdditionalInformationSyntax.getInstance(null);
        if (syntax != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            AdditionalInformationSyntax.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(AdditionalInformationSyntax syntax, DirectoryString information) throws IOException {
        this.checkValues(syntax, information);
        syntax = AdditionalInformationSyntax.getInstance(syntax);
        this.checkValues(syntax, information);
        ASN1InputStream aIn = new ASN1InputStream(syntax.toASN1Object().getEncoded());
        DERString info = (DERString)((Object)aIn.readObject());
        syntax = AdditionalInformationSyntax.getInstance(info);
        this.checkValues(syntax, information);
    }

    private void checkValues(AdditionalInformationSyntax syntax, DirectoryString information) {
        this.checkMandatoryField("information", information, syntax.getInformation());
    }

    public static void main(String[] args) {
        AdditionalInformationSyntaxUnitTest.runTest(new AdditionalInformationSyntaxUnitTest());
    }
}

