/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1InputStream;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1Sequence;
import com.kingdee.bos.ctrl.cipher.asn1.DERObjectIdentifier;
import com.kingdee.bos.ctrl.cipher.asn1.isismtt.ocsp.CertHash;
import com.kingdee.bos.ctrl.cipher.asn1.test.ASN1UnitTest;
import com.kingdee.bos.ctrl.cipher.asn1.x509.AlgorithmIdentifier;
import java.io.IOException;

public class CertHashUnitTest
extends ASN1UnitTest {
    @Override
    public String getName() {
        return "CertHash";
    }

    @Override
    public void performTest() throws Exception {
        AlgorithmIdentifier algId = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.2.3"));
        byte[] digest = new byte[20];
        CertHash certID = new CertHash(algId, digest);
        this.checkConstruction(certID, algId, digest);
        certID = CertHash.getInstance(null);
        if (certID != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            CertHash.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(CertHash certHash, AlgorithmIdentifier algId, byte[] digest) throws IOException {
        this.checkValues(certHash, algId, digest);
        certHash = CertHash.getInstance(certHash);
        this.checkValues(certHash, algId, digest);
        ASN1InputStream aIn = new ASN1InputStream(certHash.toASN1Object().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        certHash = CertHash.getInstance(seq);
        this.checkValues(certHash, algId, digest);
    }

    private void checkValues(CertHash certHash, AlgorithmIdentifier algId, byte[] digest) {
        this.checkMandatoryField("algorithmHash", algId, certHash.getHashAlgorithm());
        this.checkMandatoryField("certificateHash", digest, certHash.getCertificateHash());
    }

    public static void main(String[] args) {
        CertHashUnitTest.runTest(new CertHashUnitTest());
    }
}

