/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1EncodableVector;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1InputStream;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1Sequence;
import com.kingdee.bos.ctrl.cipher.asn1.DEROctetString;
import com.kingdee.bos.ctrl.cipher.asn1.DERSequence;
import com.kingdee.bos.ctrl.cipher.asn1.icao.DataGroupHash;
import com.kingdee.bos.ctrl.cipher.asn1.icao.LDSSecurityObject;
import com.kingdee.bos.ctrl.cipher.asn1.x509.AlgorithmIdentifier;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class LDSSecurityObjectUnitTest
extends SimpleTest {
    @Override
    public String getName() {
        return "LDSSecurityObject";
    }

    private byte[] generateHash() {
        SecureRandom rand = null;
        byte[] bytes = new byte[20];
        try {
            rand = SecureRandom.getInstanceStrong();
            for (int i = 0; i != bytes.length; ++i) {
                bytes[i] = (byte)rand.nextInt();
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return bytes;
    }

    @Override
    public void performTest() throws Exception {
        AlgorithmIdentifier algoId = new AlgorithmIdentifier("1.3.14.3.2.26");
        DataGroupHash[] datas = new DataGroupHash[]{new DataGroupHash(1, new DEROctetString(this.generateHash())), new DataGroupHash(2, new DEROctetString(this.generateHash()))};
        LDSSecurityObject so = new LDSSecurityObject(algoId, datas);
        this.checkConstruction(so, algoId, datas);
        so = LDSSecurityObject.getInstance(null);
        if (so != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            LDSSecurityObject.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ASN1EncodableVector v = new ASN1EncodableVector();
            new LDSSecurityObject(new DERSequence(v));
            this.fail("constructor failed to detect empty sequence.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new LDSSecurityObject(algoId, new DataGroupHash[1]);
            this.fail("constructor failed to detect small DataGroupHash array.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new LDSSecurityObject(algoId, new DataGroupHash[17]);
            this.fail("constructor failed to out of bounds DataGroupHash array.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(LDSSecurityObject so, AlgorithmIdentifier digestAlgorithmIdentifier, DataGroupHash[] datagroupHash) throws IOException {
        this.checkStatement(so, digestAlgorithmIdentifier, datagroupHash);
        so = LDSSecurityObject.getInstance(so);
        this.checkStatement(so, digestAlgorithmIdentifier, datagroupHash);
        ASN1InputStream aIn = new ASN1InputStream(so.toASN1Object().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        so = LDSSecurityObject.getInstance(seq);
        this.checkStatement(so, digestAlgorithmIdentifier, datagroupHash);
    }

    private void checkStatement(LDSSecurityObject so, AlgorithmIdentifier digestAlgorithmIdentifier, DataGroupHash[] datagroupHash) {
        if (digestAlgorithmIdentifier != null) {
            if (!so.getDigestAlgorithmIdentifier().equals(digestAlgorithmIdentifier)) {
                this.fail("ids don't match.");
            }
        } else if (so.getDigestAlgorithmIdentifier() != null) {
            this.fail("digest algorithm Id found when none expected.");
        }
        if (datagroupHash != null) {
            DataGroupHash[] datas = so.getDatagroupHash();
            for (int i = 0; i != datas.length; ++i) {
                if (datagroupHash[i].equals(datas[i])) continue;
                this.fail("name registration authorities don't match.");
            }
        } else if (so.getDatagroupHash() != null) {
            this.fail("data hash groups found when none expected.");
        }
    }

    public static void main(String[] args) {
        LDSSecurityObjectUnitTest.runTest(new LDSSecurityObjectUnitTest());
    }
}

