/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1InputStream;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1OutputStream;
import com.kingdee.bos.ctrl.cipher.asn1.DERObjectIdentifier;
import com.kingdee.bos.ctrl.cipher.asn1.DEROutputStream;
import com.kingdee.bos.ctrl.cipher.asn1.pkcs.PKCSObjectIdentifiers;
import com.kingdee.bos.ctrl.cipher.util.encoders.Hex;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class OIDTest
extends SimpleTest {
    byte[] req1 = Hex.decode("0603813403");
    byte[] req2 = Hex.decode("06082A36FFFFFFDD6311");

    @Override
    public String getName() {
        return "OID";
    }

    private void recodeCheck(String oid, byte[] enc) throws IOException {
        DERObjectIdentifier o = new DERObjectIdentifier(oid);
        ByteArrayInputStream bIn = new ByteArrayInputStream(enc);
        ASN1InputStream aIn = new ASN1InputStream(bIn);
        DERObjectIdentifier encO = (DERObjectIdentifier)aIn.readObject();
        if (!o.equals(encO)) {
            this.fail("oid ID didn't match", o, encO);
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        dOut.writeObject(o);
        byte[] bytes = bOut.toByteArray();
        if (bytes.length != enc.length) {
            this.fail("failed length test");
        }
        for (int i = 0; i != enc.length; ++i) {
            if (bytes[i] == enc[i]) continue;
            this.fail("failed comparison test", new String(Hex.encode(enc)), new String(Hex.encode(bytes)));
        }
    }

    private void validOidCheck(String oid) throws IOException {
        DERObjectIdentifier o = new DERObjectIdentifier(oid);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(o);
        ByteArrayInputStream bIn = new ByteArrayInputStream(bOut.toByteArray());
        ASN1InputStream aIn = new ASN1InputStream(bIn);
        o = (DERObjectIdentifier)aIn.readObject();
        if (!o.getId().equals(oid)) {
            this.fail("failed oid check for " + oid);
        }
    }

    private void invalidOidCheck(String oid) {
        try {
            new DERObjectIdentifier(oid);
            this.fail("failed to catch bad oid: " + oid);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public void performTest() throws IOException {
        this.recodeCheck("2.100.3", this.req1);
        this.recodeCheck("1.2.54.34359733987.17", this.req2);
        this.validOidCheck(PKCSObjectIdentifiers.pkcs_9_at_contentType.getId());
        this.validOidCheck("0.1");
        this.validOidCheck("1.1.127.32512.8323072.2130706432.545460846592.139637976727552.35747322042253312.9151314442816847872");
        this.validOidCheck("1.2.123.12345678901.1.1.1");
        this.validOidCheck("2.25.196556539987194312349856245628873852187.1");
        this.invalidOidCheck("0");
        this.invalidOidCheck("1");
        this.invalidOidCheck("2");
        this.invalidOidCheck("3.1");
        this.invalidOidCheck("..1");
        this.invalidOidCheck("192.168.1.1");
        this.invalidOidCheck(".123452");
        this.invalidOidCheck("1.");
        this.invalidOidCheck("1.345.23.34..234");
        this.invalidOidCheck("1.345.23.34.234.");
        this.invalidOidCheck(".12.345.77.234");
        this.invalidOidCheck(".12.345.77.234.");
        this.invalidOidCheck("1.2.3.4.A.5");
        this.invalidOidCheck("1,2");
    }

    public static void main(String[] args) {
        OIDTest.runTest(new OIDTest());
    }
}

