/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1InputStream;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1Sequence;
import com.kingdee.bos.ctrl.cipher.asn1.DERInteger;
import com.kingdee.bos.ctrl.cipher.asn1.DERObjectIdentifier;
import com.kingdee.bos.ctrl.cipher.asn1.ess.OtherCertID;
import com.kingdee.bos.ctrl.cipher.asn1.test.ASN1UnitTest;
import com.kingdee.bos.ctrl.cipher.asn1.x509.AlgorithmIdentifier;
import com.kingdee.bos.ctrl.cipher.asn1.x509.GeneralName;
import com.kingdee.bos.ctrl.cipher.asn1.x509.GeneralNames;
import com.kingdee.bos.ctrl.cipher.asn1.x509.IssuerSerial;
import com.kingdee.bos.ctrl.cipher.asn1.x509.X509Name;
import java.io.IOException;

public class OtherCertIDUnitTest
extends ASN1UnitTest {
    @Override
    public String getName() {
        return "OtherCertID";
    }

    @Override
    public void performTest() throws Exception {
        AlgorithmIdentifier algId = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.2.3"));
        byte[] digest = new byte[20];
        IssuerSerial issuerSerial = new IssuerSerial(new GeneralNames(new GeneralName(new X509Name("CN=test"))), new DERInteger(1));
        OtherCertID certID = new OtherCertID(algId, digest);
        this.checkConstruction(certID, algId, digest, null);
        certID = new OtherCertID(algId, digest, issuerSerial);
        this.checkConstruction(certID, algId, digest, issuerSerial);
        certID = OtherCertID.getInstance(null);
        if (certID != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            OtherCertID.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(OtherCertID certID, AlgorithmIdentifier algId, byte[] digest, IssuerSerial issuerSerial) throws IOException {
        this.checkValues(certID, algId, digest, issuerSerial);
        certID = OtherCertID.getInstance(certID);
        this.checkValues(certID, algId, digest, issuerSerial);
        ASN1InputStream aIn = new ASN1InputStream(certID.toASN1Object().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        certID = OtherCertID.getInstance(seq);
        this.checkValues(certID, algId, digest, issuerSerial);
    }

    private void checkValues(OtherCertID certID, AlgorithmIdentifier algId, byte[] digest, IssuerSerial issuerSerial) {
        this.checkMandatoryField("algorithmHash", algId, certID.getAlgorithmHash());
        this.checkMandatoryField("certHash", digest, certID.getCertHash());
        this.checkOptionalField("issuerSerial", issuerSerial, certID.getIssuerSerial());
    }

    public static void main(String[] args) {
        OtherCertIDUnitTest.runTest(new OtherCertIDUnitTest());
    }
}

