/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.DERBitString;
import com.kingdee.bos.ctrl.cipher.asn1.DERT61String;
import com.kingdee.bos.ctrl.cipher.asn1.DERUniversalString;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;
import java.io.IOException;

public class StringTest
extends SimpleTest {
    @Override
    public String getName() {
        return "String";
    }

    @Override
    public void performTest() throws IOException {
        DERUniversalString us;
        DERBitString bs = new DERBitString(new byte[]{1, 35, 69, 103, -119, -85, -51, -17});
        if (!bs.getString().equals("#0309000123456789ABCDEF")) {
            this.fail("DERBitString.getString() result incorrect");
        }
        if (!bs.toString().equals("#0309000123456789ABCDEF")) {
            this.fail("DERBitString.toString() result incorrect");
        }
        if (!(bs = new DERBitString(new byte[]{-2, -36, -70, -104, 118, 84, 50, 16})).getString().equals("#030900FEDCBA9876543210")) {
            this.fail("DERBitString.getString() result incorrect");
        }
        if (!bs.toString().equals("#030900FEDCBA9876543210")) {
            this.fail("DERBitString.toString() result incorrect");
        }
        if (!(us = new DERUniversalString(new byte[]{1, 35, 69, 103, -119, -85, -51, -17})).getString().equals("#1C080123456789ABCDEF")) {
            this.fail("DERUniversalString.getString() result incorrect");
        }
        if (!us.toString().equals("#1C080123456789ABCDEF")) {
            this.fail("DERUniversalString.toString() result incorrect");
        }
        if (!(us = new DERUniversalString(new byte[]{-2, -36, -70, -104, 118, 84, 50, 16})).getString().equals("#1C08FEDCBA9876543210")) {
            this.fail("DERUniversalString.getString() result incorrect");
        }
        if (!us.toString().equals("#1C08FEDCBA9876543210")) {
            this.fail("DERUniversalString.toString() result incorrect");
        }
        byte[] t61Bytes = new byte[]{-1, -2, -3, -4, -5, -6, -7, -8};
        String t61String = new String(t61Bytes, "iso-8859-1");
        DERT61String t61 = new DERT61String(t61Bytes);
        if (!t61.getString().equals(t61String)) {
            this.fail("DERT61String.getString() result incorrect");
        }
        if (!t61.toString().equals(t61String)) {
            this.fail("DERT61String.toString() result incorrect");
        }
    }

    public static void main(String[] args) {
        StringTest.runTest(new StringTest());
    }
}

