/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.bcpg;

import com.kingdee.bos.ctrl.cipher.bcpg.BCPGInputStream;
import com.kingdee.bos.ctrl.cipher.bcpg.BCPGKey;
import com.kingdee.bos.ctrl.cipher.bcpg.BCPGObject;
import com.kingdee.bos.ctrl.cipher.bcpg.BCPGOutputStream;
import com.kingdee.bos.ctrl.cipher.bcpg.MPInteger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class DSASecretBCPGKey
extends BCPGObject
implements BCPGKey {
    MPInteger x;

    public DSASecretBCPGKey(BCPGInputStream in) throws IOException {
        this.x = new MPInteger(in);
    }

    public DSASecretBCPGKey(BigInteger x) {
        this.x = new MPInteger(x);
    }

    @Override
    public String getFormat() {
        return "PGP";
    }

    @Override
    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            BCPGOutputStream pgpOut = new BCPGOutputStream(bOut);
            pgpOut.writeObject(this);
            return bOut.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        out.writeObject(this.x);
    }

    public BigInteger getX() {
        return this.x.getValue();
    }
}

