/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.generators;

import com.kingdee.bos.ctrl.cipher.crypto.AsymmetricCipherKeyPair;
import com.kingdee.bos.ctrl.cipher.crypto.AsymmetricCipherKeyPairGenerator;
import com.kingdee.bos.ctrl.cipher.crypto.KeyGenerationParameters;
import com.kingdee.bos.ctrl.cipher.crypto.generators.DHKeyGeneratorHelper;
import com.kingdee.bos.ctrl.cipher.crypto.params.DHKeyGenerationParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.DHParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.DHPrivateKeyParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.DHPublicKeyParameters;
import java.math.BigInteger;

public class DHBasicKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (DHKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dhp = this.param.getParameters();
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(y, dhp), new DHPrivateKeyParameters(x, dhp));
    }
}

