/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.generators;

import com.kingdee.bos.ctrl.cipher.crypto.AsymmetricCipherKeyPair;
import com.kingdee.bos.ctrl.cipher.crypto.AsymmetricCipherKeyPairGenerator;
import com.kingdee.bos.ctrl.cipher.crypto.KeyGenerationParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.ECDomainParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.ECKeyGenerationParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.ECPrivateKeyParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.ECPublicKeyParameters;
import com.kingdee.bos.ctrl.cipher.math.ec.ECConstants;
import com.kingdee.bos.ctrl.cipher.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    @Override
    public void init(KeyGenerationParameters param) {
        ECKeyGenerationParameters ecP = (ECKeyGenerationParameters)param;
        this.random = ecP.getRandom();
        this.params = ecP.getDomainParameters();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger d;
        BigInteger n = this.params.getN();
        int nBitLength = n.bitLength();
        while ((d = new BigInteger(nBitLength, this.random)).equals(ZERO) || d.compareTo(n) >= 0) {
        }
        ECPoint Q = this.params.getG().multiply(d);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(Q, this.params), new ECPrivateKeyParameters(d, this.params));
    }
}

