/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.test;

import com.kingdee.bos.ctrl.cipher.crypto.BlockCipher;
import com.kingdee.bos.ctrl.cipher.crypto.BufferedBlockCipher;
import com.kingdee.bos.ctrl.cipher.crypto.CipherParameters;
import com.kingdee.bos.ctrl.cipher.util.encoders.Hex;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;

public class BlockCipherMonteCarloTest
extends SimpleTest {
    int id;
    int iterations;
    BlockCipher engine;
    CipherParameters param;
    byte[] input;
    byte[] output;

    public BlockCipherMonteCarloTest(int id, int iterations, BlockCipher engine, CipherParameters param, String input, String output) {
        this.id = id;
        this.iterations = iterations;
        this.engine = engine;
        this.param = param;
        this.input = Hex.decode(input);
        this.output = Hex.decode(output);
    }

    @Override
    public String getName() {
        return this.engine.getAlgorithmName() + " Monte Carlo Test " + this.id;
    }

    @Override
    public void performTest() throws Exception {
        int len1;
        int i;
        BufferedBlockCipher cipher = new BufferedBlockCipher(this.engine);
        cipher.init(true, this.param);
        byte[] out = new byte[this.input.length];
        System.arraycopy(this.input, 0, out, 0, out.length);
        for (i = 0; i != this.iterations; ++i) {
            len1 = cipher.processBytes(out, 0, out.length, out, 0);
            cipher.doFinal(out, len1);
        }
        if (!this.areEqual(out, this.output)) {
            this.fail("failed - expected " + new String(Hex.encode(this.output)) + " got " + new String(Hex.encode(out)));
        }
        cipher.init(false, this.param);
        for (i = 0; i != this.iterations; ++i) {
            len1 = cipher.processBytes(out, 0, out.length, out, 0);
            cipher.doFinal(out, len1);
        }
        if (!this.areEqual(this.input, out)) {
            this.fail("failed reversal");
        }
    }
}

