/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.test;

import com.kingdee.bos.ctrl.cipher.crypto.AsymmetricCipherKeyPair;
import com.kingdee.bos.ctrl.cipher.crypto.agreement.ECDHBasicAgreement;
import com.kingdee.bos.ctrl.cipher.crypto.digests.SHA1Digest;
import com.kingdee.bos.ctrl.cipher.crypto.engines.IESEngine;
import com.kingdee.bos.ctrl.cipher.crypto.engines.TwofishEngine;
import com.kingdee.bos.ctrl.cipher.crypto.generators.ECKeyPairGenerator;
import com.kingdee.bos.ctrl.cipher.crypto.generators.KDF2BytesGenerator;
import com.kingdee.bos.ctrl.cipher.crypto.macs.HMac;
import com.kingdee.bos.ctrl.cipher.crypto.modes.CBCBlockCipher;
import com.kingdee.bos.ctrl.cipher.crypto.paddings.PaddedBufferedBlockCipher;
import com.kingdee.bos.ctrl.cipher.crypto.params.ECDomainParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.ECKeyGenerationParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.ECPrivateKeyParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.ECPublicKeyParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.IESParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.IESWithCipherParameters;
import com.kingdee.bos.ctrl.cipher.math.ec.ECCurve;
import com.kingdee.bos.ctrl.cipher.util.encoders.Hex;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECIESTest
extends SimpleTest {
    ECIESTest() {
    }

    @Override
    public String getName() {
        return "ECIES";
    }

    private void staticTest() throws Exception {
        byte[] out2;
        ECCurve.Fp curve = new ECCurve.Fp(new BigInteger("6277101735386680763835789423207666416083908700390324961279"), new BigInteger("fffffffffffffffffffffffffffffffefffffffffffffffc", 16), new BigInteger("64210519e59c80e70fa7e9ab72243049feb8deecc146b9b1", 16));
        ECDomainParameters params = new ECDomainParameters(curve, curve.decodePoint(Hex.decode("03188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012")), new BigInteger("6277101735386680763835789423176059013767194773182842284081"));
        ECPrivateKeyParameters priKey = new ECPrivateKeyParameters(new BigInteger("651056770906015076056810763456358567190100156695615665659"), params);
        ECPublicKeyParameters pubKey = new ECPublicKeyParameters(curve.decodePoint(Hex.decode("0262b12d60690cdcf330babab6e69763b471f994dd702d16a5")), params);
        AsymmetricCipherKeyPair p1 = new AsymmetricCipherKeyPair(pubKey, priKey);
        AsymmetricCipherKeyPair p2 = new AsymmetricCipherKeyPair(pubKey, priKey);
        IESEngine i1 = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()));
        IESEngine i2 = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()));
        byte[] d = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] e = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        IESParameters p = new IESParameters(d, e, 64);
        i1.init(true, p1.getPrivate(), p2.getPublic(), p);
        i2.init(false, p2.getPrivate(), p1.getPublic(), p);
        byte[] message = Hex.decode("1234567890abcdef");
        byte[] out1 = i1.processBlock(message, 0, message.length);
        if (!this.areEqual(out1, Hex.decode("2442ae1fbf90dd9c06b0dcc3b27e69bd11c9aee4ad4cfc9e50eceb44"))) {
            this.fail("stream cipher test failed on enc");
        }
        if (!this.areEqual(out2 = i2.processBlock(out1, 0, out1.length), message)) {
            this.fail("stream cipher test failed");
        }
        PaddedBufferedBlockCipher c1 = new PaddedBufferedBlockCipher(new CBCBlockCipher(new TwofishEngine()));
        PaddedBufferedBlockCipher c2 = new PaddedBufferedBlockCipher(new CBCBlockCipher(new TwofishEngine()));
        i1 = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()), c1);
        i2 = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()), c2);
        d = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        e = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        p = new IESWithCipherParameters(d, e, 64, 128);
        i1.init(true, p1.getPrivate(), p2.getPublic(), p);
        i2.init(false, p2.getPrivate(), p1.getPublic(), p);
        message = Hex.decode("1234567890abcdef");
        out1 = i1.processBlock(message, 0, message.length);
        if (!this.areEqual(out1, Hex.decode("2ea288651e21576215f2424bbb3f68816e282e3931b44bd1c429ebdb5f1b290cf1b13309"))) {
            this.fail("twofish cipher test failed on enc");
        }
        if (!this.areEqual(out2 = i2.processBlock(out1, 0, out1.length), message)) {
            this.fail("twofish cipher test failed");
        }
    }

    private void doTest(AsymmetricCipherKeyPair p1, AsymmetricCipherKeyPair p2) throws Exception {
        IESEngine i1 = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()));
        IESEngine i2 = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()));
        byte[] d = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] e = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        IESParameters p = new IESParameters(d, e, 64);
        i1.init(true, p1.getPrivate(), p2.getPublic(), p);
        i2.init(false, p2.getPrivate(), p1.getPublic(), p);
        byte[] message = Hex.decode("1234567890abcdef");
        byte[] out1 = i1.processBlock(message, 0, message.length);
        byte[] out2 = i2.processBlock(out1, 0, out1.length);
        if (!this.areEqual(out2, message)) {
            this.fail("stream cipher test failed");
        }
        PaddedBufferedBlockCipher c1 = new PaddedBufferedBlockCipher(new CBCBlockCipher(new TwofishEngine()));
        PaddedBufferedBlockCipher c2 = new PaddedBufferedBlockCipher(new CBCBlockCipher(new TwofishEngine()));
        i1 = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()), c1);
        i2 = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()), c2);
        d = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        e = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        p = new IESWithCipherParameters(d, e, 64, 128);
        i1.init(true, p1.getPrivate(), p2.getPublic(), p);
        i2.init(false, p2.getPrivate(), p1.getPublic(), p);
        message = Hex.decode("1234567890abcdef");
        out1 = i1.processBlock(message, 0, message.length);
        out2 = i2.processBlock(out1, 0, out1.length);
        if (!this.areEqual(out2, message)) {
            this.fail("twofish cipher test failed");
        }
    }

    @Override
    public void performTest() throws Exception {
        this.staticTest();
        ECCurve.Fp curve = new ECCurve.Fp(new BigInteger("6277101735386680763835789423207666416083908700390324961279"), new BigInteger("fffffffffffffffffffffffffffffffefffffffffffffffc", 16), new BigInteger("64210519e59c80e70fa7e9ab72243049feb8deecc146b9b1", 16));
        ECDomainParameters params = new ECDomainParameters(curve, curve.decodePoint(Hex.decode("03188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012")), new BigInteger("6277101735386680763835789423176059013767194773182842284081"));
        ECKeyPairGenerator eGen = new ECKeyPairGenerator();
        ECKeyGenerationParameters gParam = new ECKeyGenerationParameters(params, new SecureRandom());
        eGen.init(gParam);
        AsymmetricCipherKeyPair p1 = eGen.generateKeyPair();
        AsymmetricCipherKeyPair p2 = eGen.generateKeyPair();
        this.doTest(p1, p2);
    }

    public static void main(String[] args) {
        ECIESTest.runTest(new ECIESTest());
    }
}

