/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.test;

import com.kingdee.bos.ctrl.cipher.crypto.ExtendedDigest;
import com.kingdee.bos.ctrl.cipher.crypto.digests.SHA1Digest;
import com.kingdee.bos.ctrl.cipher.crypto.digests.SHA512Digest;
import com.kingdee.bos.ctrl.cipher.crypto.digests.ShortenedDigest;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;

public class ShortenedDigestTest
extends SimpleTest {
    @Override
    public void performTest() {
        ExtendedDigest d = new SHA1Digest();
        ShortenedDigest sd = new ShortenedDigest(new SHA1Digest(), 10);
        if (sd.getDigestSize() != 10) {
            this.fail("size check wrong for SHA-1");
        }
        if (sd.getByteLength() != d.getByteLength()) {
            this.fail("byte length check wrong for SHA-1");
        }
        sd.doFinal(new byte[10], 0);
        d = new SHA512Digest();
        sd = new ShortenedDigest(new SHA512Digest(), 20);
        if (sd.getDigestSize() != 20) {
            this.fail("size check wrong for SHA-512");
        }
        if (sd.getByteLength() != d.getByteLength()) {
            this.fail("byte length check wrong for SHA-512");
        }
        sd.doFinal(new byte[20], 0);
        try {
            new ShortenedDigest(null, 20);
            this.fail("null parameter not caught");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new ShortenedDigest(new SHA1Digest(), 50);
            this.fail("short digest not caught");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public String getName() {
        return "ShortenedDigest";
    }

    public static void main(String[] args) {
        ShortenedDigestTest.runTest(new ShortenedDigestTest());
    }
}

