/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext;

import com.kingdee.bos.ctrl.ext.IExtWizardManager;
import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.ui.wizards.convenientkeys.ConvenientKeysWizzard;
import com.kingdee.bos.ctrl.ext.ui.wizards.data.DatasetImporterWizard;
import com.kingdee.bos.ctrl.ext.ui.wizards.data.FieldPermissionWizard;
import com.kingdee.bos.ctrl.ext.ui.wizards.data.inner.DatesetManagementWizzard;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.dlg.FormulaComposerWizard;
import com.kingdee.bos.ctrl.ext.ui.wizards.io.WizardExport;
import com.kingdee.bos.ctrl.ext.ui.wizards.io.WizardImport;
import com.kingdee.bos.ctrl.ext.ui.wizards.pic.InsertPicWizzard;
import com.kingdee.bos.ctrl.ext.ui.wizards.report.ReportComposerWizard;
import com.kingdee.bos.ctrl.ext.ui.wizards.scheduler.WizardScheduler;
import com.kingdee.bos.ctrl.ext.ui.wizards.showcase.MobileReportViewConstraintsWizard;
import com.kingdee.bos.ctrl.ext.ui.wizards.showcase.ReportViewConstraintsWizard;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.impl.FacadeManager;
import com.kingdee.bos.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.swing.KDDialog;
import java.awt.Dialog;
import java.util.HashMap;

public class ExtWizardManager
implements IExtWizardManager {
    private HashMap _wizardMap;
    private KDExt _ext;

    ExtWizardManager(KDExt ext) {
        this._ext = ext;
    }

    @Override
    public ISpreadWizzard getWizard(FacadeManager.WizzardType name, boolean create) {
        ISpreadWizzard wizard = null;
        if (this._wizardMap != null) {
            wizard = (ISpreadWizzard)this._wizardMap.get(name);
        }
        if (wizard == null && create && (wizard = this.createWizard(name)) != null) {
            this.putWizard(name, wizard);
        }
        return wizard;
    }

    @Override
    public ISpreadWizzard getWizard(FacadeManager.WizzardType name) {
        return this.getWizard(name, true);
    }

    private void putWizard(FacadeManager.WizzardType name, ISpreadWizzard wizard) {
        if (this._wizardMap == null) {
            this._wizardMap = new HashMap();
        }
        this._wizardMap.put(name, wizard);
    }

    private ISpreadWizzard createWizard(FacadeManager.WizzardType name) {
        if (name == Wizard_DatasetManagement) {
            return new DatesetManagementWizzard((Dialog)((KDDialog)this.getWizard(Wizard_DatasetImporter)), this._ext);
        }
        if (name == Wizard_DatasetImporter) {
            return new DatasetImporterWizard(this._ext);
        }
        if (name == Wizard_FieldPermission) {
            return new FieldPermissionWizard(this._ext);
        }
        if (name == Wizard_ReportComposer) {
            return new ReportComposerWizard(this._ext);
        }
        if (name == Wizard_Formula) {
            return new FormulaComposerWizard(this._ext);
        }
        if (name == Wizard_Import) {
            return new WizardImport(this._ext);
        }
        if (name == Wizard_Export) {
            return new WizardExport(this._ext);
        }
        if (name == Wizard_ReportViewConstraints) {
            if (this._ext.getExtCallback().isMobileTemplate()) {
                return new MobileReportViewConstraintsWizard(this._ext);
            }
            return new ReportViewConstraintsWizard(this._ext);
        }
        if (name == Wizard_ConvenientKeys) {
            return new ConvenientKeysWizzard(this._ext);
        }
        if (name == Wizard_FusionChart) {
            return MiscUtil.getActiveSpreadContext(this._ext).getFacadeManager().getWizzard(FacadeManager.WIZZARD_FlashChart);
        }
        if (name == Wizard_Schedular) {
            return new WizardScheduler();
        }
        if (name == Wizard_InsertPic) {
            return new InsertPicWizzard(this._ext);
        }
        return null;
    }
}

