/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.ext.BasicExtCallback;
import com.kingdee.bos.ctrl.ext.ExtActionManager;
import com.kingdee.bos.ctrl.ext.ExtKeyboardManager;
import com.kingdee.bos.ctrl.ext.ExtMenuManager;
import com.kingdee.bos.ctrl.ext.ExtStatusBarManager;
import com.kingdee.bos.ctrl.ext.ExtToolbarManager;
import com.kingdee.bos.ctrl.ext.ExtWizardManager;
import com.kingdee.bos.ctrl.ext.IExtActionManager;
import com.kingdee.bos.ctrl.ext.IExtKeyboardManager;
import com.kingdee.bos.ctrl.ext.IExtMenuManager;
import com.kingdee.bos.ctrl.ext.IExtStatusBarManager;
import com.kingdee.bos.ctrl.ext.IExtToolbarManager;
import com.kingdee.bos.ctrl.ext.IExtWizardManager;
import com.kingdee.bos.ctrl.ext.dd.DataPerspective;
import com.kingdee.bos.ctrl.ext.immit.IExtCallback;
import com.kingdee.bos.ctrl.ext.pd.ParameterPerspective;
import com.kingdee.bos.ctrl.ext.rd.ReportPerspective;
import com.kingdee.bos.ctrl.ext.rd.RptPerspective;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.install.ZipFile;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.FormulaWizardMisc;
import com.kingdee.bos.ctrl.ext.ui.wizards.io.WizardImport;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.core.KDSpread;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.io.BookIOUtil;
import com.kingdee.bos.ctrl.kds.io.kds.AuthorizationFailedException;
import com.kingdee.bos.ctrl.kds.io.kds.HighVersionException;
import com.kingdee.bos.ctrl.kds.io.kds.InvalidCouponException;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.PrintSetup;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.Span;
import com.kingdee.bos.ctrl.kds.model.struct.UserObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.ChartRectEmbedment;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.dataset.util.ChartUtil;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.ChartFrameWorkType;
import com.kingdee.bos.ctrl.kds.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.kds.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.kds.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.kds.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.kds.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kds.print.PrintBookTrans;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.ctrl.workbench.logic.PerspectiveChangeEvent;
import com.kingdee.bos.ctrl.workbench.logic.PerspectiveChangeListener;
import com.kingdee.bos.ctrl.workbench.persist.IIOProvider;
import com.kingdee.bos.ctrl.workbench.persist.TrimDatabase;
import com.kingdee.bos.ctrl.workbench.splash.NotifyObject;
import com.kingdee.bos.ctrl.workbench.ui.Perspective;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class KDExt
extends KDFrame
implements BookChangeListener {
    public static final String KEY_TITLE = "title";
    public static final String KEY_REPORT_DESIGNER = "reportDesigner";
    public static final String KEY_PROPERTY_EDITOR = "propertyEditor";
    public static final String REPORT_DESIGNER_PERSPECTIVE = "Report Designer";
    public static final String PARAMETER_DESIGNER_PERSPECTIVE = "Parameter Designer";
    public static final String DATA_DESIGNER_PERSPECTIVE = "Data Designer";
    public static final String USER_HISTORY_FILENAME = "OpenHistory.text";
    private Perspective activePerspective;
    private Perspective reportPerspective;
    private Perspective paramPerspective;
    private Perspective dataPerspective;
    private IExtCallback extCallback;
    private IExtActionManager spreadActionManager;
    private IExtWizardManager wizardManager;
    private IExtKeyboardManager keyboardManager;
    private IExtToolbarManager toolbarManager;
    private IExtStatusBarManager statusbarManager;
    private IExtMenuManager menubarManager;
    private List perspectiveListeners = new ArrayList();
    private NotifyObject notice = NotifyObject.getCurrentInstance();
    private FormulaWizardMisc formulaWizardMisc;
    private boolean isClosing = false;
    private static IPathDefiner definer;

    public static String getLocalText(String key, String defaultStr) {
        return LanguageManager.getLangMessage((String)key, KDExt.class, (String)defaultStr);
    }

    private void nextStage(int stepProgress, String stepDetail) {
        if (this.notice != null) {
            this.notice.notice(stepProgress, stepDetail);
        }
    }

    public KDExt() {
        this.notice.start();
        this.setExtCallback(new BasicExtCallback(this));
        this.init();
        this.initListeners();
        this.setDefaultCloseOperation(0);
    }

    public KDExt(IExtCallback callback) {
        this.notice.start();
        this.setExtCallback(callback);
        this.init();
        this.initListeners();
        this.setDefaultCloseOperation(0);
    }

    public void refresh() throws HighVersionException, InvalidCouponException, AuthorizationFailedException {
        byte[] bytes = this.extCallback.getReportData();
        if (bytes == null) {
            this.nextStage(5, "\u521d\u59cb\u5316\u5de5\u4f5c\u533a");
            Book book = Book.Manager.getNewBook("created_by_ext", 0);
            Sheet sheet = new Sheet(book, "Sheet1");
            sheet.setSheetType(1);
            book.insertSheet(0, sheet);
            book.setAutoCalculate(false);
            book.getDeps().setExtendMode(true);
            book.setCellDisplayMode(1);
            this.setDefaultRowColLenght(book, true);
            this.setBook(book);
            this.nextStage(100, "\u8fdb\u5165\u91d1\u8776\u6269\u5c55\u62a5\u8868");
        } else {
            this.nextStage(5, "\u521d\u59cb\u5316\u5de5\u4f5c\u533a");
            Book book = MiscUtil.unpack(bytes);
            book.setAutoCalculate(false);
            book.getDeps().setExtendMode(true);
            book.setCellDisplayMode(1);
            this.setDefaultRowColLenght(book, false);
            this.setBook(book);
            this.nextStage(100, "\u52a0\u8f7d\u62a5\u8868\u5de5\u4f5c\u5f15\u64ce");
        }
    }

    public void show() {
        if (this.extCallback.isCloudView()) {
            MessageUtil.msgboxInfo((Component)((Object)this), "\u201c\u4e91\u62a5\u8868\u4e2d\u5fc3\u201d\u89c6\u56fe\u4e2d\u7684\u62a5\u8868\u6a21\u677f\u7981\u6b62\u4fdd\u5b58\uff0c\u5982\u9700\u4fee\u6539\uff0c\u9700\u8981\u60a8\uff1a\n1\u3001\u5bfc\u51fa\u6a21\u677f\u6587\u4ef6\u5230\u672c\u5730\u76ee\u5f55\uff1b\n2\u3001\u5c06\u6a21\u677f\u6587\u4ef6\u4ece\u672c\u5730\u76ee\u5f55\u5bfc\u5165\u5230\u201cEAS\u62a5\u8868\u201d\u89c6\u56fe\u4e2d\u3002");
        }
        super.show();
    }

    public IExtCallback getExtCallback() {
        return this.extCallback;
    }

    public IExtActionManager getExtActionManager() {
        return this.spreadActionManager;
    }

    public void setIExtActionManager(IExtActionManager extActionManager) {
        this.spreadActionManager = extActionManager;
    }

    public IExtWizardManager getExtWizardManager() {
        return this.wizardManager;
    }

    public void setIExtWizardManager(IExtWizardManager extWizardManager) {
        this.wizardManager = extWizardManager;
    }

    public IExtKeyboardManager getExtKeyboardManager() {
        return this.keyboardManager;
    }

    public void setIExtKeyboardManager(IExtKeyboardManager extKeyboardManager) {
        this.keyboardManager = extKeyboardManager;
    }

    public IExtStatusBarManager getExtStatusBarManager() {
        return this.statusbarManager;
    }

    public void setIExtStatusBarManager(IExtStatusBarManager extStatusBarManager) {
        this.statusbarManager = extStatusBarManager;
    }

    public void setIExtToolbarManager(IExtToolbarManager extToolbarManager) {
        this.toolbarManager = extToolbarManager;
    }

    public IExtToolbarManager getIExtToolbarManager() {
        return this.toolbarManager;
    }

    public void setIExtMenuManager(IExtMenuManager extMenuManager) {
        this.menubarManager = extMenuManager;
    }

    public IExtMenuManager getIExtMenuManager() {
        return this.menubarManager;
    }

    public void closeExt() {
        SpreadContext context = MiscUtil.getActiveSpreadContext(this);
        context.getStateManager().stopEditing();
        Perspective perspective = this.getPerspective(REPORT_DESIGNER_PERSPECTIVE, false);
        if (perspective != null) {
            ((RptPerspective)perspective).getBeanBindManager().commitPropertySheetPanels();
        }
        if (context.getBook().isEncrypted() || this.extCallback.isCloudView()) {
            this.shutdown();
            return;
        }
        int mark = MessageUtil.msgboxYesNoCancel((Component)((Object)this), ExtActionManager.getLocalText("msg1", "\u662f\u5426\u4fdd\u5b58\u5f53\u524d\u6587\u4ef6\uff1f"));
        if (mark == 0) {
            try {
                if (!this.extCallback.saveReportData(BookIOUtil.pack(context.getBook()), false)) {
                    return;
                }
                this.shutdown();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        } else if (mark == 1) {
            this.shutdown();
        }
    }

    private void init() {
        this.createBufferStrategy(1);
        this.setTitle(KDExt.getLocalText(KEY_TITLE, "\u91d1\u8776\u6269\u5c55\u62a5\u8868\u8bbe\u8ba1\u5668"));
        this.setExtendedState(6);
        this.setSize(400, 300);
        this.getContentPane().setLayout(new BorderLayout());
        this.initManager();
        this.initDND();
    }

    private void initManager() {
        this.spreadActionManager = new ExtActionManager(this);
        this.wizardManager = new ExtWizardManager(this);
        this.keyboardManager = new ExtKeyboardManager(this);
        this.toolbarManager = new ExtToolbarManager(this);
        this.menubarManager = new ExtMenuManager(this);
        this.statusbarManager = new ExtStatusBarManager(this);
    }

    private void initDND() {
        try {
            DropTarget target = new DropTarget();
            this.setDropTarget(target);
            target.addDropTargetListener(new DropTargetAdapter(){

                @Override
                public void drop(DropTargetDropEvent event) {
                    WizardImport imp = (WizardImport)KDExt.this.getExtWizardManager().getWizard(IExtWizardManager.Wizard_Import, true);
                    if (KDExt.this.getExtCallback() instanceof BasicExtCallback) {
                        imp.setLogOpenHistory(true);
                    }
                    event.acceptDrop(1);
                    Transferable transferable = event.getTransferable();
                    DataFlavor[] flavors = transferable.getTransferDataFlavors();
                    for (int i = 0; i < flavors.length; ++i) {
                        DataFlavor d = flavors[i];
                        try {
                            if (!d.equals(DataFlavor.javaFileListFlavor)) continue;
                            List fileList = (List)transferable.getTransferData(d);
                            int size = fileList.size();
                            if (size <= 0) {
                                return;
                            }
                            String whiteSpace = "      ";
                            File f = (File)fileList.get(fileList.size() - 1);
                            boolean flag = false;
                            for (int j = size - 1; j >= 0; --j) {
                                if (f.getName().endsWith(".kds") || f.getName().endsWith(".xls")) {
                                    flag = true;
                                    break;
                                }
                                f = (File)fileList.get(j);
                            }
                            if (flag && size > 1) {
                                MessageUtil.msgboxOkCancel((Component)((Object)KDExt.this), "\u5f53\u524d\u7248\u672c\u4e0d\u652f\u6301\u591a\u6587\u6863\u6253\u5f00,\u672c\u6b21\u5c06\u6253\u5f00:\n" + whiteSpace + f.getName() + ".");
                            } else if (!flag) {
                                f = null;
                                MessageUtil.msgboxOkCancel((Component)((Object)KDExt.this), "\u6253\u5f00\u6587\u4ef6\u5931\u8d25,\u8bf7\u786e\u8ba4\u6253\u5f00\u7684\u6587\u4ef6\u7c7b\u578b!");
                                return;
                            }
                            imp.openFileByDND(f);
                            continue;
                        }
                        catch (Exception e) {
                            if (!(e instanceof HeadlessException)) continue;
                        }
                    }
                    event.dropComplete(true);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initListeners() {
        this.addPerspectiveChangeListener(this.toolbarManager);
        this.addPerspectiveChangeListener(this.menubarManager);
        this.addPerspectiveChangeListener(this.statusbarManager);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                KDExt.this.getActivePerspective().requestFocus();
            }

            @Override
            public void windowClosing(WindowEvent e) {
                if (!KDExt.this.isClosing) {
                    KDExt.this.closeExt();
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
                IExtCallback obj = KDExt.this.getExtCallback();
                if (obj == null) {
                    return;
                }
                if (obj instanceof BasicExtCallback) {
                    String[] history = ((WizardImport)KDExt.this.getExtWizardManager().getWizard(IExtWizardManager.Wizard_Import)).getUserOpenHistory();
                    String configDir = System.getProperty("user.dir");
                    if (history != null) {
                        try {
                            PrintWriter writer = new PrintWriter(new FileWriter(new File(configDir + File.separator + KDExt.USER_HISTORY_FILENAME)));
                            int l = history.length;
                            writer.println(l);
                            for (int i = 0; i < l; ++i) {
                                writer.println(history[i]);
                            }
                            writer.flush();
                            writer.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        });
    }

    private void setExtCallback(IExtCallback extCallback) {
        this.extCallback = extCallback;
        if (extCallback == null) {
            TrimDatabase.setIOProvider(null);
        } else {
            TrimDatabase.setIOProvider((IIOProvider)extCallback.getWorkbenchIOProvider());
        }
    }

    private void shutdown() {
        this.isClosing = true;
        if (this.reportPerspective != null) {
            this.reportPerspective.persist();
        }
        if (this.paramPerspective != null) {
            this.paramPerspective.persist();
        }
        if (this.dataPerspective != null) {
            this.dataPerspective.persist();
        }
        TrimDatabase.persist();
        this.extCallback.closeNotify();
        this.releaseEmbedments(MiscUtil.getActiveSpreadContext(this));
        this.setVisible(false);
        this.dispose();
    }

    private void releaseEmbedments(SpreadContext context) {
        Book book = context.getBook();
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            EmbedhLayer layer = sheet.getEmbedments(false);
            if (null == layer) continue;
            for (int j = 0; j < layer.size(); ++j) {
                EmbedObject object = layer.getEmbed(j);
                if (!(object instanceof ChartRectEmbedment)) continue;
                ((ChartRectEmbedment)object).destory();
            }
        }
    }

    public Perspective getPerspective(String perspectiveName) {
        return this.getPerspective(perspectiveName, true);
    }

    public Perspective getPerspective(String perspectiveName, boolean create) {
        if (REPORT_DESIGNER_PERSPECTIVE.equals(perspectiveName)) {
            if (this.reportPerspective == null && create) {
                if (this.extCallback != null) {
                    this.reportPerspective = this.extCallback.getPerspective(perspectiveName);
                }
                if (this.reportPerspective == null) {
                    this.reportPerspective = new ReportPerspective(this, REPORT_DESIGNER_PERSPECTIVE, "1.0.1");
                }
            }
            return this.reportPerspective;
        }
        if (PARAMETER_DESIGNER_PERSPECTIVE.equals(perspectiveName)) {
            if (this.paramPerspective == null && create) {
                if (this.extCallback != null) {
                    this.paramPerspective = this.extCallback.getPerspective(perspectiveName);
                }
                if (this.paramPerspective == null) {
                    this.paramPerspective = new ParameterPerspective(this, PARAMETER_DESIGNER_PERSPECTIVE, "1.0.1");
                }
            }
            return this.paramPerspective;
        }
        if (DATA_DESIGNER_PERSPECTIVE.equals(perspectiveName)) {
            if (this.dataPerspective == null && create) {
                if (this.extCallback != null) {
                    this.dataPerspective = this.extCallback.getPerspective(perspectiveName);
                }
                if (this.dataPerspective == null) {
                    this.dataPerspective = new DataPerspective(this, DATA_DESIGNER_PERSPECTIVE, "1.0.1");
                }
            }
            return this.dataPerspective;
        }
        return null;
    }

    public Perspective getActivePerspective() {
        return this.activePerspective;
    }

    public FormulaWizardMisc getFormulaWizardMisc() {
        if (this.formulaWizardMisc == null) {
            this.formulaWizardMisc = new FormulaWizardMisc(this);
        }
        return this.formulaWizardMisc;
    }

    public void setBook(Book book) {
        SpreadContext context = MiscUtil.getActiveSpreadContext(this);
        this.nextStage(10, "\u52a0\u8f7d\u5de5\u4f5c\u7a7a\u95f4");
        this.nextStage(18, "\u521d\u59cb\u5316\u62a5\u8868");
        if (context == null) {
            int sType = book.getActiveSheet().getSheetType();
            context = sType == 1 ? MiscUtil.getPerspectiveSpreadContext(this.getPerspective(REPORT_DESIGNER_PERSPECTIVE)) : MiscUtil.getPerspectiveSpreadContext(this.getPerspective(DATA_DESIGNER_PERSPECTIVE));
        }
        this.nextStage(30, "\u521d\u59cb\u5316JavaFX");
        new JFXPanel();
        Platform.setImplicitExit((boolean)false);
        KDSpread spread = context.getSpread();
        if (ZipFile.FUSIONCHART_INSTALLED && spread.isFreezed()) {
            spread.unFreeze();
        }
        book.setCellDisplayMode(1);
        int sheetCount = book.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            Sheet sheet = book.getSheet(i);
            sheet.setSheetType(1);
            sheet.getSheetOption().setCellDisplayMode(1);
        }
        book.set4Mobile(this.extCallback.isMobileTemplate());
        UserObject uo = book.getUserObject("ExtRpt_noChartTransferTip");
        boolean skipShowChartTransferTips = false;
        if (null != uo) {
            skipShowChartTransferTips = Boolean.valueOf(uo.getValue().toString());
        }
        if (!skipShowChartTransferTips && ChartUtil.hasChart(book, ChartFrameWorkType.FUSIONCART)) {
            ChartUtil.processTransferCharts((Component)((Object)this), book);
        }
        context.setBook(book);
        this.nextStage(40, "\u521d\u59cb\u5316\u6253\u5370\u8bbe\u7f6e");
        for (int i = 0; i < sheetCount; ++i) {
            Sheet sheet = book.getSheet(i);
            PrintSetup ps = sheet.getSheetOption().getPrintSetup(false);
            if (ps != null) continue;
            ps = sheet.getSheetOption().getPrintSetup(true);
            PrintBookTrans.saveToBook(context.getPrintManager(), book, new String[]{sheet.getID()});
            ps.setHasColHead(false);
            ps.setBlackWhite(false);
            ps.setHasGrid(false);
        }
        this.nextStage(80, "\u52a0\u8f7d\u62a5\u8868\u5de5\u4f5c\u5f15\u64ce");
    }

    public void setDefaultRowColLenght(Book book, boolean isNew) {
        if (!this.extCallback.isMobileTemplate() || book == null) {
            return;
        }
        if (isNew) {
            int sheetCount = book.getSheetCount();
            for (int i = 0; i < sheetCount; ++i) {
                Sheet sheet = book.getSheet(i);
                sheet.setOriginalDefRowHeight(30);
                sheet.setOriginalDefColWidth(79);
                this.setDefaultRowColLenght(sheet);
            }
        }
        book.addBookChangeListener(new BookChangeListener(){

            @Override
            public void changed(BookChangeEvent e) {
                if (e.isSheetInsert()) {
                    Sheet sheet = e.getSheet();
                    sheet.setOriginalDefRowHeight(30);
                    sheet.setOriginalDefColWidth(79);
                    KDExt.this.setDefaultRowColLenght(sheet);
                }
            }
        });
        book.addSheetChangeListener(new SheetChangeListener(){

            @Override
            public void changed(SheetChangeEvent e) {
                long clearState = SheetChangeEvent.Changed_Content | SheetChangeEvent.Changed_Style | SheetChangeEvent.Changed_Resize;
                if (e.getChangedStates() == clearState || e.hasState(SheetChangeEvent.Changed_Insert)) {
                    SortedCellBlockArray blockArray = e.getChangedBlocks();
                    KDExt.this.setDefaultRowColLenght(e.getSheet(), blockArray);
                }
            }
        });
    }

    private void setDefaultRowColLenght(Sheet sheet, SortedCellBlockArray blockArray) {
        if (blockArray == null || blockArray.isEmpty()) {
            return;
        }
        for (int i = 0; i < blockArray.size(); ++i) {
            CellBlock cellBlock = blockArray.getBlock(i);
            if (cellBlock.isRow()) {
                int row = cellBlock.getRow();
                int row2 = cellBlock.getRow2();
                sheet.getRowSpans().setSpanAttribute(new Span(row, row2), null, new Integer(30), new Boolean(true), null, null, null);
                continue;
            }
            if (!cellBlock.isCol()) continue;
            int col = cellBlock.getCol();
            int col2 = cellBlock.getCol2();
            sheet.getColSpans().setSpanAttribute(new Span(col, col2), null, new Integer(79), new Boolean(true), null, null, null);
        }
    }

    private void setDefaultRowColLenght(Sheet sheet) {
        if (sheet == null) {
            return;
        }
        sheet.getRowSpans().setSpanAttribute(new Span(0, 1048575), null, new Integer(30), new Boolean(true), null, null, null);
        sheet.getColSpans().setSpanAttribute(new Span(0, 65535), null, new Integer(79), new Boolean(true), null, null, null);
    }

    @Override
    public void changed(BookChangeEvent e) {
        if (e.isSheetActive()) {
            Sheet sheet = e.getSheet();
            if (sheet.getSheetType() == 1) {
                if (this.reportPerspective != null && this.reportPerspective == this.activePerspective) {
                    return;
                }
                Perspective deactivedPerspective = this.activePerspective;
                this.activePerspective = this.reportPerspective;
                Container c = this.getContentPane();
                c.removeAll();
                c.add((Component)this.getPerspective(REPORT_DESIGNER_PERSPECTIVE), "Center");
                SpreadContext activeContext = MiscUtil.getPerspectiveSpreadContext(this.reportPerspective);
                if (activeContext.getBook() != sheet.getBook()) {
                    activeContext.setBook(sheet.getBook());
                }
                this.firePerspectiveChangeEvent(new PerspectiveChangeEvent(this.reportPerspective, deactivedPerspective));
            } else {
                if (this.dataPerspective != null && this.dataPerspective == this.activePerspective) {
                    return;
                }
                Perspective deactivedPerspective = this.activePerspective;
                this.activePerspective = this.dataPerspective;
                Container c = this.getContentPane();
                c.removeAll();
                c.add((Component)this.getPerspective(DATA_DESIGNER_PERSPECTIVE), "Center");
                SpreadContext activeContext = MiscUtil.getPerspectiveSpreadContext(this.dataPerspective);
                if (activeContext.getBook() != sheet.getBook()) {
                    activeContext.setBook(sheet.getBook());
                }
                this.firePerspectiveChangeEvent(new PerspectiveChangeEvent(this.dataPerspective, deactivedPerspective));
            }
        }
    }

    public IPathDefiner getPathDefiner() {
        return definer;
    }

    public void setPathDefiner(IPathDefiner definer) {
        KDExt.definer = definer;
    }

    public void addPerspectiveChangeListener(PerspectiveChangeListener listener) {
        this.perspectiveListeners.add(listener);
    }

    public void removePerspectiveChangeListener(PerspectiveChangeListener listener) {
        this.perspectiveListeners.remove(listener);
    }

    private void firePerspectiveChangeEvent(PerspectiveChangeEvent e) {
        for (int i = this.perspectiveListeners.size() - 1; i >= 0; --i) {
            ((PerspectiveChangeListener)this.perspectiveListeners.get(i)).perspectiveChanged(e);
        }
    }

    public static void main(String[] args) {
        if (System.getProperty("EAS_SERVER") == null) {
            System.setProperty("EAS_SERVER", "localhost");
        }
        Locale.setDefault(Locale.CHINA);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    KingdeeLookAndFeel.setCurrentTheme((int)3);
                    UIManager.setLookAndFeel((LookAndFeel)new KingdeeLookAndFeel());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                CtrlSwingUtilities.resetAppDefaultFocusTraversalKeys();
                KDExt frame = new KDExt();
                try {
                    frame.refresh();
                }
                catch (Exception e) {
                    MiscUtil.handleFileCheckingException(e, (Component)((Object)frame));
                }
                frame.setVisible(true);
            }
        }).start();
    }

    static {
        TimeZone zone = TimeZone.getDefault();
        TimeZone.setDefault(new SimpleTimeZone(zone.getRawOffset(), zone.getID(), 0, 0, 0, 0, 0, 0, 0, 0));
    }

    public static interface IPathDefiner {
        public String defineName(String var1);
    }
}

