/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.fulfil.mobile;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.fulfil.ExtGuiExecutor;
import com.kingdee.bos.ctrl.ext.immit.IExtRuntimeDataProvider;
import com.kingdee.bos.ctrl.ext.immit.ReportProperties;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.exec.ExecutionContext;
import com.kingdee.bos.ctrl.kds.exec.ExtExecutor;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.io.kds.AuthorizationFailedException;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Protection;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.embed.subrpt.SubReportGuiExecutor;
import com.kingdee.bos.ctrl.swing.event.AncestorAdapter;
import java.util.Map;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class ExtMobileExecutor {
    private Book _book;
    private byte[] _bookData;
    private SpreadContext _context;
    private IExtRuntimeDataProvider _dataProvider;
    private ExternalAuthentificator authentificator;
    private boolean _limit;
    private boolean _needExternalAuthorization;
    private SubReportGuiExecutor _subRptExecutor;

    public ExtMobileExecutor(byte[] bookData, IExtRuntimeDataProvider provider, boolean limit) {
        try {
            this._book = MiscUtil.unpack(bookData);
        }
        catch (Exception e) {
            MiscUtil.handleFileCheckingException(e, null);
            if (MiscUtil.shouldLog()) {
                MiscUtil.log(e);
            }
            return;
        }
        this._bookData = bookData;
        this.init(this._book, provider, limit);
    }

    private void init(Book book, IExtRuntimeDataProvider provider, boolean limit) {
        if (provider != null) {
            ReportProperties rp = provider.fetchCurrentReportProperties();
            if (rp != null) {
                this._book.getDeps().setCalcDescription("localhost", "localhost", rp.getName());
            } else {
                this._book.getDeps().setCalcDescription("localhost", "localhost", this._book.getName());
            }
        }
        this._needExternalAuthorization = !StringUtil.isEmptyString((String)this._book.getPassportGrantor());
        this._limit = limit;
        this._dataProvider = provider;
        if (this._dataProvider != null) {
            this._book.getDataSetManager().getExecutionContext().setRptRuntimeCallback(this._dataProvider.getRptRuntimeCallback(null));
        }
        this.configSpread();
        boolean unhideRC = ExtGuiExecutor.isSecurityHidedRowsOrCols(this._book);
        for (int i = this._book.getSheetCount() - 1; i >= 0; --i) {
            Protection protection = this._book.getSheet(i).getSheetOption().getProtection(true);
            if (unhideRC) {
                protection.deleteOperation(131072);
                continue;
            }
            protection.appendOperation(131072);
        }
    }

    private void configSpread() {
        this._context = new SpreadContext();
        if (MiscUtil.shouldLog()) {
            MiscUtil.log(3, MiscUtil.SIGN);
        }
        if (!this._limit && this._needExternalAuthorization) {
            this.authentificator = new ExternalAuthentificator();
            this._context.addAncestorListener((AncestorListener)((Object)this.authentificator));
        }
        MiscUtil.capacitateFiCalculation(this._context);
    }

    public boolean execute(Map params) throws AuthorizationFailedException, Exception {
        return this.execute(true, params);
    }

    public boolean execute(boolean isClient, Map params) throws AuthorizationFailedException, Exception {
        try {
            this._book = MiscUtil.unpack(this._bookData);
            ReportProperties rp = this._dataProvider.fetchCurrentReportProperties();
            if (rp != null) {
                this._book.getDeps().setCalcDescription("localhost", "localhost", rp.getName());
            } else {
                this._book.getDeps().setCalcDescription("localhost", "localhost", this._book.getName());
            }
        }
        catch (Exception e) {
            MiscUtil.handleFileCheckingException(e, null);
            if (MiscUtil.shouldLog()) {
                MiscUtil.log(e);
            }
            return false;
        }
        ExecutionContext exeCtx = this._book.getDataSetManager().getExecutionContext();
        if (this._dataProvider != null) {
            exeCtx.setRptRuntimeCallback(this._dataProvider.getRptRuntimeCallback(null));
        }
        if (!isClient) {
            boolean shouldUseDemoData = !this._dataProvider.isAuthorizedReport() && this._book.getCloudRptUuid() != null && this._book.getUserObject("CLOUD_REPORT_DEMO_BOOK_DATA") != null;
            exeCtx.setUseDemoData(shouldUseDemoData);
        }
        if (this._limit) {
            exeCtx.registerDataSetCacheObject("isPreview", Boolean.TRUE);
            exeCtx.registerDataSetCacheObject("isLimitRecord", Boolean.TRUE);
        }
        try {
            ExtExecutor.exec(this._book, this._dataProvider.fetchDataSetFactories(MiscUtil.collectExtDataSetTypes(this._book), exeCtx), params, null);
        }
        catch (Exception e) {
            if (MiscUtil.shouldLog()) {
                MiscUtil.log(e);
            }
            return false;
        }
        this.setBook();
        if (this._subRptExecutor == null) {
            this._subRptExecutor = new SubReportGuiExecutor(this._dataProvider, this._book, this._limit, params);
        } else {
            this._subRptExecutor.setMainBook(this._book);
        }
        this._subRptExecutor.exec();
        return true;
    }

    private Map mergeMap(Map map1, Map map2) {
        if (map1 == null && map2 == null) {
            return null;
        }
        if (map1 != null && map2 == null) {
            return map1;
        }
        if (map1 == null && map2 != null) {
            return map2;
        }
        map1.putAll(map2);
        return map1;
    }

    private void setBook() {
        this._context.setBook(this._book);
        Sheet sheet = this._book.getActiveSheet();
        sheet.calcSecHidedColsNRows();
    }

    public Book getBook() {
        return this._book;
    }

    public void setBookData(byte[] bookData) {
        this._bookData = bookData;
    }

    public IExtRuntimeDataProvider getDataProvider() {
        return this._dataProvider;
    }

    public boolean isLimit() {
        return this._limit;
    }

    static /* synthetic */ byte[] access$402(ExtMobileExecutor x0, byte[] x1) {
        x0._bookData = x1;
        return x1;
    }

    private class ExternalAuthentificator
    extends AncestorAdapter {
        private ExternalAuthentificator() {
        }

        public void ancestorRemoved(AncestorEvent e) {
            if (!ExtMobileExecutor.this._limit && ExtMobileExecutor.this._needExternalAuthorization) {
                String passportGrantor = ExtMobileExecutor.this._book.getPassportGrantor();
                try {
                    if (((Boolean)Class.forName(passportGrantor).getMethod("releaseLicense", new Class[0]).invoke(null, new Object[0])).booleanValue()) {
                        MiscUtil.log(2, "\u62a5\u8868\u6267\u884c\u5668\u91ca\u653e\u6807\u51c6\u4ea7\u54c1\u62a5\u8868\u7248\u6743License\u6210\u529f\uff01");
                    } else {
                        MiscUtil.log(2, "\u62a5\u8868\u6267\u884c\u5668\u65e0\u6cd5\u91ca\u653e\u6807\u51c6\u4ea7\u54c1\u62a5\u8868\u7248\u6743License\uff01");
                    }
                }
                catch (Throwable t) {
                    MiscUtil.log(2, "\u62a5\u8868\u6267\u884c\u5668\u91ca\u653e\u6807\u51c6\u4ea7\u54c1\u62a5\u8868\u7248\u6743License\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u672a\u77e5\u5f02\u5e38\uff1a");
                    MiscUtil.log(t);
                }
                ExtMobileExecutor.this._book = null;
                ExtMobileExecutor.access$402(ExtMobileExecutor.this, null);
                ExtMobileExecutor.this._context.setBook(Book.Manager.getNewBook());
            }
        }
    }
}

