/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.fulfil.mobile.device;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.ext.fulfil.mobile.device.AbstractDevice;
import com.kingdee.bos.ctrl.ext.fulfil.mobile.device.CommonDevice;
import com.kingdee.bos.ctrl.ext.fulfil.mobile.device.DefaultDevice;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class DeviceFactory {
    private static Logger logger = LogUtil.getPackageLogger(DeviceFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static AbstractDevice[] createAll() {
        ArrayList<AbstractDevice> all;
        block9: {
            InputStream stm;
            block8: {
                all = new ArrayList<AbstractDevice>();
                stm = DeviceFactory.class.getResourceAsStream("devices.xml");
                if (stm != null) break block8;
                all.add(new DefaultDevice());
                logger.error((Object)"Devices config file not found.");
                break block9;
            }
            Element root = null;
            try {
                root = XmlUtil.loadXmlStream((InputStream)stm);
            }
            catch (IOException ex) {
                logger.error((Object)"Load devices config file error.", (Throwable)ex);
                CloseUtil.close((Closeable[])new Closeable[]{stm});
            }
            catch (JDOMException ex2) {
                logger.error((Object)"Load devices config file error.", (Throwable)ex2);
                {
                    catch (Throwable throwable) {
                        CloseUtil.close((Closeable[])new Closeable[]{stm});
                        throw throwable;
                    }
                }
                CloseUtil.close((Closeable[])new Closeable[]{stm});
            }
            CloseUtil.close((Closeable[])new Closeable[]{stm});
            if (root != null) {
                List deviceNodes = root.getChildren("Device");
                int c = deviceNodes.size();
                for (int i = 0; i < c; ++i) {
                    Element deviceNode = (Element)deviceNodes.get(i);
                    CommonDevice device = DeviceFactory.createDevice(deviceNode);
                    all.add(device);
                }
            }
        }
        return all.toArray(new AbstractDevice[0]);
    }

    private static CommonDevice createDevice(Element deviceNode) {
        CommonDevice device = new CommonDevice();
        device.setName(deviceNode.getAttributeValue("name"));
        device.setRealScreenSize(DeviceFactory.getIntFromXmlNode(deviceNode, "width"), DeviceFactory.getIntFromXmlNode(deviceNode, "height"));
        Element statusBar = deviceNode.getChild("StatusBar");
        if (null != statusBar) {
            device.setHasStatusBar(Boolean.parseBoolean(statusBar.getAttributeValue("showBar")));
            String shape = statusBar.getAttributeValue("shape");
            if (!StringUtil.isEmptyString((String)shape)) {
                device.setStatusBarShape(shape);
            }
        }
        Element simNode = deviceNode.getChild("Sim");
        device.setImageName(simNode.getAttributeValue("image"));
        Element simSizeNode = simNode.getChild("Size");
        device.setWindowSize(DeviceFactory.getIntFromXmlNode(simSizeNode, "width"), DeviceFactory.getIntFromXmlNode(simSizeNode, "height"));
        Element simScreenNode = simNode.getChild("Screen");
        device.setSimScreenPosition(DeviceFactory.getIntFromXmlNode(simScreenNode, "x"), DeviceFactory.getIntFromXmlNode(simScreenNode, "y"));
        device.setSimScreenSize(DeviceFactory.getIntFromXmlNode(simScreenNode, "width"), DeviceFactory.getIntFromXmlNode(simScreenNode, "height"));
        return device;
    }

    private static int getIntFromXmlNode(Element node, String attrName) {
        return Integer.parseInt(node.getAttributeValue(attrName));
    }
}

