/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.fulfil.mobile.webapps.util;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.ext.fulfil.mobile.webapps.model.PackageMeta;
import com.kingdee.bos.ctrl.ext.fulfil.mobile.webapps.model.SourceObject;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.util.Uuid;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class WebAppsPackUtil {
    private static Logger log = CommonLogger.getLogger(WebAppsPackUtil.class);
    private static List<SourceObject> sourceObjects = new ArrayList<SourceObject>(128);
    public static String EXTWEB_FILE_PATH = "";
    public static String PACK_FILE_DEST_PATH = "D:" + File.separator + "temp" + File.separator + "369";

    public static void main(String[] args) throws InterruptedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pack(String src, String dest) {
        File srcFile = new File(src);
        File destFile = new File(dest);
        if (destFile.isDirectory()) {
            String name = srcFile.getName();
            name = name.indexOf(".") > 0 ? name.substring(0, name.indexOf(".")) : name;
            name = name + ".mobile_rpt";
            destFile = new File(destFile + File.separator + name);
        }
        PackageMeta meta = WebAppsPackUtil.collectAllFile(srcFile);
        FileOutputStream fout = null;
        ZipOutputStream out = null;
        try {
            fout = new FileOutputStream(destFile);
            out = new ZipOutputStream(new BufferedOutputStream(fout));
            meta.exportToZip(out);
        }
        catch (IOException e) {
            try {
                log.error((Object)"pack file error.", (Throwable)e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{out, fout});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{out, fout});
        }
        CloseUtil.close((Closeable[])new Closeable[]{out, fout});
    }

    private static PackageMeta collectAllFile(File src) {
        PackageMeta meta = new PackageMeta();
        if (src.isDirectory()) {
            WebAppsPackUtil.collectAllFile(src, src.getName());
        }
        meta.setSourceObjects(sourceObjects);
        return meta;
    }

    private static void collectAllFile(File src, String path) {
        if (src.isDirectory()) {
            File[] files = src.listFiles();
            path = path.equals("") ? "" : path + "/";
            for (int i = 0; i < files.length; ++i) {
                WebAppsPackUtil.collectAllFile(files[i], path + files[i].getName());
            }
        } else {
            WebAppsPackUtil.collectSourcefile(src, path);
        }
    }

    private static void collectSourcefile(File file, String path) {
        SourceObject sourceObject = new SourceObject();
        sourceObject.setName(file.getName());
        sourceObject.setUid(Uuid.randomUUID().toString());
        sourceObject.setPath(path);
        sourceObjects.add(sourceObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpack(String src) {
        ZipInputStream in;
        FileInputStream fis;
        block6: {
            if (null == src) {
                return;
            }
            File srcFile = new File(FilenameUtils.normalize((String)src));
            if (!srcFile.getName().endsWith(".mobile_rpt")) {
                return;
            }
            fis = null;
            in = null;
            try {
                String firstFileName;
                fis = new FileInputStream(srcFile);
                in = new ZipInputStream(fis);
                ZipEntry firstEntry = in.getNextEntry();
                if (null == firstEntry || !(firstFileName = firstEntry.getName()).equals("package-meta.xml")) break block6;
                PackageMeta packageMeta = new PackageMeta();
                ByteArrayInputStream byteArrayInputStream = WebAppsPackUtil.getInputStreamFromZipInputStream(in);
                Element metaElement = XmlUtil.loadXmlStream((InputStream)byteArrayInputStream);
                packageMeta.fromXml(metaElement);
                packageMeta.write(in);
            }
            catch (Exception e) {
                try {
                    log.error((Object)"unpack file error.", (Throwable)e);
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{in, fis});
                    throw throwable;
                }
                CloseUtil.close((Closeable[])new Closeable[]{in, fis});
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{in, fis});
    }

    public static ByteArrayInputStream getInputStreamFromZipInputStream(InputStream inputStream) throws IOException {
        return new ByteArrayInputStream(WebAppsPackUtil.parseInputStream2Bytes(inputStream));
    }

    public static byte[] parseInputStream2Bytes(InputStream inputStream) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = inputStream.read(buffer)) > -1) {
            baos.write(buffer, 0, len);
        }
        baos.flush();
        return baos.toByteArray();
    }

    public static void deleteMobileRptFile(Path path) throws IOException {
        if (null == path) {
            return;
        }
        if (path.toFile().exists()) {
            Files.delete(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteSource(Path path) throws IOException {
        if (null == path) {
            return;
        }
        if (path.toFile().isDirectory()) {
            DirectoryStream<Path> entries = null;
            try {
                entries = Files.newDirectoryStream(path);
                for (Path entry : entries) {
                    WebAppsPackUtil.deleteSource(entry);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{entries});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{entries});
        }
        Files.delete(path);
    }
}

