/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.pd.ui.embed;

import com.kingdee.bos.ctrl.ext.pd.ui.embed.ParamEmbedXControl;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.util.KDSDataInputStream;
import com.kingdee.bos.ctrl.kds.util.KDSDataOutputStream;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.swing.JComponent;

public class ParamEmbedXCheckBox
extends ParamEmbedXControl {
    private KDCheckBox _check;

    public ParamEmbedXCheckBox(Sheet sheet) {
        super(sheet);
        this.initEmbed();
    }

    private void initEmbed() {
        this._check = new KDCheckBox();
        ((ParamEmbedXControl.SimpleLabelContainer)this.ui).setEditor((JComponent)this._check);
    }

    @Override
    public void setParameter(IParameter param) {
        super.setParameter(param);
        ((ParamEmbedXControl.SimpleLabelContainer)this.ui).setLabelText(param.getAlias());
        Variant value = param.getValue();
        if (value == null) {
            this._check.setSelected(false);
        } else {
            try {
                this._check.setSelected(value.toBoolean().booleanValue());
            }
            catch (SyntaxErrorException e) {
                this._check.setSelected(false);
            }
        }
    }

    public void setCheckBoxSelected(boolean selected) {
        this._check.setSelected(selected);
    }

    public boolean isCheckBoxSelected() {
        return this._check.isSelected();
    }

    @Override
    protected byte[] saveCustom() {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        KDSDataOutputStream out = new KDSDataOutputStream(bs);
        try {
            out.writeString("1.0");
            out.writeBoolean(this.physical);
            if (this.param != null) {
                out.writeString(this.param.getName());
            } else if (this.paramName != null) {
                out.writeString(this.paramName);
            } else {
                out.writeString(null);
            }
            out.writeString(this.getLabelText());
            out.writeBoolean(this._check.isSelected());
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bs.toByteArray();
    }

    @Override
    protected void loadCustom(byte[] str) {
        try {
            KDSDataInputStream is = new KDSDataInputStream(new ByteArrayInputStream(str));
            is.readString();
            this.physical = is.readBoolean();
            this.paramName = is.readString();
            this.setLabelText(is.readString());
            this._check.setSelected(is.readBoolean());
            is.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

