/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.pd.ui.views.params;

import com.kingdee.bos.ctrl.ext.pd.ui.embed.EmbedXControl;
import com.kingdee.bos.ctrl.ext.pd.ui.embed.EmbedXLabel;
import com.kingdee.bos.ctrl.ext.pd.ui.embed.EmbedXSeparator;
import com.kingdee.bos.ctrl.ext.pd.ui.embed.ParamEmbedXCheckBox;
import com.kingdee.bos.ctrl.ext.pd.ui.embed.ParamEmbedXComboBox;
import com.kingdee.bos.ctrl.ext.pd.ui.embed.ParamEmbedXDatePicker;
import com.kingdee.bos.ctrl.ext.pd.ui.embed.ParamEmbedXTextField;
import com.kingdee.bos.ctrl.ext.pd.ui.views.ctrls.ControlsTrimView;
import com.kingdee.bos.ctrl.ext.pd.ui.views.ctrls.desc.IEmbedDesc;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;

public class ShadowPanel
extends JComponent {
    private SpreadContext _context;
    private Point startPoint;
    private Point currentPoint;
    private ControlsTrimView ctrlsTrim;

    public ShadowPanel(SpreadContext context) {
        this._context = context;
        this.initListeners();
        this.setOpaque(false);
    }

    public void setControlsTrimView(ControlsTrimView trim) {
        this.ctrlsTrim = trim;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(new Color(0, 0, 0, 0));
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.startPoint == null || this.currentPoint == null) {
            return;
        }
        g2d.setColor(Color.BLACK);
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.drawRect(this.startPoint.x, this.startPoint.y, this.currentPoint.x - this.startPoint.x, this.currentPoint.y - this.startPoint.y);
    }

    private void executeInsertion() {
        EmbedXControl embedx;
        if (this.startPoint == null || this.currentPoint == null) {
            this.ctrlsTrim.resetDescList();
            this._context.getSpread().requestFocusInWindow();
            return;
        }
        Sheet sheet = this._context.getBook().getActiveSheet();
        IEmbedDesc desc = this.ctrlsTrim.getSelectedEmbedDesc();
        switch (desc.getType()) {
            case 0: {
                return;
            }
            case 1: {
                embedx = new EmbedXLabel(sheet);
                break;
            }
            case 2: {
                embedx = new ParamEmbedXTextField(sheet);
                break;
            }
            case 3: {
                embedx = new EmbedXSeparator(sheet);
                break;
            }
            case 4: {
                embedx = new ParamEmbedXComboBox(sheet);
                break;
            }
            case 5: {
                embedx = new ParamEmbedXDatePicker(sheet);
                break;
            }
            case 6: {
                embedx = new ParamEmbedXCheckBox(sheet);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u4e0d\u53ef\u601d\u8bae\u7684\u63a7\u4ef6\u7c7b\u578b");
            }
        }
        EmbedXControl xControl = embedx;
        xControl.setBounds(this.startPoint.x, this.startPoint.y, this.currentPoint.x - this.startPoint.x, this.currentPoint.y - this.startPoint.y);
        xControl.setUIPhysical(false);
        EmbedhLayer layer = sheet.getEmbedments(true);
        layer.addEmbed(xControl);
        layer.selectEmbed(xControl, 2);
        this.ctrlsTrim.resetDescList();
        this._context.getSpread().requestFocusInWindow();
    }

    private void initListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ShadowPanel.this.startPoint = e.getPoint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ShadowPanel.this.executeInsertion();
                ShadowPanel.this.startPoint = null;
                ShadowPanel.this.currentPoint = null;
                ShadowPanel.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                ShadowPanel.this.currentPoint = e.getPoint();
                ShadowPanel.this.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }
}

