/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.pe.propsheet;

import com.kingdee.bos.ctrl.ext.pe.beans.ExtendedPropertyDescriptor;
import com.kingdee.bos.ctrl.ext.pe.beans.renderer.BooleanCellRenderer;
import com.kingdee.bos.ctrl.ext.pe.beans.renderer.ColorCellRenderer;
import com.kingdee.bos.ctrl.ext.pe.beans.renderer.DateRenderer;
import com.kingdee.bos.ctrl.ext.pe.beans.renderer.DefaultCellRenderer;
import com.kingdee.bos.ctrl.ext.pe.beans.renderer.PrimitiveBooleanCellRenderer;
import com.kingdee.bos.ctrl.ext.pe.beans.value.BooleanVFPair;
import com.kingdee.bos.ctrl.ext.pe.beans.value.ColorVFPair;
import com.kingdee.bos.ctrl.ext.pe.beans.value.DateVFPair;
import com.kingdee.bos.ctrl.ext.pe.beans.value.DoubleVFPair;
import com.kingdee.bos.ctrl.ext.pe.beans.value.FloatVFPair;
import com.kingdee.bos.ctrl.ext.pe.beans.value.IntegerVFPair;
import com.kingdee.bos.ctrl.ext.pe.beans.value.LongVFPair;
import com.kingdee.bos.ctrl.ext.pe.beans.value.ShortVFPair;
import com.kingdee.bos.ctrl.ext.pe.beans.value.StringVFPair;
import com.kingdee.bos.ctrl.ext.pe.propsheet.Property;
import com.kingdee.bos.ctrl.ext.pe.propsheet.PropertyDescriptorAdapter;
import com.kingdee.bos.ctrl.ext.pe.propsheet.PropertyRendererFactory;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableCellRenderer;

public class PropertyRendererRegistry
implements PropertyRendererFactory {
    private Map typeToRenderer = new HashMap();
    private Map propertyToRenderer = new HashMap();

    public PropertyRendererRegistry() {
        this.registerDefaults();
    }

    @Override
    public TableCellRenderer createTableCellRenderer(Property property) {
        return this.getRenderer(property);
    }

    @Override
    public TableCellRenderer createTableCellRenderer(Class type) {
        return this.getRenderer(type);
    }

    public synchronized TableCellRenderer getRenderer(Property property) {
        Object value;
        PropertyDescriptor descriptor;
        TableCellRenderer renderer = null;
        if (property instanceof PropertyDescriptorAdapter && (descriptor = ((PropertyDescriptorAdapter)property).getDescriptor()) instanceof ExtendedPropertyDescriptor && ((ExtendedPropertyDescriptor)descriptor).getPropertyTableRendererClass() != null) {
            try {
                return (TableCellRenderer)((ExtendedPropertyDescriptor)descriptor).getPropertyTableRendererClass().newInstance();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if ((value = this.propertyToRenderer.get(property)) instanceof TableCellRenderer) {
            renderer = (TableCellRenderer)value;
        } else if (value instanceof Class) {
            try {
                renderer = (TableCellRenderer)((Class)value).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            renderer = this.getRenderer(property.getType());
        }
        return renderer;
    }

    public synchronized TableCellRenderer getRenderer(Class type) {
        TableCellRenderer renderer = null;
        Object value = this.typeToRenderer.get(type);
        if (value instanceof TableCellRenderer) {
            renderer = (TableCellRenderer)value;
        } else if (value instanceof Class) {
            try {
                renderer = (TableCellRenderer)((Class)value).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return renderer;
    }

    public synchronized void registerRenderer(Class type, Class rendererClass) {
        this.typeToRenderer.put(type, rendererClass);
    }

    public synchronized void registerRenderer(Class type, TableCellRenderer renderer) {
        this.typeToRenderer.put(type, renderer);
    }

    public synchronized void unregisterRenderer(Class type) {
        this.typeToRenderer.remove(type);
    }

    public synchronized void registerRenderer(Property property, Class rendererClass) {
        this.propertyToRenderer.put(property, rendererClass);
    }

    public synchronized void registerRenderer(Property property, TableCellRenderer renderer) {
        this.propertyToRenderer.put(property, renderer);
    }

    public synchronized void unregisterRenderer(Property property) {
        this.propertyToRenderer.remove(property);
    }

    public void registerDefaults() {
        this.typeToRenderer.clear();
        this.propertyToRenderer.clear();
        DefaultCellRenderer renderer = new DefaultCellRenderer();
        renderer.setShowOddAndEvenRows(false);
        ColorCellRenderer colorRenderer = new ColorCellRenderer();
        colorRenderer.setShowOddAndEvenRows(false);
        BooleanCellRenderer booleanRenderer = new BooleanCellRenderer();
        DateRenderer dateRenderer = new DateRenderer();
        dateRenderer.setShowOddAndEvenRows(false);
        this.registerRenderer(ColorVFPair.class, (TableCellRenderer)colorRenderer);
        this.registerRenderer(BooleanVFPair.class, (TableCellRenderer)booleanRenderer);
        this.registerRenderer(StringVFPair.class, (TableCellRenderer)renderer);
        this.registerRenderer(DoubleVFPair.class, (TableCellRenderer)renderer);
        this.registerRenderer(FloatVFPair.class, (TableCellRenderer)renderer);
        this.registerRenderer(IntegerVFPair.class, (TableCellRenderer)renderer);
        this.registerRenderer(LongVFPair.class, (TableCellRenderer)renderer);
        this.registerRenderer(ShortVFPair.class, (TableCellRenderer)renderer);
        this.registerRenderer(DateVFPair.class, (TableCellRenderer)dateRenderer);
        this.registerRenderer(Integer.TYPE, (TableCellRenderer)renderer);
        this.registerRenderer(Boolean.TYPE, (TableCellRenderer)new PrimitiveBooleanCellRenderer());
    }
}

