/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.rd;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.pe.beans.BaseBeanInfo;
import com.kingdee.bos.ctrl.ext.pe.beans.DefaultBeanInfoResolver;
import com.kingdee.bos.ctrl.ext.pe.beans.ExtendedPropertyDescriptor;
import com.kingdee.bos.ctrl.ext.pe.beans.editor.mobile.PhoneNumPropertyEditor;
import com.kingdee.bos.ctrl.ext.pe.beans.editor.mobile.PhonenumRenderer;
import com.kingdee.bos.ctrl.ext.pe.propsheet.Property;
import com.kingdee.bos.ctrl.ext.pe.propsheet.PropertySheetPanel;
import com.kingdee.bos.ctrl.ext.rd.model.beans.CellContextBean;
import com.kingdee.bos.ctrl.ext.rd.model.beans.ColContextBean;
import com.kingdee.bos.ctrl.ext.rd.model.beans.DummyResourceObject;
import com.kingdee.bos.ctrl.ext.rd.model.beans.RowContextBean;
import com.kingdee.bos.ctrl.ext.rd.model.beans.TableContextBean;
import com.kingdee.bos.ctrl.ext.rd.ui.views.peview.PropertyEditorTrimView;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.kds.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.kds.model.struct.event.GraphChangeListener;
import com.kingdee.bos.ctrl.kds.model.struct.event.GraphChangedEvent;
import com.kingdee.bos.ctrl.kds.model.struct.event.GraphPropertyChangedEvent;
import com.kingdee.bos.ctrl.kds.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.kds.model.struct.event.SheetChangeListener;
import java.beans.BeanInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import javax.swing.UIManager;

public class ReportBeanBindingManager {
    private static final HashMap _blockDisables = new HashMap();
    private KDExt _ext;
    private SpreadContext _context;
    private PropertySheetPanel _psp;
    private CellContextBean cellBean;
    private ColContextBean colBean;
    private RowContextBean rowBean;
    private TableContextBean tableBean;
    private Object contextBean;
    private BaseBeanInfo bbInfo;
    private BeanPropertyChangeListener propertyChangeListener;

    public ReportBeanBindingManager(KDExt ext, SpreadContext context, PropertySheetPanel psp) {
        this.contextBean = this.cellBean;
        this._ext = ext;
        this._context = context;
        this._psp = psp;
        this.init();
        this.initListeners();
    }

    private void init() {
        this.cellBean = new CellContextBean();
        this.colBean = new ColContextBean();
        this.rowBean = new RowContextBean();
        this.tableBean = new TableContextBean();
        this.propertyChangeListener = new BeanPropertyChangeListener();
    }

    private void initListeners() {
        this._psp.addPropertySheetChangeListener(this.propertyChangeListener);
        this._context.addSheetChangeListener(new SheetChangeListener(){

            @Override
            public void changed(SheetChangeEvent e) {
                if (e.hasState(SheetChangeEvent.Changed_BeforeSelection)) {
                    if (!ReportBeanBindingManager.this._ext.getFormulaWizardMisc().isEditing()) {
                        ReportBeanBindingManager.this.commitPropertySheetPanels();
                    }
                } else if (e.hasState(SheetChangeEvent.Changed_Selection)) {
                    if (!ReportBeanBindingManager.this._ext.getFormulaWizardMisc().isEditing()) {
                        ReportBeanBindingManager.this.bindContextBean();
                        Sheet sheet = ReportBeanBindingManager.this._context.getSpread().getBook().getActiveSheet();
                        ReportBeanBindingManager.this.setExtPropertyEnabled(SheetBaseMath.isSingleCellSelected(sheet));
                        ReportBeanBindingManager.this.refreshPropertySheetPanels();
                    }
                } else if (e.hasState(SheetChangeEvent.Changed_SelectionActive)) {
                    if (!ReportBeanBindingManager.this._ext.getFormulaWizardMisc().isEditing()) {
                        ReportBeanBindingManager.this.refreshPropertySheetPanels();
                    }
                } else if (e.hasState(SheetChangeEvent.Changed_Style)) {
                    Sheet sheet = ReportBeanBindingManager.this._context.getSpread().getBook().getActiveSheet();
                    if (e.getChangedBlocks().contains(CellBlock.getCellBlock(sheet.getActiveRow(), sheet.getActiveCol()))) {
                        ReportBeanBindingManager.this.refreshPropertySheetPanels();
                    }
                }
            }
        });
        this._context.addBookChangeListener(new BookChangeListener(){

            @Override
            public void changed(BookChangeEvent e) {
                if (e.isSheetActive()) {
                    Sheet sheet = e.getSheet();
                    ReportBeanBindingManager.this.bindContextBean();
                    ReportBeanBindingManager.this.refreshPropertySheetPanels();
                    CellBlock cb = sheet.getSelectionRange().getBounds();
                    ReportBeanBindingManager.this.setExtPropertyEnabled(cb.isSingleCell());
                    ((PropertyEditorTrimView)ReportBeanBindingManager.this._psp.getParent().getParent()).refreshDatasetTree();
                }
            }
        });
        this._context.addGraphChangeListener(new GraphChangeListener(){

            @Override
            public void propertyChanged(GraphPropertyChangedEvent e) {
            }

            @Override
            public void changed(GraphChangedEvent e) {
                if (e.isGraphSelected() && ReportBeanBindingManager.this.bbInfo != null) {
                    int size = ReportBeanBindingManager.this.bbInfo.getPropertyDescriptorCount();
                    for (int i = 0; i < size; ++i) {
                        ExtendedPropertyDescriptor epd = (ExtendedPropertyDescriptor)ReportBeanBindingManager.this.bbInfo.getPropertyDescriptor(i);
                        epd.setEditable(false);
                    }
                    ReportBeanBindingManager.this.refreshPropertySheetPanels();
                }
            }
        });
    }

    public void commitPropertySheetPanels() {
        this._psp.getTable().commitEditing();
    }

    private void bindContextBean() {
        Sheet sheet = this._context.getSpread().getBook().getActiveSheet();
        CellBlock cb = sheet.getSelectionRange().getBounds();
        this.contextBean = cb.isWholeSheet() ? this.tableBean : (cb.isRow() ? this.rowBean : (cb.isCol() ? this.colBean : this.cellBean));
        ((CellContextBean)this.contextBean).setSheet(sheet);
        this.bind(this.contextBean);
    }

    private void bind(Object bean) {
        this.bind(bean, new DefaultBeanInfoResolver().getBeanInfo(bean));
    }

    private void bind(Object bean, BeanInfo beanInfo) {
        if (this.cellBean instanceof CellContextBean && this._context.getSpread().getBook().is4Mobile()) {
            String localText = LanguageManager.getLangMessage((String)"cellCategory", DummyResourceObject.class, (String)"NotFound");
            ExtendedPropertyDescriptor desc = ((BaseBeanInfo)beanInfo).addProperty("phoneNum").setCategory(localText);
            desc.setPropertyEditorClass(PhoneNumPropertyEditor.class);
            desc.setPropertyTableRendererClass(PhonenumRenderer.class);
        }
        this.bbInfo = (BaseBeanInfo)beanInfo;
        this._psp.setProperties(beanInfo.getPropertyDescriptors());
        this.propertyChangeListener.bean = bean;
    }

    private void refreshPropertySheetPanels() {
        this._psp.readFromObject(this.contextBean, false);
    }

    private void setExtPropertyEnabled(boolean enabled) {
        if (this.bbInfo == null) {
            return;
        }
        int size = this.bbInfo.getPropertyDescriptorCount();
        for (int i = 0; i < size; ++i) {
            ExtendedPropertyDescriptor epd = (ExtendedPropertyDescriptor)this.bbInfo.getPropertyDescriptor(i);
            String name = epd.getName();
            Sheet sheet = this._context.getSpread().getBook().getActiveSheet();
            Cell cell = sheet.getActiveCell();
            if (enabled && cell != null && cell.getSubReportInfo() != null) {
                epd.setEditable(false);
                continue;
            }
            if (!_blockDisables.containsKey(name)) continue;
            epd.setEditable(enabled);
        }
    }

    static {
        _blockDisables.put("extensible", null);
        _blockDisables.put("leftHead", null);
        _blockDisables.put("topHead", null);
        _blockDisables.put("pageBreakRow", null);
        _blockDisables.put("pageBreakCol", null);
        _blockDisables.put("dispValue", null);
        _blockDisables.put("extRange", null);
        _blockDisables.put("rowHided", null);
        _blockDisables.put("columnHided", null);
        _blockDisables.put("hyperLink", null);
        _blockDisables.put("phoneNum", null);
    }

    private class BeanPropertyChangeListener
    implements PropertyChangeListener {
        private Object bean;

        private BeanPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Property prop = (Property)evt.getSource();
            try {
                prop.writeToObject(this.bean);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof PropertyVetoException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(ReportBeanBindingManager.this._psp);
                    prop.setValue(evt.getOldValue());
                }
                throw e;
            }
        }
    }
}

