/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.rd.celltree;

import com.kingdee.bos.ctrl.ext.rd.celltree.TreeCellInfoItem;
import com.kingdee.bos.ctrl.ext.rd.celltree.TreeCellUtil;
import com.kingdee.bos.ctrl.kds.impl.state.mouse.OutlineGroupColHeaderMouseController;
import com.kingdee.bos.ctrl.kds.impl.state.mouse.OutlineGroupRowHeaderMouseController;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class TreeCellPopMenuHelper {
    private JPopupMenu _menu = new JPopupMenu();
    private Integer[] nodeArray = null;
    private Sheet _sheet;
    private Map map = null;
    private Map rowLevelMap = null;
    private Map colLevelMap = null;
    private Point p = null;
    private boolean isRow = false;
    private int curIdx = -1;
    private List list;
    private int row;
    private int col;
    private static TreeCellPopMenuHelper helper = null;
    private static boolean flag = false;
    private List criticalPointList = new ArrayList();

    private TreeCellPopMenuHelper() {
        this.rowLevelMap = new HashMap();
        this.colLevelMap = new HashMap();
        if (this.list == null) {
            this.list = new ArrayList();
        }
    }

    public static TreeCellPopMenuHelper getInstance(Sheet sheet, Point point) {
        if (helper == null) {
            helper = new TreeCellPopMenuHelper();
        }
        if (TreeCellPopMenuHelper.helper._sheet != sheet) {
            flag = true;
        }
        TreeCellPopMenuHelper.helper._sheet = sheet;
        TreeCellPopMenuHelper.helper.p = point;
        return helper;
    }

    public JPopupMenu getCellTreePopupMenu(Point p) {
        this._menu.removeAll();
        this.buildCellTreePopupMenu(p);
        return this._menu;
    }

    private void buildCellTreePopupMenu(Point point) {
        if (point != null) {
            this.p = point;
        }
        this.row = SheetBaseMath.rowAtPoint(this._sheet, this.p);
        this.col = SheetBaseMath.colAtPoint(this._sheet, this.p);
        if (this.row < 0 || this.col < 0) {
            return;
        }
        this.isRow = TreeCellUtil.isColumnCellTreeDisplay(this._sheet.getCell(this.row, this.col, false));
        List _nodeList = null;
        if (this.isRow) {
            if (this.rowLevelMap != null || this.rowLevelMap.isEmpty() || flag) {
                this.collectAllcellsLevel(this.isRow);
            }
            _nodeList = this.getTreeByPointWhenRow(this.p);
            this.map = this.rowLevelMap;
        } else {
            if (this.colLevelMap != null || this.colLevelMap.isEmpty() || flag) {
                this.collectAllcellsLevel(this.isRow);
            }
            _nodeList = this.getTreeByPointWhenColumn(this.p);
            this.map = this.colLevelMap;
        }
        this.nodeArray = new Integer[_nodeList != null ? _nodeList.size() : 0];
        int maxLevel = 0;
        for (int i = 0; i < (this.nodeArray != null ? this.nodeArray.length : 0); ++i) {
            this.nodeArray[i] = (Integer)_nodeList.get(i);
            int level = ((TreeCellInfoItem)this.map.get(this.nodeArray[i])).getLevel();
            maxLevel = Math.max(maxLevel, level);
        }
        Arrays.sort((Object[])this.nodeArray);
        for (int j = 0; j <= maxLevel; ++j) {
            KDMenuItem item = new KDMenuItem("\u663e\u793a\u81f3" + (j + 1) + "\u7ea7\u7ed3\u70b9");
            item.setCustomAction((Action)new TreeCellLevelExpandAction(j));
            this.list.add(item);
            this._menu.add((JMenuItem)item);
        }
        KDMenuItem item = new KDMenuItem("\u5168\u90e8");
        item.setCustomAction((Action)new TreeCellLevelExpandAction(maxLevel));
        this._menu.add((JMenuItem)item);
    }

    private void saveInfoToLevelMap(int index, int level, boolean isCollapse, boolean isRow) {
        TreeCellInfoItem item = new TreeCellInfoItem();
        item.setCellIndex(index);
        item.setCollapse(isCollapse);
        item.setLevel(level);
        if (isRow) {
            this.rowLevelMap.put(new Integer(index), item);
        } else {
            this.colLevelMap.put(new Integer(index), item);
        }
    }

    private void collectAllcellsLevel(boolean isRow) {
        this.criticalPointList.clear();
        int maxIndex = 0;
        SortedAttributeSpanArray sa = null;
        if (isRow) {
            this.rowLevelMap.clear();
            if (this.map != null) {
                this.map.clear();
            }
            maxIndex = this._sheet.getMaxRowIndex(true);
            sa = this._sheet.getRowSpans();
        } else {
            this.colLevelMap.clear();
            if (this.map != null) {
                this.map.clear();
            }
            maxIndex = this._sheet.getMaxColIndex(true);
            sa = this._sheet.getColSpans();
        }
        boolean flag = false;
        SortedAttributeSpanArray.AttributeSpan preSpan = null;
        int preIdx = 0;
        for (int i = 0; i <= maxIndex; ++i) {
            CriticalPoint criticalPoint;
            int pos = sa.searchSpan(i);
            if (pos < 0) {
                if (flag) {
                    CriticalPoint criticalPoint2 = new CriticalPoint(preSpan, preIdx);
                    this.criticalPointList.add(criticalPoint2);
                }
                flag = false;
                preIdx = i;
                continue;
            }
            SortedAttributeSpanArray.AttributeSpan span = sa.getAttributeSpan(pos);
            if (span != null && span.getOutlineGroupLevel() == 0) {
                if (flag) {
                    criticalPoint = new CriticalPoint(preSpan, preIdx);
                    this.criticalPointList.add(criticalPoint);
                }
                flag = false;
                preIdx = i;
                continue;
            }
            if (span != null && span.getOutlineGroupLevel() > 0) {
                preSpan = span;
                this.saveInfoToLevelMap(i, span.getOutlineGroupLevel(), span.isCollapse(), isRow);
                if (!flag) {
                    criticalPoint = new CriticalPoint(preSpan, preIdx);
                    this.criticalPointList.add(criticalPoint);
                }
                flag = true;
            }
            preIdx = i;
        }
        this.dealWithCriticalPoint(this.criticalPointList, isRow);
    }

    private void dealWithCriticalPoint(List list, boolean dealWithRow) {
        boolean flag = false;
        flag = dealWithRow ? this._sheet.isAboveOfOutlineGroup() : this._sheet.isLeftToOutlineGroup();
        int startPos = 0;
        if (flag) {
            for (int i = startPos = 0; i < this.criticalPointList.size(); i += 2) {
                CriticalPoint criticalPoint = (CriticalPoint)this.criticalPointList.get(i);
                this.saveInfoToLevelMap(criticalPoint._index, 0, criticalPoint._span.isCollapse(), dealWithRow);
            }
        } else {
            for (int i = startPos = 1; i < this.criticalPointList.size(); i += 2) {
                CriticalPoint criticalPoint = (CriticalPoint)this.criticalPointList.get(i);
                this.saveInfoToLevelMap(criticalPoint._index, 0, criticalPoint._span.isCollapse(), dealWithRow);
            }
        }
    }

    private List getTreeByPointWhenRow(Point p) {
        int col = SheetBaseMath.colAtPoint(this._sheet, p);
        int row = SheetBaseMath.rowAtPoint(this._sheet, p);
        if (row < 0 || col < 0) {
            return null;
        }
        if (!this.rowLevelMap.containsKey(new Integer(row))) {
            return null;
        }
        Object[] keyObjects = this.rowLevelMap.keySet().toArray();
        Object[] keys = new Integer[keyObjects == null ? 0 : keyObjects.length];
        for (int k = 0; k < keyObjects.length; ++k) {
            keys[k] = (Integer)keyObjects[k];
        }
        Arrays.sort((Object[])keys);
        int idx = this.search(row, (Integer[])keys);
        if (idx < 0) {
            return null;
        }
        this.curIdx = idx;
        return this.getTheWholeTreeData(idx, (Integer[])keys, this.rowLevelMap, this._sheet.isAboveOfOutlineGroup());
    }

    private List getTheWholeTreeData(int idx, Integer[] keys, Map curMap, boolean condition) {
        TreeCellInfoItem item;
        Integer tmp;
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = idx; i >= 0; --i) {
            tmp = keys[i];
            item = (TreeCellInfoItem)curMap.get(tmp);
            if (item.getLevel() == 0) {
                if (!condition) break;
                list.add(tmp);
                break;
            }
            list.add(tmp);
        }
        for (int j = idx + 1; j < keys.length; ++j) {
            tmp = keys[j];
            item = (TreeCellInfoItem)curMap.get(tmp);
            if (item.getLevel() == 0) {
                if (condition) break;
                list.add(tmp);
                break;
            }
            list.add(tmp);
        }
        return list;
    }

    private int search(int key, Integer[] keys) {
        if (keys == null || keys.length == 0) {
            return -1;
        }
        int low = 0;
        int high = keys.length - 1;
        while (low <= high) {
            int cmp;
            int mid = low + high >> 1;
            int midVal = keys[mid];
            int n = midVal > key ? 1 : (cmp = midVal < key ? -1 : 0);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private List getTreeByPointWhenColumn(Point p) {
        int row = SheetBaseMath.colAtPoint(this._sheet, p);
        int col = SheetBaseMath.rowAtPoint(this._sheet, p);
        if (row < 0 || col < 0) {
            return null;
        }
        if (!this.colLevelMap.containsKey(new Integer(row))) {
            return null;
        }
        Object[] keyObjects = this.colLevelMap.keySet().toArray();
        Object[] keys = new Integer[keyObjects == null ? 0 : keyObjects.length];
        for (int k = 0; k < keyObjects.length; ++k) {
            keys[k] = (Integer)keyObjects[k];
        }
        Arrays.sort((Object[])keys);
        int idx = this.search(row, (Integer[])keys);
        if (idx < 0) {
            return null;
        }
        this.curIdx = idx;
        return this.getTheWholeTreeData(idx, (Integer[])keys, this.colLevelMap, this._sheet.isLeftToOutlineGroup());
    }

    private void switchTheHandler(boolean collapseCondition, boolean levelCompare, TreeCellInfoItem item, int cellIdx, int level) {
        if (item == null || levelCompare) {
            return;
        }
        if (this._sheet.isAboveOfOutlineGroup() && this.isRow && collapseCondition) {
            OutlineGroupRowHeaderMouseController.switchTheHandlerWhenAbove(this._sheet, cellIdx, this._sheet.getRowSpans(), level, item.isCollapse(), 1);
        }
        if (!this._sheet.isAboveOfOutlineGroup() && this.isRow && collapseCondition) {
            OutlineGroupRowHeaderMouseController.switchTheHandlerWhenBelow(this._sheet, cellIdx, this._sheet.getRowSpans(), level, item.isCollapse());
        }
        if (this._sheet.isLeftToOutlineGroup() && !this.isRow && collapseCondition) {
            OutlineGroupColHeaderMouseController.switchTheHandlerWhenLeft(this._sheet, cellIdx, this._sheet.getColSpans(), level, item.isCollapse(), 1);
        }
        if (!this._sheet.isLeftToOutlineGroup() && !this.isRow && collapseCondition) {
            OutlineGroupColHeaderMouseController.switchTheHandlerWhenRight(this._sheet, cellIdx, this._sheet.getColSpans(), level, item.isCollapse());
        }
    }

    private void switchTheHandlerAtLevel(int curLevel, TreeCellInfoItem item, int cellIdx, int level) {
        if (item == null) {
            return;
        }
        boolean off = false;
        off = level >= 0 && level < curLevel;
        if (this._sheet.isAboveOfOutlineGroup() && this.isRow) {
            OutlineGroupRowHeaderMouseController.switchTheHandlerWhenAbove(this._sheet, cellIdx, this._sheet.getRowSpans(), level, off, 1);
        }
        if (!this._sheet.isAboveOfOutlineGroup() && this.isRow) {
            OutlineGroupRowHeaderMouseController.switchTheHandlerWhenBelow(this._sheet, cellIdx, this._sheet.getRowSpans(), level, off);
        }
        if (this._sheet.isLeftToOutlineGroup() && !this.isRow) {
            OutlineGroupColHeaderMouseController.switchTheHandlerWhenLeft(this._sheet, cellIdx, this._sheet.getColSpans(), level, off, 1);
        }
        if (!this._sheet.isLeftToOutlineGroup() && !this.isRow) {
            OutlineGroupColHeaderMouseController.switchTheHandlerWhenRight(this._sheet, cellIdx, this._sheet.getColSpans(), level, off);
        }
    }

    private class TreeCellLevelCollapseAction
    extends AbstractAction {
        private int level = 0;
        private Map nodeMap = new HashMap();

        public TreeCellLevelCollapseAction(int level, Map map) {
            this.level = level;
            for (Integer key : map.keySet()) {
                this.nodeMap.put(key, map.get(key));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < TreeCellPopMenuHelper.this.nodeArray.length; ++i) {
                TreeCellInfoItem item = (TreeCellInfoItem)this.nodeMap.get(TreeCellPopMenuHelper.this.nodeArray[i]);
                TreeCellPopMenuHelper.this.switchTheHandler(!item.isCollapse(), item.getLevel() != this.level, item, TreeCellPopMenuHelper.this.nodeArray[i], this.level);
            }
        }
    }

    private class TreeCellLevelExpandAction
    extends AbstractAction {
        private int level = 0;

        public TreeCellLevelExpandAction(int level) {
            this.level = level;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SheetBaseMath.collapseGroupLevelTo(TreeCellPopMenuHelper.this._sheet, true, this.level);
        }
    }

    private class TreeCellCollapseAction
    extends AbstractAction {
        private int cellIdx = 0;
        private TreeCellInfoItem item = new TreeCellInfoItem();

        public TreeCellCollapseAction(int cellIdx, TreeCellInfoItem item) {
            this.cellIdx = cellIdx;
            this.item = item;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeCellPopMenuHelper.this.switchTheHandler(!this.item.isCollapse(), false, this.item, this.cellIdx, this.item.getLevel());
        }
    }

    private class TreeCellExpandAction
    extends AbstractAction {
        private int cellIdx = 0;
        private TreeCellInfoItem item = new TreeCellInfoItem();

        public TreeCellExpandAction(int cellIdx, TreeCellInfoItem item) {
            this.cellIdx = cellIdx;
            this.item = item;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeCellPopMenuHelper.this.switchTheHandler(this.item.isCollapse(), false, this.item, this.cellIdx, this.item.getLevel());
        }
    }

    private class CriticalPoint {
        public SortedAttributeSpanArray.AttributeSpan _span;
        public int _index;

        public CriticalPoint(SortedAttributeSpanArray.AttributeSpan span, int index) {
            this._index = index;
            this._span = span;
        }
    }
}

