/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.reporting.dirty;

import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.ext.reporting.dirty.ExtReportingDirtyManager;
import com.kingdee.bos.ctrl.ext.reporting.exception.ExtReportingBizException;
import com.kingdee.bos.ctrl.ext.reporting.model.runtime.CommitResult;
import com.kingdee.bos.ctrl.ext.reporting.model.runtime.ExecutionPlan;
import com.kingdee.bos.ctrl.ext.util.VariantUtil;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import java.util.Iterator;
import org.jdom2.Content;
import org.jdom2.Element;

public class ExtReportingDirtyManagerSaver {
    public void save(ExtReportingDirtyManager manager) throws ExtReportingBizException {
        Element root = new Element("ExtReportingDirtyManager");
        Element recodes = new Element("Recodes");
        root.addContent((Content)recodes);
        if (manager._records != null) {
            Iterator iter = manager._records.iterator();
            while (iter.hasNext()) {
                Element recode = new Element("Recode");
                ExecutionPlan plan = (ExecutionPlan)iter.next();
                recode.setAttribute("constraintName", plan.getConstraintName());
                recode.setAttribute("identityKey", plan.getIdentityKey());
                recode.setAttribute("className", plan.getClass().getName());
                Cell[] cellList = plan.getUsedCells();
                if (cellList != null) {
                    for (int i = 0; i < cellList.length; ++i) {
                        Element cell = new Element("Cell");
                        cell.setAttribute("sheetName", cellList[i].getSheet().getSheetName());
                        cell.setAttribute("rowIndex", String.valueOf(cellList[i].getRow()));
                        cell.setAttribute("colIndex", String.valueOf(cellList[i].getCol()));
                        Variant value = cellList[i].getValue();
                        cell.setAttribute("valueType", String.valueOf(VariantUtil.parseVariantType(value)));
                        cell.setAttribute("value", VariantUtil.variant2PlainString(value));
                        recode.addContent((Content)cell);
                    }
                }
                recodes.addContent((Content)recode);
                if (!plan.isLoaded()) {
                    plan.generateSQL();
                }
                recode.setAttribute("sqlContent", plan.getSQL());
                Variant[] commitValues = plan.getValues();
                int[] jdbcTypes = plan.getJdbcTypes();
                for (int i = 0; i < commitValues.length; ++i) {
                    Element commitValue = new Element("CommitValue");
                    Variant value = commitValues[i];
                    commitValue.setAttribute("valueType", String.valueOf(VariantUtil.parseVariantType(value)));
                    commitValue.setAttribute("value", VariantUtil.variant2PlainString(value));
                    commitValue.setAttribute("jdbcType", String.valueOf(jdbcTypes[i]));
                    recode.addContent((Content)commitValue);
                }
            }
        }
        Element results = new Element("Results");
        root.addContent((Content)results);
        if (manager._commitResults != null) {
            Iterator iter = manager._commitResults.iterator();
            while (iter.hasNext()) {
                Element result = new Element("Result");
                CommitResult cr = (CommitResult)iter.next();
                result.setAttribute("className", cr.getClass().getName());
                result.setAttribute("identityKey", cr.getIdentityKey());
                result.setAttribute("level", cr.getLevel());
                result.setText(cr.getResult());
                results.addContent((Content)result);
            }
        }
        try {
            manager._book.setUserObject("EXT_REPORTING_DIRTY_MANAGER_CONTENT_USER_OBJECT_KEY", new String(XmlUtil.saveXmlBytes((Element)root), "UTF-8"));
        }
        catch (Throwable cause) {
            throw new ExtReportingBizException("error ocurred during saving dirty manager", cause);
        }
    }
}

