/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.chart.chartpanelImpl.typechooser;

import com.kingdee.bos.ctrl.ext.ui.wizards.chart.chartpanelImpl.typechooser.SelectionButtonChangedListener;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.chartpanelImpl.typechooser.SelectionButtonDoubleClickListener;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class ChartTypeButton
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static ChartTypeButton selectedButton;
    private static SelectionButtonChangedListener listener;
    private static SelectionButtonDoubleClickListener doubleClickListener;
    private static Border focusBorder;
    private static Border unFocusBorder;
    private static Color cover;
    private BufferedImage img;
    private boolean isSelected = false;
    private JTextComponent area;
    private String toolTipText;
    private FlashChartType chartType;
    private boolean isMouseOn;

    public ChartTypeButton(JTextComponent area, FlashChartType chartType) {
        this.chartType = chartType;
        this.area = area;
        this.setFocusable(true);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(162, 133));
        this.setSize(new Dimension(162, 133));
        ToolTipManager.sharedInstance().registerComponent(this);
        this.initMouseListener();
        this.img = chartType.getImage();
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        return this.toolTipText;
    }

    private void initMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ChartTypeButton.this.doClick();
                if (e.getClickCount() == 2) {
                    ChartTypeButton.this.doDoubleClick();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ChartTypeButton button = ChartTypeButton.this;
                button.isMouseOn = true;
                button.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ChartTypeButton button = ChartTypeButton.this;
                button.isMouseOn = false;
                button.repaint();
            }
        });
    }

    public void doClick() {
        if (selectedButton != null && this.chartType == ChartTypeButton.selectedButton.chartType) {
            return;
        }
        if (selectedButton != null) {
            ChartTypeButton.selectedButton.isSelected = false;
            selectedButton.repaint();
        }
        selectedButton = this;
        this.isSelected = true;
        this.repaint();
        this.area.setText(this.chartType.getDescription());
        if (listener != null) {
            listener.selectionChanged(this.getChartType());
        }
    }

    public void doDoubleClick() {
        if (doubleClickListener != null) {
            doubleClickListener.doubleClick();
        }
    }

    @Override
    public void paintBorder(Graphics g) {
        if (this.isSelected) {
            focusBorder.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        } else {
            unFocusBorder.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
            if (this.isMouseOn) {
                Color old = g.getColor();
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(cover);
                g2.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
                g2.setColor(old);
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.img != null) {
            g.drawImage(this.img.getScaledInstance(this.getWidth() - 10, this.getHeight() - 10, 4), 5, 5, this.getWidth() - 10, this.getHeight() - 10, null);
        }
        if (this.isSelected) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setComposite(AlphaComposite.getInstance(3, 0.4f));
            Color color = new Color(0, 0, 255, 180);
            g2.setColor(color);
            g2.fill(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            g2.dispose();
        }
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public FlashChartType getChartType() {
        return this.chartType;
    }

    @Override
    public void setToolTipText(String toolTip) {
        this.toolTipText = toolTip;
    }

    public static ChartTypeButton currentSelection() {
        return selectedButton;
    }

    public static void clearSelection() {
        if (selectedButton != null) {
            ChartTypeButton.selectedButton.isSelected = false;
            selectedButton = null;
        }
    }

    public static void setSelectionButtonChangedListener(SelectionButtonChangedListener listener) {
        ChartTypeButton.listener = listener;
    }

    public static void setSelectionButtonDoubleClickListener(SelectionButtonDoubleClickListener listener) {
        doubleClickListener = listener;
    }

    static {
        focusBorder = BorderFactory.createLoweredBevelBorder();
        unFocusBorder = BorderFactory.createRaisedBevelBorder();
        cover = new Color(255, 239, 209);
    }
}

