/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.chart.extend.pattern;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.extend.CommonStyleEditor;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.extend.pattern.FormatEditor;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.extend.pattern.NumberFormatVFPair;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.extend.pattern.PatternNode;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import org.jdom2.Element;

public class NumberFormatTemplateEditor
extends CommonStyleEditor {
    private FormatEditor _editor;
    private NumberFormatVFPair _value;

    @Override
    protected void showEditor() {
        this._editor = new FormatEditor(this.getCustomEditor(), this._value);
    }

    @Override
    public Object getValue() {
        return this._value;
    }

    @Override
    public void setValue(Object value) {
        this._value = (NumberFormatVFPair)value;
        if (NumberFormatTemplateEditor.getCommonFormatXML().equals(this._value.getXmlValue())) {
            this.setText("\u7cfb\u7edf\u9ed8\u8ba4");
        } else {
            this.setText("\u7528\u6237\u81ea\u5b9a\u4e49");
        }
    }

    public static String getCommonFormatXML() {
        StringBuilder sb = new StringBuilder("<template>");
        sb.append("<percent value='false' />");
        sb.append("<forceDecimals type='Boolean' value='true' />");
        sb.append("<numberPrefix type='String' />");
        sb.append("<numberSuffix type='String' />");
        sb.append("<sNumberSuffix type='String' />");
        sb.append("<decimals type='Integer' value='2' />");
        sb.append("<decimalSeparator type='String' value='.' />");
        sb.append("<formatNumber type='Boolean' value='true' />");
        sb.append("<thousandSeparator type='String' value=',' />");
        sb.append("</template>");
        return sb.toString();
    }

    public static PatternNode parsePattern(String formatXml, String numberPrefix, String numberSuffix) {
        Element root = null;
        try {
            root = XmlUtil.loadXmlBytes((byte[])formatXml.getBytes("UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List contents = root.getContent();
        int decimals = 2;
        boolean forceDecimals = true;
        boolean formatNumber = true;
        boolean percentNumber = false;
        String prefix = "";
        String suffix = "";
        String rSuffix = "";
        Character decimalSeparator = Character.valueOf('.');
        Character thousandSeparator = Character.valueOf(',');
        for (int i = 0; i < contents.size(); ++i) {
            String v;
            Object next = contents.get(i);
            if (!(next instanceof Element)) continue;
            Element ele = (Element)next;
            if (ele.getName().equals("forceDecimals")) {
                forceDecimals = Boolean.parseBoolean(ele.getAttributeValue("value"));
                continue;
            }
            if (ele.getName().equals("numberPrefix")) {
                prefix = ele.getAttributeValue("value");
                if (!StringUtil.isEmptyString((String)prefix)) continue;
                if (!StringUtil.isEmptyString((String)numberPrefix)) {
                    prefix = numberPrefix;
                    continue;
                }
                prefix = "";
                continue;
            }
            if (ele.getName().equals("numberSuffix")) {
                suffix = ele.getAttributeValue("value");
                if (!StringUtil.isEmptyString((String)suffix)) continue;
                if (!StringUtil.isEmptyString((String)numberSuffix)) {
                    suffix = numberSuffix;
                    continue;
                }
                suffix = "";
                continue;
            }
            if (ele.getName().equals("sNumberSuffix")) {
                rSuffix = ele.getAttributeValue("value");
                if (!StringUtil.isEmptyString((String)rSuffix)) continue;
                if (!StringUtil.isEmptyString((String)numberSuffix)) {
                    rSuffix = numberSuffix;
                    continue;
                }
                rSuffix = "";
                continue;
            }
            if (ele.getName().equals("decimals")) {
                decimals = Integer.parseInt(ele.getAttributeValue("value"));
                continue;
            }
            if (ele.getName().equals("decimalSeparator")) {
                v = ele.getAttributeValue("value");
                if (StringUtil.isEmptyString((String)v)) continue;
                decimalSeparator = Character.valueOf(v.charAt(0));
                continue;
            }
            if (ele.getName().equals("formatNumber")) {
                formatNumber = Boolean.parseBoolean(ele.getAttributeValue("value"));
                continue;
            }
            if (ele.getName().equals("thousandSeparator")) {
                v = ele.getAttributeValue("value");
                if (!StringUtil.isEmptyString((String)v)) {
                    thousandSeparator = Character.valueOf(v.charAt(0));
                    continue;
                }
                thousandSeparator = null;
                continue;
            }
            if (!ele.getName().equals("percent") || !"true".equals(v = ele.getAttributeValue("value"))) continue;
            percentNumber = true;
        }
        PatternNode node = new PatternNode();
        node.setDecimals(decimals);
        node.setDecimalSeparator(decimalSeparator.charValue());
        node.setPercentNumber(percentNumber);
        if (percentNumber) {
            suffix = suffix.replace("%", "");
        }
        node.setPrefix(prefix);
        node.setSuffix(suffix);
        node.setrSuffix(rSuffix);
        node.setForceDecimals(forceDecimals);
        node.setFormatNumber(formatNumber);
        node.setThousandSeparator(thousandSeparator);
        return node;
    }

    public static String applayPattern(String valueString, String formatXml) {
        return NumberFormatTemplateEditor.applayPattern(valueString, formatXml, null, null);
    }

    public static String applayPattern(String valueString, String formatXml, String numberPrefix, String numberSuffix) {
        Number value = new BigDecimal(valueString);
        PatternNode node = NumberFormatTemplateEditor.parsePattern(formatXml, numberPrefix, numberSuffix);
        DecimalFormat format = new DecimalFormat();
        if (node.isPercentNumber()) {
            value = ((Number)value).doubleValue() * 100.0;
        } else {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator(node.getDecimalSeparator());
            symbols.setGroupingSeparator(node.getThousandSeparator());
            format.setDecimalFormatSymbols(symbols);
            format.setGroupingUsed(node.isFormatNumber());
        }
        format.setMaximumFractionDigits(node.getDecimals());
        if (node.isForceDecimals()) {
            format.setMinimumFractionDigits(node.getDecimals());
        }
        return node.getPrefix() + format.format(value) + node.getSuffix();
    }
}

