/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.chart.install;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.install.ZipFile;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.workbench.splash.NotifyObject;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Enumeration;
import java.util.Locale;
import java.util.zip.ZipEntry;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

public class FlashEnvDownloader {
    private static Logger logger = CommonLogger.getLogger(FlashEnvDownloader.class);
    private static String UPDATE_SERVER = System.getProperty("UPDATE_SERVER");
    private static boolean DEBUG_MODE = false;
    private static String currentFileVersion;
    private static String currentZipVersion;
    private static String dllFileName;

    public static void fetchWebkitPackage() {
        if (UPDATE_SERVER == null) {
            return;
        }
        try {
            if (FlashEnvDownloader.checkVersion()) {
                FlashEnvDownloader.download();
            }
        }
        catch (HttpException e) {
            logger.error((Object)"network failed", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"file access failed", (Throwable)e);
        }
        catch (Throwable e) {
            logger.error((Object)"unkown system error", e);
        }
    }

    private static boolean checkVersion() throws HttpException, IOException {
        String remoteZipVersion = "";
        HttpClient client = new HttpClient();
        String easWebClient = "easWebClient";
        if (UPDATE_SERVER.endsWith("/")) {
            easWebClient = easWebClient + "/";
        }
        GetMethod get = new GetMethod(UPDATE_SERVER.replace(easWebClient, "mobile/lightapp/extRpt/resources?remoteMethod=extLightWebkitVersion&ctxIgnore=1"));
        client.executeMethod((HttpMethod)get);
        JSONObject jsonObj = JSON.parseObject((String)new String(get.getResponseBody()));
        if (jsonObj.containsKey((Object)"errorCode")) {
            logger.error(jsonObj.get((Object)"errorMessage"));
            return false;
        }
        remoteZipVersion = (String)jsonObj.get((Object)"data");
        currentFileVersion = FlashEnvDownloader.getCurrentFileVersion();
        currentZipVersion = FlashEnvDownloader.getCurrentZipVersion();
        return !remoteZipVersion.equals(currentFileVersion) && !remoteZipVersion.equals(currentZipVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentFileVersion() {
        if (!StringUtil.isEmptyString((String)currentFileVersion)) {
            return currentFileVersion;
        }
        File f = new File(ZipFile.EAS_HOME + "/client/deploy/client/webkit" + "/MANIFEST.MF");
        if (f.exists()) {
            FileInputStream fileIn = null;
            byte[] buffer = new byte[1024];
            try {
                fileIn = new FileInputStream(f);
                int len = fileIn.read(buffer);
                currentFileVersion = new String(buffer, 0, len);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)e);
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            finally {
                try {
                    if (fileIn != null) {
                        fileIn.close();
                    }
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
        }
        return currentFileVersion;
    }

    public static String getCurrentZipVersion() {
        if (!StringUtil.isEmptyString((String)currentZipVersion)) {
            return currentZipVersion;
        }
        FlashEnvDownloader.handleZipFile();
        return currentZipVersion;
    }

    public static String getDllFileName() {
        if (!StringUtil.isEmptyString((String)dllFileName)) {
            return dllFileName;
        }
        FlashEnvDownloader.handleZipFile();
        return dllFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleZipFile() {
        File f = new File(ZipFile.EAS_HOME + "/client/deploy/client/webkit-7534.57.2.4.win32.zip");
        if (f.exists()) {
            InputStream in = null;
            java.util.zip.ZipFile zipFile = null;
            StringBuilder builder = new StringBuilder();
            try {
                zipFile = new java.util.zip.ZipFile(f);
                in = zipFile.getInputStream(zipFile.getEntry("MANIFEST.MF"));
                byte[] buffer = new byte[1024];
                int len = -1;
                while ((len = in.read(buffer)) != -1) {
                    builder.append(new String(buffer, 0, len));
                }
                currentZipVersion = builder.toString();
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry zipEntry = entries.nextElement();
                    String entryFilePath = zipEntry.getName();
                    int occurence = entryFilePath.lastIndexOf(47);
                    if (occurence != -1 || !entryFilePath.toLowerCase(Locale.ENGLISH).endsWith(".dll")) continue;
                    dllFileName = File.separator + entryFilePath;
                    break;
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
                try {
                    if (null != zipFile) {
                        zipFile.close();
                    }
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void download() throws HttpException, IOException {
        DownloaderWatcher watcher = new DownloaderWatcher();
        HttpClient client = new HttpClient();
        String easWebClient = "easWebClient";
        if (UPDATE_SERVER.endsWith("/")) {
            easWebClient = easWebClient + "/";
        }
        GetMethod get = new GetMethod(UPDATE_SERVER.replace(easWebClient, "mobile/lightapp/extRpt/resources?remoteMethod=extLightWebkitPackage"));
        client.executeMethod((HttpMethod)get);
        watcher.contentLen = get.getResponseContentLength();
        watcher.start();
        InputStream in = null;
        FileOutputStream out = null;
        try {
            in = get.getResponseBodyAsStream();
            out = new FileOutputStream(ZipFile.EAS_HOME + "/client/deploy/client/webkit-7534.57.2.4.win32.zip");
            byte[] buffer = new byte[1024];
            int len = in.read(buffer);
            watcher.readSize += (long)len;
            while (len > 0) {
                out.write(buffer, 0, len);
                len = in.read(buffer);
                watcher.readSize += (long)len;
            }
            out.flush();
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{out, in});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{out, in});
        }
        CloseUtil.close((Closeable[])new Closeable[]{out, in});
    }

    public static void main(String[] args) {
        DEBUG_MODE = true;
        UPDATE_SERVER = "http://localhost:6888/easWebClient/";
        FlashEnvDownloader.fetchWebkitPackage();
    }

    private static class DownloaderWatcher
    extends Thread {
        long startTime = System.currentTimeMillis();
        long contentLen;
        long readSize = 1L;

        private DownloaderWatcher() {
        }

        @Override
        public void run() {
            NotifyObject no = null;
            if (!DEBUG_MODE) {
                no = NotifyObject.getCurrentInstance();
                no.notice(30, "\u4e0b\u8f7d\u6d4f\u89c8\u5668\u7ec4\u4ef6");
            } else {
                System.out.println("\u4e0b\u8f7dFlash\u8fd0\u884c\u65f6");
            }
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                double time = (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
                double speed = (double)this.readSize / 1024.0 / time;
                String unit = "kb/s";
                if (speed > 1024.0) {
                    speed /= 1024.0;
                    unit = "mb/s";
                }
                BigDecimal bd = new BigDecimal(speed);
                bd = bd.round(new MathContext(3, RoundingMode.DOWN));
                if (!DEBUG_MODE && null != no) {
                    no.notice(30, "\u4e0b\u8f7d\u6d4f\u89c8\u5668\u7ec4\u4ef6" + bd + unit);
                    continue;
                }
                System.out.println("\u4e0b\u8f7dFlash\u8fd0\u884c\u65f6\uff1a" + bd + unit);
            } while (this.readSize < this.contentLen);
            if (!DEBUG_MODE && null != no) {
                no.notice(30, "\u5b89\u88c5\u6d4f\u89c8\u5668\u7ec4\u4ef6");
            } else {
                System.out.println("\u4e0b\u8f7d\u5b8c\u6210");
            }
        }
    }
}

