/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.formula.assembled;

import com.kingdee.bos.ctrl.common.GlobalLocator;
import com.kingdee.bos.ctrl.common.ui.formulawizard.AbstractExtCtrl;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.FormulaWizardMisc;
import com.kingdee.bos.ctrl.swing.KDComboColor;
import com.kingdee.bos.ctrl.swing.event.ComboColorSelectedEvent;
import com.kingdee.bos.ctrl.swing.event.ComboColorSelectedListener;
import com.kingdee.bos.ctrl.swing.event.ComboColorViewPicClickEvent;
import com.kingdee.bos.ctrl.swing.event.ComboColorViewPicClickListener;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class ComboColorExtCtrl
extends AbstractExtCtrl {
    private KDComboColor comboColor = new KDComboColor(2, true);

    public ComboColorExtCtrl() {
        this.comboColor.addViewPicClickListener(new ComboColorViewPicClickListener(){

            public void clicked(ComboColorViewPicClickEvent evt) {
                ComboColorExtCtrl.this.fireFinishEdit();
            }
        });
        this.comboColor.addSelectedListener(new ComboColorSelectedListener(){

            public void selected(ComboColorSelectedEvent evt) {
                ComboColorExtCtrl.this.fireFinishEdit();
            }
        });
        this.comboColor.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.comboColor.setToolTipText(FormulaWizardMisc.getLocalText("colorChoose", "\u9009\u62e9\u989c\u8272"));
        this.addUsedColorPersistence(this.comboColor);
    }

    public JComponent getCtrl() {
        return this.comboColor;
    }

    public String getExtResult() {
        Color c = this.comboColor.getColor();
        StringBuffer sb = new StringBuffer();
        sb.append("RGB(");
        sb.append(c.getRed());
        sb.append(",");
        sb.append(c.getGreen());
        sb.append(",");
        sb.append(c.getBlue());
        sb.append(")");
        return sb.toString();
    }

    public void setProcessString(String str) {
    }

    protected void addUsedColorPersistence(KDComboColor cbc) {
        cbc.addUsedColorPersistence(new KDComboColor.IUsedColorPersistence(){

            public void save(LinkedList<Color> usedColorList) {
                Document doc = new Document();
                Element root = new Element("UsedColors");
                doc.setRootElement(root);
                Element UsedColor = new Element("UsedColor");
                StringBuffer colorsStr = new StringBuffer();
                for (Color color : usedColorList) {
                    colorsStr.append(color.getRGB() + ",");
                }
                UsedColor.addContent(colorsStr.toString());
                root.addContent((Content)UsedColor);
                String filePth = GlobalLocator.getInstance().getHomeDir() + "\\UsedColor.xml";
                try {
                    XmlUtil.saveXmlFile((String)filePth, (Element)root);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            public LinkedList<Color> load() {
                String filePth = GlobalLocator.getInstance().getHomeDir() + File.separator + "UsedColor.xml";
                LinkedList<Color> usedColorList = new LinkedList<Color>();
                File f = new File(filePth);
                if (f.exists() && f.isFile()) {
                    try {
                        Element root = XmlUtil.loadXmlFile((String)filePth);
                        if (root.getChild("UsedColor") != null && root.getChild("UsedColor").getText() != "") {
                            String colorStr = root.getChild("UsedColor").getText();
                            String[] color = colorStr.split(",");
                            for (int i = 0; i < color.length; ++i) {
                                if (!StringUtil.isNumber((String)color[i])) continue;
                                Color c = new Color(Integer.parseInt(color[i]));
                                usedColorList.add(c);
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (JDOMException e) {
                        e.printStackTrace();
                    }
                }
                return usedColorList;
            }
        });
    }
}

