/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.formulawizard.Formula;
import com.kingdee.bos.ctrl.common.ui.formulawizard.FormulaWizardFactory;
import com.kingdee.bos.ctrl.common.ui.formulawizard.Group;
import com.kingdee.bos.ctrl.common.ui.formulawizard.GroupEvent;
import com.kingdee.bos.ctrl.common.ui.formulawizard.GroupListener;
import com.kingdee.bos.ctrl.common.ui.formulawizard.IExtCtrl;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.DrawersCtrl;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.SyntaxErrorPrompt;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.bizmodel.ParamsModelSet;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.editor.FuncCollapsableEditor;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.expr.ExprStringMapping;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.expr.IFuncUnit;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.navigator.Navigator;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.model.expr.Expr;
import com.kingdee.bos.ctrl.kds.model.expr.ExprContext;
import com.kingdee.bos.ctrl.kds.model.expr.Parser;
import com.kingdee.bos.ctrl.kds.model.struct.Dependents;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.jfree.util.Log;

abstract class AbstractFunctionWizard {
    private static final Icon LIGHT_RED = ResourceManager.getImageIcon("statusbad.gif");
    private static final Icon LIGHT_GREEN = ResourceManager.getImageIcon("statusgood.gif");
    private KDPanel _panOwner;
    private KDSplitPane _sppFull;
    private KDSplitPane _sppUp;
    private KDSplitPane _sppDown;
    private DrawersCtrl _drawers;
    private Group _dsSupplyGroup;
    private KDPanel _panEditorTitle;
    private FuncCollapsableEditor _editor;
    private KDPanel _panEditorStatus;
    private KDLabel _labStatus;
    private KDLabel _labSyntaxErrorPrompt;
    private JTextPane _txtExample;
    private KDLabel _labExampleFuncName;
    private Navigator _navigator;
    private HashMap _cacheExample = new HashMap();
    private ExtCtrlListener _extCtrlListener;
    private Map _customProperties;
    private String _dsSupplyTitle = "\u6570\u636e\u96c6";

    public AbstractFunctionWizard() {
        this.init();
    }

    private void init() {
        this._drawers = new DrawersCtrl();
        KDPanel panEditor = this.initEditorPanel();
        KDPanel panExample = this.initExamplePanel();
        this.initNavigator();
        this._sppUp = new KDSplitPane(1);
        this._sppUp.setDividerLocation(200);
        this._sppUp.setResizeWeight(0.2);
        this._sppUp.setRightComponent((Component)panEditor);
        this._sppDown = new KDSplitPane(1);
        this._sppDown.setResizeWeight(0.7);
        this._sppDown.setLeftComponent((Component)panExample);
        this._sppDown.setRightComponent((Component)this._navigator.getCtrl());
        this._sppFull = new KDSplitPane(0);
        this._sppFull.setResizeWeight(0.75);
        this._sppFull.setTopComponent((Component)this._sppUp);
        this._sppFull.setBottomComponent((Component)this._sppDown);
        this._panOwner = new KDPanel((LayoutManager)new BorderLayout());
        this._panOwner.add((Component)this._sppFull, (Object)"Center");
    }

    private void initDrawer(InputStream config, boolean isWithDsSupply) {
        if (isWithDsSupply) {
            this.initDsSupply();
        }
        GroupHandler drawerHandler = new GroupHandler();
        FormulaWizardFactory factory = new FormulaWizardFactory((FormulaWizardFactory.IXmlParseListener)ParamsModelSet.getExtInstance());
        Group[] groups = factory.createGroupsByStream(config);
        if ((groups = this.cutDownSupplyFunction(groups)) != null) {
            for (int i = 0; i < groups.length; ++i) {
                groups[i].expandRoot();
                groups[i].addGroupListener((GroupListener)drawerHandler);
                this._drawers.addDrawer((KDTreeView)groups[i]);
                this.cacheExample(groups[i]);
            }
        }
        this._sppUp.setLeftComponent((Component)this._drawers.createPanel());
    }

    private void initDsSupply() {
        this._dsSupplyGroup = new Group();
        this._dsSupplyGroup.setTitle(this._dsSupplyTitle);
        this._dsSupplyGroup.addGroupListener((GroupListener)new GroupHandler(){

            @Override
            public void selection(GroupEvent e) {
            }
        });
        this._drawers.addDrawer((KDTreeView)this._dsSupplyGroup);
    }

    public void setDsSupplyTitle(String dsSupplyTitle) {
        this._dsSupplyTitle = dsSupplyTitle;
    }

    public void setConfig(InputStream config, boolean isWithDsSupply) {
        this.initDrawer(config, isWithDsSupply);
    }

    protected Group[] cutDownSupplyFunction(Group[] groups) {
        return groups;
    }

    private void cacheExample(Group group) {
        Enumeration allNodes = group.getRoot().breadthFirstEnumeration();
        while (allNodes.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)allNodes.nextElement();
            if (!(node.getUserObject() instanceof Formula)) continue;
            this._cacheExample.put(node.getText().toUpperCase(), node.getUserObject());
        }
    }

    private KDPanel initEditorPanel() {
        this._editor = new FuncCollapsableEditor();
        KDScrollPane scp = new KDScrollPane((Component)((Object)this._editor));
        scp.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this._editor.setFont(this._editor.getFont().deriveFont(14.0f));
        this._editor.setParamWrapAsker(ParamsModelSet.getExtInstance());
        this._editor.setSyntaxStatusListener(new FuncCollapsableEditor.ISyntaxStatusListener(){

            @Override
            public void syntaxChecked(boolean isError, int textPos, SyntaxErrorException syntaxError) {
                AbstractFunctionWizard.this.syncSyntaxStatus(isError, textPos, syntaxError);
            }
        });
        this._panEditorTitle = new KDPanel();
        KDLabel labTitle = new KDLabel("\u5185\u5bb9\uff1a");
        labTitle.setToolTipText(null);
        this.addCustomCtrl((JComponent)labTitle);
        this.addCustomCtrl((JComponent)new KDWorkButton((Action)new MaxDialogAction()));
        this.addCustomCtrl((JComponent)new KDWorkButton((Action)new ContentLayoutAction()));
        this._labSyntaxErrorPrompt = new KDLabel();
        this._labSyntaxErrorPrompt.addMouseListener((MouseListener)new SyntaxErrorLocator());
        this._labStatus = new KDLabel("\u8bed\u6cd5\u72b6\u6001 -");
        this._labStatus.setHorizontalTextPosition(2);
        this.syncSyntaxStatus(true, 0, null);
        TableLayout2 lyStatus = new TableLayout2(1, 3);
        lyStatus.setFixedWidth(0, 10);
        lyStatus.setFixedWidth(1, 100);
        lyStatus.setRatableWidth(2, 100);
        this._panEditorStatus = new KDPanel((LayoutManager)lyStatus);
        this._panEditorStatus.add((Component)this._labStatus, (Object)TableLayout2.param((int)0, (int)1));
        this._panEditorStatus.add((Component)this._labSyntaxErrorPrompt, (Object)TableLayout2.param((int)0, (int)2));
        this._panEditorStatus.setBorder(BorderFactory.createEtchedBorder());
        TableLayout2 ly = new TableLayout2(3, 1);
        ly.setFixedHeight(0, 21);
        ly.setRowSpacing(0, 3);
        ly.setRatableHeight(1, 100);
        ly.setRowSpacing(1, 1);
        ly.setFixedHeight(2, 23);
        KDPanel pan = new KDPanel((LayoutManager)ly);
        pan.add((Component)this._panEditorTitle, (Object)TableLayout2.param((int)0, (int)0));
        pan.add((Component)scp, (Object)TableLayout2.param((int)1, (int)0));
        pan.add((Component)this._panEditorStatus, (Object)TableLayout2.param((int)2, (int)0));
        return pan;
    }

    private KDPanel initExamplePanel() {
        this._txtExample = new JTextPane();
        this._txtExample.setEditable(false);
        KDScrollPane scp = new KDScrollPane((Component)this._txtExample);
        scp.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        KDLabel labTitle = new KDLabel("\u51fd\u6570\u8bf4\u660e\uff1a");
        labTitle.setToolTipText(null);
        this._labExampleFuncName = new KDLabel();
        TableLayout2 ly = new TableLayout2(2, 2);
        ly.setFixedWidth(0, 80);
        ly.setRatableWidth(1, 100);
        ly.setFixedHeight(0, 20);
        ly.setRatableHeight(1, 100);
        KDPanel pan = new KDPanel((LayoutManager)ly);
        pan.add((Component)labTitle, (Object)TableLayout2.param((int)0, (int)0));
        pan.add((Component)this._labExampleFuncName, (Object)TableLayout2.param((int)0, (int)1));
        pan.add((Component)scp, (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)1));
        return pan;
    }

    private void initNavigator() {
        this._navigator = new Navigator(new NavigatorHandler());
        this._editor.setNavigatorListener(this._navigator);
    }

    public void addCustomCtrl(IExtCtrl extCtrl) {
        if (this._extCtrlListener == null) {
            this._extCtrlListener = new ExtCtrlListener();
        }
        extCtrl.addEditListener((IExtCtrl.EditListener)this._extCtrlListener);
        this.addCustomCtrl(extCtrl.getCtrl());
    }

    private void addCustomCtrl(JComponent ctrl) {
        int i;
        int c = this._panEditorTitle.getComponentCount();
        TableLayout2 ly = new TableLayout2(1, c + 1);
        ly.setRatableWidth(0, 100);
        for (i = 1; i < c + 1; ++i) {
            ly.setColSpacing(i - 1, 3);
            JComponent tempCtrl = i == c ? ctrl : this._panEditorTitle.getComponent(i);
            int w = ((Component)tempCtrl).getPreferredSize().width;
            ly.setFixedWidth(i, w == 0 ? 40 : w);
        }
        this._panEditorTitle.setLayout((LayoutManager)ly);
        for (i = 0; i < c + 1; ++i) {
            JComponent ctrlToAdd = i == c ? ctrl : this._panEditorTitle.getComponent(0);
            this._panEditorTitle.add((Component)ctrlToAdd, (Object)TableLayout2.param((int)0, (int)i));
        }
        this._panEditorTitle.add((Component)ctrl, (Object)TableLayout2.param((int)0, (int)c));
    }

    private void syncSyntaxStatus(boolean isError, int textPos, SyntaxErrorException syntaxError) {
        this._labStatus.setEnabled(true);
        if (isError) {
            this._labStatus.setIcon(LIGHT_RED);
            this._labStatus.setToolTipText("\u5b58\u5728\u8bed\u6cd5\u9519\u8bef");
            if (textPos <= 0) {
                this.clearPrompt();
            } else {
                String prompt = null;
                if (syntaxError != null) {
                    prompt = SyntaxErrorPrompt.getPrompt(syntaxError);
                }
                this._labSyntaxErrorPrompt.setText(prompt);
                this._labSyntaxErrorPrompt.setCursor(Cursor.getPredefinedCursor(12));
                this._labSyntaxErrorPrompt.setUserObject((Object)new Integer(textPos));
            }
        } else {
            this._labStatus.setIcon(LIGHT_GREEN);
            this._labStatus.setToolTipText("\u8bed\u6cd5\u6b63\u786e");
            this.clearPrompt();
        }
    }

    private void clearPrompt() {
        this._labSyntaxErrorPrompt.setText(null);
        this._labSyntaxErrorPrompt.setCursor(Cursor.getDefaultCursor());
        this._labSyntaxErrorPrompt.setUserObject(null);
    }

    public JComponent getCtrl() {
        return this._panOwner;
    }

    public FuncCollapsableEditor getEditor() {
        return this._editor;
    }

    public void setEditingData(String text) {
        this._editor.setRealText(text);
    }

    public String getEditingData() {
        return this._editor.getRealText();
    }

    public Group getDsSupplyGroup() {
        return this._dsSupplyGroup;
    }

    private void updateExample(String funcName, Formula formula) {
        if (StringUtil.isEmptyString((String)funcName)) {
            return;
        }
        String str = formula == null ? funcName + "\u4e0d\u53ef\u8bc6\u522b" : formula.getExample();
        this._txtExample.setText(str);
        this._txtExample.setCaretPosition(0);
        this._labExampleFuncName.setText(funcName);
    }

    private Map getCustomProperties() {
        if (this._customProperties == null) {
            this._customProperties = new HashMap();
        }
        return this._customProperties;
    }

    public void putCustomProperty(Object key, Object value) {
        this.getCustomProperties().put(key, value);
    }

    public Object getCustomProperty(Object key) {
        return this.getCustomProperties().get(key);
    }

    public static abstract class AbstractExprCreator
    implements ExprStringMapping.IExprCreator {
        private SyntaxErrorException _ex;
        private int _errorPos;

        protected abstract Sheet getSheet();

        @Override
        public ExprContext getExprContext() {
            return this.getSheet().getDeps().getExprContext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Expr toExpr(String strFormula) {
            this._ex = null;
            this._errorPos = 0;
            Sheet.ParserHelper formulaOwner = this.getSheet().getParserHelper();
            Dependents deps = this.getSheet().getDeps();
            Parser psr = deps.getParser();
            try {
                Object result = psr.parse(formulaOwner, strFormula);
                if (result instanceof Variant && ((Variant)result).isError()) {
                    Exception ex = (Exception)((Variant)result).getValue();
                    if (ex instanceof SyntaxErrorException) {
                        this._ex = (SyntaxErrorException)ex;
                    }
                    this._errorPos = psr.getTokenPos();
                }
                Expr expr = psr.getExpr();
                return expr;
            }
            finally {
                deps.recycleParser(psr);
            }
        }

        @Override
        public SyntaxErrorException getSyntaxError() {
            return this._ex;
        }

        @Override
        public int getSyntaxErrorPos() {
            return this._errorPos;
        }
    }

    private class ExtCtrlListener
    implements IExtCtrl.EditListener {
        private ExtCtrlListener() {
        }

        public void startEdit(IExtCtrl.EditEvent evt) {
            IExtCtrl ext = (IExtCtrl)evt.getSource();
            if (ext.getProcessPolicy() == 16) {
                ext.setProcessString(AbstractFunctionWizard.this.getEditingData());
            } else if (ext.getProcessPolicy() == 32) {
                AbstractFunctionWizard.this.getEditor().requestFocus();
                ext.setProcessString(AbstractFunctionWizard.this.getEditor().getSelectedRealText());
            } else if (ext.getProcessPolicy() == 48) {
                IFuncUnit func;
                AbstractFunctionWizard.this.getEditor().requestFocus();
                String selectedText = AbstractFunctionWizard.this.getEditor().getSelectedRealText();
                if (StringUtil.isEmptyString((String)selectedText) && (func = AbstractFunctionWizard.this._navigator.getCurrentFunc()) != null && ext.isFuncUnitSupported(func.getFuncName())) {
                    int startPos = func.getStartAtText();
                    int endPos = startPos + func.getAllLength();
                    AbstractFunctionWizard.this.getEditor().setCaretPosition(endPos);
                    AbstractFunctionWizard.this.getEditor().moveCaretPosition(startPos);
                    selectedText = AbstractFunctionWizard.this.getEditor().getSelectedRealText();
                }
                ext.setProcessString(selectedText);
            }
        }

        public void finishEdit(IExtCtrl.EditEvent evt) {
            String rv;
            IExtCtrl ext = (IExtCtrl)evt.getSource();
            if (ext.getExtResultPolicy() == 1) {
                AbstractFunctionWizard.this.setEditingData(ext.getExtResult());
            } else if (ext.getExtResultPolicy() == 2 && (rv = ext.getExtResult()) != null) {
                AbstractFunctionWizard.this.getEditor().replaceSelection(rv);
            }
        }
    }

    private class NavigatorHandler
    implements Navigator.IEditorDependency {
        private NavigatorHandler() {
        }

        @Override
        public void caretGoto(int pos) {
            AbstractFunctionWizard.this._editor.requestFocus();
            AbstractFunctionWizard.this._editor.setCaretPosition(pos);
        }

        @Override
        public void caretSelect(int fromPos, int toPos) {
            AbstractFunctionWizard.this._editor.requestFocus();
            AbstractFunctionWizard.this._editor.setCaretPosition(toPos);
            AbstractFunctionWizard.this._editor.moveCaretPosition(fromPos);
        }

        @Override
        public int[][] getValidParamsPos(IFuncUnit func) {
            int p2;
            int p1 = func.getLpPos() + 1;
            int[] cs = func.getCommasPos();
            int[][] result = new int[cs.length + 1][2];
            for (int idx = 0; idx < cs.length; ++idx) {
                p2 = cs[idx];
                result[idx] = this.trim(p1, p2);
                p1 = p2 + 1;
            }
            p2 = func.getRpPos();
            result[idx] = this.trim(p1, p2);
            return result;
        }

        private int[] trim(int fromPos, int toPos) {
            try {
                int x = AbstractFunctionWizard.this._editor.getEmptyCharCountForward(fromPos);
                int newFromPos = fromPos + x;
                if (newFromPos >= toPos) {
                    return new int[]{fromPos, toPos};
                }
                return new int[]{newFromPos, toPos - AbstractFunctionWizard.this._editor.getEmptyCharCountBackward(toPos)};
            }
            catch (BadLocationException ex) {
                Log.error((Object)"", (Exception)ex);
                return new int[]{fromPos, toPos};
            }
        }

        @Override
        public void updateWizardExample(String funcName) {
            Formula formula = (Formula)AbstractFunctionWizard.this._cacheExample.get(funcName);
            AbstractFunctionWizard.this.updateExample(funcName, formula);
        }
    }

    private class GroupHandler
    implements GroupListener {
        private GroupHandler() {
        }

        public void doubleClicked(GroupEvent e) {
            Formula formula = e.getFormula();
            String str = null;
            if (formula != null) {
                str = formula.getData();
            }
            if (StringUtil.isEmptyString(str)) {
                return;
            }
            AbstractFunctionWizard.this._editor.replaceSelection(str);
            if (null != formula && formula.isMethodWithParam()) {
                int left = str.indexOf("(\"");
                if (left >= 0) {
                    int minus = str.length() - left - 2;
                    AbstractFunctionWizard.this._editor.setCaretPosition(AbstractFunctionWizard.this._editor.getCaretPosition() - minus);
                } else {
                    left = str.indexOf("(");
                    if (left >= 0) {
                        int minus = str.length() - left - 1;
                        AbstractFunctionWizard.this._editor.setCaretPosition(AbstractFunctionWizard.this._editor.getCaretPosition() - minus);
                    }
                }
            }
            AbstractFunctionWizard.this._editor.grabFocus();
        }

        public void selection(GroupEvent e) {
            Formula formula = e.getFormula();
            if (formula != null) {
                AbstractFunctionWizard.this.updateExample(e.getText(), formula);
            }
        }
    }

    private static class MaxDialogAction
    extends AbstractAction {
        private boolean _isFullScreen;
        private int _x;
        private int _y;
        private int _w;
        private int _h;

        public MaxDialogAction() {
            this.putValue("Name", "\u7a97\u53e3\u6700\u5927\u5316");
            this.putValue("ShortDescription", "\u4f7f\u7a97\u53e3\u5168\u5c4f/\u8fd8\u539f");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractButton btn = (AbstractButton)e.getSource();
            btn.setText(this._isFullScreen ? "\u7a97\u53e3\u6700\u5927\u5316" : "\u7a97\u53e3\u8fd8\u539f");
            Window win = SwingUtilities.getWindowAncestor(btn);
            if (win instanceof KDDialog) {
                KDDialog dlg = (KDDialog)win;
                if (this._isFullScreen) {
                    dlg.setLocation(this._x, this._y);
                    dlg.setSize(this._w, this._h);
                    dlg.validate();
                    dlg.repaint();
                } else {
                    this._x = dlg.getX();
                    this._y = dlg.getY();
                    this._w = dlg.getWidth();
                    this._h = dlg.getHeight();
                    WindowUtil.makeDialogFullScreen((KDDialog)dlg);
                }
            }
            this._isFullScreen = !this._isFullScreen;
        }
    }

    private class ContentLayoutAction
    extends AbstractAction {
        public ContentLayoutAction() {
            this.putValue("Name", "\u6392\u7248");
            this.putValue("ShortDescription", "\u5185\u5bb9\u91cd\u65b0\u6392\u7248");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractFunctionWizard.this._editor.layoutWithTab();
        }
    }

    private class SyntaxErrorLocator
    extends MouseAdapter {
        private SyntaxErrorLocator() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Integer posValue = (Integer)AbstractFunctionWizard.this._labSyntaxErrorPrompt.getUserObject();
            if (posValue != null) {
                AbstractFunctionWizard.this._editor.requestFocus();
                int editorPos = AbstractFunctionWizard.this._editor.changeTextPos2EditorPos(posValue);
                AbstractFunctionWizard.this._editor.setCaretPosition(editorPos);
            }
            this.disableLocator();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (AbstractFunctionWizard.this._labSyntaxErrorPrompt.getText() == null) {
                return;
            }
            Integer posValue = (Integer)AbstractFunctionWizard.this._labSyntaxErrorPrompt.getUserObject();
            if (posValue != null) {
                boolean located = true;
                if (AbstractFunctionWizard.this._editor.isTextPosInsideCollapsed(posValue)) {
                    located = false;
                } else {
                    int editorPos = AbstractFunctionWizard.this._editor.changeTextPos2EditorPos(posValue);
                    if (AbstractFunctionWizard.this._editor.getCaretPosition() != editorPos) {
                        located = false;
                    }
                }
                if (!located) {
                    this.enableLocator();
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.disableLocator();
        }

        private void enableLocator() {
            AbstractFunctionWizard.this._labSyntaxErrorPrompt.setForeground(Color.BLUE);
            AbstractFunctionWizard.this._labSyntaxErrorPrompt.setToolTipText("\u5149\u6807\u5b9a\u4f4d\u5230\u51fa\u9519\u4f4d\u7f6e");
        }

        private void disableLocator() {
            AbstractFunctionWizard.this._labSyntaxErrorPrompt.setForeground(Color.BLACK);
            AbstractFunctionWizard.this._labSyntaxErrorPrompt.setToolTipText("\u5df2\u5b9a\u4f4d");
        }
    }
}

