/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior;

import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.plaf.lfm.KDFontUIResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.swing.CellRendererPane;

class DrawersCtrl {
    private static final int TITLE_HEIGHT = 22;
    private ArrayList _drawers = new ArrayList();
    private TableLayout _layout;
    private int _currentIdx;
    private PropertyChangeSupport _propertyChangeSupport = new PropertyChangeSupport(this);

    public void addDrawer(KDTreeView drawer) {
        this._drawers.add(drawer);
    }

    private KDTreeView getCurrentDrawer() {
        return (KDTreeView)this._drawers.get(this._currentIdx);
    }

    public KDPanel createPanel() {
        int count = this._drawers.size();
        this._layout = TableLayout.splitRow((int)(count * 2));
        KDPanel pan = new KDPanel((LayoutManager)this._layout);
        ButtonHandler buttonHandler = new ButtonHandler(pan);
        for (int i = 0; i < count; ++i) {
            this._layout.rowStyle(i * 2).setHeight(22);
            this._layout.rowStyle(i * 2 + 1).setMargin(0, 0, 0, 1);
            KDTreeView drawer = (KDTreeView)this._drawers.get(i);
            Button btn = new Button(drawer.getTitle());
            btn.setUserObject(new Integer(i));
            btn.addActionListener(buttonHandler);
            btn.setMinimumSize(new Dimension(0, 0));
            drawer.setMinimumSize(new Dimension(0, 0));
            pan.add((Component)((Object)btn), (Object)this._layout.cell(i * 2));
            pan.add((Component)drawer, (Object)this._layout.cell(i * 2 + 1));
        }
        this._currentIdx = count - 1 < 0 ? 0 : count - 1;
        this.showDrawer(pan);
        return pan;
    }

    private void showDrawer(KDPanel pan) {
        for (int i = 0; i < pan.getComponentCount(); i += 2) {
            if (i / 2 == this._currentIdx) {
                this._layout.rowStyle(i).setHeight(0);
                this._layout.rowStyle(i + 1).setPriY(1);
                continue;
            }
            this._layout.rowStyle(i).setHeight(22);
            this._layout.rowStyle(i + 1).setPriY(0);
            this._layout.rowStyle(i + 1).setHeight(0);
        }
        pan.revalidate();
    }

    public void addDrawerChangedListener(PropertyChangeListener l) {
        this._propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removeDrawerChangedListener(PropertyChangeListener l) {
        this._propertyChangeSupport.removePropertyChangeListener(l);
    }

    private static class Button
    extends KDPanel {
        private KDTreeView.ControlPanel _titlePane;
        private CellRendererPane _cellRendererPane;

        public Button(String title) {
            KDTreeView tv = new KDTreeView();
            tv.setTitle(title);
            tv.setShowButton(false);
            tv.setShowFind(false);
            this._titlePane = tv.getControlPane();
            this._titlePane.setPreferredSize(new Dimension(10, 10));
            this._cellRendererPane = new CellRendererPane();
            this.add(this._cellRendererPane);
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void addActionListener(final ActionListener l) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    l.actionPerformed(new ActionEvent(e.getSource(), 1001, null));
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    Component lab = _titlePane.getComponent(0);
                    Font oriFont = lab.getFont();
                    int size = oriFont instanceof KDFontUIResource ? ((KDFontUIResource)oriFont).getDrawingSize() : oriFont.getSize();
                    lab.setFont(oriFont.deriveFont((float)size + 2.0f));
                    lab.setForeground(Color.BLUE);
                    this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    Component lab = _titlePane.getComponent(0);
                    Font oriFont = lab.getFont();
                    lab.setFont(oriFont.deriveFont((float)oriFont.getSize() - 2.0f));
                    lab.setForeground(Color.BLACK);
                    this.repaint();
                }
            });
        }

        public void paint(Graphics g) {
            this._titlePane.setSize(this.getWidth(), this.getHeight());
            this._titlePane.layoutContainer((Container)this._titlePane);
            this._cellRendererPane.paintComponent(g, (Component)this._titlePane, (Container)((Object)this), 0, 0, this.getWidth(), this.getHeight());
            this._cellRendererPane.removeAll();
        }
    }

    private class ButtonHandler
    implements ActionListener {
        private KDPanel pan;

        public ButtonHandler(KDPanel pan) {
            this.pan = pan;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IKDComponent btn = (IKDComponent)e.getSource();
            Integer integer = (Integer)btn.getUserObject();
            if (DrawersCtrl.this._currentIdx != integer) {
                KDTreeView oldOne = DrawersCtrl.this.getCurrentDrawer();
                DrawersCtrl.this._currentIdx = integer;
                DrawersCtrl.this.showDrawer(this.pan);
                KDTreeView newOne = DrawersCtrl.this.getCurrentDrawer();
                DrawersCtrl.this._propertyChangeSupport.firePropertyChange("Drawer", oldOne, newOne);
            }
        }
    }
}

