/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.editor;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.editor.FuncCollapsableDocument;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.editor.FuncCollapsableEditor;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.editor.IPreChangeListener;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.expr.IFuncUnit;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.KDLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledEditorKit;
import org.apache.log4j.Logger;

class FuncCollapsableEditorKit
extends StyledEditorKit {
    private static final Logger log = LogUtil.getPackageLogger(FuncCollapsableEditorKit.class);
    private static Icon ICN_COLLAPSE = ResourceManager.getImageIcon("collapse.gif");
    private static Icon ICN_EXPAND = ResourceManager.getImageIcon("expand.gif");
    private static Color CollapsedTextColor = Color.BLUE;
    private MouseHandler _mouseHandler = new MouseHandler();
    private CaretHandler _caretHandler = new CaretHandler();
    private DocPreChangeHandler _docPreChangeHandler = new DocPreChangeHandler();

    FuncCollapsableEditorKit() {
    }

    @Override
    public Document createDefaultDocument() {
        FuncCollapsableDocument doc = new FuncCollapsableDocument();
        doc.setPreChangeListener(this._docPreChangeHandler);
        return doc;
    }

    @Override
    public void install(JEditorPane c) {
        c.addMouseMotionListener(this._mouseHandler);
        c.addCaretListener(this._caretHandler);
        super.install(c);
    }

    @Override
    public void deinstall(JEditorPane c) {
        c.removeMouseMotionListener(this._mouseHandler);
        c.removeCaretListener(this._caretHandler);
        super.deinstall(c);
    }

    private static boolean isDescendantInvalid(IFuncUnit unit, StringBuffer prompt) {
        boolean isFound = false;
        int c = unit.getChildrenCount();
        for (int i = 0; i < c; ++i) {
            IFuncUnit child = unit.getChild(i);
            if (child.isInvalid()) {
                prompt.append("(");
                prompt.append(unit.getIndexOfParam(child) + 1);
                prompt.append(")");
                prompt.append(child.getDisplayName());
                isFound = true;
                break;
            }
            if (!FuncCollapsableEditorKit.isDescendantInvalid(child, prompt)) continue;
            prompt.insert(0, ")");
            prompt.insert(0, unit.getIndexOfParam(child) + 1);
            prompt.insert(0, "(");
            isFound = true;
            break;
        }
        if (isFound) {
            prompt.insert(0, " \u2192 ");
            prompt.insert(0, unit.getDisplayName());
        }
        return isFound;
    }

    private void clearBright(FuncCollapsableDocument doc) {
        this._caretHandler.clearLastBracket(doc);
        this._mouseHandler.clearLastFunc();
    }

    private void clearBright_Sync(FuncCollapsableDocument doc) {
        this._caretHandler.clearLastBracket(doc);
        this._mouseHandler.clearLastFunc_Sync();
    }

    private class DocPreChangeHandler
    implements IPreChangeListener {
        private DocPreChangeHandler() {
        }

        @Override
        public void willChange(FuncCollapsableDocument doc) {
            FuncCollapsableEditorKit.this.clearBright(doc);
        }
    }

    private class CaretHandler
    implements CaretListener {
        private Set _ctrls = new HashSet();
        private int _bracketPos = -1;

        private CaretHandler() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            this.dealCtrlSelection(e);
            this.dealBracketPair(e);
            this.updateNavigator(e);
        }

        private void updateNavigator(final CaretEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    FuncCollapsableEditor editor = (FuncCollapsableEditor)((Object)e.getSource());
                    IFuncUnit func = null;
                    int paramIdx = -1;
                    FuncCollapsableDocument doc = editor.getMyDoc();
                    try {
                        doc.readLock();
                        int pos = e.getDot();
                        func = doc.searchBreadcrumb(pos);
                        if (func != null) {
                            paramIdx = this.searchParamIdx(pos, func, paramIdx);
                        }
                        if (pos != e.getMark()) {
                            int paramIdx2 = -1;
                            pos = e.getMark();
                            IFuncUnit func2 = doc.searchBreadcrumb(pos);
                            if (func2 != null) {
                                paramIdx2 = this.searchParamIdx(pos, func2, paramIdx2);
                            }
                            if (func != func2 || paramIdx != paramIdx2) {
                                func = null;
                                paramIdx = -1;
                            }
                        }
                    }
                    finally {
                        doc.readUnlock();
                    }
                    editor.fireNavigatorUpdate(func, paramIdx);
                }

                private int searchParamIdx(int pos, IFuncUnit func, int defaultParamIdx) {
                    int[] commasPos = func.getCommasPos();
                    for (int i = func.getParamsCount() - 1; i >= 0; --i) {
                        int p;
                        int n = p = i == 0 ? func.getLpPos() : commasPos[i - 1];
                        if (pos <= p) continue;
                        return i;
                    }
                    return defaultParamIdx;
                }
            });
        }

        private void dealCtrlSelection(CaretEvent e) {
            FuncCollapsableEditor editor = (FuncCollapsableEditor)((Object)e.getSource());
            this.clearLastCtrlSelection();
            int from = e.getDot();
            int to = e.getMark();
            if (from == to) {
                return;
            }
            if (from > to) {
                from += to;
                to = from - to;
                from -= to;
            }
            for (int i = from; i < to; ++i) {
                String t;
                try {
                    t = editor.getText(i, 1);
                }
                catch (BadLocationException ex) {
                    log.error((Object)"", (Throwable)ex);
                    return;
                }
                if (!"@".equals(t) || !editor.getMyDoc().isInsteadCtrl(i)) continue;
                JComponent ctrl = editor.getMyDoc().getInsteadCtrl(i);
                ctrl.setOpaque(true);
                ctrl.setBackground(editor.getSelectionColor());
                ctrl.setForeground(editor.getSelectedTextColor());
                this._ctrls.add(ctrl);
            }
        }

        private void clearLastCtrlSelection() {
            if (this._ctrls.isEmpty()) {
                return;
            }
            Iterator it = this._ctrls.iterator();
            while (it.hasNext()) {
                JComponent ctrl = (JComponent)it.next();
                ctrl.setOpaque(false);
                ctrl.setForeground(CollapsedTextColor);
                it.remove();
            }
        }

        private void dealBracketPair(final CaretEvent e) {
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    FuncCollapsableEditor editor = (FuncCollapsableEditor)((Object)e.getSource());
                    FuncCollapsableDocument doc = editor.getMyDoc();
                    doc.myWriteLock();
                    try {
                        FuncCollapsableEditorKit.this.clearBright(doc);
                        int from = e.getDot();
                        int to = e.getMark();
                        if (from == to && from != 0) {
                            CaretHandler.this._bracketPos = doc.searchAnotherBracketPos(from - 1);
                            if (CaretHandler.this._bracketPos >= 0) {
                                doc.setCharacterAttributes(CaretHandler.this._bracketPos, 1, doc.getBracketPairStyle(), false);
                            }
                        }
                    }
                    finally {
                        doc.myWriteUnlock();
                    }
                }
            };
            new Thread(r).start();
        }

        public void clearLastBracket(FuncCollapsableDocument doc) {
            if (this._bracketPos >= 0) {
                doc.setCharacterAttributes(this._bracketPos, 1, doc.getNormalStyle(), false);
            }
        }
    }

    private static class Ctrl
    extends KDLabel {
        private Ctrl() {
        }

        public void paintComponent(Graphics g) {
            int w = this.getWidth();
            int h = this.getHeight();
            if (this.isOpaque()) {
                Color c = g.getColor();
                g.setColor(this.getBackground());
                g.fillRect(0, 0, w, h);
                g.setColor(c);
            }
            int down = this.getFontMetrics(this.getFont()).getLeading();
            Graphics gg = g.create(0, down, w, h);
            super.paintComponent(gg);
        }
    }

    private class MouseHandler
    extends MouseMotionAdapter {
        private FuncCollapsableEditor _editor;
        private FuncCollapsableDocument _doc;
        private IFuncUnit _lastUnit;
        private Popup _popup;
        private JLabel _labCollapseHandler;

        private MouseHandler() {
        }

        private void popupMenu(int x, int y, int height) {
            if (this._labCollapseHandler == null) {
                this._labCollapseHandler = new JLabel();
                this._labCollapseHandler.setOpaque(false);
                this._labCollapseHandler.setIcon(ICN_COLLAPSE);
                this._labCollapseHandler.setCursor(Cursor.getPredefinedCursor(12));
                this._labCollapseHandler.addMouseListener(new CollapseHandler());
            }
            int w = ICN_COLLAPSE.getIconWidth();
            this._labCollapseHandler.setPreferredSize(new Dimension(w, height));
            Point pt = new Point(x - w, y);
            SwingUtilities.convertPointToScreen(pt, (Component)((Object)this._editor));
            this._popup = PopupFactory.getSharedInstance().getPopup((Component)((Object)this._editor), this._labCollapseHandler, pt.x, pt.y);
            this._popup.show();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this._editor = (FuncCollapsableEditor)((Object)e.getSource());
            this._doc = this._editor.getMyDoc();
            TextUI ui = this._editor.getUI();
            int pos = this.getMouseOverPos(this._editor, e.getPoint());
            IFuncUnit unit = null;
            if (pos >= 0) {
                unit = this._doc.searchFuncUnitByPos(pos);
            }
            if (unit != this._lastUnit) {
                FuncCollapsableEditorKit.this.clearBright_Sync(this._doc);
                if (unit != null) {
                    this.updateCurrentFuncStyle(unit, false);
                    if (!unit.isInvalid()) {
                        StringBuffer prompt = new StringBuffer();
                        try {
                            Rectangle rect = ui.modelToView((JTextComponent)((Object)this._editor), unit.getNameStartPos());
                            if (FuncCollapsableEditorKit.isDescendantInvalid(unit, prompt)) {
                                this._editor.setToolTipText("\u5b50\u51fd\u6570\u8bed\u6cd5\u9519\u8bef\uff1a" + prompt.toString());
                            } else {
                                this.popupMenu(rect.x, rect.y, rect.height);
                            }
                        }
                        catch (BadLocationException ex) {
                            log.error((Object)"", (Throwable)ex);
                        }
                    }
                }
                this._lastUnit = unit;
            }
        }

        public void clearLastFunc() {
            if (this._lastUnit != null) {
                this.updateCurrentFuncStyle(this._lastUnit, true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (MouseHandler.this._popup != null) {
                            MouseHandler.this._popup.hide();
                        }
                        MouseHandler.this._editor.setToolTipText(null);
                    }
                });
            }
        }

        private void clearLastFunc_Sync() {
            if (this._lastUnit != null) {
                this.updateCurrentFuncStyle(this._lastUnit, true);
            }
            if (this._popup != null) {
                this._popup.hide();
            }
            this._editor.setToolTipText(null);
        }

        private void updateCurrentFuncStyle(IFuncUnit unit, boolean isNormal) {
            boolean isOk = !unit.isInvalid();
            boolean isFix = false;
            AttributeSet style = null;
            if (isNormal) {
                style = this._doc.getNormalStyle();
                isFix = true;
            } else if (isOk) {
                style = this._doc.getFuncNameStyle();
                isFix = true;
            }
            if (!isFix) {
                style = unit.isInvalid(1L) ? this._doc.getInvalidBrightStyle() : this._doc.getInvalidBaseStyle();
            }
            this._doc.setCharacterAttributes(unit.getNameStartPos(), unit.getNameLength(), style, false);
            if (!isNormal && isOk) {
                style = this._doc.getFuncBracketStyle();
            }
            if (!isFix) {
                style = unit.isInvalid(2L) ? this._doc.getInvalidBrightStyle() : this._doc.getInvalidBaseStyle();
            }
            this._doc.setCharacterAttributes(unit.getLpPos(), 1, style, false);
            if (!isFix) {
                style = unit.isInvalid(4L) ? this._doc.getInvalidBrightStyle() : this._doc.getInvalidBaseStyle();
            }
            this._doc.setCharacterAttributes(unit.getRpPos(), 1, style, false);
            if (!isNormal && isOk) {
                style = this._doc.getFuncCommaStyle();
            }
            int[] cms = unit.getCommasPos();
            for (int i = 0; i < cms.length; ++i) {
                if (!isFix) {
                    style = unit.isCommaInvalid(i) ? this._doc.getInvalidBrightStyle() : this._doc.getInvalidBaseStyle();
                }
                this._doc.setCharacterAttributes(cms[i], 1, style, false);
            }
        }

        private int getMouseOverPos(FuncCollapsableEditor editor, Point pt) {
            TextUI ui = editor.getUI();
            Position.Bias[] bi = new Position.Bias[1];
            int pos = ui.viewToModel((JTextComponent)((Object)editor), pt, bi);
            Element ele = this._doc.getCharacterElement(pos);
            try {
                Rectangle rect = ui.modelToView((JTextComponent)((Object)editor), pos, Position.Bias.Forward);
                Rectangle rect2 = ui.modelToView((JTextComponent)((Object)editor), ele.getEndOffset(), Position.Bias.Backward);
                if (rect.y == rect2.y && rect2.x - rect.x < 3) {
                    return -1;
                }
                if (pt.y < rect.y) {
                    return -1;
                }
            }
            catch (BadLocationException ex) {
                return -1;
            }
            return pos;
        }

        private class ExpandHandler
        extends MouseAdapter {
            private ExpandHandler() {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                MouseHandler.this._editor.fireNavigatorReset();
                IKDComponent ctrl = (IKDComponent)e.getSource();
                IFuncUnit unit = (IFuncUnit)ctrl.getUserObject();
                MouseHandler.this._doc.expandFuncUnit(unit);
                MouseHandler.this._editor.setCaretPosition(unit.getNameStartPos());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                FuncCollapsableEditorKit.this.clearBright(MouseHandler.this._doc);
                MouseHandler.this._lastUnit = null;
            }
        }

        private class CollapseHandler
        extends MouseAdapter {
            private CollapseHandler() {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                FuncCollapsableEditorKit.this.clearBright(MouseHandler.this._doc);
                if (MouseHandler.this._lastUnit.getCollapsedInsteadCtrl() == null) {
                    Ctrl btn = new Ctrl();
                    btn.setText(MouseHandler.this._lastUnit.getFuncName() + "(...)");
                    btn.setIcon(ICN_EXPAND);
                    btn.setIconTextGap(1);
                    btn.setCursor(Cursor.getPredefinedCursor(12));
                    btn.setForeground(CollapsedTextColor);
                    Font font = MouseHandler.this._editor.getFont();
                    btn.setFont(font);
                    FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
                    float ay = 1.0f - (float)fm.getDescent() / (float)fm.getHeight();
                    btn.setAlignmentY(ay);
                    btn.addMouseListener(new ExpandHandler());
                    btn.setUserObject(MouseHandler.this._lastUnit);
                    MouseHandler.this._lastUnit.setCollapsedInsteadCtrl((JComponent)((Object)btn));
                }
                MouseHandler.this._doc.collapseFuncUnit(MouseHandler.this._lastUnit);
                MouseHandler.this._editor.fireNavigatorReset();
            }
        }
    }
}

