/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.expr;

import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.expr.IFuncUnit;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.expr.IUnit;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.expr.Param;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;

class FuncUnitImpl
implements IFuncUnit {
    private String _funcName;
    private int _nameStartPos;
    private int _lpPos;
    private int _rpPos;
    private int[] _commasPos = new int[0];
    private FuncUnitImpl _parent;
    private ArrayList _children;
    private LinkedList _params;
    private boolean _isCollapsed;
    private String _collapsedText;
    private int _collapsedStartPos;
    private JComponent _bindCtrl;
    private int _startAtFullText;
    private int _invalidMark;

    FuncUnitImpl() {
    }

    @Override
    public String getFuncName() {
        return this._funcName;
    }

    @Override
    public String getDisplayName() {
        return this.getFuncName();
    }

    void setFuncName(String funcName) {
        this._funcName = funcName;
    }

    @Override
    public int getNameStartPos() {
        return this._nameStartPos;
    }

    void setNameStartPos(int nameStartPos) {
        this._nameStartPos = nameStartPos;
        this._startAtFullText = nameStartPos;
    }

    @Override
    public int getNameLength() {
        return this._funcName.length();
    }

    @Override
    public int getAllLength() {
        return this._rpPos - this._nameStartPos + 1;
    }

    @Override
    public int getLpPos() {
        return this._lpPos;
    }

    void setLpPos(int lpPos) {
        this._lpPos = lpPos;
    }

    @Override
    public int getRpPos() {
        return this._rpPos;
    }

    void setRpPos(int rpPos) {
        this._rpPos = rpPos;
    }

    @Override
    public int[] getCommasPos() {
        return this._commasPos;
    }

    void addCommaPos(int commaPos) {
        int[] newInst = new int[this._commasPos.length + 1];
        System.arraycopy(this._commasPos, 0, newInst, 0, this._commasPos.length);
        newInst[this._commasPos.length] = commaPos;
        this._commasPos = newInst;
    }

    @Override
    public IFuncUnit getParent() {
        return this._parent;
    }

    public void setParent(FuncUnitImpl unit) {
        this._parent = unit;
        this._parent.addChild(this);
    }

    @Override
    public int getChildrenCount() {
        return this._children == null ? 0 : this._children.size();
    }

    private List getChildren() {
        if (this._children == null) {
            this._children = new ArrayList();
        }
        return this._children;
    }

    @Override
    public IFuncUnit getChild(int idx) {
        return (IFuncUnit)this.getChildren().get(idx);
    }

    private void addChild(FuncUnitImpl child) {
        this.getChildren().add(child);
    }

    @Override
    public void removeChild(IFuncUnit child) {
        this.getChildren().remove(child);
    }

    private LinkedList getParamsQueue() {
        if (this._params == null) {
            this._params = new LinkedList();
        }
        return this._params;
    }

    @Override
    public int getParamsCount() {
        return this._params == null ? 0 : this._params.size();
    }

    @Override
    public Param[] getParams() {
        if (this._params == null) {
            return new Param[0];
        }
        return this.getParamsQueue().toArray(new Param[0]);
    }

    void addUnit(IUnit unit) {
        if (this.getParamsQueue().size() == 0) {
            this.startNewParam();
        }
        Param param = (Param)this.getParamsQueue().getLast();
        param.addUnit(unit);
    }

    void startNewParam() {
        this.getParamsQueue().addLast(new Param());
    }

    private void replaceUnit(IUnit oldOne, IUnit newOne) {
        for (Param param : this.getParamsQueue()) {
            int idx = param.getUnitIdx(oldOne);
            if (idx < 0) continue;
            param.setUnit(newOne, idx);
            break;
        }
    }

    @Override
    public int getIndexOfParam(IUnit childUnit) {
        int paramIdx = 0;
        for (Param param : this.getParamsQueue()) {
            int idx = param.getUnitIdx(childUnit);
            if (idx >= 0) {
                return paramIdx;
            }
            ++paramIdx;
        }
        return -1;
    }

    @Override
    public boolean isCollapsed() {
        return this._isCollapsed;
    }

    @Override
    public void setCollapsed(boolean collapse) {
        this._isCollapsed = collapse;
    }

    @Override
    public String getCollapsedText() {
        return this._collapsedText;
    }

    @Override
    public void setCollapsedText(String text) {
        this._collapsedText = text;
    }

    @Override
    public int getCollapsedStartPos() {
        return this._collapsedStartPos;
    }

    @Override
    public void setCollapsedStartPos(int pos) {
        this._collapsedStartPos = pos;
    }

    @Override
    public JComponent getCollapsedInsteadCtrl() {
        return this._bindCtrl;
    }

    @Override
    public void setCollapsedInsteadCtrl(JComponent ctrl) {
        this._bindCtrl = ctrl;
    }

    @Override
    public void relative(int relativeValue, boolean back) {
        int c = relativeValue * (back ? -1 : 1);
        this._nameStartPos -= c;
        this._lpPos -= c;
        this._rpPos -= c;
        int i = 0;
        while (i < this._commasPos.length) {
            int n = i++;
            this._commasPos[n] = this._commasPos[n] - c;
        }
    }

    @Override
    public void updateEditorPos(int greaterThan, int delta) {
        if (this.isCollapsed()) {
            if (this._collapsedStartPos > greaterThan) {
                this._collapsedStartPos += delta;
            }
        } else {
            if (this._nameStartPos > greaterThan) {
                this._nameStartPos += delta;
            }
            if (this._lpPos > greaterThan) {
                this._lpPos += delta;
            }
            if (this._rpPos > greaterThan) {
                this._rpPos += delta;
            }
            for (int i = 0; i < this._commasPos.length; ++i) {
                if (this._commasPos[i] <= greaterThan) continue;
                int n = i;
                this._commasPos[n] = this._commasPos[n] + delta;
            }
        }
    }

    @Override
    public void updateTextPos(int greaterThan, int delta) {
        if (this._startAtFullText > greaterThan) {
            this._startAtFullText += delta;
        }
    }

    @Override
    public int getStartAtText() {
        return this._startAtFullText;
    }

    @Override
    public void replaceNode(IFuncUnit another) {
        int idx = this._parent._children.indexOf(this);
        this._parent._children.set(idx, another);
        this._parent.replaceUnit(this, another);
    }

    @Override
    public boolean checkInvalid(int pos, int delta) {
        block6: {
            int nameEndPos;
            block5: {
                if (this.isCollapsed()) {
                    return false;
                }
                nameEndPos = this._nameStartPos + this.getNameLength();
                if (delta <= 0) break block5;
                if (pos <= this._nameStartPos || pos >= nameEndPos) break block6;
                this._invalidMark = (int)((long)this._invalidMark | 1L);
                break block6;
            }
            int deleteEnd = pos - delta;
            if (pos >= this._nameStartPos && pos < nameEndPos || pos < this._nameStartPos && deleteEnd > this._nameStartPos) {
                this._invalidMark = (int)((long)this._invalidMark | 1L);
            }
            if (pos <= this._lpPos && this._lpPos < deleteEnd) {
                this._invalidMark = (int)((long)this._invalidMark | 2L);
            }
            if (pos <= this._rpPos && this._rpPos < deleteEnd) {
                this._invalidMark = (int)((long)this._invalidMark | 4L);
            }
            for (int i = 0; i < this._commasPos.length; ++i) {
                if (pos > this._commasPos[i] || this._commasPos[i] >= deleteEnd) continue;
                this._invalidMark = (int)((long)this._invalidMark | 8L);
                this._invalidMark |= 1 << i + 5;
                break;
            }
        }
        return this.isInvalid();
    }

    @Override
    public boolean isInvalid() {
        return this._invalidMark != 0;
    }

    @Override
    public boolean isInvalid(long tag) {
        return ((long)this._invalidMark & tag) == tag;
    }

    @Override
    public boolean isCommaInvalid(int commaIdx) {
        if (this.isInvalid(8L)) {
            return (this._invalidMark >> commaIdx + 5 & 1) == 1;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDisplayName());
        sb.append("  \u6587\u672c\u4f4d\u7f6e\uff1a");
        sb.append(this._startAtFullText);
        sb.append(this._isCollapsed ? " \u76f8\u5bf9\u4f4d\u7f6e\uff1a" : "  \u7f16\u8f91\u5668\u4f4d\u7f6e\uff1a");
        sb.append(this._nameStartPos);
        sb.append("; ");
        sb.append(this._lpPos);
        sb.append("; [");
        for (int i = 0; i < this._commasPos.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this._commasPos[i]);
        }
        sb.append("]; ");
        sb.append(this._rpPos);
        if (this._isCollapsed) {
            sb.append("  \u6536\uff0c");
            sb.append(this._collapsedStartPos);
        }
        if (this.isInvalid()) {
            sb.append("  \u65e0\u6548");
        }
        return sb.toString();
    }
}

