/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.impl;

import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.AbstractListTableBuilder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.MobileReportWizardModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.ReportType;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.TableType;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.style.TableStyleDesign;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.expans.model.ExtProps;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;

public class ListTableBuilder
extends AbstractListTableBuilder {
    public ListTableBuilder(KDExt ext, MobileReportWizardModel model, int startRow) {
        super(ext, model);
        this.startRow = startRow;
    }

    @Override
    public void build() {
        super.build();
        this.buildList(this.startRow);
        this.buildListSA(this.startRow);
    }

    private void buildList(int startRow) {
        for (int i = 0; i < this.fieldSize; ++i) {
            if (this.tableModel.getFieldList().get(i) != null) {
                String field = this.tableModel.getFieldList().get(i).toString();
                Cell cell = this.sheet.getCell(startRow, i, true);
                cell.setValue(new Variant(field));
                this.buildField(startRow + 1, i);
            }
            if (!this.isShowTotal) continue;
            this.buildTotal(startRow + 2, i, startRow + 1);
        }
    }

    private void buildListSA(int startRow) {
        for (int i = 0; i < this.fieldSize; ++i) {
            this.sheet.getRange(startRow, i).setStyle(this.titleSa, Styles.getEmptySA());
            this.sheet.getRange(startRow + 1, i).setStyle(this.detailSa, Styles.getEmptySA());
            if (TableStyleDesign.CLASSIC2 == this.tableStyle.getDesign() || TableStyleDesign.CLASSIC4 == this.tableStyle.getDesign()) {
                this.sheet.getCell(startRow + 1, i, false).getExtProps(true).getFormulas(true).insert(ExtProps.FORMULA_BACKGROUND, "IF(MOD(ROW(), 2) = 1, RGB(245, 244, 249))");
            }
            if (!this.isShowTotal) continue;
            this.sheet.getRange(startRow + 2, i).setStyle(this.totalSa, Styles.getEmptySA());
        }
        int endRow = startRow + 1;
        if (this.isShowTotal) {
            this.setFormulaTotal(startRow + 2, 0, "\u603b\u8ba1");
            endRow = startRow + 2;
        }
        if (TableStyleDesign.CLASSIC3 == this.tableStyle.getDesign()) {
            this.sheet.getRange(startRow, 0, startRow, this.fieldSize - 1).setStyle(this.borderSaBottom, Styles.getEmptySA());
        }
        this.buildSpecialSA(startRow, endRow, true);
        if (this.isShowTotal) {
            this.sheet.getRange(startRow + 2, 0).setStyle(this.leftSa, Styles.getEmptySA());
        }
    }

    private void buildField(int startRow, int index) {
        if (index == 0) {
            this.sheet.getCell(startRow, index, true).setFormula(this.buildFullFormula(this.tableModel.getCurrentDs().getAlias(), this.tableModel.getFieldList().get(index).toString()));
        } else {
            String formula = this.buildSmartFormula(this.tableModel.getCurrentDs().getAlias(), this.tableModel.getFieldList().get(index).toString());
            this.sheet.getCell(startRow, index, true).setFormula(formula);
        }
    }

    @Override
    public ReportType getReportType() {
        return ReportType.TABLE;
    }

    @Override
    public TableStyleDesign[] getDesigns() {
        return new TableStyleDesign[]{TableStyleDesign.CLASSIC1, TableStyleDesign.CLASSIC2, TableStyleDesign.CLASSIC3, TableStyleDesign.CLASSIC4, TableStyleDesign.ECLIPSE};
    }

    @Override
    public TableType getTableType() {
        return TableType.LIST;
    }
}

