/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.impl;

import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.AbstractGroupTableBuilder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.DesignBuilder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.MobileReportWizardModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.ReportType;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.TableType;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.style.TableStyleDesign;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.expans.model.ExtProps;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;

public class SegmentGroupTableBuilder
extends AbstractGroupTableBuilder {
    public SegmentGroupTableBuilder(KDExt ext, MobileReportWizardModel model, int startRow) {
        super(ext, model);
        this.startRow = startRow;
    }

    @Override
    public void build() {
        super.build();
        this.buildSegmentGroup(this.startRow);
        this.buildSegmentGroupSa(this.startRow);
    }

    private void buildSegmentGroup(int startRow) {
        for (int i = 0; i < this.fieldSize; ++i) {
            if (this.tableModel.getFieldList().get(i) == null) continue;
            String field = this.tableModel.getFieldList().get(i).toString();
            Cell cell = this.sheet.getCell(startRow, i, true);
            cell.setValue(new Variant(field));
            this.buildSegmentGroup(startRow + 1, i, this.tableModel.getSegment());
            this.buildSubTotal(startRow + 3, i, startRow + 2);
            if (this.isShowSubTotal) {
                this.buildTotal(startRow + 4, i, startRow + 2);
                continue;
            }
            this.buildTotal(startRow + 3, i, startRow + 2);
        }
        this.setHead(startRow + 2);
    }

    private void buildSegmentGroupSa(int startRow) {
        DesignBuilder builder = null;
        switch (this.model.getTableModel().getTableStyle().getDesign()) {
            case CLASSIC3: {
                builder = new Classic3Builder();
                break;
            }
            case CLASSIC4: {
                builder = new Classic4Builder();
                break;
            }
            case ECLIPSE: {
                builder = new EclipseBuilder();
                break;
            }
            default: {
                builder = new Classic1Builder();
            }
        }
        builder.build();
    }

    private void buildSegmentGroup(int row, int col, String segment) {
        this.sheet.getCell(row, 0, true).setFormula(this.buildGroupFormula(this.tableModel.getCurrentDs().getAlias(), segment));
        this.sheet.getMerger(true).insert(CellBlock.getCellBlock(row, 0, row, col));
        this.sheet.getCell(row + 1, col, true).setFormula(this.buildSegmentFormula(this.tableModel.getCurrentDs().getAlias(), this.tableModel.getFieldList().get(col).toString(), col));
    }

    protected void setHead(int row) {
        if (this.sheet.getCell(row - 1, 0, false) == null) {
            return;
        }
        String ref = this.sheet.getCell(row - 1, 0, false).getName(false, false);
        this.sheet.getCell(row, 0, false).getExtProps(true).setHead(ref, true);
    }

    @Override
    public ReportType getReportType() {
        return ReportType.TABLE;
    }

    @Override
    public TableStyleDesign[] getDesigns() {
        return new TableStyleDesign[]{TableStyleDesign.CLASSIC1, TableStyleDesign.CLASSIC2, TableStyleDesign.CLASSIC3, TableStyleDesign.CLASSIC4};
    }

    @Override
    public TableType getTableType() {
        return TableType.SEGMENTGROUP;
    }

    private class EclipseBuilder
    implements DesignBuilder {
        private EclipseBuilder() {
        }

        @Override
        public void build() {
            SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 2, 0, SegmentGroupTableBuilder.this.startRow + 2, 65535).insert(true);
            SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 2, 0, SegmentGroupTableBuilder.this.startRow + 2, 65535).setRowHeight(1);
            if (SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 1, 0, false) == null) {
                return;
            }
            String ref = SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 1, 0, false).getName(false, false);
            SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 2, 0, true).getExtProps(true).setHead(ref, true);
            SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 1, 0, SegmentGroupTableBuilder.this.startRow + 1, SegmentGroupTableBuilder.this.fieldSize - 1).setStyle(SegmentGroupTableBuilder.this.segmentSa, Styles.getEmptySA());
            SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 2, 0, true).setFormula("=EXINDEX(" + ref + ")");
            String refIndex = SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 2, 0, false).getName(false, false);
            for (int i = 0; i < SegmentGroupTableBuilder.this.fieldSize; ++i) {
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow, i).setStyle(SegmentGroupTableBuilder.this.titleSa, Styles.getEmptySA());
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 1, i).setStyle(SegmentGroupTableBuilder.this.segmentSa, Styles.getEmptySA());
                if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                    SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 4, i).setStyle(SegmentGroupTableBuilder.this.subTotalSa, Styles.getEmptySA());
                }
                if (!SegmentGroupTableBuilder.this.isShowTotal) continue;
                if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                    SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 5, i).setStyle(SegmentGroupTableBuilder.this.totalSa, Styles.getEmptySA());
                    continue;
                }
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 4, i).setStyle(SegmentGroupTableBuilder.this.totalSa, Styles.getEmptySA());
            }
            SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 3, 0, SegmentGroupTableBuilder.this.startRow + 3, SegmentGroupTableBuilder.this.fieldSize - 1).setStyle(SegmentGroupTableBuilder.this.whiteSa, Styles.getEmptySA());
            int endRow = SegmentGroupTableBuilder.this.startRow + 3;
            if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                SegmentGroupTableBuilder.this.setFormulaTotal(SegmentGroupTableBuilder.this.startRow + 4, 0, "\u5c0f\u8ba1");
                String ref2 = SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 1, 0, false).getName(false, false);
                SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 4, 0, false).getExtProps(true).setHead(ref2, true);
                endRow = SegmentGroupTableBuilder.this.startRow + 4;
            }
            if (SegmentGroupTableBuilder.this.isShowTotal) {
                if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                    SegmentGroupTableBuilder.this.setFormulaTotal(SegmentGroupTableBuilder.this.startRow + 5, 0, "\u603b\u8ba1");
                    endRow = SegmentGroupTableBuilder.this.startRow + 5;
                } else {
                    SegmentGroupTableBuilder.this.setFormulaTotal(SegmentGroupTableBuilder.this.startRow + 4, 0, "\u603b\u8ba1");
                    endRow = SegmentGroupTableBuilder.this.startRow + 4;
                }
            }
            SegmentGroupTableBuilder.this.buildSpecialSA(SegmentGroupTableBuilder.this.startRow, endRow, true);
            SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 1, 0).setStyle(SegmentGroupTableBuilder.this.leftSa, Styles.getEmptySA());
            if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 4, 0).setStyle(SegmentGroupTableBuilder.this.leftSa, Styles.getEmptySA());
            }
            if (SegmentGroupTableBuilder.this.isShowTotal) {
                if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                    SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 5, 0).setStyle(SegmentGroupTableBuilder.this.leftSa, Styles.getEmptySA());
                } else {
                    SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 4, 0).setStyle(SegmentGroupTableBuilder.this.leftSa, Styles.getEmptySA());
                }
            }
            if (!SegmentGroupTableBuilder.this.isShowSubTotal) {
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 4, 0, SegmentGroupTableBuilder.this.startRow + 4, 65535).insert(true);
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 4, 0, SegmentGroupTableBuilder.this.startRow + 4, 65535).setRowHeight(0);
                SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 4, 0, true).getExtProps(true).setHead(ref, true);
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 4, 0, SegmentGroupTableBuilder.this.startRow, SegmentGroupTableBuilder.this.fieldSize - 1).setStyle(SegmentGroupTableBuilder.this.borderSaBottom, Styles.getEmptySA());
            }
        }
    }

    private class Classic4Builder
    implements DesignBuilder {
        private Classic4Builder() {
        }

        @Override
        public void build() {
            SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 2, 0, SegmentGroupTableBuilder.this.startRow + 2, 65535).insert(true);
            SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 2, 0, SegmentGroupTableBuilder.this.startRow + 2, 65535).setRowHeight(1);
            SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 4, 0, SegmentGroupTableBuilder.this.startRow + 4, 65535).insert(true);
            SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 4, 0, SegmentGroupTableBuilder.this.startRow + 4, 65535).setRowHeight(0);
            SegmentGroupTableBuilder.this.sheet.getRange(0, 0, 1048575, 0).insert(false);
            SegmentGroupTableBuilder.this.sheet.getRange(0, 0, 1048575, 0).setColumnWidth(10);
            SegmentGroupTableBuilder.this.sheet.getRange(0, SegmentGroupTableBuilder.this.fieldSize + 1, 1048575, SegmentGroupTableBuilder.this.fieldSize + 1).insert(false);
            SegmentGroupTableBuilder.this.sheet.getRange(0, SegmentGroupTableBuilder.this.fieldSize + 1, 1048575, SegmentGroupTableBuilder.this.fieldSize + 1).setColumnWidth(10);
            if (SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 1, 1, false) == null) {
                return;
            }
            String ref = SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 1, 1, false).getName(false, false);
            SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 1, 0, true).getExtProps(true).setHead(ref, true);
            SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 2, 0, true).getExtProps(true).setHead(ref, true);
            SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 3, 0, true).getExtProps(true).setHead(ref, true);
            SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 4, 0, true).getExtProps(true).setHead(ref, true);
            if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 5, 0, true).getExtProps(true).setHead(ref, true);
            }
            SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 1, 1, SegmentGroupTableBuilder.this.startRow + 1, SegmentGroupTableBuilder.this.fieldSize).setStyle(SegmentGroupTableBuilder.this.segmentSa, Styles.getEmptySA());
            SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 2, 0, true).setFormula("=EXINDEX(" + ref + ")");
            String refIndex = SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 2, 0, false).getName(false, false);
            for (int i = 0; i < SegmentGroupTableBuilder.this.fieldSize + 2; ++i) {
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow, i).setStyle(SegmentGroupTableBuilder.this.titleSa, Styles.getEmptySA());
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 1, i).setStyle(SegmentGroupTableBuilder.this.whiteSa, Styles.getEmptySA());
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 3, i).setStyle(SegmentGroupTableBuilder.this.whiteSa, Styles.getEmptySA());
                SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 1, i, true).getExtProps(true).getFormulas(true).insert(ExtProps.FORMULA_BACKGROUND, "IF(MOD(" + refIndex + ", 2) = 0, RGB(245, 244, 249), RGB(255, 255, 255))");
                SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 2, i, true).getExtProps(true).getFormulas(true).insert(ExtProps.FORMULA_BACKGROUND, "IF(MOD(" + refIndex + ", 2) = 0, RGB(245, 244, 249), RGB(255, 255, 255))");
                SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 3, i, true).getExtProps(true).getFormulas(true).insert(ExtProps.FORMULA_BACKGROUND, "IF(MOD(" + refIndex + ", 2) = 0, RGB(245, 244, 249), RGB(255, 255, 255))");
                if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                    SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 5, i, true).getExtProps(true).getFormulas(true).insert(ExtProps.FORMULA_BACKGROUND, "IF(MOD(" + refIndex + ", 2) = 0, RGB(245, 244, 249), RGB(255, 255, 255))");
                    SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 5, i).setStyle(SegmentGroupTableBuilder.this.whiteSa, Styles.getEmptySA());
                }
                if (!SegmentGroupTableBuilder.this.isShowTotal) continue;
                if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                    SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 6, i).setStyle(SegmentGroupTableBuilder.this.totalSa, Styles.getEmptySA());
                    continue;
                }
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 5, i).setStyle(SegmentGroupTableBuilder.this.totalSa, Styles.getEmptySA());
            }
            int endRow = SegmentGroupTableBuilder.this.startRow + 4;
            if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                SegmentGroupTableBuilder.this.setFormulaTotal(SegmentGroupTableBuilder.this.startRow + 5, 1, "\u5c0f\u8ba1");
                endRow = SegmentGroupTableBuilder.this.startRow + 5;
            }
            if (SegmentGroupTableBuilder.this.isShowTotal) {
                if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                    SegmentGroupTableBuilder.this.setFormulaTotal(SegmentGroupTableBuilder.this.startRow + 6, 1, "\u603b\u8ba1");
                    endRow = SegmentGroupTableBuilder.this.startRow + 6;
                } else {
                    SegmentGroupTableBuilder.this.setFormulaTotal(SegmentGroupTableBuilder.this.startRow + 5, 1, "\u603b\u8ba1");
                    endRow = SegmentGroupTableBuilder.this.startRow + 5;
                }
            }
            SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow, 0, SegmentGroupTableBuilder.this.startRow, SegmentGroupTableBuilder.this.fieldSize + 1).setStyle(SegmentGroupTableBuilder.this.borderSaBottom, Styles.getEmptySA());
            if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 5, 1, SegmentGroupTableBuilder.this.startRow + 5, SegmentGroupTableBuilder.this.fieldSize).setStyle(SegmentGroupTableBuilder.this.borderSaTop, Styles.getEmptySA());
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 5, 0, SegmentGroupTableBuilder.this.startRow + 5, SegmentGroupTableBuilder.this.fieldSize + 1).setStyle(SegmentGroupTableBuilder.this.borderSaBottom, Styles.getEmptySA());
            }
            SegmentGroupTableBuilder.this.buildSpecialSA(SegmentGroupTableBuilder.this.startRow, endRow, false);
            SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 1, 1).setStyle(SegmentGroupTableBuilder.this.leftSa, Styles.getEmptySA());
            if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 5, 1).setStyle(SegmentGroupTableBuilder.this.leftSa, Styles.getEmptySA());
            }
            if (SegmentGroupTableBuilder.this.isShowTotal) {
                if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                    SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 6, 1).setStyle(SegmentGroupTableBuilder.this.leftSa, Styles.getEmptySA());
                } else {
                    SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 5, 1).setStyle(SegmentGroupTableBuilder.this.leftSa, Styles.getEmptySA());
                }
            }
        }
    }

    private class Classic3Builder
    implements DesignBuilder {
        private Classic3Builder() {
        }

        @Override
        public void build() {
            SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 2, 0, SegmentGroupTableBuilder.this.startRow + 2, 65535).insert(true);
            SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 2, 0, SegmentGroupTableBuilder.this.startRow + 2, 65535).setRowHeight(1);
            if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 5, 0, SegmentGroupTableBuilder.this.startRow + 5, 65535).insert(true);
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 5, 0, SegmentGroupTableBuilder.this.startRow + 5, 65535).setRowHeight(8);
            } else {
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 4, 0, SegmentGroupTableBuilder.this.startRow + 4, 65535).insert(true);
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 4, 0, SegmentGroupTableBuilder.this.startRow + 4, 65535).setRowHeight(8);
            }
            SegmentGroupTableBuilder.this.sheet.getRange(0, 0, 1048575, 0).insert(false);
            SegmentGroupTableBuilder.this.sheet.getRange(0, 0, 1048575, 0).setColumnWidth(10);
            SegmentGroupTableBuilder.this.sheet.getRange(0, SegmentGroupTableBuilder.this.fieldSize + 1, 1048575, SegmentGroupTableBuilder.this.fieldSize + 1).insert(false);
            SegmentGroupTableBuilder.this.sheet.getRange(0, SegmentGroupTableBuilder.this.fieldSize + 1, 1048575, SegmentGroupTableBuilder.this.fieldSize + 1).setColumnWidth(10);
            if (SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 1, 1, false) == null) {
                return;
            }
            String ref = SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 1, 1, false).getName(false, false);
            SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 1, 0, true).getExtProps(true).setHead(ref, true);
            SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 2, 0, true).getExtProps(true).setHead(ref, true);
            SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 3, 0, true).getExtProps(true).setHead(ref, true);
            SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 4, 0, true).getExtProps(true).setHead(ref, true);
            if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 5, 0, true).getExtProps(true).setHead(ref, true);
            }
            SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 1, 1, SegmentGroupTableBuilder.this.startRow + 1, SegmentGroupTableBuilder.this.fieldSize + 1).setStyle(SegmentGroupTableBuilder.this.segmentSa, Styles.getEmptySA());
            for (int i = 0; i < SegmentGroupTableBuilder.this.fieldSize + 2; ++i) {
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow, i).setStyle(SegmentGroupTableBuilder.this.titleSa, Styles.getEmptySA());
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 1, i).setStyle(SegmentGroupTableBuilder.this.whiteSa, Styles.getEmptySA());
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 3, i).setStyle(SegmentGroupTableBuilder.this.whiteSa, Styles.getEmptySA());
                if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                    SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 4, i).setStyle(SegmentGroupTableBuilder.this.subTotalSa, Styles.getEmptySA());
                    SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 5, i).setStyle(SegmentGroupTableBuilder.this.whiteSa, Styles.getEmptySA());
                } else {
                    SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 4, i).setStyle(SegmentGroupTableBuilder.this.whiteSa, Styles.getEmptySA());
                }
                if (!SegmentGroupTableBuilder.this.isShowTotal) continue;
                if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                    SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 6, i).setStyle(SegmentGroupTableBuilder.this.totalSa, Styles.getEmptySA());
                    continue;
                }
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 5, i).setStyle(SegmentGroupTableBuilder.this.totalSa, Styles.getEmptySA());
            }
            SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 2, 0, SegmentGroupTableBuilder.this.startRow + 2, SegmentGroupTableBuilder.this.fieldSize + 1).setStyle(SegmentGroupTableBuilder.this.whiteSa, Styles.getEmptySA());
            SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 3, 0, SegmentGroupTableBuilder.this.startRow + 3, SegmentGroupTableBuilder.this.fieldSize - 1).setStyle(SegmentGroupTableBuilder.this.whiteSa, Styles.getEmptySA());
            int endRow = SegmentGroupTableBuilder.this.startRow + 4;
            if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                SegmentGroupTableBuilder.this.setFormulaTotal(SegmentGroupTableBuilder.this.startRow + 4, 1, "\u5c0f\u8ba1");
            }
            if (SegmentGroupTableBuilder.this.isShowTotal) {
                if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                    SegmentGroupTableBuilder.this.setFormulaTotal(SegmentGroupTableBuilder.this.startRow + 6, 1, "\u603b\u8ba1");
                    endRow = SegmentGroupTableBuilder.this.startRow + 6;
                } else {
                    SegmentGroupTableBuilder.this.setFormulaTotal(SegmentGroupTableBuilder.this.startRow + 5, 1, "\u603b\u8ba1");
                    endRow = SegmentGroupTableBuilder.this.startRow + 5;
                }
            }
            if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 1, 0, SegmentGroupTableBuilder.this.startRow + 4, SegmentGroupTableBuilder.this.fieldSize + 1).setStyle(SegmentGroupTableBuilder.this.borderSa, Styles.getEmptySA());
            }
            SegmentGroupTableBuilder.this.buildSpecialSA(SegmentGroupTableBuilder.this.startRow, endRow, false);
            SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 1, 1).setStyle(SegmentGroupTableBuilder.this.leftSa, Styles.getEmptySA());
            SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 4, 1).setStyle(SegmentGroupTableBuilder.this.leftSa, Styles.getEmptySA());
            if (SegmentGroupTableBuilder.this.isShowTotal) {
                if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                    SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 6, 1).setStyle(SegmentGroupTableBuilder.this.leftSa, Styles.getEmptySA());
                } else {
                    SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 5, 1).setStyle(SegmentGroupTableBuilder.this.leftSa, Styles.getEmptySA());
                }
            }
            if (!SegmentGroupTableBuilder.this.isShowSubTotal) {
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 4, 0, SegmentGroupTableBuilder.this.startRow + 4, 65535).insert(true);
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 4, 0, SegmentGroupTableBuilder.this.startRow + 4, 65535).setRowHeight(1);
                SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 4, 0, true).getExtProps(true).setHead(ref, true);
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 1, 0, SegmentGroupTableBuilder.this.startRow + 4, SegmentGroupTableBuilder.this.fieldSize + 1).setStyle(SegmentGroupTableBuilder.this.borderSa, Styles.getEmptySA());
            }
        }
    }

    private class Classic1Builder
    implements DesignBuilder {
        private Classic1Builder() {
        }

        @Override
        public void build() {
            SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 2, 0, SegmentGroupTableBuilder.this.startRow + 2, 65535).insert(true);
            SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 2, 0, SegmentGroupTableBuilder.this.startRow + 2, 65535).setRowHeight(1);
            if (SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 1, 0, false) == null) {
                return;
            }
            String ref = SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 1, 0, false).getName(false, false);
            SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 2, 0, true).getExtProps(true).setHead(ref, true);
            SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 1, 0, SegmentGroupTableBuilder.this.startRow + 1, SegmentGroupTableBuilder.this.fieldSize - 1).setStyle(SegmentGroupTableBuilder.this.segmentSa, Styles.getEmptySA());
            SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 2, 0, true).setFormula("=EXINDEX(" + ref + ")");
            String refIndex = SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 2, 0, false).getName(false, false);
            for (int i = 0; i < SegmentGroupTableBuilder.this.fieldSize; ++i) {
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow, i).setStyle(SegmentGroupTableBuilder.this.titleSa, Styles.getEmptySA());
                if (TableStyleDesign.CLASSIC2 == SegmentGroupTableBuilder.this.tableStyle.getDesign()) {
                    SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 1, i, true).getExtProps(true).getFormulas(true).insert(ExtProps.FORMULA_BACKGROUND, "IF(MOD(" + refIndex + ", 2) = 0, RGB(245, 244, 249), RGB(255, 255, 255))");
                    SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 3, i, true).getExtProps(true).getFormulas(true).insert(ExtProps.FORMULA_BACKGROUND, "IF(MOD(" + refIndex + ", 2) = 0, RGB(245, 244, 249), RGB(255, 255, 255))");
                }
                if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                    SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 4, i).setStyle(SegmentGroupTableBuilder.this.subTotalSa, Styles.getEmptySA());
                }
                if (!SegmentGroupTableBuilder.this.isShowTotal) continue;
                if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                    SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 5, i).setStyle(SegmentGroupTableBuilder.this.totalSa, Styles.getEmptySA());
                    continue;
                }
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 4, i).setStyle(SegmentGroupTableBuilder.this.totalSa, Styles.getEmptySA());
            }
            SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 3, 0, SegmentGroupTableBuilder.this.startRow + 3, SegmentGroupTableBuilder.this.fieldSize - 1).setStyle(SegmentGroupTableBuilder.this.whiteSa, Styles.getEmptySA());
            int endRow = SegmentGroupTableBuilder.this.startRow + 3;
            if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                SegmentGroupTableBuilder.this.setFormulaTotal(SegmentGroupTableBuilder.this.startRow + 4, 0, "\u5c0f\u8ba1");
                String ref2 = SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 1, 0, false).getName(false, false);
                SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 4, 0, false).getExtProps(true).setHead(ref2, true);
                endRow = SegmentGroupTableBuilder.this.startRow + 4;
            }
            if (SegmentGroupTableBuilder.this.isShowTotal) {
                if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                    SegmentGroupTableBuilder.this.setFormulaTotal(SegmentGroupTableBuilder.this.startRow + 5, 0, "\u603b\u8ba1");
                    endRow = SegmentGroupTableBuilder.this.startRow + 5;
                } else {
                    SegmentGroupTableBuilder.this.setFormulaTotal(SegmentGroupTableBuilder.this.startRow + 4, 0, "\u603b\u8ba1");
                    endRow = SegmentGroupTableBuilder.this.startRow + 4;
                }
            }
            SegmentGroupTableBuilder.this.buildSpecialSA(SegmentGroupTableBuilder.this.startRow, endRow, true);
            SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 1, 0).setStyle(SegmentGroupTableBuilder.this.leftSa, Styles.getEmptySA());
            if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 4, 0).setStyle(SegmentGroupTableBuilder.this.leftSa, Styles.getEmptySA());
            }
            if (SegmentGroupTableBuilder.this.isShowTotal) {
                if (SegmentGroupTableBuilder.this.isShowSubTotal) {
                    SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 5, 0).setStyle(SegmentGroupTableBuilder.this.leftSa, Styles.getEmptySA());
                } else {
                    SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 4, 0).setStyle(SegmentGroupTableBuilder.this.leftSa, Styles.getEmptySA());
                }
            }
            if (TableStyleDesign.CLASSIC1 == SegmentGroupTableBuilder.this.tableStyle.getDesign() && !SegmentGroupTableBuilder.this.isShowSubTotal) {
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 4, 0, SegmentGroupTableBuilder.this.startRow + 4, 65535).insert(true);
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 4, 0, SegmentGroupTableBuilder.this.startRow + 4, 65535).setRowHeight(0);
                SegmentGroupTableBuilder.this.sheet.getCell(SegmentGroupTableBuilder.this.startRow + 4, 0, true).getExtProps(true).setHead(ref, true);
                SegmentGroupTableBuilder.this.sheet.getRange(SegmentGroupTableBuilder.this.startRow + 4, 0, SegmentGroupTableBuilder.this.startRow, SegmentGroupTableBuilder.this.fieldSize - 1).setStyle(SegmentGroupTableBuilder.this.borderSaBottom, Styles.getEmptySA());
            }
        }
    }
}

