/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.impl;

import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.AbstractListTableBuilder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.DesignBuilder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.MobileReportWizardModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.ReportType;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.TableType;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.style.TableStyleDesign;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.expans.model.ExtProps;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;

public class SegmentListTableBuilder
extends AbstractListTableBuilder {
    public SegmentListTableBuilder(KDExt ext, MobileReportWizardModel model, int startRow) {
        super(ext, model);
        this.startRow = startRow;
    }

    @Override
    public void build() {
        super.build();
        this.buildSegmentList(this.startRow);
        this.buildSegmentListSa(this.startRow);
    }

    private void buildSegmentList(int startRow) {
        for (int i = 0; i < this.fieldSize; ++i) {
            if (this.tableModel.getFieldList().get(i) != null) {
                String field = this.tableModel.getFieldList().get(i).toString();
                Cell cell = this.sheet.getCell(startRow, i, true);
                cell.setValue(new Variant(field));
                this.buildSegment(startRow + 1, i, this.tableModel.getSegment());
            }
            this.buildTotal(startRow + 3, i, startRow + 2);
        }
    }

    private void buildSegmentListSa(int startRow) {
        DesignBuilder builder = null;
        switch (this.model.getTableModel().getTableStyle().getDesign()) {
            case CLASSIC1: {
                builder = new Classic1Builder();
                break;
            }
            case ECLIPSE: {
                builder = new EclipseBuilder();
                break;
            }
            default: {
                builder = new Classic3Builder();
            }
        }
        builder.build();
    }

    private void buildSegment(int startRow, int index, String segment) {
        this.sheet.getCell(startRow, 0, true).setFormula(this.buildFullFormula(this.tableModel.getCurrentDs().getAlias(), segment));
        this.sheet.getMerger(true).insert(CellBlock.getCellBlock(startRow, 0, startRow, index));
        this.sheet.getCell(startRow + 1, index, true).setFormula(this.buildSmartFormula(this.tableModel.getCurrentDs().getAlias(), this.tableModel.getFieldList().get(index).toString()));
    }

    @Override
    public ReportType getReportType() {
        return ReportType.TABLE;
    }

    @Override
    public TableStyleDesign[] getDesigns() {
        return new TableStyleDesign[]{TableStyleDesign.CLASSIC1, TableStyleDesign.CLASSIC2, TableStyleDesign.CLASSIC3, TableStyleDesign.CLASSIC4};
    }

    @Override
    public TableType getTableType() {
        return TableType.SEGMENTLIST;
    }

    private class EclipseBuilder
    implements DesignBuilder {
        private EclipseBuilder() {
        }

        @Override
        public void build() {
            SegmentListTableBuilder.this.sheet.getRange(0, 0, 1048575, 0).insert(false);
            SegmentListTableBuilder.this.sheet.getRange(0, 0, 1048575, 0).setColumnWidth(10);
            SegmentListTableBuilder.this.sheet.getRange(0, SegmentListTableBuilder.this.fieldSize + 1, 1048575, SegmentListTableBuilder.this.fieldSize + 1).insert(false);
            SegmentListTableBuilder.this.sheet.getRange(0, SegmentListTableBuilder.this.fieldSize + 1, 1048575, SegmentListTableBuilder.this.fieldSize + 1).setColumnWidth(10);
            for (int i = 0; i < SegmentListTableBuilder.this.fieldSize + 2; ++i) {
                SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow, i).setStyle(SegmentListTableBuilder.this.titleSa, Styles.getEmptySA());
                SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow + 2, i).setStyle(SegmentListTableBuilder.this.detailSa, Styles.getEmptySA());
                if (!SegmentListTableBuilder.this.isShowTotal) continue;
                SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow + 3, i).setStyle(SegmentListTableBuilder.this.totalSa, Styles.getEmptySA());
            }
            SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow + 1, 0, SegmentListTableBuilder.this.startRow + 1, SegmentListTableBuilder.this.fieldSize + 1).setStyle(SegmentListTableBuilder.this.segmentSa, Styles.getEmptySA());
            String ref = SegmentListTableBuilder.this.sheet.getCell(SegmentListTableBuilder.this.startRow + 1, 1, false).getName(false, false);
            SegmentListTableBuilder.this.sheet.getCell(SegmentListTableBuilder.this.startRow + 1, 0, false).getExtProps(true).setHead(ref, true);
            SegmentListTableBuilder.this.sheet.getCell(SegmentListTableBuilder.this.startRow + 2, 0, false).getExtProps(true).setHead(ref, true);
            int endRow = SegmentListTableBuilder.this.startRow + 2;
            if (SegmentListTableBuilder.this.isShowTotal) {
                SegmentListTableBuilder.this.setFormulaTotal(SegmentListTableBuilder.this.startRow + 3, 1, "\u603b\u8ba1");
                endRow = SegmentListTableBuilder.this.startRow + 3;
            }
            SegmentListTableBuilder.this.buildSpecialSA(SegmentListTableBuilder.this.startRow, endRow, false);
            SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow + 1, 1).setStyle(SegmentListTableBuilder.this.leftSa, Styles.getEmptySA());
            if (SegmentListTableBuilder.this.isShowTotal) {
                SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow + 3, 1).setStyle(SegmentListTableBuilder.this.leftSa, Styles.getEmptySA());
            }
        }
    }

    private class Classic3Builder
    implements DesignBuilder {
        private Classic3Builder() {
        }

        @Override
        public void build() {
            SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow + 3, 0, SegmentListTableBuilder.this.startRow + 3, 65535).insert(true);
            SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow + 3, 0, SegmentListTableBuilder.this.startRow + 3, 65535).setRowHeight(8);
            SegmentListTableBuilder.this.sheet.getRange(0, 0, 1048575, 0).insert(false);
            SegmentListTableBuilder.this.sheet.getRange(0, 0, 1048575, 0).setColumnWidth(10);
            SegmentListTableBuilder.this.sheet.getRange(0, SegmentListTableBuilder.this.fieldSize + 1, 1048575, SegmentListTableBuilder.this.fieldSize + 1).insert(false);
            SegmentListTableBuilder.this.sheet.getRange(0, SegmentListTableBuilder.this.fieldSize + 1, 1048575, SegmentListTableBuilder.this.fieldSize + 1).setColumnWidth(10);
            for (int i = 0; i < SegmentListTableBuilder.this.fieldSize + 2; ++i) {
                SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow, i).setStyle(SegmentListTableBuilder.this.titleSa, Styles.getEmptySA());
                SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow + 2, i).setStyle(SegmentListTableBuilder.this.detailSa, Styles.getEmptySA());
                if (!SegmentListTableBuilder.this.isShowTotal) continue;
                SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow + 4, i).setStyle(SegmentListTableBuilder.this.totalSa, Styles.getEmptySA());
            }
            int endRow = SegmentListTableBuilder.this.startRow + 3;
            if (SegmentListTableBuilder.this.isShowTotal) {
                SegmentListTableBuilder.this.setFormulaTotal(SegmentListTableBuilder.this.startRow + 4, 1, "\u603b\u8ba1");
                endRow = SegmentListTableBuilder.this.startRow + 4;
            }
            SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow + 1, 0, SegmentListTableBuilder.this.startRow + 1, SegmentListTableBuilder.this.fieldSize + 1).setStyle(SegmentListTableBuilder.this.whiteSa, Styles.getEmptySA());
            SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow + 1, 0, SegmentListTableBuilder.this.startRow + 1, SegmentListTableBuilder.this.fieldSize + 1).setStyle(SegmentListTableBuilder.this.boldSa, Styles.getEmptySA());
            SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow + 1, 1, SegmentListTableBuilder.this.startRow + 1, SegmentListTableBuilder.this.fieldSize).setStyle(SegmentListTableBuilder.this.borderSaBottom, Styles.getEmptySA());
            SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow + 1, 0, SegmentListTableBuilder.this.startRow + 2, SegmentListTableBuilder.this.fieldSize + 1).setStyle(SegmentListTableBuilder.this.borderSa, Styles.getEmptySA());
            String ref = SegmentListTableBuilder.this.sheet.getCell(SegmentListTableBuilder.this.startRow + 1, 1, true).getName(false, false);
            SegmentListTableBuilder.this.sheet.getCell(SegmentListTableBuilder.this.startRow + 1, 0, true).getExtProps(true).setHead(ref, true);
            SegmentListTableBuilder.this.sheet.getCell(SegmentListTableBuilder.this.startRow + 2, 0, true).getExtProps(true).setHead(ref, true);
            SegmentListTableBuilder.this.sheet.getCell(SegmentListTableBuilder.this.startRow + 3, 0, true).getExtProps(true).setHead(ref, true);
            SegmentListTableBuilder.this.buildSpecialSA(SegmentListTableBuilder.this.startRow, endRow, false);
            SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow + 1, 1).setStyle(SegmentListTableBuilder.this.leftSa, Styles.getEmptySA());
            if (SegmentListTableBuilder.this.isShowTotal) {
                SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow + 4, 1).setStyle(SegmentListTableBuilder.this.leftSa, Styles.getEmptySA());
            }
        }
    }

    private class Classic1Builder
    implements DesignBuilder {
        private Classic1Builder() {
        }

        @Override
        public void build() {
            SegmentListTableBuilder.this.sheet.getRange(0, 0, 1048575, 0).insert(false);
            SegmentListTableBuilder.this.sheet.getRange(0, 0, 1048575, 0).setColumnWidth(10);
            SegmentListTableBuilder.this.sheet.getRange(0, SegmentListTableBuilder.this.fieldSize + 1, 1048575, SegmentListTableBuilder.this.fieldSize + 1).insert(false);
            SegmentListTableBuilder.this.sheet.getRange(0, SegmentListTableBuilder.this.fieldSize + 1, 1048575, SegmentListTableBuilder.this.fieldSize + 1).setColumnWidth(10);
            for (int i = 0; i < SegmentListTableBuilder.this.fieldSize + 2; ++i) {
                SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow, i).setStyle(SegmentListTableBuilder.this.titleSa, Styles.getEmptySA());
                SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow + 2, i).setStyle(SegmentListTableBuilder.this.detailSa, Styles.getEmptySA());
                if (TableStyleDesign.CLASSIC2 == SegmentListTableBuilder.this.tableStyle.getDesign() || TableStyleDesign.CLASSIC4 == SegmentListTableBuilder.this.tableStyle.getDesign()) {
                    SegmentListTableBuilder.this.sheet.getCell(SegmentListTableBuilder.this.startRow + 1, i, true).getExtProps(true).getFormulas(true).insert(ExtProps.FORMULA_BACKGROUND, "IF(MOD(ROW(), 4) = 0, RGB(245, 244, 249))");
                    SegmentListTableBuilder.this.sheet.getCell(SegmentListTableBuilder.this.startRow + 2, i, true).getExtProps(true).getFormulas(true).insert(ExtProps.FORMULA_BACKGROUND, "IF(MOD(ROW(), 4) = 1, RGB(245, 244, 249))");
                }
                if (!SegmentListTableBuilder.this.isShowTotal) continue;
                SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow + 3, i).setStyle(SegmentListTableBuilder.this.totalSa, Styles.getEmptySA());
            }
            SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow + 1, 0, SegmentListTableBuilder.this.startRow + 1, SegmentListTableBuilder.this.fieldSize + 1).setStyle(SegmentListTableBuilder.this.whiteSa, Styles.getEmptySA());
            SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow, 0, SegmentListTableBuilder.this.startRow, SegmentListTableBuilder.this.fieldSize + 1).setStyle(SegmentListTableBuilder.this.borderSaBottom, Styles.getEmptySA());
            SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow + 1, 1, SegmentListTableBuilder.this.startRow + 1, SegmentListTableBuilder.this.fieldSize).setStyle(SegmentListTableBuilder.this.borderSaBottom, Styles.getEmptySA());
            SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow + 2, 0, SegmentListTableBuilder.this.startRow + 2, SegmentListTableBuilder.this.fieldSize).setStyle(SegmentListTableBuilder.this.borderSaBottom, Styles.getEmptySA());
            SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow + 1, 1).setStyle(SegmentListTableBuilder.this.boldSa, Styles.getEmptySA());
            String ref = SegmentListTableBuilder.this.sheet.getCell(SegmentListTableBuilder.this.startRow + 1, 1, false).getName(false, false);
            SegmentListTableBuilder.this.sheet.getCell(SegmentListTableBuilder.this.startRow + 1, 0, false).getExtProps(true).setHead(ref, true);
            SegmentListTableBuilder.this.sheet.getCell(SegmentListTableBuilder.this.startRow + 2, 0, false).getExtProps(true).setHead(ref, true);
            int endRow = SegmentListTableBuilder.this.startRow + 2;
            if (SegmentListTableBuilder.this.isShowTotal) {
                SegmentListTableBuilder.this.setFormulaTotal(SegmentListTableBuilder.this.startRow + 3, 1, "\u603b\u8ba1");
                endRow = SegmentListTableBuilder.this.startRow + 3;
            }
            SegmentListTableBuilder.this.buildSpecialSA(SegmentListTableBuilder.this.startRow, endRow, false);
            SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow + 1, 1).setStyle(SegmentListTableBuilder.this.leftSa, Styles.getEmptySA());
            if (SegmentListTableBuilder.this.isShowTotal) {
                SegmentListTableBuilder.this.sheet.getRange(SegmentListTableBuilder.this.startRow + 3, 1).setStyle(SegmentListTableBuilder.this.leftSa, Styles.getEmptySA());
            }
        }
    }
}

