/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.mobile.designer;

import com.kingdee.bos.ctrl.common.util.ReflectUtil;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.designer.AbstractViewBuilder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.designer.View1Builder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.designer.View2Builder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.designer.View3Builder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.designer.View4Builder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.TableStyleModel;
import com.kingdee.bos.ctrl.kds.core.KDSpread;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.lang.reflect.Constructor;
import org.jfree.layout.CenterLayout;

public class StyleDisplayPanel
extends KDPanel {
    private static final long serialVersionUID = 8402190554980190230L;
    private transient Sheet sheet;
    private transient TableStyleModel styleModel;
    private KDSpread kdSpread;
    private transient Book book;
    private int displayRows = 12;
    private transient AbstractViewBuilder builder1;
    private transient AbstractViewBuilder builder2;
    private transient AbstractViewBuilder builder3;
    private transient AbstractViewBuilder builder4;

    public StyleDisplayPanel(TableStyleModel model) {
        this.styleModel = model;
        this.init();
    }

    public TableStyleModel getStyleModel() {
        return this.styleModel;
    }

    public void setStyleModel(TableStyleModel styleModel) {
        this.styleModel = styleModel;
    }

    private void init() {
        try {
            Constructor boConstructor = Book.class.getDeclaredConstructor(String.class, Integer.TYPE);
            ReflectUtil.makeAccessible(boConstructor);
            this.book = (Book)boConstructor.newInstance("\u6d4b\u8bd5\u5de5\u4f5c\u7c3f", 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SpreadContext cxt = new SpreadContext(this.book);
        this.kdSpread = cxt.getSpread();
        this.kdSpread.setPreferredSize(new Dimension(600, 1200));
        this.sheet = this.book.getSheet(0);
        KDPanel tableStylePanel = new KDPanel();
        tableStylePanel.add((Component)this.kdSpread);
        this.setLayout((LayoutManager)new CenterLayout());
        this.add((Component)tableStylePanel, "Center");
        this.setPreferredSize(new Dimension(600, 1200));
        this.sheet.getSheetOption().getSelection().changeSelection(CellBlock.getCellBlock(0, 8), 2);
        this.builder1 = new View1Builder(this.displayRows, this.sheet, this.styleModel);
        this.builder2 = new View2Builder(this.displayRows, this.sheet, this.styleModel);
        this.builder3 = new View3Builder(this.displayRows, this.sheet, this.styleModel);
        this.builder4 = new View4Builder(this.displayRows, this.sheet, this.styleModel);
        this.initAllViews();
    }

    public void prepare2ScreenShot() {
        this.sheet.getSheetOption().getSelection().changeSelection(CellBlock.getCellBlock(0, 8), 2);
    }

    public void setAllViewStyle(TableStyleModel model) {
        this.setViewStyle(1, model);
        this.setViewStyle(2, model);
        this.setViewStyle(3, model);
        this.setViewStyle(4, model);
    }

    private void initAllViews() {
        this.initView(1);
        this.initView(2);
        this.initView(3);
        this.initView(4);
    }

    public void setViewStyle(int n, TableStyleModel model) {
        switch (n) {
            case 1: {
                this.builder1.setModel(model);
                this.builder1.initStyle();
                break;
            }
            case 2: {
                this.builder2.setModel(model);
                this.builder2.initStyle();
                break;
            }
            case 3: {
                this.builder3.setModel(model);
                this.builder3.initStyle();
                break;
            }
            case 4: {
                this.builder4.setModel(model);
                this.builder4.initStyle();
                break;
            }
        }
    }

    public Point[] getCellPoints(int x1, int y1, int x2, int y2) {
        Point startPiont = this.kdSpread.getLocationOnScreen();
        Point p1 = this.calcPoint(x1, y1);
        Point p2 = this.calcPoint(x2, y2);
        p1.setLocation(startPiont.getX() + p1.getX() + 1.0, startPiont.getY() + p1.getY() + 1.0);
        p2.setLocation(startPiont.getX() + p2.getX() - 1.0, startPiont.getY() + p2.getY() - 1.0);
        return new Point[]{p1, p2};
    }

    public Point[] getViewPoints(int n) {
        Point[] result = null;
        switch (n) {
            case 1: {
                result = this.getCellPoints(0, 0, this.displayRows + 1, 3);
                break;
            }
            case 2: {
                result = this.getCellPoints(0, 4, this.displayRows + 1, 7);
                break;
            }
            case 3: {
                result = this.getCellPoints(this.displayRows + 2, 0, this.displayRows * 2 + 3, 3);
                break;
            }
            case 4: {
                result = this.getCellPoints(this.displayRows + 2, 4, this.displayRows * 2 + 3, 7);
                break;
            }
        }
        return result;
    }

    private Point calcPoint(int cellx, int celly) {
        Point p = new Point();
        int y = Sheet.getRowY(this.sheet, cellx);
        int x = Sheet.getColX(this.sheet, celly);
        p.setLocation(x + this.sheet.getRowHeaderWidth(), y + this.sheet.getColHeaderHeight());
        return p;
    }

    private void initView(int n) {
        switch (n) {
            case 1: {
                this.builder1.build();
                break;
            }
            case 2: {
                this.builder2.build();
                break;
            }
            case 3: {
                this.builder3.build();
                break;
            }
            case 4: {
                this.builder4.build();
                break;
            }
        }
    }
}

