/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.icons.ResourceManager;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.ReportType;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.TableStyleDescriptionModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.TableStyleFileModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.TableStyleModel;
import java.awt.Image;
import java.util.LinkedHashMap;
import java.util.Map;

public enum StyleModelMannager {
    INSTANCE;

    private Map<String, TableStyleModel> tableStyleMap = new LinkedHashMap<String, TableStyleModel>();
    public static final String STYLE_FILE_PATH = "tableStyles.json";
    public static final String CHARSET = "UTF-8";
    private TableStyleFileModel fileModel;

    private StyleModelMannager() {
        this.initStyles(STYLE_FILE_PATH);
    }

    public TableStyleModel geTableStyleModel(String key) {
        return this.tableStyleMap.get(key);
    }

    public Map<String, TableStyleModel> getStyleMap() {
        return this.tableStyleMap;
    }

    public Map<String, TableStyleModel> getTableStyleMap() {
        return this.getStyleMap(ReportType.TABLE);
    }

    public Map<String, TableStyleModel> getChartTableStyleMap() {
        return this.getStyleMap(ReportType.CHARTTABLE);
    }

    public Map<String, TableStyleModel> getStyleMap(ReportType type) {
        LinkedHashMap<String, TableStyleModel> result = new LinkedHashMap<String, TableStyleModel>();
        for (Map.Entry<String, TableStyleModel> entry : this.tableStyleMap.entrySet()) {
            if (!entry.getValue().getReportType().equals(type.name())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public Image getStyleImage(TableStyleModel model) {
        if (null != model.getPicName()) {
            return ResourceManager.getBufferedImage(model.getPicName());
        }
        return null;
    }

    public TableStyleFileModel getFileModel() {
        return this.fileModel;
    }

    private void initStyles(String path) {
        String jsonStr = ResourceManager.getSourceAsString(path, CHARSET);
        this.fileModel = (TableStyleFileModel)JSON.parseObject((String)jsonStr, TableStyleFileModel.class);
        for (Map.Entry<String, TableStyleDescriptionModel> entry : this.fileModel.getTableStyleMap().entrySet()) {
            String name = entry.getKey();
            TableStyleDescriptionModel descriptionModel = entry.getValue();
            String filePath = descriptionModel.getStyleFilePath();
            jsonStr = ResourceManager.getSourceAsString(filePath, CHARSET);
            TableStyleModel styleModel = (TableStyleModel)JSON.parseObject((String)jsonStr, TableStyleModel.class);
            styleModel.setReportType(descriptionModel.getReportType());
            styleModel.setDesign(descriptionModel.getDesign());
            styleModel.setPicName(descriptionModel.getPicPath());
            styleModel.setDisplayName(descriptionModel.getDisPlayName());
            this.tableStyleMap.put(name, styleModel);
        }
    }

    public static void main(String[] args) {
        StyleModelMannager mannager = INSTANCE;
        for (Map.Entry<String, TableStyleModel> entry : mannager.tableStyleMap.entrySet()) {
            System.out.println(entry.getKey() + "\t" + entry.getValue());
        }
    }
}

