/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.mobile.ui;

import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.chartpanelImpl.datachooser.DataLabelUtil;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.chartpanelImpl.datachooser.dataset.AbstractChartKindOf;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.FusionGraphicsModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.bos.ctrl.ext.ui.wizards.data.DatasetImporter;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.icons.ResourceManager;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.MobileReportWizardModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.ReportType;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.ui.AbstractMobileReportWizardPanel;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.model.struct.embed.dataset.DataFromDataset;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.EChartDisplayPanel;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;

public class ChartComposerPanel
extends AbstractMobileReportWizardPanel {
    private DatasetImporter importerPanel;
    private KDPanel contentPanel;
    private KDPanel dataSetPanel = new KDPanel();
    private AbstractChartKindOf chartKindOf;
    private KDTextField chartTitle;
    private KDExt kdExt;
    private List all;
    private KDComboBox boxDs;
    private ExtDataSet currentDs;
    private Graphics g;
    private List<String> littleWizardNameList;
    private MobileReportWizardModel model;
    private List<Integer> littleWizardLengthList;
    private boolean isChartComposerPanel = true;
    private ItemListener datasetItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1 && ChartComposerPanel.this.isChartComposerPanel) {
                ChartComposerPanel.this.addMoreDataSet(ChartComposerPanel.this.boxDs.getSelectedItem());
            }
        }
    };

    public ChartComposerPanel() {
        this.contentPanel.setLayout(null);
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.g = g;
        this.drawLittleWizard(g);
    }

    @Override
    protected String getLabPicIconName() {
        return "step4";
    }

    @Override
    protected JComponent getContentPanel() {
        this.contentPanel = new KDPanel();
        return this.contentPanel;
    }

    private void drawLittleWizard(Graphics g) {
        String[] str = new String[]{"\u2460", "\u2461", "\u2462", "\u2463", "\u2464", "\u2465"};
        if (ReportType.CHART == this.model.getReportType()) {
            int fontSize = 12;
            for (int i = 0; i < this.littleWizardNameList.size(); ++i) {
                KDLabel label = new KDLabel();
                Font f = new Font("\u65b0\u5b8b\u4f53", 1, fontSize);
                String text = " " + str[i] + " " + this.littleWizardNameList.get(i);
                g.getFontMetrics(f).stringWidth(text);
            }
        }
    }

    public void initComps(KDExt ext, MobileReportWizardModel model, DatasetImporter ds, int index) {
        KDLabel label;
        this.kdExt = ext;
        this.model = model;
        List<FusionGraphicsModel> fusionGraphicsModelList = model.getChartModel().getFusionGraphicsModelList();
        List<String> littleWizardNameList = model.getSecondaryStepNames();
        this.littleWizardNameList = littleWizardNameList;
        this.littleWizardLengthList = new ArrayList<Integer>();
        FlashChartType flashChartType = fusionGraphicsModelList.get(index).getChartType();
        FusionChartDataNode node = fusionGraphicsModelList.get(index).getDataNode();
        DataFromDataset fromDataset = node.getFromDataset();
        AbstractFusionBean bean = fusionGraphicsModelList.get(index).getBean();
        String title = bean.getChartTitle();
        this.importerPanel = ds;
        this.all = this.importerPanel.getAllExtDataSets();
        this.currentDs = (ExtDataSet)this.importerPanel.getSelectedExtDataSets().get(0);
        KDPanel wizardPanel = new KDPanel();
        wizardPanel.setLayout(null);
        String[] str = new String[]{"\u2460", "\u2461", "\u2462", "\u2463", "\u2464", "\u2465"};
        if (ReportType.CHART == model.getReportType()) {
            int fontSize = 12;
            for (int i = 0; i < littleWizardNameList.size(); ++i) {
                label = new KDLabel();
                Font f = new Font("\u65b0\u5b8b\u4f53", 1, fontSize);
                String text = " " + str[i] + " " + littleWizardNameList.get(i);
                if (i <= index) {
                    label.setText(text);
                    label.setFont(f);
                    label.setForeground(new Color(53, 169, 228));
                    label.setIcon((Icon)ResourceManager.getImageIcon("arrow_blue.png"));
                    if (i == 0) {
                        label.setIcon(null);
                    }
                } else {
                    label.setText(text);
                    label.setFont(f);
                    label.setForeground(new Color(186, 185, 186));
                    label.setIcon((Icon)ResourceManager.getImageIcon("arrow_gray.png"));
                }
                FontMetrics metrics = new FontMetrics(f){};
                Rectangle2D bounds = metrics.getStringBounds(text, null);
                int width = (int)bounds.getWidth() + 40;
                label.setBounds(wizardPanel.getWidth(), 0, width, 20);
                if (i == 0) {
                    label.setBounds(0, 0, width - 30, 20);
                }
                wizardPanel.add((Component)label);
                wizardPanel.setBounds(390 - (wizardPanel.getWidth() + label.getWidth()) / 2, 10, wizardPanel.getWidth() + label.getWidth(), 20);
                this.littleWizardLengthList.add(wizardPanel.getWidth());
            }
            if (wizardPanel.getX() < 0) {
                wizardPanel.setBounds(0, 10, wizardPanel.getWidth(), 20);
                if (this.littleWizardLengthList.get(index) > 780) {
                    wizardPanel.setBounds(780 - wizardPanel.getWidth(), 10, wizardPanel.getWidth(), 20);
                }
            }
        } else if (ReportType.CHARTTABLE == model.getReportType()) {
            Font f = new Font("\u65b0\u5b8b\u4f53", 1, 12);
            FontMetrics metrics = new FontMetrics(f){};
            label = new KDLabel();
            String text = " \u2460 " + littleWizardNameList.get(0);
            label.setText(text);
            label.setFont(f);
            label.setForeground(new Color(53, 169, 228));
            Rectangle2D bounds = metrics.getStringBounds(text, null);
            int width = (int)bounds.getWidth() + 10;
            label.setBounds(0, 0, width, 20);
            KDLabel label1 = new KDLabel();
            String text1 = " \u2461 " + littleWizardNameList.get(1);
            label1.setText(text1);
            label1.setFont(f);
            label1.setForeground(new Color(186, 185, 186));
            label1.setIcon((Icon)ResourceManager.getImageIcon("arrow_gray.png"));
            Rectangle2D bounds1 = metrics.getStringBounds(text1, null);
            int width1 = (int)bounds1.getWidth() + 40;
            label1.setBounds(width, 0, width1, 20);
            wizardPanel.add((Component)label);
            wizardPanel.add((Component)label1);
            wizardPanel.setBounds(390 - (width + width1) / 2, 10, width + width1, 20);
        }
        this.contentPanel.add((Component)wizardPanel);
        this.chartTitle = new KDTextField();
        this.chartTitle.setText(title);
        KDLabelContainer containerChartTitle = CtrlSwingUtilities.createLabelContainer((JComponent)this.chartTitle, (String)"\u56fe\u8868\u6807\u9898", (int)100);
        containerChartTitle.setBounds(0, 240, 260, 19);
        this.contentPanel.add((Component)containerChartTitle);
        EChartDisplayPanel displayPanel = new EChartDisplayPanel(true);
        FusionGraphicsModel m = new FusionGraphicsModel();
        m.setChartType(flashChartType);
        m.getBean().setChartType(flashChartType);
        displayPanel.setModel(m);
        displayPanel.execute();
        displayPanel.setBounds(0, 43, 720, 192);
        this.contentPanel.add((Component)((Object)displayPanel));
        this.dataSetPanel.setLayout(null);
        this.dataSetPanel.setBounds(0, 267, 616, 189);
        this.chartKindOf = DataLabelUtil.getChartKindOf(flashChartType);
        this.chartKindOf.setDataPanel(this.dataSetPanel);
        this.chartKindOf.addToDataPanel(this.all);
        this.chartKindOf.refreshData();
        this.boxDs = this.chartKindOf.getBoxDataset();
        this.boxDs.addItem((Object)"\u5f15\u5165\u66f4\u591a\u6570\u636e\u96c6...");
        this.boxDs.addItemListener(this.datasetItemListener);
        if (fromDataset != null) {
            this.chartKindOf.syncModel2UI(fromDataset);
        } else {
            this.boxDs.setSelectedItem((Object)this.currentDs, true);
        }
        this.contentPanel.add((Component)this.dataSetPanel);
    }

    private void addMoreDataSet(Object selectedItem) {
        if ("\u5f15\u5165\u66f4\u591a\u6570\u636e\u96c6...".equals(selectedItem) && !(selectedItem instanceof ExtDataSet)) {
            this.boxDs.hidePopup();
            this.importerPanel.getAdd().doClick();
            List all = this.importerPanel.getAllExtDataSets();
            if (all.size() == 0) {
                this.boxDs.setSelectedItem(null, false);
                return;
            }
            ExtDataSet currentDs = (ExtDataSet)this.importerPanel.getSelectedExtDataSets().get(0);
            this.boxDs.removeAllItems();
            for (int i = 0; i < all.size(); ++i) {
                if (all.get(i).equals(this.boxDs.getItemAt(i))) continue;
                this.boxDs.addItem(all.get(i));
            }
            this.boxDs.addItem((Object)"\u5f15\u5165\u66f4\u591a\u6570\u636e\u96c6...");
            this.boxDs.setSelectedItem((Object)currentDs, true);
        }
    }

    public AbstractChartKindOf getChartKindOf() {
        return this.chartKindOf;
    }

    public String getChartTitle() {
        return this.chartTitle.getText();
    }

    public void setChartComposerPanel(boolean isChartComposerPanel) {
        this.isChartComposerPanel = isChartComposerPanel;
    }
}

