/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.expans.model.data;

import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.immit.IRptRuntimeCallback;
import com.kingdee.bos.ctrl.ext.ui.wizards.showcase.TreeDisplayMode;
import com.kingdee.bos.ctrl.extcommon.util.ObjectArray;
import com.kingdee.bos.ctrl.extcommon.util.ObjectCache;
import com.kingdee.bos.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.bos.ctrl.extcommon.variant.ExprErr;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.exec.ExecutionContext;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtColumn;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetType;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDynamicDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtFuncProvider;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtGroup;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtGroupTreeNode;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtRow;
import com.kingdee.bos.ctrl.kds.expans.model.data.FieldPermission;
import com.kingdee.bos.ctrl.kds.expans.model.data.FieldPermissionException;
import com.kingdee.bos.ctrl.kds.expans.model.data.ReportFieldUtil;
import com.kingdee.bos.ctrl.kds.model.expr.ExcelFuncProvider;
import com.kingdee.bos.ctrl.kds.model.expr.Expr;
import com.kingdee.bos.ctrl.kds.model.expr.ExprContext;
import com.kingdee.bos.ctrl.kds.model.expr.IExprBuffer;
import com.kingdee.bos.ctrl.kds.model.expr.IInnerFuncProvider;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.ICalculable;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.kds.model.struct.Span;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public class ExtendFuncProvider
implements IInnerFuncProvider {
    static final ExtendFuncProvider inst = new ExtendFuncProvider();

    public Variant $E(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 1);
        Variant var = (Variant)args[0];
        if (!(var.isArray() || var.getValue() instanceof ExtGroup || var.isNull())) {
            ExprErr.goError(16L, null);
        }
        return var;
    }

    public Variant TO(Object[] args) throws SyntaxErrorException {
        Variant varResult;
        ExcelFuncProvider.validParamCount(args, 2, 3);
        try {
            boolean ascent;
            Variant step;
            Variant begin = new Variant(this._getSingleValue((Variant)args[0]));
            Variant end = new Variant(this._getSingleValue((Variant)args[1]));
            ExcelFuncProvider.validNumericParam("Begin", begin);
            ExcelFuncProvider.validNumericParam("End", end);
            int cmp = begin.compareTo(end);
            if (cmp == 0) {
                return begin;
            }
            if (args.length == 3) {
                step = (Variant)args[2];
                ExcelFuncProvider.validNumericParam("Step", step);
                if (cmp < 0) {
                    if (step.doubleValue() <= 0.0) {
                        ExprErr.goError(16L, "Cannot End");
                    }
                } else if (cmp > 0 && step.doubleValue() >= 0.0) {
                    ExprErr.goError(16L, "Cannot End");
                }
            } else {
                step = new Variant(cmp < 0 ? 1L : -1L);
            }
            ObjectArray al = new ObjectArray();
            boolean bl = ascent = cmp < 1;
            while (ascent ? cmp < 1 : cmp > -1) {
                al.append(new Variant(begin));
                cmp = begin.add(step).compareTo(end);
            }
            Object[] va = new Variant[al.size()];
            al.toArray(va, 0);
            varResult = new Variant(va, 527);
        }
        catch (SyntaxErrorException e) {
            varResult = new Variant(e, 16);
        }
        return varResult;
    }

    public Variant ARRAY(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, Integer.MAX_VALUE);
        Object[] array = new Variant[args.length];
        KDToolkit.arraycopy((Object[])args, (int)0, (Object[])array, (int)0, (int)args.length);
        return new Variant(array, 527);
    }

    private Variant _getSingleValue(Variant var) {
        if (var.isArray()) {
            Variant[] aV = (Variant[])var.getValue();
            var = aV[0];
        }
        return var;
    }

    public Variant LIST(Object[] args) {
        ObjectArray al = new ObjectArray(args.length);
        for (int i = 0; i < args.length; ++i) {
            ExcelFuncProvider.platValues(al, (Variant)args[i]);
        }
        Object[] av = new Variant[al.size()];
        al.toArray(av, 0);
        return new Variant(av, 527);
    }

    ExtGroup filter(ExprContext ctx, Object[] args, Variant[] aRet) throws SyntaxErrorException {
        ExtGroup oriGroup;
        Variant varSel;
        ExtDataSet ds = ExtFuncProvider.getValidDataSet(ctx, (Variant)args[0], true);
        aRet[0] = varSel = ExtFuncProvider.getValidExp(ctx, ds, args[1], "\u975e\u6709\u6548\u5217\u6807", true);
        ExtGroup group = oriGroup = ds.getCurrentGroup();
        int argCount = args.length;
        if (argCount > 2) {
            Variant varDesc = (Variant)args[2];
            Variant varSort = null;
            if (argCount > 3) {
                Variant varFilter = !(ds instanceof ExtDynamicDataSet) ? ExtFuncProvider.getValidExp(ctx, ds, args[3], "\u8fc7\u6ee4\u8868\u8fbe\u5f0f", false) : ExtFuncProvider.getValidExp(ctx, ds, args[3], "\u8fc7\u6ee4\u8868\u8fbe\u5f0f", true);
                if (!varFilter.isNull()) {
                    if (group == oriGroup) {
                        group = (ExtGroup)group.clone();
                    }
                    group.filterRow(ctx, varFilter, group);
                    if (group.isNullGroup()) {
                        return group;
                    }
                }
                if (argCount > 4) {
                    varSort = !(ds instanceof ExtDynamicDataSet) ? ExtFuncProvider.getValidExp(ctx, ds, args[4], "\u6392\u5e8f\u8868\u8fbe\u5f0f", false) : ExtFuncProvider.getValidExp(ctx, ds, args[4], "\u6392\u5e8f\u8868\u8fbe\u5f0f", true);
                }
            }
            if (varSort != null && !varSort.isNull() || !varDesc.isNull()) {
                Expr expr;
                Object obj;
                boolean desc;
                if (varDesc.getValue() instanceof Expr) {
                    boolean traceMode = ctx.isTraceMode();
                    ctx.setTraceMode(false);
                    desc = ((Expr)varDesc.getValue()).execute(ctx, ctx.getExprOwner()).booleanValue();
                    ctx.setTraceMode(traceMode);
                } else {
                    desc = varDesc.booleanValue();
                }
                if (group == oriGroup) {
                    group = (ExtGroup)group.clone();
                }
                Variant varSortExp = varSort == null || varSort.isNull() ? varSel : varSort;
                boolean sorted = false;
                if (varSortExp == varSort && null != varSortExp && (obj = varSortExp.getValue()) instanceof Expr && (expr = (Expr)obj).isArray()) {
                    Variant[] av;
                    boolean traceMode = ctx.isTraceMode();
                    ctx.setTraceMode(false);
                    Variant aValues = expr.execute(ctx, null);
                    ctx.setTraceMode(traceMode);
                    if (aValues.isArray() && (av = (Variant[])aValues.getValue()).length > 0) {
                        int srcCount = av.length;
                        Variant[] aSort = new Variant[srcCount + 1 >> 1];
                        boolean[] aDesc = new boolean[aSort.length];
                        for (int i = 0; i < aSort.length; ++i) {
                            int avIndex = i << 1;
                            aSort[i] = ExtFuncProvider.getValidExp(ctx, ds, av[avIndex++], "\u6392\u5e8f\u8868\u8fbe\u5f0f", false);
                            if (avIndex >= srcCount) continue;
                            aDesc[i] = av[avIndex].booleanValue();
                        }
                        group.sort(ctx, aSort, aDesc);
                        sorted = true;
                    }
                }
                if (!sorted) {
                    group.sort(ctx, varSortExp, desc);
                }
            }
        }
        return group;
    }

    public Variant SELECT1(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        int argCount = args.length;
        if (argCount < 2) {
            ExprErr.goError(8L, null);
        }
        ExtDataSet ds = ExtFuncProvider.getValidDataSet(ctx, (Variant)args[0], true);
        Variant selExp = ExtFuncProvider.getValidExp(ctx, ds, args[1], "\u975e\u6709\u6548\u5217\u6807", true);
        ExtRow row = ds.getNullRow();
        ExtGroup group = ds.getCurrentGroup();
        if (args.length > 2) {
            Variant filterExp = ExtFuncProvider.getValidExp(ctx, ds, args[2], "\u8fc7\u6ee4\u8868\u8fbe\u5f0f", false);
            ExtRow[] rows = group.getRows();
            int end = group.getTo();
            for (int i = group.getFrom(); i < end; ++i) {
                ExtRow r = rows[i];
                ds.setCurrentRow(r);
                Variant var = ds.calc(ctx, filterExp);
                if (!var.booleanValue()) continue;
                row = r;
                Variant value = ds.calc(ctx, selExp);
                row.setValue(value);
                break;
            }
        } else {
            row = group.getFirstRow();
            ds.setCurrentRow(row);
            Variant value = ds.calc(ctx, selExp);
            row.setValue(value);
        }
        if (row.isNullRow()) {
            return Variant.nullVariant;
        }
        return new Variant(row, 18);
    }

    public Variant DISTINCT(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 3, Integer.MAX_VALUE);
        ExtDataSet ds = ExtFuncProvider.getValidDataSet(ctx, (Variant)args[0], true);
        Variant varGroup = (Variant)args[1];
        if (!(varGroup.getValue() instanceof Expr)) {
            ExprErr.goError(16L, "Group?");
        }
        Expr expr = (Expr)varGroup.getValue();
        boolean traceMode = ctx.isTraceMode();
        ctx.setTraceMode(false);
        varGroup = expr.execute(ctx, ctx.getExprOwner());
        ctx.setTraceMode(traceMode);
        if (varGroup.getVt() == 527) {
            Variant[] grps = (Variant[])varGroup.getValue();
            if (grps != null) {
                for (int i = 0; i < grps.length; ++i) {
                    grps[i] = this._distinct(ctx, ds, grps[i], args);
                }
            }
        } else {
            varGroup = this._distinct(ctx, ds, varGroup, args);
        }
        return varGroup;
    }

    private Variant _distinct(ExprContext ctx, ExtDataSet ds, Variant varGroup, Object[] args) throws SyntaxErrorException {
        ExtGroup grp;
        Object value = varGroup.getValue();
        if (!(value instanceof ExtGroup)) {
            ExprErr.goError(16L, "Not Group Param");
        }
        if ((grp = (ExtGroup)value).getDataSet() != ds) {
            ExprErr.goError(16L, "Dif Group");
        }
        for (int i = 2; i < args.length; ++i) {
            args[i] = ExtFuncProvider.getValidExp(ctx, ds, args[i], "\u975e\u6709\u6548\u5217\u6807", true);
        }
        ExtGroup newGroup = ds.distinct(grp, ctx, args);
        return newGroup != grp ? new Variant(newGroup, varGroup.getVt()) : varGroup;
    }

    public Variant SELECT(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, 5);
        Variant[] aRet = ctx.getBuffer().getOneVariantArray(null);
        ExtGroup group = this.filter(ctx, args, aRet);
        Variant[] values = group.getDataSet().select(group, ctx, aRet[0]);
        group.setValues(values);
        ctx.getBuffer().recycleArray(aRet);
        return group.getVar();
    }

    public Variant GROUP(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, 8);
        Variant[] aRet = ctx.getBuffer().getOneVariantArray(null);
        ExtGroup group = this.filter(ctx, args, aRet);
        Variant var = group.group(ctx, aRet[0]);
        ctx.getBuffer().recycleArray(aRet);
        int argCount = args.length;
        if (argCount > 5 && var.isArray()) {
            ExtDataSet ds = group.getDataSet();
            Variant sortExp = ExtFuncProvider.getValidExp(ctx, ds, args[5], "\u7ec4\u6392\u5e8f\u8868\u8fbe\u5f0f", false);
            Variant filterExp = argCount > 7 ? ExtFuncProvider.getValidExp(ctx, ds, args[7], "\u7ec4\u8fc7\u6ee4\u8868\u8fbe\u5f0f", false) : null;
            Variant[] groups = (Variant[])var.getValue();
            if (groups.length > 1 && !sortExp.isNull() || filterExp != null) {
                Variant[] filtered;
                if (filterExp != null && !filterExp.isNull() && (filtered = group.filterGroup(ctx, groups, filterExp)).length < groups.length) {
                    var = filtered.length == 0 ? ds.getNullGroup().getVar() : new Variant(filtered, 527);
                    groups = filtered;
                }
                if (groups.length > 1 && !sortExp.isNull()) {
                    group.sortGroup(ctx, groups, sortExp, argCount > 6 ? (Variant)args[6] : Variant.nullVariant);
                }
            }
        }
        return var;
    }

    public Variant ENUMGROUP(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        return this.separate(ctx, args, true);
    }

    public Variant OVERLAP(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        return this.separate(ctx, args, false);
    }

    private Variant separate(ExprContext ctx, Object[] args, boolean isEnum) throws SyntaxErrorException {
        Variant varRet;
        Variant[] exprs;
        ExcelFuncProvider.validParamCount(args, 3, Integer.MAX_VALUE);
        boolean dynamic = args.length == 3;
        boolean keepNullGroup = ((Variant)args[1]).booleanValue();
        ExtDataSet ds = ExtFuncProvider.getValidDataSet(ctx, (Variant)args[0], true);
        if (dynamic) {
            Object obj = ((Variant)args[2]).getValue();
            if (!(obj instanceof Variant[]) || (args = (Object[])obj).length < 2) {
                ExprErr.goError(16L, "Invalid Array Param");
            }
            exprs = new Variant[args.length >> 1];
        } else {
            exprs = new Variant[args.length - 2 >> 1];
        }
        IExprBuffer buffer = ctx.getBuffer();
        boolean keepDefaultGroup = (args.length & 1) == 1;
        Variant[] groupValues = new Variant[exprs.length + (keepDefaultGroup ? 1 : 0)];
        ObjectArray[] rowsArray = new ObjectArray[groupValues.length];
        ICalculable exprOwner = ctx.getExprOwner();
        Sheet sheet = exprOwner.getSheet();
        ExtDataSetManager dm = sheet.getBook().getDataSetManager();
        int e = 0;
        int i = dynamic ? 0 : 2;
        int iEnd = args.length - 1;
        while (i < iEnd) {
            Object varExpr;
            if (dynamic) {
                String formula = args[i].toString();
                Expr expr = sheet.getExpr(exprOwner, formula);
                if (expr.isSyntaxError()) {
                    ExprErr.goError(16L, "Condition Expression");
                }
                expr = dm.replaceDSNode(exprOwner, expr, ds);
                varExpr = expr.getVarThis();
            } else {
                varExpr = args[i];
            }
            exprs[e] = ExtFuncProvider.getValidExp(ctx, ds, varExpr, "\u8fc7\u6ee4\u8868\u8fbe\u5f0f", false);
            rowsArray[e] = buffer.getObjectArray(0);
            groupValues[e] = (Variant)args[i + 1];
            i += 2;
            ++e;
        }
        if (keepDefaultGroup) {
            rowsArray[e] = buffer.getObjectArray(0);
            groupValues[e] = (Variant)args[args.length - 1];
        }
        ds.getCurrentGroup().separate(ctx, isEnum, exprs, rowsArray, groupValues, keepDefaultGroup);
        for (int i2 = 0; i2 < groupValues.length; ++i2) {
            groupValues[i2] = ExtGroup.getDynamicFieldExpr(ctx, ds, groupValues[i2]);
        }
        ObjectArray aGroups = buffer.getObjectArray(0);
        for (int i3 = 0; i3 < rowsArray.length; ++i3) {
            ExtGroup grp = null;
            ObjectArray array = rowsArray[i3];
            int size = array.size();
            if (size > 0) {
                Object[] rows = new ExtRow[size];
                array.toArray(rows, 0);
                grp = new ExtGroup(ds, (ExtRow[])rows);
            } else if (keepNullGroup) {
                grp = new ExtGroup(ds, new ExtRow[0]);
            }
            buffer.recycleArray(array);
            if (grp == null) continue;
            Variant valueExp = groupValues[i3];
            if (valueExp.getVt() == 3 || valueExp.getValue() instanceof Expr) {
                valueExp = ds.calc(ctx, valueExp);
            }
            grp.setValues(new Variant[]{valueExp});
            aGroups.append(grp);
        }
        if (aGroups.size() == 0) {
            varRet = ds.getNullGroup().getVar();
        } else {
            Variant[] groups = new Variant[aGroups.size()];
            for (int i4 = 0; i4 < groups.length; ++i4) {
                groups[i4] = ((ExtGroup)aGroups.get(i4)).getVar();
            }
            varRet = new Variant(groups, 527);
        }
        buffer.recycleArray(aGroups);
        return varRet;
    }

    public Variant SORT(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 2);
        Variant var = (Variant)args[0];
        if (!var.isArray()) {
            ExprErr.goError(16L, "Cannot sort");
        }
        Object[] array = (Variant[])var.getValue();
        Arrays.sort(array);
        if (args.length == 2 && !((Variant)args[1]).booleanValue()) {
            int i = 0;
            for (int j = array.length - 1; i < j; ++i, --j) {
                Object tmp = array[i];
                array[i] = array[j];
                array[j] = tmp;
            }
        }
        return var;
    }

    private int _getSubRange(ExprContext ctx, int count, Variant varTop, Variant varBottom, Span[] sps) throws SyntaxErrorException {
        int newCount;
        block20: {
            block18: {
                int top;
                block19: {
                    block17: {
                        if (count <= 0) {
                            return -1;
                        }
                        top = ExcelFuncProvider.numberValue(ctx, varTop, "top").intValue();
                        if (top <= 0) break block17;
                        sps[0] = new Span(0, Math.min(count, top) - 1);
                        break block18;
                    }
                    if (top != 0) break block19;
                    sps[0] = new Span(0, count - 1);
                    break block18;
                }
                if ((top = -top) >= count) break block20;
                sps[0] = new Span(top - 1, count - 1);
            }
            if (varBottom != null) {
                int bottom = ExcelFuncProvider.numberValue(ctx, varBottom, "bottom").intValue();
                if (bottom > 0) {
                    sps[1] = new Span(Math.max(count - 1 - bottom, 0), count - 1);
                } else if (bottom == 0) {
                    sps[1] = new Span(0, count - 1);
                } else if ((bottom = -bottom) >= count) {
                    sps[0] = null;
                } else {
                    sps[1] = new Span(0, count - 1 - bottom);
                }
            }
        }
        Span spTop = sps[0];
        Span spBottom = sps[1];
        if (spTop == null || spBottom != null && spTop.getStart() > spBottom.getEnd()) {
            newCount = -1;
        } else if (spBottom == null) {
            newCount = spTop.getExtent();
        } else if (spTop.isSeparate(spBottom)) {
            newCount = spTop.getExtent() + spBottom.getExtent();
        } else {
            sps[0] = spTop = new Span(Math.max(spTop.getStart() + 1, spBottom.getStart() + 1), Math.min(spTop.getEnd(), spBottom.getEnd()));
            spBottom = null;
            sps[1] = null;
            newCount = spTop.getExtent();
        }
        return newCount;
    }

    private Variant _makeDataSet(ExtDataSet src, Variant[][] datas) {
        Book book = src.getBook();
        ExtDynamicDataSet dds = ExtDynamicDataSet.getExtDynamicDataSet(book, "Inner", "", ExtDataSetType.TXT, null);
        dds.setColumns(src.getColumns());
        dds.setData(datas);
        dds = book.getDataSetManager().addDynamicDataSet(dds);
        return dds.getVarThis();
    }

    public Variant SUBDS(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Variant ret;
        ExcelFuncProvider.validParamCount(args, 2, 3);
        Variant varDS = (Variant)args[0];
        Variant varBottom = args.length > 2 ? (Variant)args[2] : null;
        Span[] sps = new Span[2];
        if (ExtGroup.isGroup(varDS)) {
            ExtGroup srcGroup = (ExtGroup)varDS.getValue();
            int srcCount = srcGroup.size();
            int newCount = this._getSubRange(ctx, srcCount, (Variant)args[1], varBottom, sps);
            if (newCount < 0) {
                ret = srcGroup.getDataSet().getNullGroup().getVar();
            } else {
                Span spTop = sps[0];
                Span spBottom = sps[1];
                Object[] srcRows = srcGroup.getRows();
                Object[] newRows = new ExtRow[newCount];
                newCount = spTop.getExtent();
                KDToolkit.arraycopy((Object[])srcRows, (int)(srcGroup.getFrom() + spTop.getStart()), (Object[])newRows, (int)0, (int)newCount);
                if (spBottom != null) {
                    KDToolkit.arraycopy((Object[])srcRows, (int)(srcGroup.getFrom() + spBottom.getStart()), (Object[])newRows, (int)newCount, (int)spBottom.getExtent());
                }
                ExtGroup newGroup = new ExtGroup(srcGroup.getDataSet(), (ExtRow[])newRows);
                Object[] srcValues = srcGroup.getValues();
                Object[] newValues = new Variant[newRows.length];
                KDToolkit.arraycopy((Object[])srcValues, (int)(srcGroup.getValueFrom() + spTop.getStart()), (Object[])newValues, (int)0, (int)newCount);
                if (spBottom != null) {
                    KDToolkit.arraycopy((Object[])srcValues, (int)(srcGroup.getValueFrom() + spBottom.getStart()), (Object[])newValues, (int)newCount, (int)spBottom.getExtent());
                }
                newGroup.setValues((Variant[])newValues);
                ret = newGroup.getVar();
            }
        } else if (varDS.isArray()) {
            int newCount;
            Object[] srcGroups = (Variant[])varDS.getValue();
            int srcCount = srcGroups.length;
            if (srcCount == 0 || !ExtGroup.isGroup(srcGroups[0])) {
                ExprErr.goError(16L, "null group");
            }
            if ((newCount = this._getSubRange(ctx, srcCount, (Variant)args[1], varBottom, sps)) < 0) {
                ExprErr.goError(16L, "range");
            }
            Span spTop = sps[0];
            Span spBottom = sps[1];
            Object[] newGroups = new Variant[newCount];
            newCount = spTop.getExtent();
            KDToolkit.arraycopy((Object[])srcGroups, (int)spTop.getStart(), (Object[])newGroups, (int)0, (int)newCount);
            if (spBottom != null) {
                KDToolkit.arraycopy((Object[])srcGroups, (int)spBottom.getStart(), (Object[])newGroups, (int)newCount, (int)spBottom.getExtent());
            }
            ret = new Variant(newGroups, 527);
        } else {
            ExtDataSet ds = ExtFuncProvider.getValidDataSet(ctx, varDS, true);
            if (ds.isEmpty()) {
                return ds.getVarThis();
            }
            Variant[][] srcDatas = ds.getData();
            int srcCount = srcDatas.length;
            int newCount = this._getSubRange(ctx, srcCount, (Variant)args[1], varBottom, sps);
            if (newCount < 0) {
                ret = ExtDataSet.EMPTY_DATASET.getVarThis();
            } else {
                Span spTop = sps[0];
                Span spBottom = sps[1];
                Variant[][] newDatas = new Variant[newCount][];
                newCount = spTop.getExtent();
                KDToolkit.arraycopy((Object[])srcDatas, (int)spTop.getStart(), (Object[])newDatas, (int)0, (int)newCount);
                if (spBottom != null) {
                    KDToolkit.arraycopy((Object[])srcDatas, (int)spBottom.getStart(), (Object[])newDatas, (int)newCount, (int)spBottom.getExtent());
                }
                ret = this._makeDataSet(ds, newDatas);
            }
        }
        return ret;
    }

    public Variant TREE(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Variant[] groups;
        String treeMode;
        ExcelFuncProvider.validParamCount(args, 5, 8);
        ExtDataSet ds = ExtFuncProvider.getValidDataSet(ctx, (Variant)args[0], true);
        int visibleLevel = 0;
        Variant var = (Variant)args[2];
        if (!var.isNull()) {
            visibleLevel = Math.max(0, var.intValue() - 1);
        }
        if (visibleLevel > 1 && !StringUtil.isEmptyString((String)(treeMode = (String)ctx.getBook().getUserObjectValue("MobileReportTreeDisplayMode"))) && TreeDisplayMode.DRILL.toString().equalsIgnoreCase(treeMode)) {
            visibleLevel = 1;
        }
        Variant varLevel = null;
        Variant baseDep = null;
        Variant lowerDep = null;
        Variant filterExp = null;
        if (args.length > 5) {
            varLevel = ExtFuncProvider.getValidExp(ctx, ds, args[5], "Level", true);
            if (args.length > 6) {
                Variant[] titles;
                Variant var2 = Expr.execute(ctx, (Variant)args[6]);
                if (var2.isArray() && (titles = (Variant[])var2.getValue()).length > 0) {
                    baseDep = titles[0];
                    if (titles.length > 1) {
                        lowerDep = titles[1];
                    }
                }
                if (args.length > 7) {
                    filterExp = ExtFuncProvider.getValidExp(ctx, ds, args[7], "\u8fc7\u6ee4\u8868\u8fbe\u5f0f", false);
                }
            }
        }
        Variant varLID = ExtFuncProvider.getValidExp(ctx, ds, args[3], "LongID", true);
        char sepChar = '.';
        Variant varPID = null;
        Variant varThisID = null;
        if (!varLID.isNull()) {
            Variant var3 = (Variant)args[4];
            if (var3.isString()) {
                String str = var3.toString();
                if (StringUtil.isEmptyString((String)str)) {
                    ExprErr.goError(16L, null);
                }
                sepChar = str.charAt(0);
            }
            if (!var3.isString() || var3.toString().length() > 1) {
                varPID = varLID;
                varLID = null;
                varThisID = ExtFuncProvider.getValidExp(ctx, ds, var3, "ThisID", true);
            }
        } else if (varLevel == null || varLevel.isNull()) {
            ExprErr.goError(16L, "Sep");
        }
        IExprBuffer buffer = ctx.getBuffer();
        ExtGroup srcGroup = null;
        Object value = Expr.execute(ctx, (Variant)args[1]).getValue();
        if (value instanceof ExtGroup) {
            srcGroup = (ExtGroup)value;
        } else if (value instanceof Variant[]) {
            groups = (Variant[])value;
            if (!(groups[0].getValue() instanceof ExtGroup)) {
                ExprErr.goError(16L, "Datas");
            }
            ObjectArray aRows = buffer.getObjectArray(groups.length << 3);
            ObjectArray aValues = buffer.getObjectArray(aRows.size());
            for (int i = 0; i < groups.length; ++i) {
                ExtGroup grp = (ExtGroup)groups[i].getValue();
                aRows.appendAll(grp.getRows(), grp.getFrom(), grp.getTo());
                aValues.appendAll(grp.getValues(), grp.getValueFrom(), grp.getValueTo());
            }
            Object[] rows = new ExtRow[aRows.size()];
            aRows.toArray(rows, 0);
            buffer.recycleArray(aRows);
            Object[] values = new Variant[aValues.size()];
            aValues.toArray(values, 0);
            buffer.recycleArray(aValues);
            srcGroup = new ExtGroup(ds, (ExtRow[])rows);
            srcGroup.setValues((Variant[])values);
        } else {
            ExprErr.goError(16L, "Datas");
        }
        Object ret = varLID != null ? this._treeLongID(ctx, ds, srcGroup, varLID, sepChar, varLevel, baseDep, lowerDep) : this._treeParentID(ctx, ds, srcGroup, varPID, varThisID, baseDep, lowerDep);
        if (ret instanceof Variant[]) {
            groups = (Variant[])ret;
        } else {
            SortedObjectArray trees = (SortedObjectArray)ret;
            if (baseDep != null) {
                int end = trees.size();
                for (int i = 0; i < end; ++i) {
                    ((TreeNode)trees.get(i)).travelVirtualNode(baseDep, lowerDep);
                }
            }
            Object[] rows = srcGroup.getRows();
            Variant[] values = srcGroup.getValues();
            ObjectArray aGroup = new ObjectArray(rows.length);
            int end = trees.size();
            for (int i = 0; i < end; ++i) {
                ((TreeNode)trees.get(i)).travel(aGroup, 0);
            }
            int groupCount = aGroup.size();
            int from = 0;
            groups = new Variant[groupCount];
            if (baseDep != null) {
                if (rows.length < groupCount) {
                    rows = new ExtRow[groupCount];
                }
                if (values.length < groupCount) {
                    values = new Variant[groupCount];
                }
            }
            for (int i = 0; i < groupCount; ++i) {
                TreeNode node = (TreeNode)aGroup.get(i);
                int thisRows = 0;
                Object obj = node._rows;
                if (obj != null) {
                    if (obj instanceof ExtRow) {
                        rows[from] = (ExtRow)obj;
                        thisRows = 1;
                    } else {
                        ObjectArray a = (ObjectArray)obj;
                        a.toArray(rows, from);
                        thisRows = a.size();
                    }
                }
                values[i] = node._value;
                int to = from + node._rank;
                ExtGroupTreeNode grp = new ExtGroupTreeNode(ds, (ExtRow[])rows, from, to, ObjectCache.getInteger(node._level));
                grp.setValues(values, i, i + 1);
                groups[i] = grp.getVar();
                from += thisRows;
            }
        }
        if (filterExp != null) {
            groups = this._filterTreeNode(ctx, ds, groups, filterExp);
        }
        Cell cll = (Cell)ctx.getExprOwner();
        Sheet sheet = cll.getSheet();
        boolean extHorz = cll.getExtProps(false).getExtensible(false) == 1;
        sheet.setUserObject("$DefaultVisibleLevel", Boolean.toString(extHorz) + "," + visibleLevel);
        if (extHorz) {
            sheet.setLeftToOutlineGroup(true);
        } else {
            sheet.setAboveOfOutlineGroup(true);
        }
        SheetBaseMath.setOutlineGroupHeaderInlinedAt(sheet, extHorz, ObjectCache.getInteger(extHorz ? cll.getRow() : cll.getCol()));
        return new Variant(groups, 527);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Variant[] _filterTreeNode(ExprContext ctx, ExtDataSet ds, Variant[] groups, Variant filterExp) throws SyntaxErrorException {
        ExtGroup oldGroup = ds.getCurrentGroup();
        try {
            SortedAttributeSpanArray delSpans = new SortedAttributeSpanArray(ctx.getExprOwner().getSheet(), true);
            int startRow = 0;
            if (groups.length > 0) {
                startRow = ((ExtGroup)groups[0].getValue()).getFrom();
                int end = ((ExtGroup)groups[groups.length - 1].getValue()).getTo() - 1;
                delSpans.setSpanAttribute(new Span(startRow, end), null, ObjectCache.getInteger(1), null, null, null, null);
            }
            Integer delMark = ObjectCache.getInteger(0);
            IExprBuffer buffer = ctx.getBuffer();
            ObjectArray keeps = buffer.getObjectArray(groups.length);
            for (int i = 0; i < groups.length; ++i) {
                Variant var = groups[i];
                ExtGroup grp = (ExtGroup)var.getValue();
                ds.setCurrentGroup(grp);
                if (ds.calc(ctx, filterExp).booleanValue()) {
                    keeps.append(var);
                    continue;
                }
                delSpans.setSpanAttribute(new Span(grp.getFrom(), grp.getTo() - 1), null, delMark, null, null, null, null);
            }
            if (keeps.size() < groups.length) {
                int iEnd = delSpans.size();
                int newRowCount = 0;
                for (int i = 0; i < iEnd; ++i) {
                    SortedAttributeSpanArray.AttributeSpan sp = delSpans.getAttributeSpan(i);
                    if (sp.getLength() <= 0) continue;
                    newRowCount += sp.getExtent();
                }
                Object[] newRows = new ExtRow[newRowCount];
                Object[] newValues = new Variant[newRowCount];
                ExtGroup grp = (ExtGroup)groups[0].getValue();
                Object[] rows = grp.getRows();
                Object[] values = grp.getValues();
                int r = 0;
                for (int i = 0; i < iEnd; ++i) {
                    SortedAttributeSpanArray.AttributeSpan sp = delSpans.getAttributeSpan(i);
                    if (sp.getLength() <= 0) continue;
                    int len = sp.getExtent();
                    KDToolkit.arraycopy((Object[])rows, (int)sp.getStart(), (Object[])newRows, (int)r, (int)len);
                    KDToolkit.arraycopy((Object[])values, (int)sp.getStart(), (Object[])newValues, (int)r, (int)len);
                    r += len;
                }
                groups = new Variant[keeps.size()];
                keeps.toArray(groups, 0);
                for (int i = 0; i < groups.length; ++i) {
                    this._updateTreeNodeExtents((ExtGroup)groups[i].getValue(), delSpans, startRow, (ExtRow[])newRows, (Variant[])newValues);
                }
            }
            buffer.recycleArray(keeps);
        }
        finally {
            ds.setCurrentGroup(oldGroup);
        }
        return groups;
    }

    private void _updateTreeNodeExtents(ExtGroup grp, SortedAttributeSpanArray delSpans, int startRow, ExtRow[] newRows, Variant[] newValues) {
        int startPos = delSpans.searchSpan(grp.getFrom());
        int endPos = delSpans.searchSpan(grp.getTo() - 1);
        int offset = 0;
        for (int i = 0; i < startPos; ++i) {
            SortedAttributeSpanArray.AttributeSpan sp = delSpans.getAttributeSpan(i);
            if (sp.getLength() != 0) continue;
            offset += sp.getExtent();
        }
        int dels = 0;
        for (int i = startPos + 1; i <= endPos; ++i) {
            SortedAttributeSpanArray.AttributeSpan sp = delSpans.getAttributeSpan(i);
            if (sp.getLength() != 0) continue;
            dels += sp.getExtent();
        }
        grp.setRows(newRows, grp.getFrom() - offset - startRow, grp.getTo() - dels - offset - startRow);
        grp.setValues(newValues, grp.getValueFrom() - offset, grp.getValueTo() - dels - offset);
    }

    private Object _treeLongID(ExprContext ctx, ExtDataSet ds, ExtGroup srcGroup, Variant varLID, char sepChar, Variant varLevel, Variant baseDep, Variant lowerDep) throws SyntaxErrorException {
        Object ret;
        int i;
        ObjectArray aGroups = new ObjectArray(srcGroup.size());
        ExtRow[] rows = srcGroup.getRows();
        Variant[] values = srcGroup.getValues();
        int currLevel = -1;
        int minLevel = Integer.MAX_VALUE;
        boolean hasLevel = varLevel != null && !varLevel.isNull();
        boolean bVirtual = baseDep != null;
        int[] thisRows = null;
        ArrayList<Span> levels = new ArrayList<Span>(16);
        for (int i2 = 0; i2 < 16; ++i2) {
            levels.add(null);
        }
        Variant var = null;
        for (i = 0; i < rows.length; ++i) {
            Variant var2;
            int level;
            ds.setCurrentRow(rows[i]);
            if (hasLevel) {
                level = ds.calc(ctx, varLevel).intValue() - 1;
            } else {
                String lID = ds.calc(ctx, varLID).toString();
                level = 0;
                int pos = -1;
                while ((pos = lID.indexOf(sepChar, pos + 1)) > -1) {
                    ++level;
                }
            }
            if (level < minLevel) {
                minLevel = level;
            }
            if (var != (var2 = values[i]) || currLevel != level) {
                if (!bVirtual) {
                    for (int j = level + 1; j <= currLevel; ++j) {
                        if (j >= levels.size()) continue;
                        levels.set(j, null);
                    }
                }
                currLevel = level;
                Span sp = new Span(i, i);
                aGroups.append(sp);
                if (bVirtual) {
                    thisRows = new int[]{0, currLevel};
                    aGroups.append(thisRows);
                } else {
                    if (currLevel >= levels.size()) {
                        for (int k = levels.size(); k < currLevel + 1; ++k) {
                            levels.add(null);
                        }
                    }
                    levels.set(currLevel, sp);
                    aGroups.append(ObjectCache.getInteger(currLevel));
                }
            }
            if (bVirtual) {
                thisRows[0] = thisRows[0] + true;
            } else {
                for (int j = 0; j <= currLevel; ++j) {
                    Span sp = (Span)levels.get(j);
                    if (sp == null) continue;
                    sp.increase(0, 1);
                }
            }
            var = var2;
        }
        if (bVirtual) {
            SortedObjectArray trees = new SortedObjectArray(Math.max(10, srcGroup.size() >> 3));
            TreeNode[] lvls = new TreeNode[16];
            int iEnd = aGroups.size();
            for (i = 0; i < iEnd; i += 2) {
                Span sp = (Span)aGroups.get(i);
                int rowStart = sp.getStart();
                thisRows = (int[])aGroups.get(i + 1);
                currLevel = thisRows[1] - minLevel;
                TreeNode node = new TreeNode(i, null, null);
                int jEnd = thisRows[0];
                for (int j = 0; j < jEnd; ++j) {
                    node.appendRow(rows[rowStart + j]);
                }
                node._value = values[rowStart];
                lvls[currLevel] = node;
                if (currLevel == 0) {
                    trees.insert(node);
                    continue;
                }
                lvls[currLevel - 1].addChild(node);
            }
            ret = trees;
        } else {
            Variant[] groups = new Variant[aGroups.size() >> 1];
            boolean offsetLevel = minLevel > 0;
            int groupCount = aGroups.size();
            int i3 = 0;
            int g = 0;
            while (i3 < groupCount) {
                Span sp = (Span)aGroups.get(i3);
                int start = sp.getStart();
                int end = sp.getEnd();
                Integer lvl = (Integer)aGroups.get(i3 + 1);
                if (offsetLevel) {
                    lvl = ObjectCache.getInteger(lvl - minLevel);
                }
                ExtGroupTreeNode grp = new ExtGroupTreeNode(ds, rows, start, end, lvl);
                grp.setValues(values, start, end);
                groups[g] = grp.getVar();
                i3 += 2;
                ++g;
            }
            ret = groups;
        }
        return ret;
    }

    private Object _treeParentID(ExprContext ctx, ExtDataSet ds, ExtGroup srcGroup, Variant varPID, Variant varThisID, Variant baseDep, Variant lowerDep) throws SyntaxErrorException {
        ExtRow[] rows = srcGroup.getRows();
        Variant[] values = srcGroup.getValues();
        HashMap<String, TreeNode> ids = new HashMap<String, TreeNode>(rows.length);
        for (int i = 0; i < rows.length; ++i) {
            boolean toCollect;
            ExtRow row = rows[i];
            ds.setCurrentRow(row);
            String pID = ds.calc(ctx, varPID).toString();
            String thisID = ds.calc(ctx, varThisID).toString();
            TreeNode thisNode = (TreeNode)ids.get(thisID);
            if (thisNode == null) {
                toCollect = true;
                thisNode = new TreeNode(i, row, values[i]);
                ids.put(thisID, thisNode);
            } else {
                toCollect = thisNode._rows == null;
                thisNode.appendRow(row);
                if (thisNode._value == null) {
                    thisNode._value = values[i];
                }
            }
            if (StringUtil.isEmptyString((String)pID) || pID.equals(thisID)) {
                thisNode._isTop = true;
                continue;
            }
            TreeNode parentNode = (TreeNode)ids.get(pID);
            if (parentNode == null) {
                parentNode = new TreeNode(thisNode._rank - 1, null, null);
                ids.put(pID, parentNode);
            }
            if (!toCollect) continue;
            parentNode.addChild(thisNode);
        }
        SortedObjectArray trees = new SortedObjectArray(Math.max(10, srcGroup.size() >> 3));
        Iterator i = ids.entrySet().iterator();
        while (i.hasNext()) {
            TreeNode node = (TreeNode)i.next().getValue();
            if (!node._isTop && node._rows != null) continue;
            trees.insert(node);
        }
        return trees;
    }

    public Variant ISAUTHORIZED(ExprContext ctx, Object[] args) throws SyntaxErrorException, FieldPermissionException {
        return this.ISAUTHORITY(ctx, args);
    }

    public Variant ISAUTHORITY(ExprContext ctx, Object[] args) throws SyntaxErrorException, FieldPermissionException {
        ExcelFuncProvider.validParamCount(args, 2, 2);
        ExtDataSet ds = ExtFuncProvider.getValidDataSet(ctx, (Variant)args[0], false);
        ExtFuncProvider.getValidExp(ctx, ds, args[1], "\u975e\u6709\u6548\u5217\u6807", true);
        FieldPermission fieldP = new FieldPermission();
        fieldP.setDataSetId(ReportFieldUtil.getDataSetId(ds.getDefine()));
        fieldP.setFieldName(((ExtColumn)((Variant)args[1]).getValue()).getName());
        ExecutionContext exeCtx = ctx.getBook().getDataSetManager().getExecutionContext();
        IRptRuntimeCallback rptRunCallback = ctx.getBook().getDataSetManager().getExecutionContext().getRptRuntimeCallback();
        boolean hasPermission = true;
        if (rptRunCallback != null) {
            hasPermission = rptRunCallback.hasPermission(fieldP);
        }
        Variant returnVar = new Variant();
        returnVar.setBoolean(hasPermission);
        return returnVar;
    }

    class TreeNode
    implements Comparable,
    Cloneable {
        Object _childs;
        Object _rows;
        Variant _value;
        int _rank;
        int _level;
        boolean _isTop;

        TreeNode(int rank, ExtRow row, Variant value) {
            this._rank = rank;
            this._rows = row;
            this._value = value;
        }

        public int compareTo(Object o) {
            return this._rank - ((TreeNode)o)._rank;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Row ");
            if (this._rows != null) {
                if (this._rows instanceof ExtRow) {
                    sb.append(this._rows);
                } else {
                    ObjectArray array = (ObjectArray)this._rows;
                    sb.append(array.get(0));
                    sb.append('-');
                    sb.append(array.size());
                }
            } else {
                sb.append("null");
            }
            sb.append(", Rank ");
            sb.append(this._rank);
            sb.append(", Level ");
            sb.append(this._level);
            if (this._isTop) {
                sb.append(", Top ");
            }
            if (this._childs != null) {
                sb.append(", Child ");
                if (this._childs instanceof ObjectArray) {
                    sb.append(((ObjectArray)this._childs).size());
                } else {
                    sb.append(1);
                }
            }
            return sb.toString();
        }

        void appendRow(ExtRow row) {
            if (this._rows == null) {
                this._rows = row;
            } else if (this._rows instanceof ExtRow) {
                ObjectArray array = new ObjectArray();
                array.append(this._rows);
                array.append(row);
                this._rows = array;
            } else {
                ((ObjectArray)this._rows).append(row);
            }
        }

        void addChild(TreeNode child) {
            if (this._childs == null) {
                this._childs = child;
            } else if (this._childs instanceof ObjectArray) {
                ((ObjectArray)this._childs).append(child);
            } else {
                ObjectArray array = new ObjectArray();
                array.append(this._childs);
                array.append(child);
                this._childs = array;
            }
        }

        void insertFirstChild(TreeNode child) {
            if (this._childs == null) {
                this._childs = child;
            } else if (this._childs instanceof ObjectArray) {
                ((ObjectArray)this._childs).insert(0, child);
            } else {
                ObjectArray array = new ObjectArray();
                array.append(child);
                array.append(this._childs);
                this._childs = array;
            }
        }

        int travel(ObjectArray aGroup, int level) {
            if (this._value != null) {
                aGroup.append(this);
                this._level = level;
            } else {
                --level;
            }
            int rank = this._rows == null ? 0 : (this._rows instanceof ExtRow ? 1 : ((ObjectArray)this._rows).size());
            if (this._childs != null) {
                if (this._childs instanceof ObjectArray) {
                    ObjectArray childs = (ObjectArray)this._childs;
                    int end = childs.size();
                    for (int i = 0; i < end; ++i) {
                        rank += ((TreeNode)childs.get(i)).travel(aGroup, level + 1);
                    }
                } else {
                    rank += ((TreeNode)this._childs).travel(aGroup, level + 1);
                }
            }
            this._rank = rank;
            return this._rank;
        }

        void travelVirtualNode(Variant base, Variant lower) {
            if (this._childs == null) {
                return;
            }
            try {
                TreeNode baseNode = (TreeNode)this.clone();
                baseNode._isTop = false;
                baseNode._value = base;
                baseNode._childs = null;
                if (this._childs instanceof ObjectArray) {
                    ObjectArray childs = (ObjectArray)this._childs;
                    int end = childs.size();
                    for (int i = 0; i < end; ++i) {
                        ((TreeNode)childs.get(i)).travelVirtualNode(base, lower);
                    }
                } else {
                    ((TreeNode)this._childs).travelVirtualNode(base, lower);
                }
                this._rows = null;
                if (lower == null) {
                    this.insertFirstChild(baseNode);
                } else {
                    TreeNode lowerNode = (TreeNode)this.clone();
                    lowerNode._isTop = false;
                    lowerNode._rows = null;
                    lowerNode._value = lower;
                    this._childs = null;
                    this.insertFirstChild(baseNode);
                    this.addChild(lowerNode);
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
    }
}

