/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.expans.model.innerlink.exec;

import com.kingdee.bos.ctrl.common.hyperlink.IHyperLinkExec;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.fulfil.ExtGuiExecutor;
import com.kingdee.bos.ctrl.ext.fulfil.IShowLinkage;
import com.kingdee.bos.ctrl.ext.fulfil.TransitionException;
import com.kingdee.bos.ctrl.ext.immit.IExtRuntimeDataProvider;
import com.kingdee.bos.ctrl.ext.immit.ReportProperties;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.exec.ExecutionContext;
import com.kingdee.bos.ctrl.kds.expans.model.ExtProps;
import com.kingdee.bos.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtTransitionTarget;
import com.kingdee.bos.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public abstract class AbstractHyperLinkExec
implements IHyperLinkExec {
    public static String ACTIONS = "actions";
    public static final String OriginalDefaultValue = "@OriginalDefaultValue";
    public static final String ParseParamDefaultValue = "ParseParamDefaultValue";
    public static String CELLID = "cellid";
    public static String PARAMS = "params";
    public static String TITLE = "title";
    public static String EXECUTOR = "executor";
    public static String REPORTID = "reportId";
    public static String PARENT_PERMISSION = "parentPermission";
    protected ExtGuiExecutor _oriExecutor;
    protected IShowLinkage _linkage;
    protected Book _book;
    protected SpreadContext _context;
    protected IExtRuntimeDataProvider _dataProvider;
    protected boolean _limit;

    public AbstractHyperLinkExec(ExtGuiExecutor executor, SpreadContext context, IExtRuntimeDataProvider dataProvider, boolean limit) {
        if (executor != null) {
            this._oriExecutor = executor;
            this._context = executor.getSpreadContext();
            this._book = executor.getBook();
            this._dataProvider = executor.getDataProvider();
            this._limit = executor.getLimit();
        } else if (context != null) {
            this._context = context;
            this._book = this._context.getBook();
            this._dataProvider = dataProvider;
            this._limit = limit;
        }
    }

    public void execute(final String id) {
        if (this._oriExecutor != null) {
            this._oriExecutor.setProgressPaneVisible(true);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                Book book = AbstractHyperLinkExec.this._oriExecutor != null ? AbstractHyperLinkExec.this._oriExecutor.getBook() : AbstractHyperLinkExec.this._context.getBook();
                Cell activeCell = book.getActiveSheet().getActiveCell();
                if (activeCell == null) {
                    activeCell = book.getActiveSheet().getCell(0, 0, true);
                }
                String celID = activeCell.getName(false, false);
                ExtProps ep = activeCell.getExtProps(true);
                ETTargets ett = AbstractHyperLinkExec.this.getETTargets(activeCell);
                if (ett == null) {
                    return;
                }
                List targets = ett.getTargets();
                ExtTransitionTarget target = null;
                for (ExtTransitionTarget temp : targets) {
                    if (!temp.getReportProps().getId().equals(id)) continue;
                    target = temp;
                    break;
                }
                if (target == null) {
                    if (MiscUtil.shouldLog()) {
                        MiscUtil.log(4, "\u8054\u67e5\u76ee\u6807\u4e3a\u7a7a\uff0c\u76f4\u63a5\u8fd4\u56de");
                    }
                    return;
                }
                ReportProperties fullName = target.getReportProps();
                Object alias = ep.executeCalculableProps(fullName.getCalculableProps());
                if (alias != null) {
                    fullName.setAlias(alias.toString());
                }
                Map params = target.getDeepCopy().getParameters();
                String title = "\u62a5\u8868\u8054\u67e5 - " + (StringUtil.isEmptyString((String)fullName.getName()) ? fullName.getName() : fullName.getAlias());
                ExecutionContext currentCtx = book.getDataSetManager().getExecutionContext();
                IExtRuntimeDataProvider dataProvider = (IExtRuntimeDataProvider)AbstractHyperLinkExec.this._dataProvider.clone(fullName);
                ReportProperties properties = AbstractHyperLinkExec.this._dataProvider.fetchCurrentReportProperties();
                byte[] data = dataProvider.getTransitionTargetData(fullName, currentCtx);
                if (data == null) {
                    if (AbstractHyperLinkExec.this._oriExecutor != null) {
                        AbstractHyperLinkExec.this._oriExecutor.setProgressPaneVisible(false);
                    }
                    String tip = "\u8054\u67e5\u7684\u76ee\u6807\u62a5\u8868\u627e\u4e0d\u5230\uff0c\u8bf7\u4fee\u6539\u62a5\u8868\u6a21\u677f\uff0c\u91cd\u65b0\u8bbe\u7f6e\u8054\u67e5\u3002";
                    MessageDialog.show((Component)SwingUtilities.getWindowAncestor((Component)((Object)AbstractHyperLinkExec.this._context)), (Object)tip, (String)"\u4fe1\u606f\u63d0\u793a", (int)-1, (int)1);
                    return;
                }
                boolean limit = AbstractHyperLinkExec.this._limit;
                if (!limit) {
                    try {
                        dataProvider.beforeTransition(fullName);
                    }
                    catch (TransitionException e) {
                        MessageDialog.show((Component)SwingUtilities.getWindowAncestor((Component)((Object)AbstractHyperLinkExec.this._context)), (Object)e.getMessage(), (String)"\u4fe1\u606f\u63d0\u793a", (int)-1, (int)1);
                        if (AbstractHyperLinkExec.this._oriExecutor != null) {
                            AbstractHyperLinkExec.this._oriExecutor.setProgressPaneVisible(false);
                        }
                        return;
                    }
                }
                if (params != null && params.size() > 0) {
                    ep.executeParams(params);
                    AbstractHyperLinkExec.executeParamsDefaultValue(dataProvider, params, fullName);
                    AbstractHyperLinkExec.this.executeChartParams(params);
                    if (MiscUtil.shouldLog()) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("\u8054\u67e5\u76ee\u6807 " + (StringUtil.isEmptyString((String)fullName.getName()) ? fullName.getName() : fullName.getAlias()) + " \u63a5\u6536\u5230\u5982\u4e0b\u53c2\u6570\uff1a<br>");
                        Iterator i = params.entrySet().iterator();
                        while (i.hasNext()) {
                            IParameter param = (IParameter)i.next().getValue();
                            sb.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                            sb.append(param.getAlias());
                            sb.append(" \uff1a ");
                            sb.append(param.getValue());
                            sb.append("<br>");
                        }
                        MiscUtil.log(4, sb.toString());
                    }
                } else if (MiscUtil.shouldLog()) {
                    MiscUtil.log(4, "\u8054\u67e5\u76ee\u6807  " + (StringUtil.isEmptyString((String)fullName.getName()) ? fullName.getName() : fullName.getAlias()) + "  \u6ca1\u6709\u63a5\u6536\u5230\u4efb\u4f55\u53c2\u6570");
                }
                ExtGuiExecutor exec = new ExtGuiExecutor(data, dataProvider, limit);
                exec.copyCacheObjectFrom(currentCtx);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(ACTIONS, exec.getToolBarActions());
                HashMap cloneParams = new HashMap();
                cloneParams.putAll(params);
                map.put(PARAMS, cloneParams);
                map.put(TITLE, title);
                map.put(EXECUTOR, exec);
                map.put(REPORTID, id);
                if (properties != null) {
                    StringBuffer permission = new StringBuffer("");
                    permission.append(properties.isExportPermitted() ? "1" : "0").append(";");
                    permission.append(properties.isPrintPermitted() ? "1" : "0");
                    map.put(PARENT_PERMISSION, permission.toString());
                }
                AbstractHyperLinkExec.this.getLinkage().show(map, title + celID, SwingUtilities.getWindowAncestor((Component)((Object)AbstractHyperLinkExec.this._context)));
                if (AbstractHyperLinkExec.this._oriExecutor != null) {
                    AbstractHyperLinkExec.this._oriExecutor.setProgressPaneVisible(false);
                }
            }
        }).start();
    }

    protected abstract ETTargets getETTargets(Cell var1);

    protected void executeChartParams(Map params) {
    }

    public static void executeParamsDefaultValue(IExtRuntimeDataProvider dataProvider, Map params, ReportProperties fullName) {
        if (params == null || params.isEmpty()) {
            return;
        }
        ExecutionContext ctx = new ExecutionContext(null);
        ctx.setDataSetParameters(params);
        dataProvider.linkParamsDefaultValue(fullName, ctx);
    }

    public void setShowLinkage(IShowLinkage linkage) {
        this._linkage = linkage;
    }

    private IShowLinkage getLinkage() {
        if (this._linkage == null) {
            this._linkage = new IShowLinkage(){

                @Override
                public void show(Map params, String cellTemplateID, Component owner) {
                    ExtGuiExecutor executor = (ExtGuiExecutor)params.get(EXECUTOR);
                    executor.executeWithinWindow((Map)params.get(PARAMS), (String)params.get(TITLE));
                }
            };
        }
        return this._linkage;
    }
}

