/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.frame;

import com.kingdee.bos.ctrl.kds.frame.CompositeScrollBarPane;
import com.kingdee.bos.ctrl.kds.frame.LayoutCell;
import com.kingdee.bos.ctrl.kds.frame.MultiViewPane;
import com.kingdee.bos.ctrl.kds.frame.MvpLayoutInfoManager;
import com.kingdee.bos.ctrl.kds.frame.MvpScrollBarManager;
import com.kingdee.bos.ctrl.kds.frame.MvpViewManager;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;

public abstract class MvpViewController {
    protected MultiViewPane _mvp;
    protected boolean _isFreezed;
    protected boolean _isSplited;
    protected boolean _hasVert = false;
    protected boolean _hasHori = false;
    private CompositeScrollBarPane _hPane;
    private CompositeScrollBarPane _hPane2;
    private CompositeScrollBarPane _vPane;
    private CompositeScrollBarPane _vPane2;

    public MvpViewController(MultiViewPane mvp) {
        this._mvp = mvp;
    }

    public void reset() {
        this._isSplited = false;
        this._hasVert = false;
        this._hasHori = false;
        this._isFreezed = false;
    }

    public boolean split(int orientation) {
        if (!this.canSplit()) {
            return false;
        }
        if (this.isSplited(orientation)) {
            return false;
        }
        int fix = orientation == 0 ? this._mvp.getFixHorizonCount() : this._mvp.getFixVerticalCount();
        boolean b = this.splitImpl(orientation, fix, this.getSplitPosition(orientation, fix), false);
        this._mvp.validate();
        return b;
    }

    public boolean freeze() {
        if (!this.canSplit() || this.isSplited()) {
            return false;
        }
        int hFix = this._mvp.getFixHorizonCount();
        int vFix = this._mvp.getFixVerticalCount();
        int hPos = this.getSplitPositionForFreeze(0, hFix);
        int vPos = this.getSplitPositionForFreeze(1, vFix);
        if (vPos > 0) {
            this.splitImpl(1, vFix, vPos, true);
            this.syncScrollBarValues(1, true);
        }
        if (hPos > 0) {
            this.splitImpl(0, hFix, hPos, true);
            this.syncScrollBarValues(0, true);
        }
        this._mvp.validate();
        return true;
    }

    public boolean unFreeze() {
        if (!this.canSplit()) {
            return false;
        }
        boolean b1 = false;
        boolean b2 = false;
        if (this.isFreezed(1)) {
            b1 = this.mergeSplit(1);
            this.syncScrollBarValues(1, false);
        }
        if (this.isFreezed(0)) {
            b2 = this.mergeSplit(0);
            this.syncScrollBarValues(0, false);
        }
        if (b1 || b2) {
            this._mvp.validate();
        }
        return b1 || b2;
    }

    public boolean mergeSplit(int orientation) {
        CompositeScrollBarPane sp;
        if (!this.canSplit()) {
            return false;
        }
        if (!this.isSplited(orientation)) {
            return false;
        }
        MvpViewManager vm = this._mvp.getViewManager();
        MvpScrollBarManager spm = this._mvp.getScrollBarManager();
        if (orientation == 1) {
            int hCount = this._mvp.getHorizonCount();
            this._mvp.setVerticalCount(this._mvp.getVerticalCount() - 1);
            vm.update();
            int vCount = this._mvp.getVerticalCount();
            for (int i = hCount - 1; i >= 0; --i) {
                vm.removeView(vCount, i);
            }
            sp = spm.getVScrollPanel(vCount);
            spm.update();
            spm.addVScrollPanel(vCount - 1, sp);
        } else {
            int vCount = this._mvp.getVerticalCount();
            this._mvp.setHorizonCount(this._mvp.getHorizonCount() - 1);
            vm.update();
            int hCount = this._mvp.getHorizonCount();
            for (int i = vCount - 1; i >= 0; --i) {
                vm.removeView(i, hCount);
            }
            sp = spm.getHScrollPanel(this._mvp.getFixHorizonCount());
            if (sp == null) {
                sp = spm.getHScrollPanel(hCount);
            }
            spm.update();
            spm.addHScrollPanel(hCount - 1, sp);
        }
        MvpLayoutInfoManager lim = this._mvp.getLayoutInfoManager();
        lim.update();
        int fix = orientation == 1 ? this._mvp.getFixVerticalCount() : this._mvp.getFixHorizonCount();
        LayoutCell oldCell = lim.getLayoutCell(orientation, fix);
        oldCell.setSplitType(0);
        this.saveSplitInfo(orientation, false, 0);
        this.saveUserData();
        this._mvp.validate();
        return true;
    }

    public boolean splitImpl(int orientation, int index, int position, boolean bFreeze) {
        int fix;
        JViewport vp;
        int i;
        MvpViewManager vm = this._mvp.getViewManager();
        MvpScrollBarManager spm = this._mvp.getScrollBarManager();
        if (orientation == 1) {
            this._mvp.setVerticalCount(this._mvp.getVerticalCount() + 1);
            int hCount = this._mvp.getHorizonCount();
            vm.update();
            for (i = 0; i < hCount; ++i) {
                JComponent destView = this.getSplitView(index + 1, i);
                vm.addView(index + 1, i, destView);
                vp = vm.getViewport(index, i);
                this.setNewViewPosition(vp, vm.getViewport(index + 1, i), position, orientation);
            }
            spm.update();
            fix = this._mvp.getFixVerticalCount();
            spm.addVScrollPanel(fix, this.getSplitScrollPanel(1, fix, bFreeze));
            spm.addVScrollPanel(fix + 1, this.getSplitScrollPanel(1, fix + 1, bFreeze));
        } else if (orientation == 0) {
            this._mvp.setHorizonCount(this._mvp.getHorizonCount() + 1);
            int vCount = this._mvp.getVerticalCount();
            vm.update();
            for (i = vCount - 1; i >= 0; --i) {
                JComponent destView = this.getSplitView(i, index + 1);
                vm.addView(i, index + 1, destView);
                vp = vm.getViewport(i, index);
                this.setNewViewPosition(vp, vm.getViewport(i, index + 1), position, orientation);
            }
            spm.update();
            fix = this._mvp.getFixHorizonCount();
            spm.addHScrollPanel(fix, this.getSplitScrollPanel(0, fix, bFreeze));
            spm.addHScrollPanel(fix + 1, this.getSplitScrollPanel(0, fix + 1, bFreeze));
        }
        MvpLayoutInfoManager lim = this._mvp.getLayoutInfoManager();
        lim.update();
        LayoutCell oldCell = lim.getLayoutCell(orientation, index);
        int oldStart = oldCell.getStart();
        int oldSpan = oldCell.getSpan();
        if (bFreeze) {
            --position;
        }
        int newStart = oldStart + position;
        int newSpan = oldSpan - position;
        LayoutCell newCell = new LayoutCell();
        newCell.setStart(newStart);
        newCell.setSpan(newSpan);
        lim.addLayOutCell(orientation, index + 1, newCell);
        oldCell.setStart(oldStart);
        oldCell.setSpan(position);
        oldCell.setSplitType(bFreeze ? 2 : 1);
        this.syncScrollBarValues(orientation, bFreeze);
        this.saveSplitInfo(orientation, true, oldCell.getSplitType());
        this.saveUserData();
        return true;
    }

    protected void syncScrollBarValues(int orientation, boolean bFreeze) {
        int value;
        MvpViewManager vm = this._mvp.getViewManager();
        Point mainp = vm.getViewport(this._mvp.getVerticalCount() - 1, this._mvp.getHorizonCount() - 1).getViewPosition();
        int n = value = orientation == 1 ? mainp.y : mainp.x;
        if (bFreeze) {
            JScrollBar bar;
            int min;
            JViewport vp;
            int vCount = this._mvp.getVerticalCount() - 1;
            int hCount = this._mvp.getHorizonCount() - 1;
            if (orientation == 1) {
                vp = this._mvp.getViewManager().getViewport(vCount, hCount);
                min = vp.getViewPosition().y;
                bar = this._mvp.getScrollBarManager().getVScrollBar(vCount);
            } else {
                vp = this._mvp.getViewManager().getViewport(vCount, hCount);
                min = vp.getViewPosition().x;
                bar = this._mvp.getScrollBarManager().getHScrollBar(hCount);
            }
            int extent = bar.getVisibleAmount();
            int max = min > bar.getMaximum() ? min : bar.getMaximum();
            bar.setValues(value, extent, min, max);
        } else {
            JScrollBar bar = orientation == 1 ? this._mvp.getScrollBarManager().getVScrollBar(this._mvp.getFixVerticalCount()) : this._mvp.getScrollBarManager().getHScrollBar(this._mvp.getFixHorizonCount());
            bar.setValues(value, bar.getVisibleAmount(), 0, bar.getMaximum());
        }
    }

    public boolean isSplited(int orientation) {
        return this.isSplited() && orientation == 0 ? this._hasHori : this._hasVert;
    }

    public boolean isSplited() {
        return this._isSplited;
    }

    public boolean isFreezed(int orientation) {
        return this.isFreezed() && (orientation == 0 ? this._hasHori : this._hasVert);
    }

    public boolean isFreezed() {
        return this.isSplited() && this._isFreezed;
    }

    protected void saveUserData() {
    }

    protected JComponent getExtComponent(int orientation, int index, boolean bFreeze) {
        return null;
    }

    protected abstract int getSplitPosition(int var1, int var2);

    protected abstract int getSplitPositionForFreeze(int var1, int var2);

    protected abstract JComponent getSplitView(int var1, int var2);

    protected abstract boolean canSplit();

    boolean mvp_SetSplitPosition(int orientation, int position) {
        if (this.checkPosition(orientation, position)) {
            return this.mvp_UpdateSplitPosition(orientation, position);
        }
        return this.mergeSplit(orientation);
    }

    boolean mvp_UpdateSplitPosition(int orientation, int position) {
        if (!this.canSplit()) {
            return false;
        }
        int count = orientation == 1 ? this._mvp.getVerticalCount() : this._mvp.getHorizonCount();
        MvpLayoutInfoManager lim = this._mvp.getLayoutInfoManager();
        LayoutCell info = lim.getLayoutCell(orientation, count - 2);
        int oldSpan = info.getSpan();
        info.setSpan(position - info.getStart());
        LayoutCell info2 = lim.getLayoutCell(orientation, count - 1);
        info2.setStart(info2.getStart() + info.getSpan() - oldSpan);
        info2.setSpan(info2.getSpan() + (oldSpan - info.getSpan()));
        this.saveUserData();
        this._mvp.revalidate();
        this._mvp.repaint();
        return true;
    }

    boolean mvp_SplitByPosition(int orientation, int position) {
        if (!this.canSplit()) {
            return false;
        }
        if (this.isSplited(orientation)) {
            return false;
        }
        if (!this.checkPosition(orientation, position)) {
            return false;
        }
        MvpLayoutInfoManager lim = this._mvp.getLayoutInfoManager();
        int splitCount = orientation == 1 ? this._mvp.getVerticalCount() - 1 : this._mvp.getHorizonCount() - 1;
        LayoutCell info2 = lim.getLayoutCell(orientation, splitCount);
        boolean b = this.splitImpl(orientation, splitCount, position -= info2.getStart(), false);
        this._mvp.validate();
        return b;
    }

    CompositeScrollBarPane getHScrollPanel(JComponent comp) {
        if (this._hPane == null) {
            this._hPane = new CompositeScrollBarPane(this._mvp);
        }
        this._hPane.setExtComponent(comp);
        return this._hPane;
    }

    CompositeScrollBarPane getHScrollPanel2(JComponent comp) {
        if (this._hPane2 == null) {
            this._hPane2 = new CompositeScrollBarPane(this._mvp);
        }
        this._hPane2.setExtComponent(comp);
        return this._hPane2;
    }

    CompositeScrollBarPane getVScrollPanel(JComponent comp) {
        if (this._vPane == null) {
            this._vPane = new CompositeScrollBarPane(this._mvp, 1);
        }
        this._vPane.setExtComponent(comp);
        return this._vPane;
    }

    CompositeScrollBarPane getVScrollPanel2(JComponent comp) {
        if (this._vPane2 == null) {
            this._vPane2 = new CompositeScrollBarPane(this._mvp, 1);
        }
        this._vPane2.setExtComponent(comp);
        return this._vPane2;
    }

    private boolean checkPosition(int orientation, int position) {
        int max = this._mvp.getLayoutInfoManager().getMaxCanSplitRange(orientation);
        int min = this._mvp.getLayoutInfoManager().getMinCanSplitRange(orientation);
        return position < max && position > min;
    }

    private void setNewViewPosition(JViewport srcvp, JViewport desvp, int position, int orientation) {
        Point p = srcvp.getViewPosition();
        if (orientation == 1) {
            p.y += position;
        } else if (orientation == 0) {
            p.x += position;
        }
        desvp.getView().setLocation(-p.x, -p.y);
    }

    private void saveSplitInfo(int orientation, boolean hasSplit, int splitType) {
        if (orientation == 0) {
            this._mvp.getLayoutInfoManager().setHSplitButtonVisible(!hasSplit);
            this._hasHori = hasSplit;
        } else {
            this._mvp.getLayoutInfoManager().setVSplitButtonVisible(!hasSplit);
            this._hasVert = hasSplit;
        }
        if (splitType == 0) {
            boolean bl = this._isSplited = this._hasHori || this._hasVert;
            this._isFreezed = this._isFreezed ? this._isSplited : false;
        } else if (splitType == 1) {
            this._isSplited = this._hasHori || this._hasVert;
            this._isFreezed = false;
        } else {
            this._isSplited = true;
            this._isFreezed = true;
            this._mvp.getLayoutInfoManager().setVSplitButtonVisible(false);
            this._mvp.getLayoutInfoManager().setHSplitButtonVisible(false);
        }
    }

    private CompositeScrollBarPane getSplitScrollPanel(int orientation, int index, boolean bFreeze) {
        if (orientation == 0) {
            int hFix = this._mvp.getFixHorizonCount();
            if (index < hFix) {
                return null;
            }
            if (index == hFix) {
                if (!bFreeze) {
                    return this.getHScrollPanel(this.getExtComponent(orientation, index, false));
                }
                return null;
            }
            if (!bFreeze) {
                return this.getHScrollPanel2(this.getExtComponent(orientation, index, false));
            }
            return this.getHScrollPanel2(this.getExtComponent(orientation, index, true));
        }
        int vFix = this._mvp.getFixVerticalCount();
        if (index < vFix) {
            return null;
        }
        if (index == vFix) {
            if (!bFreeze) {
                return this.getVScrollPanel(this.getExtComponent(orientation, index, false));
            }
            return null;
        }
        if (!bFreeze) {
            return this.getVScrollPanel2(this.getExtComponent(orientation, index, false));
        }
        return this.getVScrollPanel2(this.getExtComponent(orientation, index, true));
    }
}

