/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl;

import com.kingdee.bos.ctrl.extcommon.util.ObjectArray;
import com.kingdee.bos.ctrl.kds.impl.RangeDecorator;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.model.expr.Expr;
import com.kingdee.bos.ctrl.kds.model.expr.IExprNode;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.kds.model.struct.Range;
import com.kingdee.bos.ctrl.kds.model.struct.Selection;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetOption;
import com.kingdee.bos.ctrl.kds.model.struct.Span;
import com.kingdee.bos.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.kds.model.struct.node.SortedNamedObjectNodeArray;
import com.kingdee.bos.ctrl.kds.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kds.model.util.SortedSpanArray;

public class RangeManager {
    private SpreadContext _context;

    RangeManager(SpreadContext context) {
        this._context = context;
    }

    public Range findRange(String name, boolean withDefined) {
        return this.findRangeInSheet(this._context.getBook().getActiveSheet(), name, withDefined);
    }

    public Range findRange(String name) {
        return this.findRangeInSheet(this._context.getBook().getActiveSheet(), name, false);
    }

    public Range findRangeInSheet(Sheet sheet, String name, boolean withDefined) {
        if (withDefined) {
            SortedNamedObjectNodeArray sona = sheet.getNames();
            NamedObjectNode node = sona.searchByName(name);
            if (node != null) {
                return node.getRefersToRange();
            }
            SortedNamedObjectNodeArray sn = sheet.getBook().getNames();
            node = sn.searchByName(name);
            if (node != null) {
                return node.getRefersToRange();
            }
        }
        ObjectArray blocks = null;
        Expr expr = sheet.getExpr(null, name);
        if (!expr.isSyntaxError() && expr.hasCellBlock()) {
            blocks = new SortedCellBlockArray();
            IExprNode[] nodes = expr.getExprParams().getNodes();
            for (int i = 0; i < nodes.length; ++i) {
                IExprNode node = nodes[i];
                if (!(node instanceof CellBlock)) {
                    blocks = null;
                    break;
                }
                ((SortedCellBlockArray)blocks).insert(node);
            }
        }
        return blocks != null && !blocks.isEmpty() ? this.getRange(sheet, (SortedCellBlockArray)blocks) : null;
    }

    public Range findRangeInSheet(Sheet sheet, String name) {
        return this.findRangeInSheet(sheet, name, false);
    }

    public Range findRangeInBook(String name, boolean withDefined) {
        Book book = this._context.getBook();
        int index = name.indexOf(33);
        if (index > 0) {
            Sheet sheet;
            String tname = name.substring(0, index);
            if (tname.startsWith("=")) {
                tname = tname.substring(1);
            }
            if ((sheet = book.getSheet(tname)) != null) {
                return this.findRangeInSheet(sheet, name.substring(index + 1), withDefined);
            }
            return null;
        }
        return this.findRangeInSheet(book.getActiveSheet(), name, withDefined);
    }

    public Range getSelectionRange() {
        return this.getSelectionRange(this._context.getBook().getActiveSheet());
    }

    public Range getRange(CellBlock cb) {
        return this.getRange(this._context.getBook().getActiveSheet(), cb);
    }

    public Range getColRange(int col, int col2) {
        return this.getColRange(this._context.getBook().getActiveSheet(), col, col2);
    }

    public Range getRowRange(int row, int row2) {
        return this.getRowRange(this._context.getBook().getActiveSheet(), row, row2);
    }

    public Range getRange(int row, int col) {
        return this.getRange(CellBlock.getCellBlock(row, col));
    }

    public Range getRange(SortedCellBlockArray sa) {
        return this.getRange(this._context.getBook().getActiveSheet(), sa);
    }

    public Range getActiveCellRange() {
        return this.getActiveCellRange(this._context.getBook().getActiveSheet());
    }

    public Range getSelectionRange(Sheet sheet) {
        Book book = this._context.getBook();
        return new RangeDecorator(this._context, book, sheet, sheet.getSheetOption().getSelection().toSortedBlocks().toArray());
    }

    public Range getRange(Sheet sheet, CellBlock cb) {
        Book book = this._context.getBook();
        return new RangeDecorator(this._context, book, sheet, cb);
    }

    public Range getColRange(Sheet sheet, int col, int col2) {
        return this.getRange(sheet, CellBlock.getCellBlock(0, col, 1048575, col2));
    }

    public Range getRowRange(Sheet sheet, int row, int row2) {
        return this.getRange(sheet, CellBlock.getCellBlock(row, 0, row2, 65535));
    }

    public Range getRange(Sheet sheet, int row, int col) {
        return this.getRange(sheet, CellBlock.getCellBlock(row, col));
    }

    public Range getRange(Sheet sheet, SortedCellBlockArray sa) {
        Book book = this._context.getBook();
        return new RangeDecorator(this._context, book, sheet, sa.toArray());
    }

    public Range getActiveCellRange(Sheet sheet) {
        Book book = this._context.getBook();
        SheetOption so = sheet.getSheetOption();
        Selection sel = so.getSelection();
        int row = sel.getActiveRow();
        int col = sel.getActiveCol();
        CellBlock cb = null;
        MergeBlocks mbs = so.getMerger(false);
        if (mbs != null) {
            cb = mbs.searchBlock(row, col);
        }
        if (cb != null) {
            row = cb.getRow();
            col = cb.getCol();
        }
        return new RangeDecorator(this._context, book, sheet, CellBlock.getCellBlock(row, col));
    }

    public Range getSelectionRangeInBook() {
        Book book = this._context.getBook();
        Sheet active = book.getActiveSheet();
        return new RangeDecorator(this._context, book, book.getSelectSheets().getCopy(), active.getSheetOption().getSelection().toSortedBlocks().toArray());
    }

    public Range getRangeInBook(CellBlock cb) {
        Book book = this._context.getBook();
        return new RangeDecorator(this._context, book, book.getSelectSheets().getCopy(), cb);
    }

    public Range getColRangeInBook(int col, int col2) {
        return this.getRangeInBook(CellBlock.getCellBlock(0, col, 1048575, col2));
    }

    public Range getRowRangeInBook(int row, int row2) {
        return this.getRangeInBook(CellBlock.getCellBlock(row, 0, row2, 65535));
    }

    public Range getRangeInBook(int row, int col) {
        return this.getRangeInBook(CellBlock.getCellBlock(row, col));
    }

    public Range getRangeInBook(SortedCellBlockArray sa) {
        Book book = this._context.getBook();
        return new RangeDecorator(this._context, book, book.getSelectSheets().getCopy(), sa.toArray());
    }

    public Range getActiveCellRangeInBook() {
        Book book = this._context.getBook();
        Sheet active = book.getActiveSheet();
        Selection sel = active.getSheetOption().getSelection();
        int row = sel.getActiveRow();
        int col = sel.getActiveCol();
        return new RangeDecorator(this._context, book, book.getSelectSheets().getCopy(), CellBlock.getCellBlock(row, col));
    }

    public Range getCompoundRangeInBook(SortedSpanArray spans, boolean bRow) {
        Span span = (Span)spans.get(0);
        Range rg = bRow ? this.getRowRangeInBook(span.getStart(), span.getEnd()) : this.getColRangeInBook(span.getStart(), span.getEnd());
        int count = spans.size();
        for (int i = 1; i < count; ++i) {
            span = (Span)spans.get(i);
            Range r = bRow ? this.getRowRangeInBook(span.getStart(), span.getEnd()) : this.getColRangeInBook(span.getStart(), span.getEnd());
            rg.addAll(r);
        }
        return rg;
    }
}

