/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl;

import com.kingdee.bos.ctrl.common.util.FontUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import javax.swing.SwingUtilities;
import sun.font.FontDesignMetrics;

class SimpleTextRender {
    private boolean _isJudge = true;
    boolean _isKeepClip = false;
    public static double PERCENT = 0.2;

    SimpleTextRender() {
    }

    public void setKeepClip(boolean b) {
        this._isKeepClip = b;
    }

    public void setJudge(boolean judge) {
        this._isJudge = judge;
    }

    public void draw(Graphics g, Shape clip, String text, Style style) {
        if (StringUtil.isEmptyString((String)text)) {
            return;
        }
        if (!(clip instanceof Rectangle2D)) {
            return;
        }
        SimpleTextRender.draw(this, g, clip, text, style);
    }

    private Font readyFont(Graphics2D g, String text, Style style) {
        Object font = style.getKDFont();
        font = FontUtil.validateFont((String)text, (Font)font);
        Color fontColor = style.getFontColor();
        g.setColor(fontColor);
        g.setFont((Font)font);
        return font;
    }

    private static synchronized void draw(SimpleTextRender render, Graphics g, Shape clip, String text, Style style) {
        int rWidth;
        Graphics2D g2d = (Graphics2D)g;
        Rectangle2D rect = clip.getBounds2D();
        Font font = render.readyFont(g2d, text, style);
        LineMetrics lm = font.getLineMetrics(text, g2d.getFontRenderContext());
        double fontHeight = lm.getAscent() + lm.getDescent();
        double x = 0.0;
        double y = 0.0;
        Styles.VerticalAlignment vAlign = style.getVerticalAlign();
        if (vAlign == Styles.VerticalAlignment.TOP) {
            y = rect.getY() + (double)lm.getAscent();
        } else if (vAlign == Styles.VerticalAlignment.BOTTOM) {
            y = rect.getY() + rect.getHeight() - 1.0 - (double)lm.getDescent();
        } else {
            double clipCenter = rect.getHeight() / 2.0;
            double fontCenter = fontHeight / 2.0;
            y = rect.getY() + (clipCenter - fontCenter) + (double)lm.getAscent() - 1.0;
        }
        int tWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), text);
        Styles.HorizontalAlignment hAlign = style.getHorizontalAlign();
        if (hAlign == Styles.HorizontalAlignment.CENTER) {
            double clipCenter = rect.getWidth() / 2.0;
            double fontCenter = tWidth / 2;
            x = rect.getX() + (clipCenter - fontCenter);
        } else if (hAlign == Styles.HorizontalAlignment.RIGHT) {
            x = rect.getX() + rect.getWidth() - 1.0 - (double)tWidth;
        } else if (style.getIndentation() > 0) {
            int fontStyle = 0;
            if (style.isBold()) {
                ++fontStyle;
            }
            if (style.isItalic()) {
                fontStyle += 2;
            }
            Font f = new Font(style.getFontName(), fontStyle, style.getFontSize());
            FontDesignMetrics fm = FontDesignMetrics.getMetrics(f);
            x = rect.getX() + (double)((FontMetrics)fm).charWidth('A') * 1.5 * (double)style.getIndentation();
        } else {
            x = rect.getX();
        }
        if (render._isJudge && tWidth > (rWidth = (int)rect.getWidth())) {
            int aWidth = g.getFontMetrics().charWidth('#');
            int times = rWidth / aWidth;
            int remain = rWidth % aWidth;
            if (times == 0) {
                return;
            }
            StringBuffer sb = new StringBuffer(times);
            for (int i = 0; i < times; ++i) {
                sb.append('#');
            }
            text = sb.toString();
            x = rect.getX() + (double)remain / 2.0;
        }
        g2d.drawString(text, (float)x, (float)y);
    }
}

