/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl;

import com.kingdee.bos.ctrl.common.hyperlink.HyperLinkHandler;
import com.kingdee.bos.ctrl.common.hyperlink.IHyperLinkExec;
import com.kingdee.bos.ctrl.common.util.Queue;
import com.kingdee.bos.ctrl.ext.reporting.model.runtime.editor.ExtReportingEditorManager;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.kds.core.IMouseController;
import com.kingdee.bos.ctrl.kds.core.KDSpread;
import com.kingdee.bos.ctrl.kds.core.SpreadView;
import com.kingdee.bos.ctrl.kds.impl.ActionLoader;
import com.kingdee.bos.ctrl.kds.impl.ActionManager;
import com.kingdee.bos.ctrl.kds.impl.CellEditManager;
import com.kingdee.bos.ctrl.kds.impl.FacadeManager;
import com.kingdee.bos.ctrl.kds.impl.FunctionRegister;
import com.kingdee.bos.ctrl.kds.impl.IUpdateStatusBar;
import com.kingdee.bos.ctrl.kds.impl.PopMenuManager;
import com.kingdee.bos.ctrl.kds.impl.RangeManager;
import com.kingdee.bos.ctrl.kds.impl.RenderManager;
import com.kingdee.bos.ctrl.kds.impl.SelectionAdapter;
import com.kingdee.bos.ctrl.kds.impl.ThreadManager;
import com.kingdee.bos.ctrl.kds.impl.ToolBarManager;
import com.kingdee.bos.ctrl.kds.impl.UserObjectRegister;
import com.kingdee.bos.ctrl.kds.impl.facade.PromptPanel;
import com.kingdee.bos.ctrl.kds.impl.facade.SplitPanel;
import com.kingdee.bos.ctrl.kds.impl.facade.editor.CellTextEditor;
import com.kingdee.bos.ctrl.kds.impl.facade.editor.ICellEditor;
import com.kingdee.bos.ctrl.kds.impl.facade.hyperlink.BookHyperLinkExec;
import com.kingdee.bos.ctrl.kds.impl.facade.hyperlink.UriHyperLinkExec;
import com.kingdee.bos.ctrl.kds.impl.facade.tip.SpreadBorderLayout;
import com.kingdee.bos.ctrl.kds.impl.state.SpreadStateManager;
import com.kingdee.bos.ctrl.kds.impl.state.mouse.ColMouseController;
import com.kingdee.bos.ctrl.kds.impl.state.mouse.CornerMouseController;
import com.kingdee.bos.ctrl.kds.impl.state.mouse.IMouseStateController;
import com.kingdee.bos.ctrl.kds.impl.state.mouse.OutlineGroupColHeaderMouseController;
import com.kingdee.bos.ctrl.kds.impl.state.mouse.OutlineGroupRowHeaderMouseController;
import com.kingdee.bos.ctrl.kds.impl.state.mouse.RowMouseController;
import com.kingdee.bos.ctrl.kds.impl.state.mouse.TableMouseController;
import com.kingdee.bos.ctrl.kds.io.kds.BookToKds;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.IEmbedX;
import com.kingdee.bos.ctrl.kds.model.struct.embed.INativeEmbedment;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.Chart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.EChart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.subrpt.SubReportEmbed;
import com.kingdee.bos.ctrl.kds.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.kds.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.kds.model.struct.event.BookPropertyChangeEvent;
import com.kingdee.bos.ctrl.kds.model.struct.event.BookPropertyChangeListener;
import com.kingdee.bos.ctrl.kds.model.struct.event.GraphChangeListener;
import com.kingdee.bos.ctrl.kds.model.struct.event.GraphChangedEvent;
import com.kingdee.bos.ctrl.kds.model.struct.event.GraphPropertyChangedEvent;
import com.kingdee.bos.ctrl.kds.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.kds.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.kds.model.struct.event.SheetPropertyChangeEvent;
import com.kingdee.bos.ctrl.kds.model.struct.event.SheetPropertyChangeListener;
import com.kingdee.bos.ctrl.kds.model.util.SortedSheetArray;
import com.kingdee.bos.ctrl.kds.print.MultiPrintJobProvider;
import com.kingdee.bos.ctrl.kds.print.PrintBookTrans;
import com.kingdee.bos.ctrl.kds.print.PrintManager;
import com.kingdee.bos.ctrl.print.IConfigChangeListener;
import com.kingdee.bos.ctrl.print.printjob.table.SheetPrintJob;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javafx.embed.swing.JFXPanel;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class SpreadContext
extends KDPanel {
    private static int base = 0;
    private static final Object ActionM = new Integer(base++);
    private static final Object ActionL = new Integer(base++);
    private static final Object FuncR = new Integer(base++);
    private static final Object UserR = new Integer(base++);
    private static final Object StateM = new Integer(base++);
    private static final Object FacadeM = new Integer(base++);
    private static final Object ToolBarM = new Integer(base++);
    private static final Object PopupM = new Integer(base++);
    private static final Object RenderM = new Integer(base++);
    private static final Object PrintM = new Integer(base++);
    private static final Object PrintJob = new Integer(base++);
    private static final Object RangeM = new Integer(base++);
    private static final Object HyperLinkHander = new Integer(base++);
    private static final Object SelectionM = new Integer(base++);
    private static final Object ThreadM = new Integer(base++);
    private static final Object EditM = new Integer(base++);
    private static final Object ReportingEditM = new Integer(base++);
    private static final Object SubReportM = new Integer(base++);
    private static final int SheetProChange = 1;
    private static final int SheetChange = 2;
    private static final int BookChange = 3;
    private static final int BookProChange = 4;
    private static final int GraphChange = 5;
    private static final Object SheetProChangeSync = "SheetProChangeSync";
    private static final Object SheetProChangeAsync = "SheetProChangeAsync";
    private static final Object SheetChangeSync = "SheetChangeSync";
    private static final Object SheetChangeAsync = "SheetChangeAsync";
    private static final Object BookProChangeSync = "BookProChangeSync";
    private static final Object BookProChangeAsync = "BookProChangeAsync";
    private static final Object BookChangeSync = "BookChangeSync";
    private static final Object BookChangeAsync = "BookChangeAsync";
    private static final Object GraphChangeSync = "GraphChangeSync";
    private static final Object GraphChangeAsync = "GraphChangeAsync";
    private KDSpread _spread;
    private Queue _syncQueue = new Queue();
    private SyncActionHandler syncHandler;
    private IMouseController _tableMouCtrl;
    private IMouseController _rowMouCtrl;
    private IMouseController _colMouCtrl;
    private IMouseController _cornerMouCtrl;
    private IMouseController _outlineGpRhMouCtrl;
    private IMouseController _outlineGpChMouCtrl;
    private IMouseStateController _userStateCtrl;
    private HashMap _managers;
    private HashMap _listeners;
    private BookListenerDelegate _bookListenerDelegate;
    private ReservedOpListener reservedOpListeners;
    private PaginationViewChangeListener pvcListeners;
    private EmbedObjectChangeListener eoListeners;
    private PhysicalEmbedXListener physicalEmbedXListeners;
    private static final String HIDDEN_EXPORT_ACTION = "HIDDEN_EXPORT_ACTION";
    private static final String HIDDEN_RECALC_ACTION = "HIDDEN_RECALC_ACTION";
    private static final String HIDDEN_SHOW_EMPTY_CELL_ACTION = "HIDDEN_SHOW_EMPTY_CELL_ACTION";
    private static final String HIDDEN_AUTO_RECALC_ACTION = "HIDDEN_AUTO_RECALC_ACTION";
    private static final String HIDDEN_PROMPT_STATUS_ACTION = "HIDDEN_PROMPT_STATUS_ACTION";
    private static final String HIDDEN_DISPLAY_SWITCH_ACTION = "HIDDEN_DISPLAY_SWITCH_ACTION";
    private String userName;
    private SplitPanel compositePane;
    private IUpdateStatusBar updateStatusBar;

    public SpreadContext() {
        this(Book.Manager.getNewBook(null, 3));
    }

    public SpreadContext(Book book) {
        this.initManagers();
        this.initComps();
        this.initListeners();
        this.setBook(book);
    }

    public void requestFocus() {
        this._spread.requestFocus();
    }

    public void addNotify() {
        super.addNotify();
        EmbedhLayer ems = this.getBook().getActiveSheet().getEmbedments(false);
        if (ems != null) {
            EmbedObject[] embeds = new EmbedObject[ems.size()];
            for (int i = ems.size() - 1; i >= 0; --i) {
                embeds[i] = ems.getEmbed(i);
            }
            this.eoListeners.relayoutEmbedXs(embeds, false);
        }
        this.getThreadManager().getTimer(70, this.syncHandler).start();
    }

    public void removeNotify() {
        super.removeNotify();
        this.getThreadManager().dispose();
        EmbedhLayer elayer = this.getBook().getActiveSheet().getEmbedments(false);
        if (elayer != null) {
            elayer.abortImageObservers();
        }
    }

    public KDSpread getSpread() {
        return this._spread;
    }

    public void setBook(Book book) {
        Book oldBook;
        if (book == null) {
            throw new IllegalArgumentException("Book\u4e0d\u80fd\u4e3aNULL");
        }
        if (this._spread == null) {
            this._spread = new KDSpread();
            this.initSpread();
        } else {
            oldBook = this._spread.getBook();
            this.unRegisterBookListeners(oldBook);
        }
        oldBook = this._spread.getBook();
        if (oldBook != null) {
            this._bookListenerDelegate.changed(new BookChangeEvent(oldBook.getActiveSheet(), "Sheet_Deactive"));
        }
        this._spread.setBook(book);
        this.registerBookListeners(book);
        this._bookListenerDelegate.changed(new BookPropertyChangeEvent(this._spread.getBook(), "", "", "Changed_BookProtection"));
        this._bookListenerDelegate.changed(new BookChangeEvent(this._spread.getBook().getActiveSheet(), "Sheet_Active"));
    }

    public Book getBook() {
        return this._spread.getBook();
    }

    private void initManagers() {
        this.syncHandler = new SyncActionHandler();
        this._tableMouCtrl = new TableMouseController(this);
        this._rowMouCtrl = new RowMouseController(this);
        this._colMouCtrl = new ColMouseController(this);
        this._cornerMouCtrl = new CornerMouseController(this);
        this._outlineGpRhMouCtrl = new OutlineGroupRowHeaderMouseController(this);
        this._outlineGpChMouCtrl = new OutlineGroupColHeaderMouseController(this);
        this._bookListenerDelegate = new BookListenerDelegate();
    }

    private void initComps() {
        this.setLayout(new SpreadBorderLayout());
        this.compositePane = new SplitPanel();
        this.compositePane.setShowLinely(true);
        this.compositePane.setDividerLocation(18);
        this.compositePane.setDividerSize(4);
        this.compositePane.setOrientation(1);
        this.compositePane.setLeftComponent((Component)((Object)this.getFacadeManager().getPromptPanel()));
        this.add(this.compositePane, "Center");
        this.setPreferredSize(new Dimension(200, 200));
    }

    private void initListeners() {
        this.pvcListeners = new PaginationViewChangeListener();
        this.addSheetChangeListener(this.pvcListeners);
        this.addBookChangeListener(this.pvcListeners, true);
        this.getPrintManager().addConfigChangeListener(this.pvcListeners);
        this.eoListeners = new EmbedObjectChangeListener();
        this.addSheetChangeListener(this.eoListeners);
        this.addBookChangeListener(this.eoListeners);
        this.addGraphChangeListener(this.eoListeners);
        this.reservedOpListeners = new ReservedOpListener();
        this.addBookChangeListener(this.reservedOpListeners);
        this.addBookPropertyChangeListener(new BookPropertyChangeListener(){

            @Override
            public void changed(BookPropertyChangeEvent e) {
                if (e.getType() == "Global_Repaint") {
                    SpreadContext.this.repaint();
                    SpreadContext.this.getFacadeManager().getPromptPanel().getLeftPane().revalidate();
                }
            }
        }, true);
        this.addBookPropertyChangeListener(new BookPropertyChangeListener(){

            @Override
            public void changed(BookPropertyChangeEvent e) {
                if (e.getType() == "Region_Repaint") {
                    Rectangle region = (Rectangle)e.getOldValue();
                    KDSpread spread = SpreadContext.this.getSpread();
                    spread.repaintTableRegion(region);
                }
            }
        }, false);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(69, 576, true), HIDDEN_EXPORT_ACTION);
        this.getActionMap().put(HIDDEN_EXPORT_ACTION, new ExportAction());
        this.getInputMap(2).put(KeyStroke.getKeyStroke(69, 576, true), HIDDEN_SHOW_EMPTY_CELL_ACTION);
        this.getActionMap().put(HIDDEN_SHOW_EMPTY_CELL_ACTION, new ShowEmptyCellAction());
        this.getInputMap(2).put(KeyStroke.getKeyStroke(82, 576, true), HIDDEN_RECALC_ACTION);
        this.getActionMap().put(HIDDEN_RECALC_ACTION, new RecalcAction());
        this.getInputMap(2).put(KeyStroke.getKeyStroke(83, 576, true), HIDDEN_DISPLAY_SWITCH_ACTION);
        this.getActionMap().put(HIDDEN_DISPLAY_SWITCH_ACTION, new DisplaySwitchAction());
        this.getInputMap(2).put(KeyStroke.getKeyStroke(65, 576, true), HIDDEN_AUTO_RECALC_ACTION);
        this.getActionMap().put(HIDDEN_AUTO_RECALC_ACTION, new AutoRecalcAction());
        this.getInputMap(2).put(KeyStroke.getKeyStroke(70, 576, true), HIDDEN_PROMPT_STATUS_ACTION);
        this.getActionMap().put(HIDDEN_PROMPT_STATUS_ACTION, new PromptStatusAction());
    }

    private void initSpread() {
        this._spread.setExtRender(3, this.getRenderManager().getTableExtRender());
        this._spread.setExtRender(2, this.getRenderManager().getRowExtRender());
        this._spread.setExtRender(1, this.getRenderManager().getColExtRender());
        this._spread.setExtRender(0, this.getRenderManager().getCornerExtRender());
        this._spread.setExtRender(4, this.getRenderManager().getGroupColHeaderExtRender());
        this._spread.setExtRender(5, this.getRenderManager().getGroupRowHeaderExtRender());
        this._spread.setExtRender(6, this.getRenderManager().getGroupColTagBarExtRender());
        this._spread.setExtRender(7, this.getRenderManager().getGroupRowTagBarExtRender());
        this._spread.setExtRender(8, this.getRenderManager().getGroupCornerExtRender());
        this._spread.setCellDisplayProvider(this.getRenderManager().getCellDisplayProvider());
        this._spread.setMouseController(3, this._tableMouCtrl);
        this._spread.setMouseController(2, this._rowMouCtrl);
        this._spread.setMouseController(1, this._colMouCtrl);
        this._spread.setMouseController(0, this._cornerMouCtrl);
        this._spread.setMouseController(5, this._outlineGpRhMouCtrl);
        this._spread.setMouseController(4, this._outlineGpChMouCtrl);
        this._spread.setActionLoader(this.getActionLoader());
        this._spread.getTabbedBar().setPopupMenuProvider(this.getPopMenuManager());
        this._spread.updateUI();
        this.compositePane.setRightComponent(this._spread);
    }

    private void unRegisterBookListeners(Book book) {
        UserObjectRegister ur;
        book.removeSheetChangeListener(this._bookListenerDelegate);
        book.removeBookChangeListener(this._bookListenerDelegate);
        book.removeSheetPropertyChangeListener(this._bookListenerDelegate);
        book.removeBookPropertyChangeListener(this._bookListenerDelegate);
        book.removeGraphChangeListener(this._bookListenerDelegate);
        FunctionRegister fr = this.getFunctionRegister();
        if (fr != null) {
            fr.unRegister();
        }
        if ((ur = this.getUserObjectRegister()) != null) {
            ur.unRegister();
        }
    }

    private void registerBookListeners(Book book) {
        UserObjectRegister ur;
        book.addSheetChangeListener(this._bookListenerDelegate);
        book.addBookChangeListener(this._bookListenerDelegate);
        book.addSheetPropertyChangeListener(this._bookListenerDelegate);
        book.addBookPropertyChangeListener(this._bookListenerDelegate);
        book.addGraphChangeListener(this._bookListenerDelegate);
        FunctionRegister fr = this.getFunctionRegister();
        if (fr != null) {
            fr.register();
        }
        if ((ur = this.getUserObjectRegister()) != null) {
            ur.register();
        }
    }

    private AbstractMap getManagers() {
        if (this._managers == null) {
            this._managers = new HashMap(8);
        }
        return this._managers;
    }

    private AbstractMap getListeners() {
        if (this._listeners == null) {
            this._listeners = new HashMap(8);
        }
        return this._listeners;
    }

    private ArrayList getListener(int type, boolean sync, boolean create) {
        Object key;
        switch (type) {
            case 3: {
                key = sync ? BookChangeSync : BookChangeAsync;
                break;
            }
            case 4: {
                key = sync ? BookProChangeSync : BookProChangeAsync;
                break;
            }
            case 2: {
                key = sync ? SheetChangeSync : SheetChangeAsync;
                break;
            }
            case 5: {
                key = sync ? GraphChangeSync : GraphChangeAsync;
                break;
            }
            default: {
                Object object = key = sync ? SheetProChangeSync : SheetProChangeAsync;
            }
        }
        if (create) {
            AbstractMap map = this.getListeners();
            Object o = map.get(key);
            if (o == null) {
                o = new ArrayList();
                map.put(key, o);
            }
            return (ArrayList)o;
        }
        if (this._listeners == null) {
            return null;
        }
        return (ArrayList)this._listeners.get(key);
    }

    private MultiPrintJobProvider getJobProvider() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(PrintJob);
        if (o == null) {
            o = new MultiPrintJobProvider(this);
            mg.put(PrintJob, o);
        }
        return (MultiPrintJobProvider)o;
    }

    public void setUserStateController(IMouseStateController mc) {
        this._userStateCtrl = mc;
    }

    public IMouseStateController getUserStateController() {
        return this._userStateCtrl;
    }

    public SelectionAdapter getSelection() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(SelectionM);
        if (o == null) {
            o = new SelectionAdapter(this);
            mg.put(SelectionM, o);
        }
        return (SelectionAdapter)o;
    }

    public ActionLoader getActionLoader() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(ActionL);
        if (o == null) {
            o = new ActionLoader(this);
            mg.put(ActionL, o);
        }
        return (ActionLoader)o;
    }

    public FunctionRegister getFunctionRegister() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(FuncR);
        if (o == null) {
            o = new FunctionRegister(this);
            mg.put(FuncR, o);
        }
        return (FunctionRegister)o;
    }

    public UserObjectRegister getUserObjectRegister() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(UserR);
        if (o == null) {
            o = new UserObjectRegister(this);
            mg.put(UserR, o);
        }
        return (UserObjectRegister)o;
    }

    public RangeManager getRangeManager() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(RangeM);
        if (o == null) {
            o = new RangeManager(this);
            mg.put(RangeM, o);
        }
        return (RangeManager)o;
    }

    public RenderManager getRenderManager() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(RenderM);
        if (o == null) {
            o = new RenderManager(this);
            mg.put(RenderM, o);
        }
        return (RenderManager)o;
    }

    public CellEditManager getEditManager() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(EditM);
        if (o == null) {
            o = new CellEditManager(this);
            mg.put(EditM, o);
        }
        return (CellEditManager)o;
    }

    public PrintManager getPrintManager() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(PrintM);
        if (o == null) {
            o = new PrintManager(this.getJobProvider());
            ((PrintManager)o).addConfigChangeListener(new PrintConfigChangeHandler());
            mg.put(PrintM, o);
        }
        return (PrintManager)o;
    }

    public SpreadStateManager getStateManager() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(StateM);
        if (o == null) {
            SpreadStateManager sm = new SpreadStateManager(this);
            this.addBookChangeListener(sm, false);
            this.addSheetChangeListener(sm, false);
            this.addSheetPropertyChangeListener(sm, false);
            mg.put(StateM, sm);
            o = sm;
        }
        return (SpreadStateManager)o;
    }

    public PopMenuManager getPopMenuManager() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(PopupM);
        if (o == null) {
            o = new PopMenuManager(this);
            mg.put(PopupM, o);
        }
        return (PopMenuManager)o;
    }

    public FacadeManager getFacadeManager() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(FacadeM);
        if (o == null) {
            FacadeManager fm = new FacadeManager(this);
            this.addBookChangeListener(fm, true);
            this.addSheetChangeListener(fm, true);
            this.addSheetPropertyChangeListener(fm, true);
            this.addGraphChangeListener(fm, true);
            mg.put(FacadeM, fm);
            o = fm;
        }
        return (FacadeManager)o;
    }

    public ExtReportingEditorManager getReportingEditorManager() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(ReportingEditM);
        if (o == null) {
            ExtReportingEditorManager erm = new ExtReportingEditorManager(this);
            this.addBookChangeListener(erm, true);
            this.addSheetChangeListener(erm, true);
            this.addSheetPropertyChangeListener(erm, true);
            this.addGraphChangeListener(erm, true);
            mg.put(ReportingEditM, erm);
            o = erm;
        }
        return (ExtReportingEditorManager)o;
    }

    public ThreadManager getThreadManager() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(ThreadM);
        if (o == null) {
            ThreadManager fm = new ThreadManager();
            mg.put(ThreadM, fm);
            o = fm;
        }
        return (ThreadManager)o;
    }

    public ActionManager getActionManager() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(ActionM);
        if (o == null) {
            ActionManager am = new ActionManager(this);
            this.addBookChangeListener(am, true);
            this.addBookPropertyChangeListener(am, true);
            this.addSheetPropertyChangeListener(am, true);
            mg.put(ActionM, am);
            o = am;
        }
        return (ActionManager)o;
    }

    public ToolBarManager getToolBarManager() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(ToolBarM);
        if (o == null) {
            ToolBarManager tm = new ToolBarManager(this);
            this.addBookChangeListener(tm, true);
            this.addSheetChangeListener(tm, true);
            this.addSheetPropertyChangeListener(tm, true);
            this.addGraphChangeListener(tm, true);
            mg.put(ToolBarM, tm);
            o = tm;
        }
        return (ToolBarManager)o;
    }

    public HyperLinkHandler getHyperLinkHandler() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(HyperLinkHander);
        if (o == null) {
            o = new HyperLinkHandler();
            ((HyperLinkHandler)o).setExec("#", (IHyperLinkExec)new BookHyperLinkExec(this));
            ((HyperLinkHandler)o).setExec("uri:", (IHyperLinkExec)new UriHyperLinkExec(this));
            mg.put(HyperLinkHander, o);
        }
        return (HyperLinkHandler)o;
    }

    public void addSheetChangeListener(SheetChangeListener l) {
        this.addSheetChangeListener(l, false);
    }

    public void removeSheetChangeListener(SheetChangeListener l) {
        this.removeSheetChangeListener(l, false);
    }

    public void addBookChangeListener(BookChangeListener l) {
        this.addBookChangeListener(l, false);
    }

    public void removeBookChangeListener(BookChangeListener l) {
        this.removeBookChangeListener(l, false);
    }

    public void addSheetPropertyChangeListener(SheetPropertyChangeListener l) {
        this.addSheetPropertyChangeListener(l, false);
    }

    public void removeSheetPropertyChangeListener(SheetPropertyChangeListener l) {
        this.removeSheetPropertyChangeListener(l, false);
    }

    public void addBookPropertyChangeListener(BookPropertyChangeListener l) {
        this.addBookPropertyChangeListener(l, false);
    }

    public void removeBookPropertyChangeListener(BookPropertyChangeListener l) {
        this.removeBookPropertyChangeListener(l, false);
    }

    public void addGraphChangeListener(GraphChangeListener l) {
        this.addGraphChangeListener(l, false);
    }

    public void removeGraphChangeListener(GraphChangeListener l) {
        this.removeGraphChangeListener(l, false);
    }

    public void addSheetChangeListener(SheetChangeListener l, boolean sync) {
        ArrayList al = this.getListener(2, sync, true);
        if (!al.contains(l)) {
            al.add(l);
        }
    }

    public void removeSheetChangeListener(SheetChangeListener l, boolean sync) {
        ArrayList al = this.getListener(2, sync, false);
        if (al != null) {
            al.remove(l);
        }
    }

    public void addBookChangeListener(BookChangeListener l, boolean sync) {
        ArrayList al = this.getListener(3, sync, true);
        if (!al.contains(l)) {
            al.add(l);
        }
    }

    public void removeBookChangeListener(BookChangeListener l, boolean sync) {
        ArrayList al = this.getListener(3, sync, false);
        if (al != null) {
            al.remove(l);
        }
    }

    public void addSheetPropertyChangeListener(SheetPropertyChangeListener l, boolean sync) {
        ArrayList al = this.getListener(1, sync, true);
        if (!al.contains(l)) {
            al.add(l);
        }
    }

    public void removeSheetPropertyChangeListener(SheetPropertyChangeListener l, boolean sync) {
        ArrayList al = this.getListener(1, sync, false);
        if (al != null) {
            al.remove(l);
        }
    }

    public void addBookPropertyChangeListener(BookPropertyChangeListener l, boolean sync) {
        ArrayList al = this.getListener(4, sync, true);
        if (!al.contains(l)) {
            al.add(l);
        }
    }

    public void removeBookPropertyChangeListener(BookPropertyChangeListener l, boolean sync) {
        ArrayList al = this.getListener(4, sync, false);
        if (al != null) {
            al.remove(l);
        }
    }

    public void addGraphChangeListener(GraphChangeListener l, boolean sync) {
        ArrayList al = this.getListener(5, sync, true);
        if (!al.contains(l)) {
            al.add(l);
        }
    }

    public void removeGraphChangeListener(GraphChangeListener l, boolean sync) {
        ArrayList al = this.getListener(5, sync, false);
        if (al != null) {
            al.remove(l);
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setCellShowFormula(boolean isFormulaOnly) {
        ICellEditor editor = this.getEditManager().getDefaultEditor(Object.class);
        if (editor instanceof CellTextEditor) {
            ((CellTextEditor)editor).setFormulaOnly(isFormulaOnly);
        }
    }

    public void updateMesage(String message) {
        if (this.updateStatusBar != null) {
            this.updateStatusBar.updateStatusBar(message);
        }
    }

    public void register(IUpdateStatusBar updateStatusBar) {
        this.updateStatusBar = updateStatusBar;
    }

    static {
        new JFXPanel();
    }

    private class PromptStatusAction
    extends AbstractAction {
        private PromptStatusAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PromptPanel pp = SpreadContext.this.getFacadeManager().getPromptPanel();
            if (pp.isTextOnly()) {
                pp.setTextOnly(false);
            } else {
                pp.setTextOnly(true);
            }
        }
    }

    private class AutoRecalcAction
    extends AbstractAction {
        private AutoRecalcAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Book current = SpreadContext.this._spread.getBook();
            if (current.isAutoCalculate()) {
                current.setAutoCalculate(false);
            } else {
                current.setAutoCalculate(true);
            }
        }
    }

    private class DisplaySwitchAction
    extends AbstractAction {
        private DisplaySwitchAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Book current = SpreadContext.this._spread.getBook();
            if (current.getCellDisplayMode() == 1) {
                current.setCellDisplayMode(0);
            } else {
                current.setCellDisplayMode(1);
            }
        }
    }

    private class RecalcAction
    extends AbstractAction {
        private RecalcAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpreadContext.this._spread.getBook().calc(false);
            SpreadContext.this._spread.repaint();
        }
    }

    private class ShowEmptyCellAction
    extends AbstractAction {
        private ShowEmptyCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cell.SHOW_EmptyCellObj = !Cell.SHOW_EmptyCellObj;
            SpreadContext.this._spread.repaint();
        }
    }

    private class ExportAction
    extends AbstractAction {
        private ExportAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KDFileChooser fileChooser = new KDFileChooser();
            fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() || pathname.getName().toLowerCase(Locale.ENGLISH).endsWith(".kds");
                }

                @Override
                public String getDescription() {
                    return "KDS\u6587\u4ef6\uff08\u4e8c\u8fdb\u5236\uff09";
                }
            });
            fileChooser.setFileSelectionMode(2);
            if (0 == fileChooser.showSaveDialog((Component)((Object)SpreadContext.this))) {
                try {
                    BookToKds btk = new BookToKds();
                    btk.export(SpreadContext.this.getBook(), fileChooser.getSelectedFile().getAbsolutePath());
                }
                catch (IOException e1) {
                    MessageUtil.msgboxWarning((Component)((Object)SpreadContext.this), e1.getMessage());
                }
            }
        }
    }

    private class PaginationViewChangeListener
    implements BookChangeListener,
    IConfigChangeListener,
    SheetChangeListener {
        private PaginationViewChangeListener() {
        }

        @Override
        public void changed(BookChangeEvent e) {
            if (e.isSheetActive()) {
                Sheet sheet = e.getSheet();
                if (sheet == null) {
                    return;
                }
                if (sheet.isPageView()) {
                    SpreadContext.this.getActionManager().getAction("Show_Normal_View").setEnabled(true);
                    SpreadContext.this.getActionManager().getAction("Show_Print_Pagination_View").setEnabled(false);
                } else {
                    SpreadContext.this.getActionManager().getAction("Show_Normal_View").setEnabled(false);
                    SpreadContext.this.getActionManager().getAction("Show_Print_Pagination_View").setEnabled(true);
                }
            }
        }

        public void configChanged() {
            Sheet sheet = SpreadContext.this.getBook().getActiveSheet();
            if (sheet != null && sheet.isPageView()) {
                PrintManager pm = SpreadContext.this.getPrintManager();
                SheetPrintJob job = (SheetPrintJob)pm.getMultiPrintManager().getPrintJob(sheet.getID());
                job.preparePagination();
                sheet.setRowPaginationPointsSnapshot(job.getTablePrintPagination().getRowPaginationPointsSnapshot());
                sheet.setColPaginationPointsSnapshot(job.getTablePrintPagination().getColPaginationPointsSnapshot());
                SpreadContext.this.repaint();
            }
        }

        public void configOver() {
        }

        public void configWillChange() {
        }

        @Override
        public void changed(SheetChangeEvent e) {
            Sheet sheet;
            if (e.hasState(SheetChangeEvent.Changed_Delete | SheetChangeEvent.Changed_Insert | SheetChangeEvent.Changed_Resize | SheetChangeEvent.Changed_Sheet_Scale)) {
                Sheet sheet2 = e.getSheet();
                if (sheet2.isPageView()) {
                    PrintManager pm = SpreadContext.this.getPrintManager();
                    sheet2.setPageView(false);
                    pm.reloadPrintJob();
                    sheet2.setPageView(true);
                    SheetPrintJob job = (SheetPrintJob)pm.getMultiPrintManager().getPrintJob(sheet2.getID());
                    job.preparePagination();
                    sheet2.setRowPaginationPointsSnapshot(job.getTablePrintPagination().getRowPaginationPointsSnapshot());
                    sheet2.setColPaginationPointsSnapshot(job.getTablePrintPagination().getColPaginationPointsSnapshot());
                    pm.getMultiPrintManager().clear();
                    SpreadContext.this.repaint();
                }
            } else if (e.hasState(SheetChangeEvent.Changed_Content) && (sheet = e.getSheet()).isPageView()) {
                PrintManager pm = SpreadContext.this.getPrintManager();
                sheet.setPageView(false);
                pm.reloadPrintJob();
                sheet.setPageView(true);
                SheetPrintJob job = (SheetPrintJob)pm.getMultiPrintManager().getPrintJob(sheet.getID());
                job.preparePagination();
                sheet.setRowPaginationPointsSnapshot(job.getTablePrintPagination().getRowPaginationPointsSnapshot());
                sheet.setColPaginationPointsSnapshot(job.getTablePrintPagination().getColPaginationPointsSnapshot());
                pm.getMultiPrintManager().clear();
                SpreadContext.this.repaint();
            }
        }
    }

    private class ReservedOpListener
    implements BookChangeListener {
        private ReservedOpListener() {
        }

        @Override
        public void changed(BookChangeEvent e) {
            EmbedhLayer elayer;
            if (e.isSheetDeactive() && (elayer = e.getSheet().getEmbedments(false)) != null) {
                elayer.abortImageObservers();
            }
        }
    }

    public class PhysicalEmbedXListener
    extends MouseAdapter
    implements KeyListener {
        public void showPopMenu(EmbedhLayer layer, SpreadView view, Point p) {
            if (!layer.hasSelection()) {
                return;
            }
            EmbedObject graph = layer.getSelectedEmbed(0);
            if (!(graph instanceof INativeEmbedment)) {
                return;
            }
            JPopupMenu jm = SpreadContext.this.getPopMenuManager().getChartLinkPopMenu();
            if (jm != null && !jm.isVisible()) {
                jm.show(view, (int)p.getX(), (int)p.getY());
                jm.setVisible(false);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            EmbedhLayer layer;
            if (e.getButton() == 1 && (layer = SpreadContext.this.getBook().getActiveSheet().getEmbedments(false)) != null) {
                SpreadView view = SpreadContext.this.getSpread().getActiveView();
                Point p = SwingUtilities.convertPoint(((Component)e.getSource()).getParent(), e.getPoint(), view);
                if (e.isControlDown()) {
                    for (int i = 0; i < layer.size(); ++i) {
                        if (!layer.getEmbed(i).getBounds().contains(p)) continue;
                        layer.selectEmbed(layer.getEmbed(i), 0);
                    }
                } else {
                    layer.cancelSelectedEmbeds();
                    for (int i = 0; i < layer.size(); ++i) {
                        if (!layer.getEmbed(i).getBounds().contains(p)) continue;
                        layer.selectEmbed(layer.getEmbed(i), 0);
                        break;
                    }
                    this.showPopMenu(layer, view, p);
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            EmbedhLayer layer;
            if (e.getKeyCode() == 127 && (layer = SpreadContext.this.getBook().getActiveSheet().getEmbedments(false)) != null) {
                layer.removeSelectedEmbeds();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    private class EmbedObjectChangeListener
    implements SheetChangeListener,
    BookChangeListener,
    GraphChangeListener {
        static final int DRAG_INSETS_LEFT_OFFSET = 3;
        static final int DRAG_INSETS_RIGHT_OFFSET = 6;

        private EmbedObjectChangeListener() {
        }

        @Override
        public void changed(GraphChangedEvent e) {
            if (!SpreadContext.this.isDisplayable()) {
                return;
            }
            if (e.isGraphRemoved()) {
                this.removeEmbedXs(e.getChangedGraphs(), true);
            } else if (e.isGraphInserted()) {
                this.relayoutEmbedXs(e.getChangedGraphs(), true);
            }
        }

        @Override
        public void propertyChanged(GraphPropertyChangedEvent e) {
            if (!SpreadContext.this.isDisplayable()) {
                return;
            }
            if ("Changed_Bounds".equals(e.getType())) {
                this.relayoutEmbedXs(e.getGraphs(), false);
            }
        }

        @Override
        public void changed(SheetChangeEvent e) {
            Sheet sheet = e.getSheet();
            if (!SpreadContext.this.isDisplayable() || sheet == null) {
                return;
            }
            EmbedhLayer ems = sheet.getEmbedments(false);
            if (ems == null) {
                return;
            }
            if (e.hasState(SheetChangeEvent.Changed_Sheet_Scale | SheetChangeEvent.Changed_Resize)) {
                EmbedObject[] embeds = new EmbedObject[ems.size()];
                for (int i = ems.size() - 1; i >= 0; --i) {
                    EmbedObject eo = ems.getEmbed(i);
                    if (eo instanceof Chart) {
                        Chart chart = (Chart)eo;
                        chart.getModel().getDataNode().setDirty(true);
                    }
                    eo.relayout();
                    embeds[i] = eo;
                }
                sheet.getBook().fireGraphPropertyChange(new GraphPropertyChangedEvent(sheet, embeds, "Changed_Bounds", new Rectangle[0], new Rectangle[0]));
            }
        }

        @Override
        public void changed(BookChangeEvent e) {
            Sheet sheet = e.getSheet();
            if (!SpreadContext.this.isDisplayable() || sheet == null) {
                return;
            }
            EmbedhLayer ems = sheet.getEmbedments(false);
            if (ems == null) {
                return;
            }
            if (e.isSheetActive()) {
                EmbedObject[] embeds = new EmbedObject[ems.size()];
                for (int i = ems.size() - 1; i >= 0; --i) {
                    embeds[i] = ems.getEmbed(i);
                }
                this.relayoutEmbedXs(embeds, false);
            } else if (e.isSheetDeactive() || e.isSheetRemove()) {
                EmbedObject[] embeds = new EmbedObject[ems.size()];
                for (int i = ems.size() - 1; i >= 0; --i) {
                    embeds[i] = ems.getEmbed(i);
                }
                this.removeEmbedXs(embeds, false);
            }
        }

        private void relayoutEmbedXs(EmbedObject[] eos, boolean careAboutURdo) {
            if (eos.length == 0) {
                return;
            }
            JComponent table = SpreadContext.this.getSpread().getView(2, 2);
            for (int i = 0; i < eos.length; ++i) {
                IEmbedX embedx;
                Component comp;
                EmbedObject eo = eos[i];
                if (!(eo instanceof IEmbedX) || (comp = (embedx = (IEmbedX)((Object)eo)).getPhysicalUI()) == null) continue;
                if (comp.getParent() == table && careAboutURdo) {
                    table.remove(comp);
                    this.dealwithPhysicalEmbedXHandler(embedx, false);
                    continue;
                }
                if (comp.getParent() != table) {
                    table.add(comp);
                    this.dealwithPhysicalEmbedXHandler(embedx, true);
                }
                if (eo instanceof FlashChart || eo instanceof SubReportEmbed || eo instanceof EChart) {
                    comp.setBounds(eo.getX(), eo.getY(), eo.getWidth(), eo.getHeight());
                    continue;
                }
                comp.setBounds(eo.getX() + 3, eo.getY() + 3, eo.getWidth() - 6, eo.getHeight() - 6);
            }
            if (null == SpreadContext.this.physicalEmbedXListeners) {
                SpreadContext.this.physicalEmbedXListeners = new PhysicalEmbedXListener();
            }
            this.dealMergeAndSplitFlashChart(false, SpreadContext.this.physicalEmbedXListeners, eos);
            table.revalidate();
        }

        private void dealMergeAndSplitFlashChart(boolean isRemove, PhysicalEmbedXListener listener, EmbedObject[] eos) {
            block6: {
                KDSpread spread;
                block4: {
                    block5: {
                        spread = SpreadContext.this.getSpread();
                        SpreadView[] views = new SpreadView[]{(SpreadView)spread.getView(2, 3), (SpreadView)spread.getView(3, 3), (SpreadView)spread.getView(3, 2)};
                        if (isRemove) break block4;
                        if (!spread.isFreezed()) break block5;
                        Sheet sheet = SpreadContext.this.getBook().getActiveSheet();
                        EmbedhLayer layer = sheet.getEmbedments(false);
                        if (layer == null) break block6;
                        int size = layer.size();
                        for (int i = 0; i < size; ++i) {
                            EmbedObject eo = layer.getEmbed(i);
                            eo.split(views, listener);
                        }
                        break block6;
                    }
                    Sheet sheet = SpreadContext.this.getBook().getActiveSheet();
                    EmbedhLayer layer = sheet.getEmbedments(false);
                    if (layer == null) break block6;
                    int size = layer.size();
                    for (int i = 0; i < size; ++i) {
                        EmbedObject eo = layer.getEmbed(i);
                        eo.merge();
                    }
                    break block6;
                }
                if (spread.isFreezed()) {
                    int size = eos.length;
                    for (int i = 0; i < size; ++i) {
                        eos[i].merge();
                    }
                }
            }
        }

        private void removeEmbedXs(EmbedObject[] eos, boolean careAboutURdo) {
            if (eos.length == 0) {
                return;
            }
            JComponent table = SpreadContext.this.getSpread().getView(2, 2);
            for (int i = 0; i < eos.length; ++i) {
                IEmbedX embedx;
                Component comp;
                EmbedObject eo = eos[i];
                if (!(eo instanceof IEmbedX) || (comp = (embedx = (IEmbedX)((Object)eo)).getPhysicalUI()) == null) continue;
                if (comp.getParent() == table) {
                    table.remove(comp);
                    this.dealwithPhysicalEmbedXHandler(embedx, false);
                    continue;
                }
                if (!careAboutURdo) continue;
                table.add(comp);
                this.dealwithPhysicalEmbedXHandler(embedx, true);
                if (eo instanceof FlashChart || eo instanceof SubReportEmbed) {
                    comp.setBounds(eo.getX(), eo.getY(), eo.getWidth(), eo.getHeight());
                    continue;
                }
                comp.setBounds(eo.getX() + 3, eo.getY() + 3, eo.getWidth() - 6, eo.getHeight() - 6);
            }
            this.dealMergeAndSplitFlashChart(true, SpreadContext.this.physicalEmbedXListeners, eos);
            table.revalidate();
        }

        private void dealwithPhysicalEmbedXHandler(IEmbedX embedx, boolean beAdded) {
            if (embedx instanceof INativeEmbedment) {
                SwingUtilities.invokeLater(new LisenerAddResolver((INativeEmbedment)((Object)embedx), beAdded));
            }
        }

        private class LisenerAddResolver
        implements Runnable {
            INativeEmbedment _embedx;
            boolean _beAdded;

            LisenerAddResolver(INativeEmbedment chart, boolean beAdded) {
                this._embedx = chart;
                this._beAdded = beAdded;
            }

            @Override
            public void run() {
                if (this._beAdded) {
                    if (SpreadContext.this.physicalEmbedXListeners == null) {
                        SpreadContext.this.physicalEmbedXListeners = new PhysicalEmbedXListener();
                    }
                    this._embedx.getNativeComponent().addMouseListener(SpreadContext.this.physicalEmbedXListeners);
                    this._embedx.getNativeComponent().addKeyListener(SpreadContext.this.physicalEmbedXListeners);
                } else {
                    this._embedx.getNativeComponent().removeMouseListener(SpreadContext.this.physicalEmbedXListeners);
                    this._embedx.getNativeComponent().removeKeyListener(SpreadContext.this.physicalEmbedXListeners);
                }
            }
        }
    }

    private class PrintConfigChangeHandler
    implements IConfigChangeListener {
        private PrintConfigChangeHandler() {
        }

        public void configChanged() {
            SpreadContext.this.getBook().setSkipListeners(true);
            SortedSheetArray selectedSheets = SpreadContext.this.getBook().getSelectSheets();
            String[] selecteds = new String[selectedSheets.size()];
            for (int i = 0; i < selectedSheets.size(); ++i) {
                selecteds[i] = selectedSheets.getSheet(i).getID();
            }
            PrintBookTrans.saveToBook(SpreadContext.this.getPrintManager(), SpreadContext.this.getBook(), selecteds);
            SpreadContext.this.getBook().setSkipListeners(false);
        }

        public void configOver() {
        }

        public void configWillChange() {
        }
    }

    private class SyncActionHandler
    implements ActionListener {
        private SyncActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block8: {
                Object o;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    if (SpreadContext.this._syncQueue.isEmpty()) break block8;
                                    o = SpreadContext.this._syncQueue.dequeue();
                                    if (!(o instanceof BookChangeEvent)) break block9;
                                    BookChangeEvent event = (BookChangeEvent)o;
                                    ArrayList al = SpreadContext.this.getListener(3, true, false);
                                    if (al == null) break block8;
                                    int size = al.size();
                                    for (int i = 0; i < size; ++i) {
                                        ((BookChangeListener)al.get(i)).changed(event);
                                    }
                                    break block8;
                                }
                                if (!(o instanceof SheetChangeEvent)) break block10;
                                SheetChangeEvent event = (SheetChangeEvent)o;
                                ArrayList al = SpreadContext.this.getListener(2, true, false);
                                if (al == null) break block8;
                                int size = al.size();
                                for (int i = 0; i < size; ++i) {
                                    ((SheetChangeListener)al.get(i)).changed(event);
                                }
                                break block8;
                            }
                            if (!(o instanceof SheetPropertyChangeEvent)) break block11;
                            SheetPropertyChangeEvent event = (SheetPropertyChangeEvent)o;
                            ArrayList al = SpreadContext.this.getListener(1, true, false);
                            if (al == null) break block8;
                            int size = al.size();
                            for (int i = 0; i < size; ++i) {
                                ((SheetPropertyChangeListener)al.get(i)).changed(event);
                            }
                            break block8;
                        }
                        if (!(o instanceof BookPropertyChangeEvent)) break block12;
                        BookPropertyChangeEvent event = (BookPropertyChangeEvent)o;
                        ArrayList al = SpreadContext.this.getListener(4, true, false);
                        if (al == null) break block8;
                        int size = al.size();
                        for (int i = 0; i < size; ++i) {
                            ((BookPropertyChangeListener)al.get(i)).changed(event);
                        }
                        break block8;
                    }
                    if (!(o instanceof GraphChangedEvent)) break block13;
                    GraphChangedEvent event = (GraphChangedEvent)o;
                    ArrayList al = SpreadContext.this.getListener(5, true, false);
                    if (al == null) break block8;
                    int size = al.size();
                    for (int i = 0; i < size; ++i) {
                        ((GraphChangeListener)al.get(i)).changed(event);
                    }
                    break block8;
                }
                if (o instanceof GraphPropertyChangedEvent) {
                    GraphPropertyChangedEvent event = (GraphPropertyChangedEvent)o;
                    ArrayList al = SpreadContext.this.getListener(5, true, false);
                    if (al != null) {
                        int size = al.size();
                        for (int i = 0; i < size; ++i) {
                            ((GraphChangeListener)al.get(i)).propertyChanged(event);
                        }
                    }
                }
            }
        }
    }

    private class BookListenerDelegate
    implements SheetPropertyChangeListener,
    BookChangeListener,
    SheetChangeListener,
    BookPropertyChangeListener,
    GraphChangeListener {
        private BookListenerDelegate() {
        }

        @Override
        public void changed(SheetPropertyChangeEvent event) {
            ArrayList al = SpreadContext.this.getListener(1, false, false);
            if (al != null) {
                int size = al.size();
                for (int i = 0; i < size; ++i) {
                    ((SheetPropertyChangeListener)al.get(i)).changed(event);
                }
            }
            SpreadContext.this._syncQueue.enqueue((Object)event);
        }

        @Override
        public void changed(SheetChangeEvent event) {
            ArrayList al = SpreadContext.this.getListener(2, false, false);
            if (al != null) {
                int size = al.size();
                for (int i = 0; i < size; ++i) {
                    ((SheetChangeListener)al.get(i)).changed(event);
                }
            }
            SpreadContext.this._syncQueue.enqueue((Object)event);
        }

        @Override
        public void changed(BookChangeEvent event) {
            ArrayList al = SpreadContext.this.getListener(3, false, false);
            if (al != null) {
                int size = al.size();
                for (int i = 0; i < size; ++i) {
                    ((BookChangeListener)al.get(i)).changed(event);
                }
            }
            SpreadContext.this._syncQueue.enqueue((Object)event);
        }

        @Override
        public void changed(BookPropertyChangeEvent event) {
            ArrayList al = SpreadContext.this.getListener(4, false, false);
            if (al != null) {
                int size = al.size();
                for (int i = 0; i < size; ++i) {
                    ((BookPropertyChangeListener)al.get(i)).changed(event);
                }
            }
            SpreadContext.this._syncQueue.enqueue((Object)event);
        }

        @Override
        public void changed(GraphChangedEvent e) {
            ArrayList al = SpreadContext.this.getListener(5, false, false);
            if (al != null) {
                int size = al.size();
                for (int i = 0; i < size; ++i) {
                    ((GraphChangeListener)al.get(i)).changed(e);
                }
            }
            SpreadContext.this._syncQueue.enqueue((Object)e);
        }

        @Override
        public void propertyChanged(GraphPropertyChangedEvent e) {
            ArrayList al = SpreadContext.this.getListener(5, false, false);
            if (al != null) {
                int size = al.size();
                for (int i = 0; i < size; ++i) {
                    ((GraphChangeListener)al.get(i)).propertyChanged(e);
                }
            }
            SpreadContext.this._syncQueue.enqueue((Object)e);
        }
    }
}

